/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.remoteadmin;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmListenerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.controls.NumberRange;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateListenerDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/remoteadmin/CreateListenerDialog.java";
    private String titleText = null;
    private Label labelIcon = null;
    private Label labelMsg = null;
    private Point preferredSize = null;
    private static final int DEFAULT_PORT_NUMBER = 1414;
    private static final int MAX_PORT_VALUE = 999999999;
    private static String blankPortError = null;
    private static String portInuseError = null;
    private static String portText = null;
    private static String portExplanation = null;
    private NumberRange port;
    private HashSet<Integer> usedPorts;
    private int defaultPortNumber;
    private int portNumber;
    private static final int HORIZONTAL_SPAN = 4;
    private static String DEFAULT_TCP_LISTENER_NAME = null;

    public CreateListenerDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        DEFAULT_TCP_LISTENER_NAME = DmListener.getDefaultName((Trace)t, (int)2);
        this.setHeadingsInfo();
        this.setPortsInUse();
    }

    public CreateListenerDialog(Shell parent) {
        this(parent, 0);
    }

    private void setHeadingsInfo() {
        Trace t = Trace.getDefault();
        if (this.titleText == null) {
            Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Command Dialog");
            this.titleText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Create.Listener.Title");
            blankPortError = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.BlankPortError");
            portInuseError = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.PortInuseError");
            portText = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Port");
            portExplanation = msgFile.getMessage(t, "UI.QMGR.Remote.Admin.Port.Text");
        }
        this.setTitle(this.titleText);
    }

    private void setPortsInUse() {
        Trace t = Trace.getDefault();
        DmObjectFilter filter = new DmObjectFilter(t, 97, 2);
        DmObjectFilter statusFilter = new DmObjectFilter(t, 98, 2);
        this.usedPorts = new HashSet();
        ArrayList qmgrs = UiPlugin.getTheDataModel().getQueueManagers(t);
        int i = 0;
        while (i < qmgrs.size()) {
            block16: {
                DmQueueManager qmgr = (DmQueueManager)qmgrs.get(i);
                if (qmgr.isLocal() && qmgr.isConnected()) {
                    ArrayList listeners = null;
                    ArrayList statusListeners = null;
                    try {
                        Integer portValue;
                        AttrInt attr;
                        DmListener listener;
                        int defaultPort = 1414;
                        AttrInt portAttr = (AttrInt)qmgr.getAttribute(t, 85, 0);
                        if (portAttr != null) {
                            Integer portValue2 = (Integer)portAttr.getValue(t);
                            defaultPort = portValue2;
                        }
                        listeners = qmgr.getObjects(t, filter);
                        int j = 0;
                        while (j < listeners.size()) {
                            listener = (DmListener)listeners.get(j);
                            attr = (AttrInt)listener.getAttribute(t, 1522, 0);
                            if (attr != null) {
                                portValue = (Integer)attr.getValue(t);
                                int number = portValue;
                                this.usedPorts.add(portValue);
                                if (number == 0 && !DEFAULT_TCP_LISTENER_NAME.equals(listener.getTitle())) {
                                    this.usedPorts.add(defaultPort);
                                } else if (number == defaultPort) {
                                    this.usedPorts.add(0);
                                }
                            } else if (Trace.isTracing) {
                                t.data(67, "CreateListenerDialog.setPortsInUse", "TCP listener with no port ? " + listener.toString(t));
                            }
                            ++j;
                        }
                        statusListeners = qmgr.getObjects(t, statusFilter);
                        j = 0;
                        while (j < statusListeners.size()) {
                            listener = (DmListenerStatus)statusListeners.get(j);
                            attr = (AttrInt)listener.getAttribute(t, 1522, 0);
                            if (attr != null) {
                                portValue = (Integer)attr.getValue(t);
                                this.usedPorts.add(portValue);
                            } else if (Trace.isTracing) {
                                t.data(67, "CreateListenerDialog.setPortsInUse", "TCP listener status with no port " + listener.toString(t));
                            }
                            ++j;
                        }
                    }
                    catch (DmCoreException e) {
                        if (!Trace.isTracing) break block16;
                        t.data(67, "CreateListenerDialog.setPortsInUse", 900, "Exception obtaining a list of used ports\n" + (Object)((Object)e));
                    }
                }
            }
            ++i;
        }
        this.defaultPortNumber = 1414;
    }

    private void setTitle(String titleText2) {
        this.titleText = titleText2;
    }

    protected void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    public int getPort() {
        int number = 0;
        Integer object = this.port.getValue();
        if (object != null) {
            number = object;
        }
        return number;
    }

    public boolean isEnableOK(Trace t) {
        boolean isEnableOk = false;
        Integer value = this.port.getValue();
        if (value == null) {
            isEnableOk = false;
            this.setErrorMessage(blankPortError);
        } else if (this.usedPorts.contains(value)) {
            isEnableOk = false;
            this.setErrorMessage(portInuseError);
        } else {
            isEnableOk = true;
            this.setErrorMessage(null);
        }
        return isEnableOk;
    }

    private void setErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            this.labelIcon.setVisible(true);
            this.labelMsg.setText(errorMessage);
            this.labelMsg.setVisible(true);
        } else {
            this.labelIcon.setVisible(false);
            this.labelMsg.setVisible(false);
        }
    }

    public boolean isPortOk() {
        boolean result = true;
        Integer value = this.port.getValue();
        if (value == null) {
            result = false;
        } else if (this.usedPorts.contains(value)) {
            result = false;
        }
        return result;
    }

    public String getTitle(Trace t) {
        return this.titleText;
    }

    public Image getImage(Trace t) {
        return Icons.get((String)Icons.iconkeyExplorerSmall);
    }

    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerRemoteAdminCreateLsnrDialog";
    }

    public boolean isPackDialog(Trace t) {
        return false;
    }

    public void packDialog(Trace t) {
    }

    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Filters");
        UiUtils.createBlankLine((Composite)composite, (int)1);
        Composite errorMessageComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        errorMessageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 400;
        errorMessageComposite.setLayoutData((Object)gridData);
        this.labelIcon = new Label(errorMessageComposite, 1);
        this.labelIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelIcon.setLayoutData((Object)gridData);
        this.labelMsg = new Label(errorMessageComposite, 64);
        this.labelMsg.setText(msgFile.getMessage(t, "UI.FILTERS.Dialog.NameInUseMsg"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 1;
        this.labelMsg.setLayoutData((Object)gridData);
        UiUtils.createBlankLine((Composite)composite, (int)4);
        final Label portExplanationLabel = new Label(composite, 64);
        portExplanationLabel.setText(portExplanation);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 400;
        gridData.grabExcessHorizontalSpace = true;
        portExplanationLabel.setLayoutData((Object)gridData);
        Composite portComposite = new Composite(composite, 0);
        layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        portComposite.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        portComposite.setLayoutData((Object)gridData);
        Label portPrompt = new Label(portComposite, 0);
        portPrompt.setText(portText);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        portPrompt.setLayoutData((Object)gridData);
        this.port = new NumberRange(portComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 50;
        this.port.setLayoutData((Object)gridData);
        this.port.setMinimum(0);
        this.port.setMaximum(999999999);
        this.port.setValue(this.defaultPortNumber);
        this.port.setEnabled(true);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                CreateListenerDialog.this.checkIfEnableOK(t2);
            }
        });
        Label label = new Label(portComposite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        UiUtils.createBlankLine((Composite)composite, (int)4);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace t2 = Trace.getDefault();
                UiUtils.resizeControl((Trace)t2, (Control)portExplanationLabel);
                UiUtils.resizeControl((Trace)t2, (Control)CreateListenerDialog.this.labelMsg);
            }
        });
        composite.pack();
        this.preferredSize = composite.getSize();
        this.checkIfEnableOK(t);
    }

    public boolean okPressed(Trace t) {
        this.setPortNumber(this.getPort());
        return true;
    }

    public void cancelPressed(Trace t) {
    }

    public boolean isUserButtons(Trace t) {
        return false;
    }

    public void createUserButtons(Trace t, Composite composite) {
    }

    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getPortNumber() {
        return this.portNumber;
    }
}

