/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queues;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queues.SelectQueuesViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueueFilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class UiQueueNewObjectProvider
extends NewObjectProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queues/UiQueueNewObjectProvider.java";
    private static final int NUM_TYPES = 4;
    private static final String TYPE_LOCAL = "com.ibm.mq.explorer.queue.local";
    private static final String TYPE_REMOTE = "com.ibm.mq.explorer.queue.remote";
    private static final String TYPE_MODEL = "com.ibm.mq.explorer.queue.model";
    private static final String TYPE_ALIAS = "com.ibm.mq.explorer.queue.alias";
    private static final String[] TYPES = new String[]{"com.ibm.mq.explorer.queue.local", "com.ibm.mq.explorer.queue.alias", "com.ibm.mq.explorer.queue.model", "com.ibm.mq.explorer.queue.remote"};
    private UiQueueManager uiQueueManager;
    private FilterProvider filterProvider = null;
    private Message msgFile = null;

    public UiQueueNewObjectProvider() {
    }

    public UiQueueNewObjectProvider(Trace t, UiMQObject parent) {
        super(t, parent);
        this.filterProvider = new UiQueueFilterProvider();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_NewObject");
    }

    public void setParent(Trace t, UiMQObject parent) {
        super.setParent(t, parent);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
    }

    public int getNewObjectTypeCount(Trace t) {
        return 4;
    }

    public String[] getNewObjectTypes(Trace t) {
        return TYPES;
    }

    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return String.valueOf(this.getNameForNewObjectType(t, typeId)) + "...";
    }

    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        String helpId = null;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QueueLocal";
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QueueRemote";
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QueueAlias";
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QueueModel";
        } else if (typeId.compareTo("com.ibm.mq.explorer.queue") == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QueueLocal";
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getHelpIdForNewObjectType", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return helpId;
    }

    public String getNameForNewObjectType(Trace t, String typeId) {
        String name = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Queue");
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeLocal");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeRemote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeAlias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeModel");
        } else if (typeId.compareTo("com.ibm.mq.explorer.queue") == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeGeneric");
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getNameForNewObjectType", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return name;
    }

    public String getDescriptionForNewObjectType(Trace t, String typeId) {
        String description = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Queue");
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            description = messageBundle.getMessage(t, "UI.Q.Queues.Description.TypeLocal");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            description = messageBundle.getMessage(t, "UI.Q.Queues.Description.TypeRemote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            description = messageBundle.getMessage(t, "UI.Q.Queues.Description.TypeAlias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            description = messageBundle.getMessage(t, "UI.Q.Queues.Description.TypeModel");
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getDescriptionForNewObjectType", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return description;
    }

    public String getDefaultLikeObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            name = "SYSTEM.DEFAULT.LOCAL.QUEUE";
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            name = "SYSTEM.DEFAULT.REMOTE.QUEUE";
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            name = "SYSTEM.DEFAULT.ALIAS.QUEUE";
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            name = "SYSTEM.DEFAULT.MODEL.QUEUE";
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getDefaultLikeObjectName", 10, 50999, 0, 0, "Unknown Like Queue Type", typeId, null);
        }
        return name;
    }

    public String getGenericObjectName(Trace t) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Queue");
        String name = messageBundle.getMessage(t, "UI.Q.Queues.Title");
        return name;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.queue";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.orderid.queues";
    }

    public boolean supportsDataModelListen(Trace t) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t) {
        DmQueueManager queueManager = null;
        if (this.uiQueueManager != null) {
            queueManager = this.uiQueueManager.getDmQueueManagerObject();
        }
        return queueManager;
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        return 13;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        int subType = 1;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            subType = 1;
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            subType = 2;
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            subType = 3;
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            subType = 6;
        }
        return subType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        IUiMQObjectFactory factory = null;
        if (this.uiQueueManager != null) {
            factory = this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.queue");
        }
        return factory;
    }

    public ViewerFilter getViewerFilter(Trace t, String typeId) {
        SelectQueuesViewerFilter viewerFilter = new SelectQueuesViewerFilter();
        viewerFilter.setHideAliasQueues(true);
        viewerFilter.setHideModelQueues(true);
        viewerFilter.setHideLocalQueues(true);
        viewerFilter.setHideRemoteQueues(true);
        viewerFilter.setHideTempQueues(true);
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            viewerFilter.setHideLocalQueues(false);
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            viewerFilter.setHideModelQueues(false);
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            viewerFilter.setHideAliasQueues(false);
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            viewerFilter.setHideRemoteQueues(false);
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getViewerFilter", 10, 50999, 0, 0, "Unknown Viewer Filter type", typeId, null);
        }
        return viewerFilter;
    }

    public int[] getMandatoryAttributeIds(Trace t, String typeId) {
        int[] ids = null;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)1);
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)6);
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)3);
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)2);
        } else if (typeId.compareTo("com.ibm.mq.explorer.queue") == 0) {
            ids = new int[]{};
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getMandatoryAttributeIds", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return ids;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.filterid.queues";
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public Integer getQSGDisposition() {
        return null;
    }

    public String getWizardTitle(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Model");
        } else if (typeId.compareTo("com.ibm.mq.explorer.queue") == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage.Title.Queue.Generic");
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getWizardTitle", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return title;
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Model");
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getWizardPage1Title", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return title;
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        String desc = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Model");
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getWizardPage2Description", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return desc;
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        String text = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Model");
        } else {
            t.FFST(67, "UiQueueNewObjectProvider.getWizardCreatingTaskText", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return text;
    }

    protected Class getNewObjectClass(Trace t) {
        return DmQueue.class;
    }

    public Composite addCustomArea(Trace t, NewObjectWiz wizard, Composite parentComposite, String pageId, int position) {
        Composite customArea = null;
        if (pageId.equals("PAGE_STD_SELECT_LIKE_OBJECT")) {
            customArea = this.addMappingArea(t, wizard, parentComposite);
        }
        return customArea;
    }
}

