/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queues;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.dialogs.ManageAuthorityRecordDeleteDialog;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queues.ClearMessagesDeleteDialog;
import com.ibm.mq.explorer.qmgradmin.internal.queues.QueueClusterPropertyPage;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public class UiQueue
extends UiMQObject
implements IActionFilter,
DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queues/UiQueue.java";
    private int queueType = -1;
    private String objectType = "";
    private UiQueueManager uiQueueManager = null;
    private BusyDialog busyDialog = null;

    public UiQueue() {
    }

    public UiQueue(Trace t, IDmObject dmObj, UiMQObject parent) {
        super(t, dmObj);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Object_Types");
        this.objectType = msgFile.getMessage(t, "UI.OBJECT.Type.Queue");
    }

    public String getId() {
        return "com.ibm.mq.explorer.queue";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 26: {
                isCustom = true;
            }
        }
        if (Trace.isTracing) {
            t.data(67, "UiQueue.isCustomGroup", 300, "isCustomGroup returning " + isCustom + " for group " + uiDisplayGroup.getDisplayGroup().getId());
        }
        return isCustom;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        QueueClusterPropertyPage customPage = null;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 26: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new QueueClusterPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiQueue.createCustomPropertyPage", 800, "Queue Cluster Property Custom Page to be displayed.");
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(67, "UiQueue.createCustomPropertyPage", 800, "No Property Custom Page to be displayed.");
            }
        }
        return customPage;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "UiQueue.testAttribute", 300, "testing object '" + target.toString() + "'");
            t.data(67, "UiQueue.testAttribute", 300, "checking attribute '" + name + "'");
            t.data(67, "UiQueue.testAttribute", 300, "for value '" + value + "'");
        }
        boolean result = false;
        UiMQObject targetObject = null;
        if (target instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)target;
            targetObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (targetObject != null && targetObject instanceof UiQueue) {
            if (name.compareTo("QueueType") == 0) {
                int qType = this.getQueueType(t);
                if (value.compareTo("Local") == 0 && qType == 1) {
                    result = true;
                } else if (value.compareTo("Remote") == 0 && qType == 6) {
                    result = true;
                } else if (value.compareTo("Alias") == 0 && qType == 3) {
                    result = true;
                } else if (value.compareTo("Model") == 0 && qType == 2) {
                    result = true;
                }
            } else if (name.compareTo("ConnectionType") == 0) {
                boolean isViaConnected = this.isViaConnected(t);
                if (value.compareTo("Indirect") == 0 && isViaConnected) {
                    result = true;
                } else if (value.compareTo("Direct") == 0 && !isViaConnected) {
                    result = true;
                }
            } else if (name.compareTo("QueueUsage") == 0) {
                Attr attr = this.getDmObject().getAttribute(t, 12, 0);
                if (attr != null && attr instanceof AttrInt) {
                    Integer intUsage = (Integer)((AttrInt)attr).getValue(t);
                    int usage = intUsage;
                    if (value.compareTo("Normal") == 0 && usage == 0) {
                        result = true;
                    } else if (value.compareTo("Transmission") == 0 && usage == 1) {
                        result = true;
                    }
                }
            } else {
                int iResult = this.uiQueueManager.testQmgrAttribute(t, (Object)this.uiQueueManager, name, value);
                switch (iResult) {
                    case 1: {
                        result = true;
                        break;
                    }
                    case 0: {
                        result = false;
                        break;
                    }
                    default: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(67, "UiQueue.testAttribute", 900, "Object is not a UiQueue");
            }
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(67, "UiQueue.testAttribute", 300, "returning " + result);
        }
        return result;
    }

    public int getQueueType(Trace t) {
        Object attrValue;
        Attr attr;
        if (this.queueType == -1 && (attr = this.getDmObject().getAttribute(t, 20, 0)) != null && (attrValue = attr.getValue(t)) instanceof Integer) {
            this.queueType = (Integer)attrValue;
            if (Trace.isTracing) {
                t.data(67, "UiQueue.getQueueType", 300, "Type for Queue '" + this.toString() + "' is " + this.queueType);
            }
        }
        int qType = this.queueType;
        if (Trace.isTracing) {
            t.data(67, "UiQueue.getQueueType", 300, "Type for Queue '" + this.toString() + "' is " + qType);
        }
        return qType;
    }

    public String getNLSResourceFileKey() {
        return "KEY_Queue";
    }

    public void updateIcon() {
        int i;
        Trace t = Trace.getDefault();
        Image image = null;
        int queueUsage = 0;
        String clusterName = "";
        String clusterNamelist = "";
        boolean qdispShared = false;
        IDmObject dmObject = this.getDmObject();
        dmObject.getAllAttributes(t);
        Attr attr = dmObject.getAttribute(t, 12, 0);
        if (attr != null) {
            Integer intUsage = (Integer)attr.getValue(t);
            queueUsage = intUsage;
        }
        if ((attr = dmObject.getAttribute(t, 2029, 0)) != null) {
            clusterName = (String)attr.getValue(t);
        }
        if ((attr = dmObject.getAttribute(t, 2030, 0)) != null) {
            clusterNamelist = (String)attr.getValue(t);
        }
        if ((attr = dmObject.getAttribute(t, 63, 0)) != null && (i = ((Integer)attr.getValue(t)).intValue()) == 2) {
            qdispShared = true;
        }
        if (clusterName.compareTo("") == 0 && clusterNamelist.compareTo("") == 0) {
            switch (this.getQueueType(t)) {
                case 3: {
                    if (qdispShared) {
                        image = Icons.get((String)Icons.iconkeyQSGqAlias);
                        break;
                    }
                    image = Icons.get((String)Icons.iconkeyQueueAliasSmall);
                    break;
                }
                case 2: {
                    if (qdispShared) {
                        image = Icons.get((String)Icons.iconkeyQSGmodelQ);
                        break;
                    }
                    image = Icons.get((String)Icons.iconkeyQueueModelSmall);
                    break;
                }
                case 6: {
                    if (qdispShared) {
                        image = Icons.get((String)Icons.iconkeyQSGremoteQ);
                        break;
                    }
                    image = Icons.get((String)Icons.iconkeyQueueRemoteSmall);
                    break;
                }
                default: {
                    if (queueUsage == 0) {
                        if (qdispShared) {
                            image = Icons.get((String)Icons.iconkeyQSGlocalQ);
                            break;
                        }
                        image = Icons.get((String)Icons.iconkeyQueueLocalSmall);
                        break;
                    }
                    if (qdispShared) {
                        image = Icons.get((String)Icons.iconkeyQSGtransmissionQ);
                        break;
                    }
                    image = Icons.get((String)Icons.iconkeyQueueTransmissionSmall);
                    break;
                }
            }
        } else {
            switch (this.getQueueType(t)) {
                case 3: {
                    image = Icons.get((String)Icons.iconkeyQueueAliasSharedSmall);
                    break;
                }
                case 6: {
                    image = Icons.get((String)Icons.iconkeyQueueRemoteSharedSmall);
                    break;
                }
                default: {
                    image = queueUsage == 0 ? Icons.get((String)Icons.iconkeyQueueLocalSharedSmall) : Icons.get((String)Icons.iconkeyQueueTransmissionSmall);
                }
            }
        }
        super.setImage(image);
    }

    public int getDataModelObjectType(Trace t) {
        return 13;
    }

    public boolean isLocal(Trace t) {
        return this.getQueueType(t) == 1;
    }

    public boolean isAlias(Trace t) {
        return this.getQueueType(t) == 3;
    }

    public boolean isModel(Trace t) {
        return this.getQueueType(t) == 2;
    }

    public boolean isRemote(Trace t) {
        return this.getQueueType(t) == 6;
    }

    public boolean isCluster(Trace t) {
        return this.getQueueType(t) == 7;
    }

    public boolean isTemporaryQueue(Trace t) {
        IDmObject dmObject = this.getDmObject();
        DmQueue dmQueue = (DmQueue)dmObject;
        return dmQueue.isTemporaryQueue(t);
    }

    public UiQueueManager getOwningUiQueueManager() {
        return this.uiQueueManager;
    }

    public boolean isSupportDelete() {
        return true;
    }

    public void deleteMenuAction(Trace t) {
        UiQueueManager uiQmgr;
        DmQueueManager dmQmgr;
        boolean fContinue = true;
        int[] parameters = new int[2];
        if (fContinue) {
            String msgCount = this.getDmObject().getAttributeValue(t, 3, 0);
            if (msgCount.equals("0") || msgCount.equalsIgnoreCase("[not_found]")) {
                fContinue = true;
            } else {
                ClearMessagesDeleteDialog clearDialog = null;
                clearDialog = new ClearMessagesDeleteDialog(this.shell);
                fContinue = clearDialog.open() == 2;
                parameters[0] = clearDialog.isClearMessages() ? 1 : 0;
            }
        }
        if (fContinue && (dmQmgr = (uiQmgr = this.getOwningUiQueueManager()).getDmQueueManagerObject()).getCommandLevel() >= 710 && dmQmgr.getPlatform() != 1) {
            ManageAuthorityRecordDeleteDialog authorityDialog = null;
            authorityDialog = new ManageAuthorityRecordDeleteDialog(1, this.shell);
            fContinue = authorityDialog.open() == 0;
            parameters[1] = authorityDialog.isRemoveAuthorityRecord() ? 1 : 0;
        }
        if (fContinue && this.isDeleteSystemObject(t, this.shell)) {
            Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)this.getNLSResourceFileKey());
            String msg = "";
            if (msgFile != null) {
                msg = msgFile.getMessage(t, "UI.GENERAL.BUSY.DELETE", this.toString());
            }
            this.busyDialog = new BusyDialog(this.shell, msg);
            this.getDmObject().actionDelete(t, (DmActionListener)this, (Object)parameters);
            this.busyDialog.showDialog(t);
        }
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public boolean isViaConnected(Trace t) {
        return this.getDmObject().getQueueManager().getConnectionHandle().isConnectionTypeVia(t);
    }

    public void dmActionDone(DmActionEvent event) {
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                UiQueue.this.busyDialog.closeDialog(trace);
                if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)trace, (Shell)UiPlugin.getShell(), (String)"AMQ4123", (String[])new String[]{UiQueue.this.toString()}, (String)"AMQ4123");
                } else if (exc != null) {
                    MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                } else {
                    MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                }
            }
        });
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public boolean isSelectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter) {
        return true;
    }

    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh) {
        String selectedAttributeObjectName = this.uiQueueManager.selectAttributeObjectFromDmObjectFilter(t, attrId, dmObjectFilter, currentSelection, helpId, sh, this.getSelectObjectDialogTitle(t, attrId), this.getSelectObjectDialogDescription(t, attrId), true);
        return selectedAttributeObjectName;
    }

    private String getSelectObjectDialogTitle(Trace t, int attrId) {
        String template = UiPlugin.getNLSString((Trace)t, (String)"KEY_Properties", (String)"UI.Objects.Select.Title");
        String title = Message.format((String)template, (String)DmQueue.getAttributeTitle((Trace)t, (int)attrId));
        return title;
    }

    private String getSelectObjectDialogDescription(Trace t, int attrId) {
        return this.getSelectObjectDialogTitle(t, attrId);
    }
}

