/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queues;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueue;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SelectQueuesViewerFilter
extends ViewerFilter {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queues/SelectQueuesViewerFilter.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    private boolean hideLocalQueues = false;
    private boolean hideAliasQueues = false;
    private boolean hideModelQueues = false;
    private boolean hideRemoteQueues = false;
    private boolean hideTempQueues = true;
    private boolean hideClusterQueues = false;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Trace t = Trace.getDefault();
        boolean select = true;
        UiQueue uiQueue = null;
        if (element instanceof UiQueue) {
            uiQueue = (UiQueue)((Object)element);
        } else if (element instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)element;
            uiQueue = (UiQueue)((Object)mqExtObject.getInternalObject());
        }
        if (uiQueue != null) {
            if (uiQueue.isTemporaryQueue(t)) {
                select = !this.hideTempQueues;
            } else {
                switch (uiQueue.getQueueType(t)) {
                    case 1: {
                        select = !this.hideLocalQueues;
                        break;
                    }
                    case 3: {
                        select = !this.hideAliasQueues;
                        break;
                    }
                    case 2: {
                        select = !this.hideModelQueues;
                        break;
                    }
                    case 6: {
                        select = !this.hideRemoteQueues;
                        break;
                    }
                    case 7: {
                        boolean bl = select = !this.hideClusterQueues;
                    }
                }
            }
        }
        if (Trace.isTracing) {
            t.data(67, "SelectQueuesViewerFilter.select", 300, "result for object " + element.toString() + " is " + select);
        }
        return select;
    }

    public boolean isHideLocalQueues() {
        return this.hideLocalQueues;
    }

    public boolean isHideAliasQueues() {
        return this.hideAliasQueues;
    }

    public boolean isHideClusterQueues() {
        return this.hideClusterQueues;
    }

    public boolean isHideModelQueues() {
        return this.hideModelQueues;
    }

    public boolean isHideRemoteQueues() {
        return this.hideRemoteQueues;
    }

    public boolean isHideTempQueues() {
        return this.hideTempQueues;
    }

    public void setHideLocalQueues(boolean b) {
        this.hideLocalQueues = b;
    }

    public void setHideAliasQueues(boolean b) {
        this.hideAliasQueues = b;
    }

    public void setHideClusterQueues(boolean b) {
        this.hideClusterQueues = b;
    }

    public void setHideModelQueues(boolean b) {
        this.hideModelQueues = b;
    }

    public void setHideRemoteQueues(boolean b) {
        this.hideRemoteQueues = b;
    }

    public void setHideTempQueues(boolean b) {
        this.hideTempQueues = b;
    }
}

