/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.actions.PingQueueManager;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandleInstance;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi.AddInstanceWiz;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi.AddInstanceWizDlg;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi.InstanceAttributeDetails;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi.UiQueueManagerHandleInstance;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi.UiQueueManagerHandleInstanceFactory;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShowInstancesDialog
extends TrayDialog
implements DmObjectListener,
DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/mi/ShowInstancesDialog.java";
    private static final int TABLE_WIDTH_HINT = 600;
    private static final int TABLE_HEIGHT_HINT = 250;
    private static final int NUMBER_OF_COLUMNS = 4;
    private ExplorerTable table = null;
    private Button buttonRemove = null;
    private Button buttonAdd = null;
    private Button buttonTestConn = null;
    private Button buttonMoveUp = null;
    private Button buttonMoveDown = null;
    private Message msgFile;
    private String qmName = null;
    private UiQueueManager uiQueueManager = null;
    private IUiMQObjectFactory mqObjFactory = null;
    private boolean listening = false;
    private UiQueueManagerHandleInstance uiQueueManagerHandleInstance = null;
    private DmQueueManagerHandleInstance dmQueueManagerHandleInstance = null;
    private BusyDialog busyDialog = null;
    private int counter = 0;

    public ShowInstancesDialog(Shell parent, UiQueueManager qm) {
        super(parent);
        Trace t = Trace.getDefault();
        this.uiQueueManager = qm;
        this.qmName = qm.toString();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_HandleInstance");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_ShowInstancesDialog");
        newShell.setText(this.msgFile.getMessage(Trace.getDefault(), "Mi.Instances.Dialog.Title", this.qmName));
        newShell.setImage(Icons.get((String)Icons.iconkeydetailsInstanceStandby));
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Composite compShown = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        compShown.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        compShown.setLayoutData((Object)gridData);
        Text labelDescription = new Text(compShown, 74);
        labelDescription.setText(this.msgFile.getMessage(t, "Mi.Instances.Dialog.Header.Info"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)labelDescription, (boolean)true);
        gridData = new GridData(4, 128, true, false, 4, 1);
        labelDescription.setLayoutData((Object)gridData);
        this.table = new ExplorerTable(t, compShown, 0, "com.ibm.mq.explorer.queuemanagerhandle", false, false, true, true, (Object)"com.ibm.mq.explorer.queuemanagerhandle.instance");
        this.initTable(t);
        this.table.getStatusBar().setCompressedMode(t);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 600;
        gridData.heightHint = 250;
        this.table.setLayoutData((Object)gridData);
        this.table.addSelChangedListener(t, new ExplorerTableSelectionChangedListener(){

            public void selChanged(ExplorerTableSelectionChangedEvent event) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.enableButtons(tr);
            }
        });
        this.table.addFocusListener(t, new FocusListener(){

            public void focusGained(FocusEvent e) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.enableButtons(tr);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Composite compositeMoveButtons = new Composite(compShown, 0);
        gridData = new GridData(1040);
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        compositeMoveButtons.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        compositeMoveButtons.setLayout((Layout)gridLayout);
        this.buttonMoveUp = new Button(compositeMoveButtons, 8);
        this.buttonMoveUp.setText(UiPlugin.getNLSString((Trace)t, (String)"KEY_HandleInstance", (String)"UI.SCHEMES.Dialog.MoveUp"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonMoveUp.setLayoutData((Object)gridData);
        this.buttonMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.moveItemUp(tr);
            }
        });
        this.buttonMoveUp.setEnabled(false);
        this.buttonMoveDown = new Button(compositeMoveButtons, 8);
        this.buttonMoveDown.setText(UiPlugin.getNLSString((Trace)t, (String)"KEY_HandleInstance", (String)"UI.SCHEMES.Dialog.MoveDown"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonMoveDown.setLayoutData((Object)gridData);
        this.buttonMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.moveItemDown(tr);
            }
        });
        this.buttonMoveDown.setEnabled(false);
        this.buttonAdd = new Button(compositeMoveButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "UI.QMGRS.Add.Button"));
        GridData gridDataAdd = new GridData();
        gridDataAdd.horizontalAlignment = 3;
        gridDataAdd.verticalAlignment = 3;
        this.buttonAdd.setLayoutData((Object)gridDataAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.addInstance(tr);
            }
        });
        this.buttonRemove = new Button(compositeMoveButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "UI.QMGRS.Remove.Button"));
        GridData gridDataHide = new GridData();
        gridDataHide.horizontalAlignment = 3;
        gridDataHide.verticalAlignment = 3;
        this.buttonRemove.setLayoutData((Object)gridDataHide);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.removeInstance(tr);
            }
        });
        this.buttonRemove.setEnabled(false);
        Composite compButtons = new Composite(compShown, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        compButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        compButtons.setLayoutData((Object)gridData);
        this.buttonTestConn = new Button(compButtons, 8);
        this.buttonTestConn.setText(this.msgFile.getMessage(t, "Mi.Instances.Dialog.Test.Connections.Button"));
        gridDataHide = new GridData();
        gridDataHide.horizontalAlignment = 3;
        gridDataHide.verticalAlignment = 3;
        this.buttonTestConn.setLayoutData((Object)gridDataHide);
        this.buttonTestConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowInstancesDialog.this.testConnections(tr);
            }
        });
        Label complabel = new Label(compButtons, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        complabel.setLayoutData((Object)gridData);
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.buttonMoveUp, this.buttonMoveDown, this.buttonAdd, this.buttonRemove});
        this.startListening(t);
        return composite;
    }

    private void initTable(Trace t) {
        this.mqObjFactory = new UiQueueManagerHandleInstanceFactory(this.uiQueueManager);
        AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
        InstanceAttributeDetails aDetails = new InstanceAttributeDetails();
        attrOrderManager.register(t, (IAttributeDetails)aDetails, "com.ibm.mq.explorer.queuemanagerhandle.instance", "com.ibm.mq.explorer.orderid.queuemanagerhandle.ha.instance", "HaInstancesExplorerTable", aDetails.getDefaultAttributeOrder(t));
        this.table.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.queuemanagerhandle.ha.instance");
        this.table.setSorting(t, false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        this.okPressed();
    }

    private void addInstance(Trace t) {
        String svrConnChannel = "";
        if (this.isMultiInstance(t)) {
            ArrayList list = this.table.getObjects(t);
            if (list.size() > 0) {
                this.dmQueueManagerHandleInstance = (DmQueueManagerHandleInstance)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(0)).getInternalObject())).getDmObject();
                svrConnChannel = this.dmQueueManagerHandleInstance.getAttributeValue(t, 11003, 0);
            }
            AddInstanceWiz addQmgrWiz = new AddInstanceWiz(t);
            addQmgrWiz.setQueueManagerName(this.qmName);
            addQmgrWiz.setDmQueueManager(this.uiQueueManager.getDmQueueManagerObject());
            addQmgrWiz.setSvrConnChannel(svrConnChannel);
            AddInstanceWizDlg addQmgrWizDlg = new AddInstanceWizDlg(this.getShell(), (IWizard)addQmgrWiz);
            addQmgrWizDlg.create();
            if (addQmgrWizDlg.open() != 1 && addQmgrWiz.getAddedDmQueueManagerHandle() != null) {
                this.dmQueueManagerHandleInstance = new DmQueueManagerHandleInstance(t, this.uiQueueManager.getDmQueueManagerObject().getConnectionHandle(), addQmgrWiz.getNewConnName());
                this.setOrderNumber(t, this.dmQueueManagerHandleInstance, this.table.getItemCount(t) + 1);
                this.uiQueueManagerHandleInstance = (UiQueueManagerHandleInstance)this.mqObjFactory.create(t, (IDmObject)this.dmQueueManagerHandleInstance, (UiMQObject)this.uiQueueManager);
                this.table.addTableItem(t, (UiMQObject)this.uiQueueManagerHandleInstance);
                this.table.updateLastRefreshText(t);
                UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager.status", (boolean)false);
            }
        }
    }

    private void removeInstance(Trace t) {
        this.uiQueueManagerHandleInstance = (UiQueueManagerHandleInstance)this.table.getSelectedItem(t);
        this.dmQueueManagerHandleInstance = (DmQueueManagerHandleInstance)this.uiQueueManagerHandleInstance.getDmObject();
        String connName = this.dmQueueManagerHandleInstance.getAttributeValue(t, 11002, 0);
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4829", (String[])new String[]{connName, this.qmName});
        int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)msg, (int)1, (String)"AMQ4829");
        if (rc == 0 && this.removeConnName(t, connName)) {
            this.table.removeTableItem(t, (UiMQObject)this.uiQueueManagerHandleInstance, false);
            this.table.refresh();
            ArrayList list = this.table.getObjects(t);
            int i = 0;
            while (i < list.size()) {
                this.dmQueueManagerHandleInstance = (DmQueueManagerHandleInstance)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(i)).getInternalObject())).getDmObject();
                this.setOrderNumber(t, this.dmQueueManagerHandleInstance, i + 1);
                ++i;
            }
            this.table.refresh();
            this.table.setSelection(t, 0);
            this.table.updateLastRefreshText(t);
            this.enableButtons(t);
        }
    }

    private void enableButtons(Trace t) {
        this.buttonRemove.setEnabled(false);
        this.buttonMoveUp.setEnabled(false);
        this.buttonMoveDown.setEnabled(false);
        int itemCount = this.table.getItemCount(t);
        if (itemCount > 1 && this.table.getSelectedItem(t) != null) {
            int index;
            this.uiQueueManagerHandleInstance = (UiQueueManagerHandleInstance)this.table.getSelectedItem(t);
            if (!this.uiQueueManagerHandleInstance.isActiveInstance(t)) {
                this.buttonRemove.setEnabled(true);
            }
            if ((index = this.table.getSelectionIndex()) > 0) {
                this.buttonMoveUp.setEnabled(true);
            }
            if (index + 1 < itemCount) {
                this.buttonMoveDown.setEnabled(true);
            }
        }
    }

    private void startListening(Trace t) {
        if (!this.listening && this.uiQueueManager.isConnected()) {
            DmObjectFilter filter = new DmObjectFilter(t, 2);
            this.uiQueueManager.getDmQueueManagerObject().addObserver(t, (DmObjectListener)this, filter);
            this.listening = true;
        }
        this.addItemsToTable(t, this.uiQueueManager.getDmQueueManagerObject());
    }

    private void stopListening(Trace t) {
        if (this.listening) {
            this.uiQueueManager.getDmQueueManagerObject().deleteObserver(t, (DmObjectListener)this);
            this.listening = false;
        }
    }

    private void addItemsToTable(Trace t, DmQueueManager qm) {
        if (!this.uiQueueManager.isLocal() && this.uiQueueManager.toString().equals(qm.getTitle())) {
            DmQueueManagerHandle dmObject = qm.getConnectionHandle();
            Attr a = dmObject.getAttribute(t, 11029, 0);
            if (a != null) {
                ArrayList ss = (ArrayList)a.getValue(t);
                this.table.removeAll(t);
                int i = 0;
                while (i < ss.size()) {
                    this.dmQueueManagerHandleInstance = new DmQueueManagerHandleInstance(t, dmObject, (String)ss.get(i));
                    this.setOrderNumber(t, this.dmQueueManagerHandleInstance, i + 1);
                    this.uiQueueManagerHandleInstance = (UiQueueManagerHandleInstance)this.mqObjFactory.create(t, (IDmObject)this.dmQueueManagerHandleInstance, (UiMQObject)this.uiQueueManager);
                    this.table.addTableItem(t, (UiMQObject)this.uiQueueManagerHandleInstance);
                    ++i;
                }
            } else {
                String s = dmObject.getAttributeValue(t, 11002, 0);
                this.dmQueueManagerHandleInstance = new DmQueueManagerHandleInstance(t, dmObject, s);
                this.setOrderNumber(t, this.dmQueueManagerHandleInstance, 1);
                this.uiQueueManagerHandleInstance = (UiQueueManagerHandleInstance)this.mqObjFactory.create(t, (IDmObject)this.dmQueueManagerHandleInstance, (UiMQObject)this.uiQueueManager);
                this.table.addTableItem(t, (UiMQObject)this.uiQueueManagerHandleInstance);
            }
            this.table.updateLastRefreshText(t);
            this.enableButtons(t);
        }
    }

    public boolean close() {
        this.stopListening(Trace.getDefault());
        return super.close();
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        if (event.getSource() != null && event.getSource() instanceof DmQueueManager) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ShowInstancesDialog.this.counter = 0;
                    ShowInstancesDialog.this.table.removeAll(Trace.getDefault());
                }
            });
        }
    }

    private boolean removeConnName(Trace t, String conn) {
        ArrayList ss = new ArrayList();
        boolean removed = true;
        DmQueueManagerHandle dmObject = this.uiQueueManager.getDmQueueManagerObject().getConnectionHandle();
        Attr a = dmObject.getAttribute(t, 11029, 0);
        if (a != null) {
            ss = (ArrayList)a.getValue(t);
            ss.remove(conn);
        }
        Object job = dmObject.beginUpdate(t);
        String[] l = ss.toArray(new String[ss.size()]);
        boolean result1 = dmObject.setAttributeValue(t, job, 11029, 0, (Object)l);
        int result2 = dmObject.actionChange(t, null, job, false);
        if (!result1 || result2 != 0) {
            removed = false;
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4172");
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)msg, (String)"AMQ4172");
        }
        return removed;
    }

    private void moveItemUp(Trace t) {
        ArrayList list = this.table.getObjects(t);
        int index = this.table.getSelectionIndex();
        MQExtObject o1 = (MQExtObject)list.get(index - 1);
        MQExtObject o2 = (MQExtObject)list.get(index);
        list.set(index - 1, o2);
        list.set(index, o1);
        if (this.saveConnNames(t, list)) {
            this.table.removeAll(t);
            int i = 0;
            while (i < list.size()) {
                this.dmQueueManagerHandleInstance = (DmQueueManagerHandleInstance)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(i)).getInternalObject())).getDmObject();
                this.setOrderNumber(t, this.dmQueueManagerHandleInstance, i + 1);
                this.table.addTableItem(t, (UiMQObject)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(i)).getInternalObject())));
                ++i;
            }
            this.table.setSelection(t, index - 1);
            this.enableButtons(t);
            this.table.updateLastRefreshText(t);
        }
    }

    private void moveItemDown(Trace t) {
        ArrayList list = this.table.getObjects(t);
        int index = this.table.getSelectionIndex();
        MQExtObject o1 = (MQExtObject)list.get(index + 1);
        MQExtObject o2 = (MQExtObject)list.get(index);
        list.set(index + 1, o2);
        list.set(index, o1);
        if (this.saveConnNames(t, list)) {
            this.table.removeAll(t);
            int i = 0;
            while (i < list.size()) {
                this.dmQueueManagerHandleInstance = (DmQueueManagerHandleInstance)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(i)).getInternalObject())).getDmObject();
                this.setOrderNumber(t, this.dmQueueManagerHandleInstance, i + 1);
                this.table.addTableItem(t, (UiMQObject)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(i)).getInternalObject())));
                ++i;
            }
            this.table.setSelection(t, index + 1);
            this.enableButtons(t);
            this.table.updateLastRefreshText(t);
        }
    }

    private boolean saveConnNames(Trace t, ArrayList<MQExtObject> list) {
        ArrayList<String> ss = new ArrayList<String>();
        boolean saved = true;
        int i = 0;
        while (i < list.size()) {
            ss.add(((UiQueueManagerHandleInstance)((Object)list.get(i).getInternalObject())).getDmObject().getAttributeValue(t, 11002, 0));
            ++i;
        }
        DmQueueManagerHandle dmObject = this.uiQueueManager.getDmQueueManagerObject().getConnectionHandle();
        Object job = dmObject.beginUpdate(t);
        String[] l = ss.toArray(new String[ss.size()]);
        boolean result1 = dmObject.setAttributeValue(t, job, 11029, 0, (Object)l);
        int result2 = dmObject.actionChange(t, null, job, false);
        if (!result1 || result2 != 0) {
            saved = false;
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4172");
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)msg, (String)"AMQ4172");
        }
        return saved;
    }

    private void testConnections(Trace t) {
        ArrayList list = this.table.getObjects(t);
        this.counter = list.size();
        if (this.counter > 0) {
            int i = 0;
            while (i < this.counter) {
                DmQueueManagerHandleInstance n = (DmQueueManagerHandleInstance)((UiQueueManagerHandleInstance)((Object)((MQExtObject)list.get(i)).getInternalObject())).getDmObject();
                new PingQueueManager(t, (DmActionListener)this, this.uiQueueManager.getDmQueueManagerObject(), n);
                ++i;
            }
            this.busyDialog = new BusyDialog(this.getShell(), this.msgFile.getMessage(t, "Mi.Instances.Dialog.Test.Connections.Button"), true);
            this.busyDialog.showDialog(t);
        } else {
            this.table.updateLastRefreshText(t);
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmActionDone(DmActionEvent event) {
        if (event.getSource() != null && event.getSource() instanceof IDmObject) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ShowInstancesDialog.this.table.isDisposed()) {
                        ShowInstancesDialog.this.table.refresh();
                    }
                }
            });
            --this.counter;
            if (this.counter <= 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ShowInstancesDialog.this.busyDialog.isClosed()) {
                            ShowInstancesDialog.this.busyDialog.closeDialog(Trace.getDefault());
                        }
                    }
                });
            }
        }
    }

    private boolean isMultiInstance(Trace t) {
        boolean multi = true;
        boolean connType = this.uiQueueManager.getDmQueueManagerObject().getConnectionHandle().isConnectionTypeClient(t);
        int i = this.table.getItemCount(t);
        if (connType && i < 2) {
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4613", (String)this.qmName);
            int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)msg, (int)1, (String)"AMQ4613");
            if (rc == 1 || rc == -1) {
                multi = false;
            }
        }
        return multi;
    }

    private void setOrderNumber(Trace t, DmQueueManagerHandleInstance dmqmhi, int i) {
        Object job = dmqmhi.beginUpdate(t);
        dmqmhi.setAttributeValue(t, job, 11031, 0, (Object)i);
        dmqmhi.actionChange(t, null, job, false);
    }
}

