/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyChange;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyFactory;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsUserid;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class UseridPropertyPage
extends CustomPropertyPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/UseridPropertyPage.java";
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    protected Message msgFile = null;
    private ConnectionDetailsUserid useridComposite = null;
    private boolean userIdEnabled = false;
    private boolean compatMode = true;
    private int passwordMode = -1;
    private String userid = "";
    private String password = null;
    private ConnDetailsPropertyChange changeManager = null;
    private String pageName = null;
    private Link linkPasswordWarning = null;

    public UseridPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDispGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Properties");
        this.pageName = uiDispGroup.getDisplayGroup().getTitle();
    }

    public void init(Trace t) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gridData = null;
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.setLayoutData(gridData);
        this.useridComposite = new ConnectionDetailsUserid((Composite)this, 0, 1, false);
        this.useridComposite.setPasswordValidation(false);
        this.loadCurrentSettings(t);
        this.linkPasswordWarning = this.useridComposite.getPasswordWarningLink();
        this.linkPasswordWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.openPasswordPreferencePage(t2);
                UseridPropertyPage.this.checkPasswordPreference(t2);
            }
        });
        this.checkPasswordPreference(t);
    }

    private void loadCurrentSettings(Trace t) {
        String passwordModeValue;
        String compatValue;
        this.dmObject = this.uiMQObject.getDmObject();
        this.userid = this.dmObject.getAttributeValue(t, 11018, 0);
        Attr passwordAttr = this.dmObject.getAttribute(t, 11019, 0);
        if (passwordAttr != null && passwordAttr.getAction(t) != 3) {
            this.password = this.dmObject.getAttributeValue(t, 11019, 0);
        }
        if (!(compatValue = this.dmObject.getAttributeValue(t, 11033, 0)).equals("[not_found]")) {
            boolean bl = this.compatMode = Integer.parseInt(compatValue) == 1;
        }
        if (!(passwordModeValue = this.dmObject.getAttributeValue(t, 11034, 0)).equals("[not_found]")) {
            this.passwordMode = Integer.parseInt(passwordModeValue);
        }
        this.userIdEnabled = Integer.parseInt(this.dmObject.getAttributeValue(t, 11032, 0)) == 1;
        this.useridComposite.setUserIdStateSelection(this.userIdEnabled);
        this.useridComposite.setCompatModeStateSelection(this.compatMode);
        this.useridComposite.setPasswordModeStateSelection(this.passwordMode);
        this.useridComposite.getTextUseridName().setText(this.userid);
        if (this.password != null && !this.password.equals("")) {
            this.useridComposite.getTextPassword().setText("********");
            this.useridComposite.setPassword(this.password);
        } else {
            this.useridComposite.getTextPassword().setText("");
            this.useridComposite.setPassword(null);
        }
        if (Trace.isTracing) {
            t.data(67, "UseridPropertyPage.loadCurrentSettings", 300, "Loaded attribute userid details" + Common.NEW_LINE + "name = " + this.userid);
        }
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        boolean applied = false;
        boolean changed = false;
        this.changeManager = ConnDetailsPropertyFactory.create(t, this.uiMQObject.getDmObject().getQueueManager());
        if (this.changeNeeded(t)) {
            String newUserid;
            int newPasswordMode;
            boolean newCompatMode;
            boolean newUseridEnabled = this.useridComposite.getUserIdStateSelection();
            if (this.userIdEnabled != newUseridEnabled && (changed = this.dmObject.setAttributeValue(t, job, 11032, 0, (Object)(newUseridEnabled ? 1 : 0)))) {
                this.userIdEnabled = newUseridEnabled;
                applied = true;
            }
            if (this.compatMode != (newCompatMode = this.useridComposite.getCompatModeStateSelection()) && (changed = this.dmObject.setAttributeValue(t, job, 11033, 0, (Object)(newCompatMode ? 1 : 0)))) {
                this.compatMode = newCompatMode;
                applied = true;
            }
            if (this.passwordMode != (newPasswordMode = this.useridComposite.getPasswordModeStateSelection()) && (changed = this.dmObject.setAttributeValue(t, job, 11034, 0, (Object)newPasswordMode))) {
                this.passwordMode = newPasswordMode;
                applied = true;
            }
            if (!this.userid.equals(newUserid = this.useridComposite.getTextUseridName().getText()) && (changed = this.dmObject.setAttributeValue(t, job, 11018, 0, (Object)newUserid))) {
                this.userid = newUserid;
                applied = true;
            }
            String newPassword = this.useridComposite.getPassword();
            if (this.password == null || !this.password.equals(newPassword)) {
                if (this.dmObject.getAttribute(t, 11019, 0) == null) {
                    Attr newAttr;
                    if (newPassword != null && (newAttr = this.dmObject.createAttribute(t, job, 11019, 0, (Object)newPassword)) != null) {
                        changed = this.dmObject.setAttributeValue(t, job, 11019, 0, (Object)newPassword);
                    }
                } else {
                    changed = newPassword != null ? this.dmObject.setAttributeValue(t, job, 11019, 0, (Object)newPassword) : this.dmObject.deleteAttribute(t, job, 11019, 0);
                }
                if (changed) {
                    this.password = newPassword;
                    applied = true;
                    if (this.password != null) {
                        PwUtils.savePassword((Trace)t, (IDmObject)this.dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.userid.pw", (String)this.userid, (String)this.password);
                    } else {
                        PwUtils.removePassword((Trace)t, (IDmObject)this.dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.userid.pw", (String)this.userid, (String)this.password);
                    }
                }
            }
        }
        return applied;
    }

    public boolean isAnyControlEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
        if (this.changeManager != null) {
            this.changeManager.changesApplied(t, this.pageName);
        }
    }

    private boolean changeNeeded(Trace t) {
        boolean change = false;
        boolean newUseridEnabled = this.useridComposite.getUserIdStateSelection();
        boolean newCompatMode = this.useridComposite.getCompatModeStateSelection();
        int newPasswordMode = this.useridComposite.getPasswordModeStateSelection();
        String newUserid = this.useridComposite.getTextUseridName().getText();
        String newPassword = this.useridComposite.getPassword();
        if (!this.userid.equals(newUserid)) {
            change = true;
        } else if (this.password == null || !this.password.equals(newPassword)) {
            change = true;
        } else if (this.compatMode != newCompatMode) {
            change = true;
        } else if (this.passwordMode != newPasswordMode) {
            change = true;
        } else if (this.userIdEnabled != newUseridEnabled) {
            change = true;
        }
        if (change) {
            change = this.changeManager.apply(t, this.pageName);
        }
        return change;
    }

    private void checkPasswordPreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
        this.linkPasswordWarning.setVisible(!passwordStoreEnabled);
        this.useridComposite.setPasswordSaving(t, passwordStoreEnabled);
    }

    public boolean isPromptPassword() {
        boolean promptMode = false;
        if (this.useridComposite.getUserIdStateSelection() && this.useridComposite.getPasswordModeStateSelection() == 1) {
            promptMode = true;
        }
        return promptMode;
    }
}

