/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiNHAGroupStatusProvider;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiNHAStatusProvider;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiPubSubLocalStatusProvider;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiPubSubParentStatusProvider;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class UiQueueManagerStatusProvider
extends UiStatusProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/UiQueueManagerStatusProvider.java";
    private static final int NUM_INFO_STRINGS = 1;
    private static final int INDEX_QMGR_NAME = 0;
    private ArrayList<UiMQObject> statusObjects = null;
    private Message msgFile = null;
    private static String typeGeneralMenuText = null;
    private static String typePubSubMenuText = null;
    private static String typeNHAMenuText = null;
    private static String genericStandardTitle = null;
    private static String genericGeneralTitle = null;
    private static String genericPubSubTitle = null;
    private static String genericNHATitle = null;
    private static final int[] weights = new int[]{33, 33, 34};
    private UiMQObject parent = null;

    public UiQueueManagerStatusProvider() {
    }

    public UiQueueManagerStatusProvider(Trace t, UiMQObject parent) {
        super(t, parent);
        this.parent = parent;
        this.statusObjects = new ArrayList();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
        typeGeneralMenuText = this.msgFile.getMessage(t, "UI.STATUS.General.MenuItem");
        typePubSubMenuText = this.msgFile.getMessage(t, "UI.STATUS.PubSub.MenuItem");
        typeNHAMenuText = this.msgFile.getMessage(t, "UI.STATUS.NativeHA.MenuItem");
        genericStandardTitle = this.msgFile.getMessage(t, "UI.QMGR.QueueManager.Title");
        genericGeneralTitle = this.msgFile.getMessage(t, "UI.STATUS.General.Title");
        genericPubSubTitle = this.msgFile.getMessage(t, "UI.STATUS.PubSub.Title");
        genericNHATitle = this.msgFile.getMessage(t, "UI.STATUS.NativeHA.Title");
    }

    public int getStatusInstances(Trace t, UiMQObject owningObject, Object contextObject) {
        UiQueueManager uiQm = (UiQueueManager)owningObject;
        if (uiQm.isConnected()) {
            return owningObject.getDmObject().getStatusType(t);
        }
        return 0;
    }

    public String[] getStatusTypes(Trace t, UiMQObject owningObject) {
        int noOfMenuItems = 1;
        UiQueueManager uiQm = (UiQueueManager)owningObject;
        DmQueueManager dmQm = uiQm.getDmQueueManagerObject();
        if (dmQm.getCommandLevel() >= 932) {
            noOfMenuItems = 3;
        } else if (dmQm.getCommandLevel() >= 700) {
            noOfMenuItems = 2;
        }
        String[] ids = new String[noOfMenuItems];
        if (noOfMenuItems > 1) {
            ids[0] = "com.ibm.mq.explorer.ui.status.general";
            ids[1] = "com.ibm.mq.explorer.ui.status.pubsub";
            if (noOfMenuItems > 2) {
                ids[2] = "com.ibm.mq.explorer.ui.status.nha";
            }
        } else {
            ids[0] = "com.ibm.mq.explorer.ui.status.standard";
        }
        return ids;
    }

    public String getMenuTextForStatusType(Trace t, String typeID) {
        String menuText = null;
        if (typeID.compareTo("com.ibm.mq.explorer.ui.status.general") == 0) {
            menuText = typeGeneralMenuText;
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            menuText = typePubSubMenuText;
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            menuText = typeNHAMenuText;
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            menuText = null;
        } else {
            t.data(67, "UiQueueManagerStatusProvider.getMenuTextForStatusType", 900, "menu text - bad status type detected: " + typeID);
        }
        return menuText;
    }

    public UiMQObject[] getStatusObjectsForStatusType(Trace t, String typeID, UiMQObject owningObject) {
        return this.statusObjects.toArray(new UiMQObject[this.statusObjects.size()]);
    }

    public String getGenericObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo("com.ibm.mq.explorer.ui.status.general") == 0) {
            name = genericGeneralTitle;
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            name = genericPubSubTitle;
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            name = genericNHATitle;
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            name = genericStandardTitle;
        } else {
            t.data(67, "UiQueueManagerStatusProvider.getGenericObjectName", 900, "generic name - bad status type detected: " + typeId);
        }
        return name;
    }

    public String getObjectId(String typeId) {
        String id = "";
        if (typeId.compareTo("com.ibm.mq.explorer.ui.status.general") == 0 || typeId.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            id = "com.ibm.mq.explorer.queuemanager.status";
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            id = "com.ibm.mq.explorer.pubsub.status";
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            id = "com.ibm.mq.explorer.nha.status";
        }
        return id;
    }

    public String getAttributeOrderId(String typeId) {
        String id = "";
        if (typeId.compareTo("com.ibm.mq.explorer.ui.status.general") == 0 || typeId.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            id = "com.ibm.mq.explorer.orderid.qmgrstatus";
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            id = "com.ibm.mq.explorer.orderid.pubsub.status";
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            id = "com.ibm.mq.explorer.orderid.nha.status";
        }
        return id;
    }

    public void refresh(Trace t, UiMQObject owningObject) {
        this.statusObjects = null;
    }

    public String[] getInformationAreaTitles(Trace t, String typeId) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Queue");
        String[] titles = new String[]{messageBundle.getMessage(t, "UI.QMGR.Status.QmgrName")};
        return titles;
    }

    public String[] getInformationAreaValues(Trace t, String typeId, UiMQObject owningObject) {
        UiQueueManager uiQueueManager = (UiQueueManager)owningObject;
        String[] values = new String[]{uiQueueManager.getDmObject().getTitle()};
        return values;
    }

    public boolean supportsDataModelListen(Trace t, String typeId) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t, UiMQObject owningObject) {
        return owningObject.getDmObject().getQueueManager();
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        int objectType = 0;
        if (typeId.compareTo("com.ibm.mq.explorer.ui.status.general") == 0 || typeId.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            objectType = 161;
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            objectType = 185;
        } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            objectType = 1031;
        }
        return objectType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t, String typeId, UiMQObject owningObject) {
        IUiMQObjectFactory uiMQObjectFactory = null;
        if (owningObject instanceof UiQueueManager) {
            UiQueueManager uiQueueManager = (UiQueueManager)owningObject;
            String id = "";
            if (typeId.compareTo("com.ibm.mq.explorer.ui.status.general") == 0 || typeId.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
                id = "com.ibm.mq.explorer.queuemanager.status";
            } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
                id = "com.ibm.mq.explorer.pubsub.status";
            } else if (typeId.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
                id = "com.ibm.mq.explorer.nha.status";
            }
            uiMQObjectFactory = uiQueueManager.getFactoryClass(t, id);
        }
        return uiMQObjectFactory;
    }

    public boolean isGenericStatus(Trace t) {
        return false;
    }

    public Image getImage(String typeId) {
        return Icons.get((String)Icons.iconkeyQmgrSmall);
    }

    public String getFilterId(String typeId) {
        return null;
    }

    public FilterProvider getFilterProvider(Trace t, String typeId) {
        return null;
    }

    public Integer getFilterQSGDisposition(Trace t, String typeId) {
        return null;
    }

    public String getTableHeading(Trace t, String typeId, UiMQObject owningObject) {
        return null;
    }

    public ViewerFilter getTableViewerFilter(Trace t, String typeId) {
        return null;
    }

    public int[] getAdditionalButtonIds(Trace t, String typeId) {
        return null;
    }

    public String getAdditionalButtonText(Trace t, String typeId, int id) {
        return null;
    }

    public boolean isEnableAdditionalButton(Trace t, String typeId, int id, UiMQObject uiMQObject) {
        return false;
    }

    public void additionalButtonSelected(Trace t, int id, Shell shell, UiMQObject uiMQObject) {
    }

    public UiStatusProvider getDualModeStatusProvider(Trace t, String typeId) {
        if (typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            return new UiPubSubParentStatusProvider();
        }
        if (typeId.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            DmQueueManager dmQm = this.parent.getDmObject().getQueueManager();
            if (dmQm.getCommandLevel() >= 942) {
                return new UiNHAGroupStatusProvider();
            }
            return null;
        }
        return null;
    }

    public String getMenuHelpIdForStatusType(Trace t, String typeID) {
        return null;
    }

    public String getDialogHelpIdForStatusType(Trace t, String typeID) {
        String helpID = null;
        if (typeID.compareTo("com.ibm.mq.explorer.ui.status.general") == 0 || typeID.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            helpID = "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerStatusDialog";
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            helpID = "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerPubSubStatusDialog";
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            helpID = "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerNHAStatusesDialog";
        } else {
            t.data(67, "UiQueueManagerStatusProvider.getDialogHelpIdForStatusType", 900, "helpID - bad status type detected: " + typeID);
        }
        return helpID;
    }

    public boolean isCollectionMode(Trace t, String typeId) {
        return typeId.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        return -1;
    }

    public UiStatusProvider[] getCollectionStatusProviders(Trace t, String typeId) {
        UiStatusProvider[] temp = null;
        if (typeId.equals("com.ibm.mq.explorer.ui.status.pubsub")) {
            temp = new UiStatusProvider[]{new UiPubSubLocalStatusProvider()};
        } else if (typeId.equals("com.ibm.mq.explorer.ui.status.nha")) {
            temp = new UiStatusProvider[]{new UiNHAStatusProvider()};
        }
        return temp;
    }

    public UiStatusProvider getOwningStatusProvider(Trace t, String type, UiStatusProvider statusProvider) {
        return null;
    }

    public boolean showSchemeBar(Trace t, String typeId, UiMQObject owningObject) {
        return false;
    }

    public DmObjectFilter getExplicitDmObjectFilter(Trace t, UiMQObject owningObject) {
        return null;
    }

    public Integer getExplicitDmObjectFilterQSGDisposition(Trace t, UiMQObject owningObject) {
        return null;
    }

    public String getNameForStatusType(Trace t, String typeID) {
        String menuText = null;
        if (typeID.compareTo("com.ibm.mq.explorer.ui.status.general") == 0 || typeID.compareTo("com.ibm.mq.explorer.ui.status.standard") == 0) {
            menuText = null;
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.pubsub") == 0) {
            menuText = genericPubSubTitle;
        } else if (typeID.compareTo("com.ibm.mq.explorer.ui.status.nha") == 0) {
            menuText = genericNHATitle;
        } else {
            t.data(67, "UiQueueManagerStatusProvider.getNameForStatusType", 900, "menu text - bad status type detected: " + typeID);
        }
        return menuText;
    }

    public int[] getRowWeights() {
        return weights;
    }
}

