/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiQueueManagerHandle;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class UiQueueManagerMenuAction
implements IActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/UiQueueManagerMenuAction.java";
    private TreeNode selectedTreeNode = null;
    private MQExtObject selectedMQExtObject = null;
    protected DmQueueManager dmQueueManager = null;
    private UiQueueManager uiQueueManager = null;

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object obj;
        Trace t = Trace.getDefault();
        if (selection != null && selection instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            if (obj instanceof TreeNode) {
                this.selectedTreeNode = (TreeNode)obj;
                if (Trace.isTracing) {
                    t.data(67, "UiQueueManagerMenuAction.selectionChanged", 300, "Selected treenode id is " + this.selectedTreeNode.getId());
                }
                if (this.selectedTreeNode.getId().startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                    Object treeNodeObj = this.selectedTreeNode.getObject();
                    if (treeNodeObj instanceof MQExtObject) {
                        this.selectedMQExtObject = (MQExtObject)treeNodeObj;
                        this.getMQQmgrExtObject(t, this.selectedMQExtObject);
                        if (Trace.isTracing) {
                            t.data(67, "UiQueueManagerMenuAction.selectionChanged", 300, "Selected MQ object id " + this.selectedMQExtObject.getObjectId());
                        }
                    }
                } else {
                    this.getMQQmgrExtObject(t, (MQExtObject)this.selectedTreeNode.getObject());
                }
            } else if (obj instanceof MQExtObject) {
                this.selectedMQExtObject = (MQExtObject)obj;
                if (Trace.isTracing) {
                    t.data(67, "UiQueueManagerMenuAction.selectionChanged", 300, "Selected MQ object id " + this.selectedMQExtObject.getObjectId());
                }
                this.getMQQmgrExtObject(t, this.selectedMQExtObject);
            }
            if (Trace.isTracing) {
                t.data(67, "UiQueueManagerMenuAction.selectionChanged", 300, "Selected MQ object name is " + this.selectedMQExtObject);
            }
            String id = action.getId();
            if (Trace.isTracing) {
                t.data(67, "UiQueueManagerMenuAction.selectionChanged", 300, "Action id = " + id);
            }
            if (id.compareTo("com.ibm.mq.explorer.qmgradmin.queuemanager.menuaction.Autoreconnect") == 0) {
                action.setChecked(this.uiQueueManager.isAutoreconnect(t));
                boolean enable = true;
                DmQueueManagerHandle dmQMh = this.dmQueueManager.getConnectionHandle();
                if (dmQMh.isPromptPassword()) {
                    enable = false;
                }
                action.setEnabled(enable);
            }
        }
    }

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        String id = action.getId();
        if (Trace.isTracing) {
            t.data(67, "UiQueueManagerMenuAction.run", 300, "Action id = " + id);
        }
        if (id.compareTo("com.ibm.mq.explorer.qmgradmin.queuemanager.menuaction.ConnectionProperties") == 0) {
            IUiMQObjectFactory uiMQObjectFactory = this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.queuemanagerhandle");
            UiMQObject uiMQObject = uiMQObjectFactory.create(t, (IDmObject)this.dmQueueManager, (UiMQObject)this.uiQueueManager);
            uiMQObject.showProperties(t);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.queuemanager.menuaction.Autoreconnect") == 0) {
            this.uiQueueManager.toggleAutoreconnect(t);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.queuemanager.menuaction.SetRefreshInterval") == 0) {
            this.uiQueueManager.setRefreshInterval(t);
        } else if (id.compareTo("com.ibm.mq.explorer.qmgradmin.queuemanager.menuaction.RemoveConnection") == 0) {
            this.removeQueueManager(t, this.uiQueueManager);
        } else if (Trace.isTracing) {
            t.data(67, "UiQueueManagerMenuAction.run", 900, "Unknown action id " + id);
        }
    }

    private void getMQQmgrExtObject(Trace t, MQExtObject mqExtObject) {
        MQQmgrExtObject mqQmgrExtObject = null;
        MQExtObject testObject = mqExtObject;
        do {
            if (!(testObject instanceof MQQmgrExtObject)) continue;
            mqQmgrExtObject = (MQQmgrExtObject)testObject;
            break;
        } while ((testObject = testObject.getParent()) != null);
        if (mqQmgrExtObject != null) {
            this.uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
            this.dmQueueManager = (DmQueueManager)this.uiQueueManager.getDmObject();
        }
    }

    private void removeQueueManager(Trace t, UiQueueManager uiQmgr) {
        IUiMQObjectFactory factory;
        int result = MessageBox.showYesNoMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)"AMQ4133", (String)uiQmgr.toString()), (int)1, (String)"AMQ4133");
        if (result == 0 && (factory = ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanagerhandle")) != null) {
            DmQueueManagerHandle dmQueueManagerHandle = uiQmgr.getDmQueueManagerObject().getConnectionHandle();
            UiQueueManagerHandle uiQueueManagerHandle = (UiQueueManagerHandle)factory.create(t, (IDmObject)dmQueueManagerHandle, (UiMQObject)uiQmgr);
            uiQueueManagerHandle.removeQM(t);
        }
    }
}

