/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyFactory;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.SSLOptionsPropertyPage;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.SSLStoresPropertyPage;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.SecurityExitPropertyPage;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UseridPropertyPage;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.QueueManagerList;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UiQueueManagerHandle
extends UiMQObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/UiQueueManagerHandle.java";
    public static final String AMQ4105 = "AMQ4105";
    private UiQueueManager uiQueueManager = null;
    private UseridPropertyPage useridPropertyPage = null;
    private Integer autoReconnect = 0;

    public UiQueueManagerHandle() {
    }

    public UiQueueManagerHandle(Trace t, IDmObject dmObject, UiMQObject parent) {
        super(t, (IDmObject)(dmObject instanceof DmQueueManager ? ((DmQueueManager)dmObject).getConnectionHandle() : dmObject));
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
    }

    public String getObjectType() {
        return null;
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                isCustom = true;
            }
        }
        return isCustom;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        CustomPropertyPage customPage = null;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 184: {
                customPage = new SecurityExitPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiQueueManagerHandle.createCustomPropertyPage", 300, "Security exit Property Custom Page to be displayed.");
                break;
            }
            case 185: {
                customPage = new UseridPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                this.useridPropertyPage = (UseridPropertyPage)customPage;
                if (!Trace.isTracing) break;
                t.data(67, "UiQueueManagerHandle.createCustomPropertyPage", 300, "Userid Property Custom Page to be displayed.");
                break;
            }
            case 186: {
                customPage = new SSLStoresPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiQueueManagerHandle.createCustomPropertyPage", 300, "SSL stores Property Custom Page to be displayed.");
                break;
            }
            case 187: {
                customPage = new SSLOptionsPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiQueueManagerHandle.createCustomPropertyPage", 300, "SSL options Property Custom Page to be displayed.");
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(67, "UiQueueManagerHandle.createCustomPropertyPage", 300, "No Custom Page to be displayed.");
            }
        }
        return customPage;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        boolean notify = false;
        if (attr.getAttributeID() == 11012) {
            notify = true;
            this.autoReconnect = (Integer)attr.getValue(Trace.getInstance());
        }
        return notify;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        if (attr.getAttributeID() == 11012) {
            this.autoReconnect = (Integer)newValue;
        }
        return false;
    }

    public String getId() {
        return "com.ibm.mq.explorer.queuemanagerhandle";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isVisible(Trace t) {
        boolean result = false;
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            result = ((DmQueueManagerHandle)dmObj).isVisible(t);
        }
        return result;
    }

    public boolean isClient(Trace t) {
        boolean result = false;
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            result = ((DmQueueManagerHandle)dmObj).isClient(t);
        }
        return result;
    }

    public boolean isUsedAsViaQM(Trace t) {
        boolean result = false;
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            DmQueueManager qm = ((DmQueueManagerHandle)dmObj).getQueueManager();
            ArrayList listOfVias = qm.getListOfViaQueueManagers(t);
            result = !listOfVias.isEmpty();
        }
        return result;
    }

    public void setVisible(Trace t, int visibility) {
        IDmObject dmObj = super.getDmObject();
        Object job = dmObj.beginUpdate(t);
        Integer value = visibility;
        dmObj.setAttributeValue(t, job, 11005, 0, (Object)value);
        dmObj.actionChange(t, null, job, false);
    }

    public void removeQM(Trace t) {
        boolean dontRemove = false;
        IDmObject dmObj = super.getDmObject();
        DmQueueManager dmQm = dmObj.getQueueManager();
        MQQmgrExtObject extObj = null;
        UiQueueManager[] qmgrArray = UiPlugin.getKnownUiQueueManagers((Trace)t, (boolean)true);
        int k = 0;
        while (k < qmgrArray.length) {
            if (qmgrArray[k].getDmObject().equals((Object)dmQm)) {
                extObj = (MQQmgrExtObject)qmgrArray[k].getExternalObject();
                break;
            }
            ++k;
        }
        ExplorerNotifyEvent event = new ExplorerNotifyEvent(extObj, null);
        dontRemove = UiPlugin.getNotificationManager().notifyIsPreventRemoveQueueManager(t, event);
        if (dontRemove) {
            MessageBox.showMessageFailure((Trace)t, (Shell)this.shell, (String)CommonServices.getSystemMessage((Trace)t, (String)AMQ4105), (String)AMQ4105);
        } else {
            UiPlugin.getTheDataModel().removeQueueManager(t, (DmQueueManagerHandle)dmObj);
        }
    }

    public String getNLSResourceFileKey() {
        return "KEY_Queue Manager";
    }

    public void updateIcon() {
        Trace t = Trace.getDefault();
        Image image = null;
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            DmQueueManager qm = ((DmQueueManagerHandle)dmObj).getQueueManager();
            QueueManagerList qmList = UiPlugin.getQueueManagerList();
            UiQueueManager uiQM = qmList.getKnownUiQueueManager(t, qm);
            uiQM.updateIcon();
            image = uiQM.getImage();
            super.setImage(image);
        }
    }

    public int getDataModelObjectType(Trace t) {
        return 1002;
    }

    public void showProperties(Trace t) {
        super.showProperties(t);
        ConnDetailsPropertyFactory.remove(t, this.uiQueueManager.getDmQueueManagerObject());
        MQExtObject extObject = this.getExternalObject();
        if (extObject != null) {
            extObject.objectChanged();
        }
    }

    public boolean isSupportDelete() {
        return false;
    }

    public void deleteMenuAction(Trace t) {
    }

    public boolean isChangeProperties(Trace t) {
        boolean result = true;
        return result;
    }

    public String getAttributeName(Trace t, int attrId) {
        String name = null;
        if (attrId == 30000) {
            name = QmgradminPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Connection.Status.Title");
        }
        return name;
    }

    public String getAttributeValue(Trace t, int attrId) {
        String value = null;
        if (attrId == 30000 && this.uiQueueManager != null) {
            value = this.uiQueueManager.isConnected() ? QmgradminPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Connection.Status.Connected.Title") : QmgradminPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Connection.Status.Disconnected.Title");
        }
        return value;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public boolean isAllowApplyProperties() {
        boolean apply = true;
        boolean passwordPromptMode = this.useridPropertyPage.isPromptPassword();
        if (this.autoReconnect == 1 && passwordPromptMode) {
            Trace t = Trace.getInstance();
            String errMsg = QmgradminPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Invalid.AutoReconnect.PasswordMode");
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)errMsg);
            apply = false;
        }
        return apply;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return false;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }
}

