/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyChange;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyFactory;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLStores;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class SSLStoresPropertyPage
extends CustomPropertyPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/SSLStoresPropertyPage.java";
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    protected Message msgFile = null;
    private ConnectionDetailsSSLStores sslStoresComposite = null;
    private String personalStore = "";
    private String personalStorePassword = "";
    private String trustedStore = "";
    private String trustedStorePassword = "";
    private ConnDetailsPropertyChange changeManager = null;
    private String pageName = null;
    private Link[] linkPasswordWarnings = null;

    public SSLStoresPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDispGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Properties");
        this.pageName = uiDispGroup.getDisplayGroup().getTitle();
    }

    public void init(Trace t) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gridData = null;
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.setLayoutData(gridData);
        this.sslStoresComposite = new ConnectionDetailsSSLStores((Composite)this, 0, 1, false);
        this.sslStoresComposite.setPasswordValidation(false);
        this.loadCurrentSettings(t);
        Link[] linkArray = this.linkPasswordWarnings = this.sslStoresComposite.getPasswordWarningLinks();
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link currentLink = linkArray[n2];
            currentLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PreferencePagePasswords.openPasswordPreferencePage(t2);
                    SSLStoresPropertyPage.this.checkPasswordPreference(t2);
                }
            });
            ++n2;
        }
        this.checkPasswordPreference(t);
    }

    private void loadCurrentSettings(Trace t) {
        this.dmObject = this.uiMQObject.getDmObject();
        this.trustedStore = this.dmObject.getAttributeValue(t, 11027, 0);
        this.trustedStorePassword = this.dmObject.getAttributeValue(t, 11028, 0);
        this.personalStore = this.dmObject.getAttributeValue(t, 11025, 0);
        this.personalStorePassword = this.dmObject.getAttributeValue(t, 11026, 0);
        this.sslStoresComposite.getTextTrustedStore().setText(this.trustedStore);
        this.sslStoresComposite.getTextPersonalStore().setText(this.personalStore);
        if (this.trustedStorePassword != null && !this.trustedStorePassword.equals("")) {
            this.sslStoresComposite.getTextTrustedPassword().setText("********");
            this.sslStoresComposite.setTrustedStorePassword(this.trustedStorePassword);
        } else {
            this.sslStoresComposite.getTextTrustedPassword().setText("");
            this.sslStoresComposite.setTrustedStorePassword("");
        }
        if (this.personalStorePassword != null && !this.personalStorePassword.equals("")) {
            this.sslStoresComposite.getTextPersonalPassword().setText("********");
            this.sslStoresComposite.setPersonalStorePassword(this.personalStorePassword);
        } else {
            this.sslStoresComposite.getTextPersonalPassword().setText("");
            this.sslStoresComposite.setPersonalStorePassword("");
        }
        if (Trace.isTracing) {
            t.data(67, "SSLStoresPropertyPage.loadCurrentSettings", 300, "Loaded attribute SSL certificate store details" + Common.NEW_LINE + "trust store = " + this.trustedStore + Common.NEW_LINE + "personal store = " + this.personalStore);
        }
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        boolean applied = false;
        boolean changed = false;
        this.changeManager = ConnDetailsPropertyFactory.create(t, this.uiMQObject.getDmObject().getQueueManager());
        if (this.changeNeeded(t)) {
            String newTrustedStorePassword;
            String newTrustedStore;
            String newPersonalStorePassword;
            String newPersonalStore = this.sslStoresComposite.getTextPersonalStore().getText();
            if (!this.personalStore.equals(newPersonalStore) && (changed = this.dmObject.setAttributeValue(t, job, 11025, 0, (Object)newPersonalStore))) {
                this.personalStore = newPersonalStore;
                applied = true;
            }
            if ((newPersonalStorePassword = this.sslStoresComposite.getPersonalStorePassword()) == null) {
                newPersonalStorePassword = "";
            }
            if (!this.personalStorePassword.equals(newPersonalStorePassword) && (changed = this.dmObject.setAttributeValue(t, job, 11026, 0, (Object)newPersonalStorePassword))) {
                this.personalStorePassword = newPersonalStorePassword;
                applied = true;
                if (this.personalStorePassword != null && !this.personalStorePassword.equals("")) {
                    PwUtils.savePassword((Trace)t, (IDmObject)this.dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", (String)this.personalStore, (String)this.personalStorePassword);
                }
            }
            if (!this.trustedStore.equals(newTrustedStore = this.sslStoresComposite.getTextTrustedStore().getText()) && (changed = this.dmObject.setAttributeValue(t, job, 11027, 0, (Object)newTrustedStore))) {
                this.trustedStore = newTrustedStore;
                applied = true;
            }
            if ((newTrustedStorePassword = this.sslStoresComposite.getTrustedStorePassword()) == null) {
                newTrustedStorePassword = "";
            }
            if (!this.trustedStorePassword.equals(newTrustedStorePassword) && (changed = this.dmObject.setAttributeValue(t, job, 11028, 0, (Object)newTrustedStorePassword))) {
                this.trustedStorePassword = newTrustedStorePassword;
                applied = true;
                if (this.trustedStorePassword != null && !this.trustedStorePassword.equals("")) {
                    PwUtils.savePassword((Trace)t, (IDmObject)this.dmObject, (String)"com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", (String)this.trustedStore, (String)this.trustedStorePassword);
                }
            }
        }
        return applied;
    }

    public boolean isAnyControlEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
        if (this.changeManager != null) {
            this.changeManager.changesApplied(t, this.pageName);
        }
    }

    private boolean changeNeeded(Trace t) {
        boolean change = false;
        String newPersonalStore = this.sslStoresComposite.getTextPersonalStore().getText();
        String newPersonalStorePassword = this.sslStoresComposite.getPersonalStorePassword();
        String newTrustedStore = this.sslStoresComposite.getTextTrustedStore().getText();
        String newTrustedStorePassword = this.sslStoresComposite.getTrustedStorePassword();
        if (!this.personalStore.equals(newPersonalStore)) {
            change = true;
        }
        if (newPersonalStorePassword == null) {
            newPersonalStorePassword = "";
        }
        if (!this.personalStorePassword.equals(newPersonalStorePassword)) {
            change = true;
        }
        if (!this.trustedStore.equals(newTrustedStore)) {
            change = true;
        }
        if (newTrustedStorePassword == null) {
            newTrustedStorePassword = "";
        }
        if (!this.trustedStorePassword.equals(newTrustedStorePassword)) {
            change = true;
        }
        if (change) {
            change = this.changeManager.apply(t, this.pageName);
        }
        return change;
    }

    private void checkPasswordPreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
        Link[] linkArray = this.linkPasswordWarnings;
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link curLink = linkArray[n2];
            curLink.setVisible(!passwordStoreEnabled);
            ++n2;
        }
        this.sslStoresComposite.setPasswordSaving(t, passwordStoreEnabled);
    }
}

