/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyChange;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.ConnDetailsPropertyFactory;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiQueueManagerHandle;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLOptions;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SSLOptionsPropertyPage
extends CustomPropertyPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/SSLOptionsPropertyPage.java";
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    protected Message msgFile = null;
    private ConnectionDetailsSSLOptions sslOptionsComposite = null;
    private String cipherSuite = "";
    private String peerName = "";
    private int fipsRequired = 0;
    private int resetCount = 0;
    private ConnDetailsPropertyChange changeManager = null;
    private String pageName = null;

    public SSLOptionsPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDispGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Properties");
        this.pageName = uiDispGroup.getDisplayGroup().getTitle();
    }

    public void init(Trace t) {
        IDmObject qmHandle;
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gridData = null;
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.setLayoutData(gridData);
        this.sslOptionsComposite = new ConnectionDetailsSSLOptions((Composite)this, 0, 1, false, false);
        this.loadCurrentSettings(t);
        if (this.uiMQObject instanceof UiQueueManagerHandle && (qmHandle = this.uiMQObject.getDmObject()) != null && qmHandle instanceof DmQueueManagerHandle && ((DmQueueManagerHandle)qmHandle).isConnectionTypeChanDefTable(t)) {
            this.sslOptionsComposite.setIsCCDTConnection(true);
        }
    }

    private void loadCurrentSettings(Trace t) {
        this.dmObject = this.uiMQObject.getDmObject();
        this.peerName = this.dmObject.getAttributeValue(t, 11023, 0);
        this.sslOptionsComposite.getTextPeerName().setText(this.peerName);
        String s = this.dmObject.getAttributeValue(t, 11022, 0);
        this.resetCount = Integer.parseInt(s);
        this.sslOptionsComposite.getSpinnerResetCount().setSelection(this.resetCount);
        s = this.dmObject.getAttributeValue(t, 11021, 0);
        Attr a = this.dmObject.getAttribute(t, 11021, 0);
        AttrTypeEnum ate = (AttrTypeEnum)a.getAttrType();
        Number n = ate.getEnumerationKey(t, (Object)s);
        this.fipsRequired = n.intValue();
        this.sslOptionsComposite.setFIPSRequired(t, this.fipsRequired);
        s = this.dmObject.getAttributeValue(t, 11020, 0);
        a = this.dmObject.getAttribute(t, 11020, 0);
        AttrTypeFixedLengthStringEnum at = (AttrTypeFixedLengthStringEnum)a.getAttrType();
        this.cipherSuite = at.getEnumerationId(t, (Object)s);
        if (this.cipherSuite == null) {
            if (Trace.isTracing) {
                t.data(67, "SSLOptionsPropertyPage.loadCurrentSettings", 300, "WARNING: Unexpected cipherSuite is null, sslCipherSuite = '" + s + "'.");
            }
            String msgBoxText = this.msgFile.getMessage(t, "UI.QMGR.Invalid.SSL.CipherSuite");
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgBoxText);
            this.cipherSuite = "";
        }
        this.sslOptionsComposite.setCipherSuite(t, this.cipherSuite);
        if (Trace.isTracing) {
            t.data(67, "SSLOptionsPropertyPage.loadCurrentSettings", 300, "Loaded attribute SSL options" + Common.NEW_LINE + "cipher suite = " + this.cipherSuite + Common.NEW_LINE + "peer name = " + this.peerName + Common.NEW_LINE + "FIPS required = " + this.fipsRequired + Common.NEW_LINE + "reset count = " + this.resetCount);
        }
        this.sslOptionsComposite.enableControls(t);
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        boolean applied = false;
        boolean changed = false;
        this.changeManager = ConnDetailsPropertyFactory.create(t, this.uiMQObject.getDmObject().getQueueManager());
        if (this.changeNeeded(t)) {
            int newResetCount;
            String s = this.sslOptionsComposite.getComboCipherSuites().getText();
            String newCipherSuite = (String)this.sslOptionsComposite.getComboCipherSuites().getData(s);
            if (!this.cipherSuite.equals(newCipherSuite) && (changed = this.dmObject.setAttributeValue(t, job, 11020, 0, (Object)newCipherSuite))) {
                this.cipherSuite = newCipherSuite;
                applied = true;
            }
            String newPeerName = this.sslOptionsComposite.getTextPeerName().getText();
            if (Trace.isTracing) {
                t.data(67, "SSLOptionsPropertyPage.apply", 300, "newPeerName = '" + newPeerName + "'");
            }
            if (!this.peerName.equals(newPeerName) && (changed = this.dmObject.setAttributeValue(t, job, 11023, 0, (Object)newPeerName))) {
                this.peerName = newPeerName;
                applied = true;
            }
            if (this.resetCount != (newResetCount = this.sslOptionsComposite.getSpinnerResetCount().getSelection()) && (changed = this.dmObject.setAttributeValue(t, job, 11022, 0, (Object)newResetCount))) {
                this.resetCount = newResetCount;
                applied = true;
            }
        }
        return applied;
    }

    public boolean isAnyControlEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
        if (this.changeManager != null) {
            this.changeManager.changesApplied(t, this.pageName);
        }
    }

    private boolean changeNeeded(Trace t) {
        boolean change = false;
        String s = this.sslOptionsComposite.getComboCipherSuites().getText();
        String newCipherSuite = (String)this.sslOptionsComposite.getComboCipherSuites().getData(s);
        String newPeerName = this.sslOptionsComposite.getTextPeerName().getText();
        int newResetCount = this.sslOptionsComposite.getSpinnerResetCount().getSelection();
        if (!this.cipherSuite.equals(newCipherSuite)) {
            change = true;
        } else if (!this.peerName.equals(newPeerName)) {
            change = true;
        } else if (this.resetCount != newResetCount) {
            change = true;
        }
        if (change) {
            change = this.changeManager.apply(t, this.pageName);
        }
        return change;
    }
}

