/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiQueueManagerHandle;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTable;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QueueManagerContentPage
extends ContentPage
implements DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/QueueManagerContentPage.java";
    private static final int NUM_COLS = 3;
    private ContentTitleBar contentTitleBar;
    private UiQueueManager uiQmgr = null;
    private UiQueueManagerHandle uiQmgrHandle = null;
    private ObjectTable objectTableStatusQV = null;
    private ObjectTable objectTableConnQV = null;
    private ObjectTable objectTablePropQV = null;
    private Message msgFile = null;
    private Composite composite = null;
    private Label labelConnection = null;
    private Label labelStatus = null;
    private Label labelProperties = null;
    private String notAvailable = null;
    private boolean isListening = false;
    private IDmObservable dataModel = null;

    public QueueManagerContentPage(Composite parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
        this.notAvailable = "   " + this.getNLSString(t, "UI.QMGR.NotAvailable");
        this.dataModel = UiPlugin.getTheDataModel();
    }

    public void init() {
        Trace t = Trace.getDefault();
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        this.composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.composite);
        Font fontLarge = null;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.verticalSpacing = 10;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData((Object)gridData);
        this.contentTitleBar = new ContentTitleBar(this.composite, 0);
        this.contentTitleBar.setText(this.getNLSString(t, "UI.QMGR.QueueManager.Title"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.contentTitleBar.setLayoutData((Object)gridData);
        this.labelConnection = new Label(this.composite, 16384);
        this.labelConnection.setFont(fontLarge);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.labelConnection.setLayoutData((Object)gridData);
        this.labelConnection.setText(this.getNLSString(t, "UI.QMGR.ContentPage.ConnectionQV"));
        this.objectTableConnQV = new ObjectTable(t, this.composite, 0, false, true, false);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.objectTableConnQV.setLayoutData((Object)gridData);
        this.objectTableConnQV.setObjectId(t, "com.ibm.mq.explorer.queuemanagerhandle");
        Label label = new Label(this.composite, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.labelStatus = new Label(this.composite, 16384);
        this.labelStatus.setFont(fontLarge);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.labelStatus.setLayoutData((Object)gridData);
        this.labelStatus.setText(this.getNLSString(t, "UI.QMGR.ContentPage.StatusQV"));
        this.objectTableStatusQV = new ObjectTable(t, this.composite, 0, false, true, false);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.objectTableStatusQV.setLayoutData((Object)gridData);
        this.objectTableStatusQV.setObjectId(t, "com.ibm.mq.explorer.queuemanager.status");
        this.objectTableStatusQV.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrstatus.qv");
        label = new Label(this.composite, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.labelProperties = new Label(this.composite, 16384);
        this.labelProperties.setFont(fontLarge);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.labelProperties.setLayoutData((Object)gridData);
        this.labelProperties.setText(this.getNLSString(t, "UI.QMGR.ContentPage.PropertiesQV"));
        this.objectTablePropQV = new ObjectTable(t, this.composite, 0, false, true, false);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.objectTablePropQV.setLayoutData((Object)gridData);
        this.objectTablePropQV.setObjectId(t, "com.ibm.mq.explorer.queuemanager");
        this.objectTablePropQV.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrs.qv");
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.composite.layout();
        scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
    }

    public String getId() {
        return "com.ibm.mq.explorer.contentpage.qm";
    }

    public void setObject(MQExtObject object) {
        Object intObj;
        Trace t = Trace.getDefault();
        if (!this.isListening) {
            this.isListening = this.dataModel.addObserver(t, (DmObjectListener)this, null);
        }
        if ((intObj = object.getInternalObject()) != null && (UiQueueManager)intObj != this.uiQmgr) {
            this.clearObjectTables(t);
            this.uiQmgr = (UiQueueManager)intObj;
            DmQueueManagerHandle dmQmgrHandle = this.uiQmgr.getDmQueueManagerObject().getConnectionHandle();
            IUiMQObjectFactory factory = ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanagerhandle");
            this.uiQmgrHandle = (UiQueueManagerHandle)factory.create(t, (IDmObject)dmQmgrHandle, (UiMQObject)this.uiQmgr);
            this.setupConnectionQuickView(t);
            this.setupStatusQuickView(t);
            this.setupPropertiesQuickView(t);
            this.setTitleBarText(t);
            this.setTablePrompts(t);
        }
    }

    private void setupConnectionQuickView(Trace t) {
        if (this.uiQmgr.getDmQueueManagerObject().getConnectionHandle().isConnectionTypeMultiInstance(t)) {
            this.objectTableConnQV.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrconns.qv");
        } else {
            this.objectTableConnQV.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrconn.qv");
        }
        this.objectTableConnQV.setObject(t, (UiMQObject)this.uiQmgrHandle, false);
    }

    private void setupPropertiesQuickView(Trace t) {
        if (this.uiQmgr.isConnected()) {
            this.objectTablePropQV.setEnabled(true);
            this.objectTablePropQV.setObject(t, (UiMQObject)this.uiQmgr, false);
        } else {
            this.objectTablePropQV.removeAll(t);
            this.objectTablePropQV.setEnabled(false);
        }
    }

    private boolean isStatusSupported(Trace t) {
        int statusType = this.uiQmgr.getDmQueueManagerObject().getStatusType(t);
        boolean statusSupported = statusType == 1;
        return statusSupported;
    }

    public void updatePage() {
        this.update();
    }

    private void setTitleBarText(Trace t) {
        String title = this.msgFile.getMessage(t, "UI.QMGR.QueueManager.Title", this.uiQmgr.getTreeName());
        this.contentTitleBar.setText(title);
    }

    private void setupStatusQuickView(Trace t) {
        this.objectTableStatusQV.setEnabled(true);
        this.objectTableStatusQV.updateLastRefreshText();
        if (this.isStatusSupported(t) && this.uiQmgr.isConnected()) {
            this.objectTableStatusQV.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrstatus.qv");
        } else if (this.uiQmgr.isLocal()) {
            this.objectTableStatusQV.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrstatus.qv.unavailable");
        } else {
            this.objectTableStatusQV.removeAll(t);
            this.objectTableStatusQV.setEnabled(false);
        }
        this.objectTableStatusQV.setObject(t, (UiMQObject)this.uiQmgr, false);
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        if (this.uiQmgr != null) {
            this.uiQmgr.getDmQueueManagerObject().refresh(t);
        }
    }

    public String getNLSString(Trace t, String textKey) {
        String nlsString = "+++" + textKey + "+++";
        if (this.msgFile != null) {
            nlsString = this.msgFile.getMessage(t, textKey);
        }
        return nlsString;
    }

    private void clearObjectTables(Trace t) {
        this.objectTablePropQV.setObject(t, null, false);
        this.objectTableStatusQV.setObject(t, null, false);
        this.objectTableConnQV.setObject(t, null, false);
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public void repaint() {
        this.updatePage();
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        DmObject object = (DmObject)event.getSource();
        if (this.uiQmgr != null && object == this.uiQmgr.getDmQueueManagerObject()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    QueueManagerContentPage.this.setTitleBarText(t2);
                    QueueManagerContentPage.this.setupConnectionQuickView(t2);
                    QueueManagerContentPage.this.setupStatusQuickView(t2);
                    QueueManagerContentPage.this.setupPropertiesQuickView(t2);
                    QueueManagerContentPage.this.setTablePrompts(t2);
                }
            });
        }
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        DmObject object = (DmObject)event.getSource();
        if (this.uiQmgr != null && object == this.uiQmgr.getDmQueueManagerObject()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    QueueManagerContentPage.this.setTitleBarText(t2);
                    QueueManagerContentPage.this.setupConnectionQuickView(t2);
                    QueueManagerContentPage.this.setupStatusQuickView(t2);
                    QueueManagerContentPage.this.setupPropertiesQuickView(t2);
                    QueueManagerContentPage.this.setTablePrompts(t2);
                }
            });
        }
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
        DmObject object = (DmObject)event.getSource();
        if (this.uiQmgr != null && object == this.uiQmgr.getDmQueueManagerObject()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    QueueManagerContentPage.this.setupConnectionQuickView(t2);
                    QueueManagerContentPage.this.setupStatusQuickView(t2);
                    QueueManagerContentPage.this.setupPropertiesQuickView(t2);
                }
            });
        }
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        if (event.getSource() instanceof DmObject) {
            DmObject object = (DmObject)event.getSource();
            if (this.uiQmgr != null && object == this.uiQmgr.getDmQueueManagerObject()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerContentPage.this.objectTableStatusQV.updateLastRefreshText();
                        QueueManagerContentPage.this.objectTableConnQV.updateLastRefreshText();
                        QueueManagerContentPage.this.objectTablePropQV.updateLastRefreshText();
                    }
                });
            }
        }
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void instanceDeleted(Object object) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    private void setTablePrompts(Trace t) {
        if (this.labelConnection != null) {
            if (this.objectTableConnQV != null && !this.objectTableConnQV.isTableEnabled()) {
                this.labelConnection.setText(String.valueOf(this.getNLSString(t, "UI.QMGR.ContentPage.ConnectionQV")) + this.notAvailable);
            } else {
                this.labelConnection.setText(this.getNLSString(t, "UI.QMGR.ContentPage.ConnectionQV"));
            }
            this.labelConnection.pack(true);
        }
        if (this.labelStatus != null) {
            if (this.objectTableStatusQV != null && !this.objectTableStatusQV.isTableEnabled()) {
                this.labelStatus.setText(String.valueOf(this.getNLSString(t, "UI.QMGR.ContentPage.StatusQV")) + this.notAvailable);
            } else {
                this.labelStatus.setText(this.getNLSString(t, "UI.QMGR.ContentPage.StatusQV"));
            }
            this.labelStatus.pack(true);
        }
        if (this.labelProperties != null) {
            if (this.objectTablePropQV != null && !this.objectTablePropQV.isTableEnabled()) {
                this.labelProperties.setText(String.valueOf(this.getNLSString(t, "UI.QMGR.ContentPage.PropertiesQV")) + this.notAvailable);
            } else {
                this.labelProperties.setText(this.getNLSString(t, "UI.QMGR.ContentPage.PropertiesQV"));
            }
            this.labelProperties.pack(true);
        }
        this.redraw();
        this.update();
    }
}

