/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.utils.OtherQueueManager;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.ConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleDialog;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ImportExportLocalHandles
implements IExplorerRuntimeImportExport,
IExecutableExtension,
IConsoleDialogUser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/ImportExportLocalHandles.java";
    public static final String SUBCATEGORY_ID_HANDLES = "com.ibm.mq.explorer.ui.subcategory.handles.local";

    public boolean importData(String categoryId, String subcategoryId, IMemento rootRead) {
        XMLMemento childNode;
        boolean result = false;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.conn.info") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_HANDLES) == 0 && (childNode = (XMLMemento)this.getIfValidHandlesMemento(rootRead)) != null) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IMemento[] qmHandles;
                    Trace t2 = Trace.getDefault();
                    ArrayList<String> otherQmgrNames = new ArrayList<String>();
                    List otherQmgrs = UiPlugin.getTheDataModel().getQueueManagersFromOtherInstallations(t2);
                    for (OtherQueueManager qmgr : otherQmgrs) {
                        otherQmgrNames.add(qmgr.getQueueManagerName());
                    }
                    IMemento[] iMementoArray = qmHandles = childNode.getChildren("QueueManagerHandle");
                    int n = qmHandles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento qmHandleMemento = iMementoArray[n2];
                        QueueManagerHandle qmh = QueueManagerHandle.createFromMemento((Trace)t2, (IMemento)qmHandleMemento);
                        String qmName = qmh.getQueueManagerName();
                        if (otherQmgrNames.contains(qmName)) {
                            ImportExportLocalHandles.this.runTransfer(t2, qmName);
                        }
                        ++n2;
                    }
                }
            });
            result = true;
        }
        return result;
    }

    private void runTransfer(Trace t, String name) {
        String message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4628", (String)name);
        Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
        Message qmgrMsgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
        int rc = MessageBox.showMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)msgFile.getMessage(t, "UI.GENERAL.MQ"), (Image)Icons.get((String)Icons.iconkeyExplorerSmall), (String)message, (int)2, (String[])new String[]{qmgrMsgFile.getMessage(t, "UI.QMGR.Transfer.Text"), msgFile.getMessage(t, "UI.GENERAL.CANCEL")}, (int)0, (String)"AMQ4628");
        if (rc == 0) {
            final ConsoleDialog consoleDialog = new ConsoleDialog(t, UiPlugin.getShell(), (IConsoleDialogUser)this);
            String title = qmgrMsgFile.getMessage(t, "UI.QMGR.Transfer.Task.Text", name);
            consoleDialog.setTitle(title);
            consoleDialog.setHelp("com.ibm.mq.explorer.ui.infopop.UI_QmgrsCreateDialog");
            String instName = CommonServices.getInstallationName((Trace)t);
            String command = "setmqm -m " + name + " -n " + instName;
            ConsoleCommand c = new ConsoleCommand(title, command);
            c.addExitValue(0);
            final ArrayList<ConsoleCommand> commandList = new ArrayList<ConsoleCommand>();
            commandList.add(c);
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace tr = Trace.getDefault();
                    consoleDialog.execute(tr, commandList);
                }
            });
        }
    }

    public void finished(Trace t, int id, boolean result) {
        if (result) {
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
        }
    }

    public IMemento exportData(String categoryId, String subcategoryId) {
        Trace t = Trace.getDefault();
        PersistQueueManagerHandles.getInstance((Trace)t).saveToDisk(t);
        XMLMemento handlesRoot = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.conn.info") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_HANDLES) == 0) {
            handlesRoot = XMLMemento.createWriteRoot((String)"ROOTNODE");
            handlesRoot.copyChild(PersistQueueManagerHandles.saveQMsToXml((Trace)t, (boolean)false));
        }
        return handlesRoot;
    }

    private IMemento getIfValidHandlesMemento(IMemento memento) {
        IMemento validMemento = null;
        validMemento = memento.getChild("QueueManagerHandles");
        if (validMemento == null && memento.getType().equals("QueueManagerHandles")) {
            validMemento = memento;
        }
        return validMemento;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public boolean persistData() {
        return false;
    }

    public boolean isDestructiveImport() {
        return false;
    }
}

