/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class ConnDetailsPropertyChange {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/queuemanager/ConnDetailsPropertyChange.java";
    private boolean wasConnected = false;
    private boolean ignorePrompt = false;
    private DmQueueManager queueManager = null;
    private ArrayList<String> list = new ArrayList();
    private String lastPage = "";

    protected ConnDetailsPropertyChange(Trace t, DmQueueManager dqm) {
        this.queueManager = dqm;
        this.list.clear();
    }

    public boolean apply(Trace t, String page) {
        boolean applyChanges = false;
        if (!this.list.contains(page)) {
            this.list.add(page);
        }
        if (this.queueManager.isConnected()) {
            if (!this.ignorePrompt || this.lastPage.equals(page)) {
                if (MessageBox.showYesNoMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4611"), (int)1, null) == 1) {
                    applyChanges = false;
                    this.ignorePrompt = true;
                } else {
                    this.queueManager.disconnectAsync(t, 0);
                    this.wasConnected = true;
                    this.ignorePrompt = true;
                    applyChanges = true;
                }
            }
        } else {
            applyChanges = true;
        }
        if (!applyChanges) {
            this.list.remove(page);
        }
        this.lastPage = page;
        return applyChanges;
    }

    public void changesApplied(Trace t, String page) {
        this.list.remove(page);
        if (this.list.size() < 1) {
            if (this.wasConnected) {
                this.queueManager.connectAsynchronously(t);
            }
            this.ignorePrompt = false;
        }
    }
}

