/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qsg.queue;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queues.SelectQueuesViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueueFilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.viewers.ViewerFilter;

public class QSGQueueNewObjectProvider
extends NewObjectProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qsg/queue/QSGQueueNewObjectProvider.java";
    private static final int NUM_TYPES = 4;
    private static final String TYPE_LOCAL = "com.ibm.mq.explorer.queue.local";
    private static final String TYPE_REMOTE = "com.ibm.mq.explorer.queue.remote";
    private static final String TYPE_MODEL = "com.ibm.mq.explorer.queue.model";
    private static final String TYPE_ALIAS = "com.ibm.mq.explorer.queue.alias";
    private static final String[] TYPES = new String[]{"com.ibm.mq.explorer.queue.local", "com.ibm.mq.explorer.queue.alias", "com.ibm.mq.explorer.queue.model", "com.ibm.mq.explorer.queue.remote"};
    private UiQueueManager uiQueueManager = null;
    private FilterProvider filterProvider = null;
    private Message msgFile = null;

    public QSGQueueNewObjectProvider(Trace t, UiQueueManager uiQmgr) {
        super(t, (UiMQObject)uiQmgr);
        this.uiQueueManager = uiQmgr;
        this.filterProvider = new UiQueueFilterProvider();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_NewObject");
    }

    public int getNewObjectTypeCount(Trace t) {
        return 4;
    }

    public String[] getNewObjectTypes(Trace t) {
        return TYPES;
    }

    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return String.valueOf(this.getNameForNewObjectType(t, typeId)) + "...";
    }

    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        String helpId = null;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QSGQueueLocal";
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QSGQueueRemote";
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QSGQueueAlias";
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QSGQueueModel";
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getHelpIdForNewObjectType", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return helpId;
    }

    public String getNameForNewObjectType(Trace t, String typeId) {
        String name = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Queue");
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeLocal");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeRemote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeAlias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            name = messageBundle.getMessage(t, "UI.Q.Queues.TypeModel");
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getNameForNewObjectType", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return name;
    }

    public String getDefaultLikeObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            name = "SYSTEM.DEFAULT.LOCAL.QUEUE";
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            name = "SYSTEM.DEFAULT.REMOTE.QUEUE";
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            name = "SYSTEM.DEFAULT.ALIAS.QUEUE";
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            name = "SYSTEM.DEFAULT.MODEL.QUEUE";
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getDefaultLikeObjectName", 10, 50999, 0, 0, "Unknown Like Queue Type", typeId, null);
        }
        return name;
    }

    public String getGenericObjectName(Trace t) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Queue");
        String name = messageBundle.getMessage(t, "UI.Q.Queues.Title");
        return name;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.queue";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.orderid.queues";
    }

    public boolean supportsDataModelListen(Trace t) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t) {
        return this.uiQueueManager.getDmQueueManagerObject();
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        return 13;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        int subType = 1;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            subType = 1;
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            subType = 2;
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            subType = 3;
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            subType = 6;
        }
        return subType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.queue");
    }

    public ViewerFilter getViewerFilter(Trace t, String typeId) {
        SelectQueuesViewerFilter viewerFilter = new SelectQueuesViewerFilter();
        viewerFilter.setHideAliasQueues(true);
        viewerFilter.setHideModelQueues(true);
        viewerFilter.setHideLocalQueues(true);
        viewerFilter.setHideRemoteQueues(true);
        viewerFilter.setHideTempQueues(true);
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            viewerFilter.setHideLocalQueues(false);
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            viewerFilter.setHideModelQueues(false);
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            viewerFilter.setHideAliasQueues(false);
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            viewerFilter.setHideRemoteQueues(false);
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getViewerFilter", 10, 50999, 0, 0, "Unknown Viewer Filter type", typeId, null);
        }
        return viewerFilter;
    }

    public void setFixedAttributes(Trace t, IDmObject object, NewObjectWiz wizard) {
        super.setFixedAttributes(t, object, wizard);
        int id = 63;
        Integer value = 3;
        this.setFixedAttribute(t, object, id, value);
    }

    public int[] getMandatoryAttributeIds(Trace t, String typeId) {
        int[] ids = null;
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)1);
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)6);
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)3);
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)13, (int)2);
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getMandatoryAttributeIds", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return ids;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.filterid.queues";
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public Integer getQSGDisposition() {
        return null;
    }

    public String getWizardTitle(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Queue.Model");
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getWizardTitle", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return title;
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Queue.Model");
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getWizardPage1Title", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return title;
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        String desc = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Queue.Model");
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getWizardPage2Description", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return desc;
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        String text = "";
        if (typeId.compareTo(TYPE_LOCAL) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Local");
        } else if (typeId.compareTo(TYPE_REMOTE) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Remote");
        } else if (typeId.compareTo(TYPE_ALIAS) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Alias");
        } else if (typeId.compareTo(TYPE_MODEL) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Queue.Model");
        } else {
            t.FFST(67, "QSGQueueNewObjectProvider.getWizardCreatingTaskText", 10, 50999, 0, 0, "Unknown Queue Type", typeId, null);
        }
        return text;
    }
}

