/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qsg.authinfo;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.authinfo.SelectAuthInfoViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.authinfo.UiAuthInfoFilterProvider;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.viewers.ViewerFilter;

public class QSGAuthInfoNewObjectProvider
extends NewObjectProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qsg/authinfo/QSGAuthInfoNewObjectProvider.java";
    private static final String TYPE_AUTHINFO_LDAP = "com.ibm.mq.explorer.authinfo_ldap";
    private static final String TYPE_AUTHINFO_OCSP = "com.ibm.mq.explorer.authinfo_ocsp";
    private static final String TYPE_AUTHINFO_IDPW_OS = "com.ibm.mq.explorer.authinfo_idpwos";
    private static final String TYPE_AUTHINFO_IDPW_LDAP = "com.ibm.mq.explorer.authinfo_idpwldap";
    private UiQueueManager uiQueueManager = null;
    private FilterProvider filterProvider = null;
    private Message msgFile = null;

    public QSGAuthInfoNewObjectProvider() {
    }

    public QSGAuthInfoNewObjectProvider(Trace t, UiMQObject parent) {
        super(t, parent);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        this.filterProvider = new UiAuthInfoFilterProvider();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_NewObject");
    }

    public int getNewObjectTypeCount(Trace t) {
        int number_of_types = 1;
        DmQueueManager dmQmgr = this.uiQueueManager.getDmQueueManagerObject();
        if (dmQmgr.getCommandLevel() >= 800) {
            number_of_types = 4;
        } else if (dmQmgr.getCommandLevel() >= 701) {
            number_of_types = 2;
        }
        return number_of_types;
    }

    public String[] getNewObjectTypes(Trace t) {
        String[] V800_TYPES = new String[]{TYPE_AUTHINFO_LDAP, TYPE_AUTHINFO_OCSP, TYPE_AUTHINFO_IDPW_OS, TYPE_AUTHINFO_IDPW_LDAP};
        String[] V701_TYPES = new String[]{TYPE_AUTHINFO_LDAP, TYPE_AUTHINFO_OCSP};
        String[] TYPES = new String[]{TYPE_AUTHINFO_LDAP};
        DmQueueManager dmQmgr = this.uiQueueManager.getDmQueueManagerObject();
        if (dmQmgr.getCommandLevel() >= 800) {
            return V800_TYPES;
        }
        if (dmQmgr.getCommandLevel() >= 701) {
            return V701_TYPES;
        }
        return TYPES;
    }

    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return String.valueOf(this.getNameForNewObjectType(t, typeId)) + "...";
    }

    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        String Id = null;
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            Id = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_QSGAuthInfo";
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            Id = "com.ibm.mq.explorer.ui.infopop.UI_NewWizard_QSGAuthInfo_OCSP";
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            Id = "com.ibm.mq.explorer.ui.infopop.UI_NewWizard_QSGAuthInfo_IDPWOS";
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            Id = "com.ibm.mq.explorer.ui.infopop.UI_NewWizard_QSGAuthInfo_IDPWLDAP";
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getHelpIdForNewObjectType", 10, 50999, 0, 0, "Unknown Authinfo Type", typeId, null);
        }
        return Id;
    }

    public String getNameForNewObjectType(Trace t, String typeId) {
        String name = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Authentication Information");
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            name = messageBundle.getMessage(t, "UI.OBJECT.Type.AuthInfo_LDAP");
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            name = messageBundle.getMessage(t, "UI.OBJECT.Type.AuthInfo_OCSP");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            name = messageBundle.getMessage(t, "UI.OBJECT.Type.AuthInfo_IDPWOS");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            name = messageBundle.getMessage(t, "UI.OBJECT.Type.AuthInfo_IDPWLDAP");
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getNameForNewObjectType", 10, 50999, 0, 0, "Unknown Authinfo Type", typeId, null);
        }
        return name;
    }

    public String getDefaultLikeObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            name = "SYSTEM.DEFAULT.AUTHINFO.CRLLDAP";
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            name = "SYSTEM.DEFAULT.AUTHINFO.OCSP";
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            name = "SYSTEM.DEFAULT.AUTHINFO.IDPWOS";
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            name = "SYSTEM.DEFAULT.AUTHINFO.IDPWLDAP";
        } else {
            t.FFST(67, "QSGAuthinfoNewObjectProvider.getDefaultLikeObjectName", 10, 50999, 0, 0, "Unknown Authinfo Type", typeId, null);
        }
        return name;
    }

    public String getGenericObjectName(Trace t) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Authentication Information");
        String name = messageBundle.getMessage(t, "UI.OBJECT.Type.AuthInfo");
        return name;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.authinfo";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.orderid.authinfo";
    }

    public boolean supportsDataModelListen(Trace t) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t) {
        return this.uiQueueManager.getDmQueueManagerObject();
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        return 83;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        int subType = 1;
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            subType = 1;
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            subType = 2;
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            subType = 3;
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            subType = 4;
        }
        return subType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.authinfo");
    }

    public ViewerFilter getViewerFilter(Trace t, String typeId) {
        SelectAuthInfoViewerFilter viewerFilter = new SelectAuthInfoViewerFilter();
        viewerFilter.setHideLDAPAuthInfo(true);
        viewerFilter.setHideOCSPAuthInfo(true);
        viewerFilter.setHideIDPWOSAuthInfo(true);
        viewerFilter.setHideIDPWLDAPAuthInfo(true);
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            viewerFilter.setHideLDAPAuthInfo(false);
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            viewerFilter.setHideOCSPAuthInfo(false);
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            viewerFilter.setHideIDPWOSAuthInfo(false);
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            viewerFilter.setHideIDPWLDAPAuthInfo(false);
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getViewerFilter", 10, 50999, 0, 0, "Unknown Viewer Filter type", typeId, null);
        }
        return viewerFilter;
    }

    public void setFixedAttributes(Trace t, IDmObject object, NewObjectWiz wizard) {
        super.setFixedAttributes(t, object, wizard);
        int id = 63;
        Integer value = 3;
        this.setFixedAttribute(t, object, id, value);
    }

    public int[] getMandatoryAttributeIds(Trace t, String typeId) {
        int[] ids = null;
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)83, (int)1);
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)83, (int)2);
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)83, (int)3);
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)83, (int)4);
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getMandatoryAttributeIds", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return ids;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.filterid.authinfo";
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public Integer getQSGDisposition() {
        return null;
    }

    public String getWizardTitle(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.AuthInfo.ldap");
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.AuthInfo.ocsp");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.AuthInfo.idpwos");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.AuthInfo.idpwldap");
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getWizardTitle", 10, 50999, 0, 0, "Unknown AuthInfo Type", typeId, null);
        }
        return title;
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.AuthInfo.ldap");
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.AuthInfo.ocsp");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.AuthInfo.idpwos");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.AuthInfo.idpwldap");
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getWizardPage1Title", 10, 50999, 0, 0, "Unknown AuthInfo Type", typeId, null);
        }
        return title;
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        String desc = "";
        if (typeId.compareTo(TYPE_AUTHINFO_LDAP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.AuthInfo.ldap");
        } else if (typeId.compareTo(TYPE_AUTHINFO_OCSP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.AuthInfo.ocsp");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_OS) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.AuthInfo.idpwos");
        } else if (typeId.compareTo(TYPE_AUTHINFO_IDPW_LDAP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.AuthInfo.idpwldap");
        } else {
            t.FFST(67, "QSGAuthInfoNewObjectProvider.getWizardPage2Description", 10, 50999, 0, 0, "Unknown AuthInfo Type", typeId, null);
        }
        return desc;
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        String text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.AuthInfo");
        return text;
    }
}

