/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.QmgrsViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiQueueManagerHandle;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShowHideQMDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/ShowHideQMDialog.java";
    private static final int TABLE_SHOWN = 1;
    private static final int TABLE_HIDDEN = 0;
    private static final int SHOW = 1;
    private static final int HIDE = 0;
    private static final int DIALOG_SPAN = 6;
    private static final int NUMBER_OF_COLUMNS = 6;
    private static final int TABLE_WIDTH_HINT = 650;
    private static final int TABLE_ROWS_HINT = 5;
    public static final String AMQ4133 = "AMQ4133";
    private static final int[] weights = new int[]{50, 50};
    private SashForm sashForm = null;
    private ExplorerTable tableShown = null;
    private ExplorerTable tableHidden = null;
    private List<UiMQObject> selectedQmgr_S = new ArrayList<UiMQObject>();
    private List<UiMQObject> selectedQmgr_H = new ArrayList<UiMQObject>();
    private Button buttonHide_S = null;
    private Button buttonShow_H = null;
    private Button buttonRemove_H = null;
    private Button buttonAdd_S = null;
    private boolean tableShownHasFocus = false;
    private boolean tableHiddenHasFocus = false;
    private Message msgFile;
    private QmgrsViewerFilter hiddenQmgrsViewerFilter = null;
    private QmgrsViewerFilter shownQmgrsViewerFilter = null;

    public ShowHideQMDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Trace t = Trace.getDefault();
        newShell.setText(this.msgFile.getMessage(t, "UI.QMGRS.ShowHide.Title"));
        newShell.setImage(Icons.get((String)Icons.iconkeyQmgrSmall));
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_QmgrsShowHideDialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button close = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        close.setFocus();
    }

    protected void buttonPressed(int buttonId) {
        this.okPressed();
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.sashForm = new SashForm(composite, 512);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.sashForm.setLayoutData((Object)gridData);
        Composite compShown = new Composite((Composite)this.sashForm, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        compShown.setLayout((Layout)gridLayout);
        Composite compHidden = new Composite((Composite)this.sashForm, 2048);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        compHidden.setLayout((Layout)gridLayout);
        this.sashForm.setWeights(weights);
        Label label = new Label(compShown, 0);
        label.setText(this.msgFile.getMessage(t, "UI.QMGRS.ShownQM.label"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.tableShown = new ExplorerTable(t, compShown, 0, "com.ibm.mq.explorer.queuemanagerhandle", false, false, false, true, (Object)"com.ibm.mq.explorer.context.showhideqmgr");
        IUiMQObjectFactory mqObjFactory = ObjectRegistrationManager.getUiMQObjectFactory((Trace)t, (String)"com.ibm.mq.explorer.queuemanagerhandle");
        this.tableShown.setUiMQObjectFactoryClass(t, mqObjFactory, null);
        this.tableShown.setObjectId(t, "com.ibm.mq.explorer.queuemanagerhandle");
        this.tableShown.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrhandle");
        this.tableShown.setSuppressEventsForHiddenQmgrs(false);
        this.tableShown.startListener(t, (IDmObservable)UiPlugin.getTheDataModel());
        this.hiddenQmgrsViewerFilter = new QmgrsViewerFilter();
        this.tableShown.addViewerFilter(t, (ViewerFilter)this.hiddenQmgrsViewerFilter);
        gridData = new GridData(1808);
        gridData.widthHint = 650;
        gridData.heightHint = this.tableShown.calculateHeight(t, 5, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        this.tableShown.setLayoutData((Object)gridData);
        this.tableShown.addSelChangedListener(t, new ExplorerTableSelectionChangedListener(){

            public void selChanged(ExplorerTableSelectionChangedEvent event) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.selectedQmgr_S = event.getObjects();
                ShowHideQMDialog.this.enableButtons(tr);
            }
        });
        this.tableShown.addFocusListener(t, new FocusListener(){

            public void focusGained(FocusEvent e) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.tablefocusGained(tr, 1);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Composite compButtons = new Composite(compShown, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginHeight = 0;
        compButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        compButtons.setLayoutData((Object)gridData);
        Label complabel = new Label(compButtons, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        complabel.setLayoutData((Object)gridData);
        this.buttonHide_S = new Button(compButtons, 8);
        this.buttonHide_S.setText(this.msgFile.getMessage(t, "UI.QMGRS.Hide.Button"));
        GridData gridDataHide = new GridData();
        gridDataHide.horizontalAlignment = 3;
        gridDataHide.verticalAlignment = 3;
        this.buttonHide_S.setLayoutData((Object)gridDataHide);
        this.buttonHide_S.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.hideQueueManagers(tr);
            }
        });
        this.buttonAdd_S = new Button(compButtons, 8);
        this.buttonAdd_S.setText(this.msgFile.getMessage(t, "UI.QMGRS.Add.Button"));
        GridData gridDataAdd = new GridData();
        gridDataAdd.horizontalAlignment = 3;
        gridDataAdd.verticalAlignment = 3;
        this.buttonAdd_S.setLayoutData((Object)gridDataAdd);
        this.buttonAdd_S.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.addQueueManager(tr);
            }
        });
        label = new Label(compHidden, 0);
        label.setText(this.msgFile.getMessage(t, "UI.QMGRS.HiddenQM.label"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.tableHidden = new ExplorerTable(t, compHidden, 0, "com.ibm.mq.explorer.queuemanagerhandle", false, false, false, true, (Object)"com.ibm.mq.explorer.context.showhideqmgr");
        this.tableHidden.setObjectId(t, "com.ibm.mq.explorer.queuemanagerhandle");
        this.tableHidden.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.qmgrhandle");
        this.tableHidden.setUiMQObjectFactoryClass(t, mqObjFactory, null);
        this.tableHidden.setSuppressEventsForHiddenQmgrs(false);
        this.tableHidden.startListener(t, (IDmObservable)UiPlugin.getTheDataModel());
        this.shownQmgrsViewerFilter = new QmgrsViewerFilter(false);
        this.tableHidden.addViewerFilter(t, (ViewerFilter)this.shownQmgrsViewerFilter);
        gridData = new GridData(1808);
        gridData.widthHint = 650;
        gridData.heightHint = this.tableHidden.calculateHeight(t, 5, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 6;
        this.tableHidden.setLayoutData((Object)gridData);
        this.tableHidden.addSelChangedListener(t, new ExplorerTableSelectionChangedListener(){

            public void selChanged(ExplorerTableSelectionChangedEvent event) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.selectedQmgr_H = event.getObjects();
                ShowHideQMDialog.this.enableButtons(tr);
            }
        });
        this.tableHidden.addFocusListener(t, new FocusListener(){

            public void focusGained(FocusEvent e) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.tablefocusGained(tr, 0);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        compButtons = new Composite(compHidden, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginHeight = 0;
        compButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        compButtons.setLayoutData((Object)gridData);
        complabel = new Label(compButtons, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        complabel.setLayoutData((Object)gridData);
        this.buttonShow_H = new Button(compButtons, 8);
        this.buttonShow_H.setText(this.msgFile.getMessage(t, "UI.QMGRS.Show.Button"));
        GridData gridDataShow = new GridData();
        gridDataShow.horizontalAlignment = 3;
        gridDataShow.verticalAlignment = 3;
        this.buttonShow_H.setLayoutData((Object)gridDataShow);
        this.buttonShow_H.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.showQueueManagers(tr);
            }
        });
        this.buttonRemove_H = new Button(compButtons, 8);
        this.buttonRemove_H.setText(this.msgFile.getMessage(t, "UI.QMGRS.Remove.Button"));
        GridData gridDataRemove = new GridData();
        gridDataRemove.horizontalAlignment = 3;
        gridDataRemove.verticalAlignment = 3;
        this.buttonRemove_H.setLayoutData((Object)gridDataRemove);
        this.buttonRemove_H.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ShowHideQMDialog.this.removeQueueManagers(tr);
            }
        });
        int maxWidth = 0;
        Point sizeHide = this.buttonHide_S.computeSize(-1, -1);
        Point sizeAdd = this.buttonAdd_S.computeSize(-1, -1);
        Point sizeShow = this.buttonShow_H.computeSize(-1, -1);
        Point sizeRemove = this.buttonRemove_H.computeSize(-1, -1);
        if (sizeHide.x > maxWidth) {
            maxWidth = sizeHide.x;
        }
        if (sizeAdd.x > maxWidth) {
            maxWidth = sizeAdd.x;
        }
        if (sizeShow.x > maxWidth) {
            maxWidth = sizeShow.x;
        }
        if (sizeRemove.x > maxWidth) {
            maxWidth = sizeRemove.x;
        }
        gridDataHide.widthHint = maxWidth;
        gridDataAdd.widthHint = maxWidth;
        gridDataShow.widthHint = maxWidth;
        gridDataRemove.widthHint = maxWidth;
        this.enableButtons(t);
        return composite;
    }

    private void addQueueManager(Trace t) {
        AddQmgrWiz addQmgrWiz = new AddQmgrWiz(t);
        AddQmgrWizDlg addQmgrWizDlg = new AddQmgrWizDlg(this.getShell(), (IWizard)addQmgrWiz);
        addQmgrWizDlg.create();
        if (addQmgrWizDlg.open() != 1) {
            UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
        }
    }

    private void tablefocusGained(Trace t, int tableId) {
        if (tableId == 1) {
            this.tableShownHasFocus = true;
            this.tableHiddenHasFocus = false;
        } else {
            this.tableShownHasFocus = false;
            this.tableHiddenHasFocus = true;
        }
        this.enableButtons(t);
    }

    private void hideQueueManagers(Trace t) {
        for (UiQueueManagerHandle uiQueueManagerHandle : this.selectedQmgr_S) {
            uiQueueManagerHandle.setVisible(t, 0);
        }
        this.selectedQmgr_S = new ArrayList<UiMQObject>();
        this.tableHidden.refresh();
        this.tableShown.refresh();
        this.enableButtons(t);
    }

    private void showQueueManagers(Trace t) {
        for (UiQueueManagerHandle uiQueueManagerHandle : this.selectedQmgr_H) {
            uiQueueManagerHandle.setVisible(t, 1);
        }
        UiPlugin.getMQNavigatorView().expandTreeNode(t, UiPlugin.getMQNavigatorView().findTreeNode(t, "com.ibm.mq.explorer.treenode.qmgrs"));
        this.selectedQmgr_H = new ArrayList<UiMQObject>();
        this.tableHidden.refresh();
        this.tableShown.refresh();
        this.enableButtons(t);
    }

    private void enableButtons(Trace t) {
        this.buttonHide_S.setEnabled(this.tableShownHasFocus && this.selectedQmgr_S.size() > 0);
        if (this.tableHiddenHasFocus) {
            this.buttonShow_H.setEnabled(this.selectedQmgr_H.size() > 0);
            if (this.selectedQmgr_H.size() > 0) {
                boolean shouldEnable = true;
                for (UiMQObject qmgr : this.selectedQmgr_H) {
                    UiQueueManagerHandle qmgrH;
                    if (!(qmgr instanceof UiQueueManagerHandle) || (qmgrH = (UiQueueManagerHandle)qmgr).isClient(t) && !qmgrH.isUsedAsViaQM(t)) continue;
                    shouldEnable = false;
                }
                this.buttonRemove_H.setEnabled(shouldEnable);
            } else {
                this.buttonRemove_H.setEnabled(false);
            }
        } else {
            this.buttonShow_H.setEnabled(false);
            this.buttonRemove_H.setEnabled(false);
        }
    }

    private void removeQueueManagers(Trace t) {
        ArrayList<UiMQObject> removed = new ArrayList<UiMQObject>();
        for (UiMQObject qmgr : this.selectedQmgr_H) {
            if (!(qmgr instanceof UiQueueManagerHandle)) continue;
            UiQueueManagerHandle selQmgr = (UiQueueManagerHandle)qmgr;
            int result = MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)AMQ4133, (String)selQmgr.toString()), (int)1, (String)AMQ4133);
            if (result != 0) continue;
            selQmgr.removeQM(t);
            removed.add(qmgr);
            this.tableHidden.removeTableItem(t, (UiMQObject)selQmgr);
        }
        this.selectedQmgr_H.removeAll(removed);
        this.enableButtons(t);
        UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)true);
    }
}

