/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.QueueManagerConnectionException;
import com.ibm.mq.explorer.ui.internal.base.IRemoteQmgrConnection;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoteQmgrConnection
implements IRemoteQmgrConnection,
DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/RemoteQmgrConnection.java";
    public static final String CANT_CONNECT_TO_SPECIFIED_QM = "AMQ4027";
    public static final String CANT_CONNECT_TO_CHANNEL_TABLE_QM = "AMQ4103";
    public static final String CHANNEL_TABLE_INVALID_FORMAT = "AMQ4104";
    BusyDialog busyDlg = null;
    private Message msgFile = null;
    private DmQueueManager addedDmQueueManager = null;
    private DmObjectEvent addedQmgrEvent = null;

    public RemoteQmgrConnection(Trace t) {
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
    }

    public MQQmgrExtObject addRemoteQueueManager(Trace t, String qmName, URL chanDefTable, Hashtable<String, ?> connOptions, Hashtable<String, ?> options) throws QueueManagerConnectionException {
        MQQmgrExtObject mqQmgrExtObject = null;
        String busyText = this.msgFile.getMessage(t, "UI.QMGRS.AddQM.Busy.Text");
        this.busyDlg = new BusyDialog(UiPlugin.getShell(), busyText);
        int refreshInterval = this.getRefreshIntervalOption(t, options);
        boolean autoReconnect = this.getAutoReconnectOption(t, options);
        boolean isDisplayDlgs = this.getDisplayDialogs(t, options);
        Hashtable<String, Object> useConnOptions = connOptions;
        if (useConnOptions == null) {
            useConnOptions = new Hashtable();
        }
        UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, qmName, chanDefTable, refreshInterval, autoReconnect, true, (DmQueueManagerListener)this);
        this.busyDlg.showDialog(t);
        QueueManagerConnectionException e = this.processResponse(t, qmName, isDisplayDlgs, CANT_CONNECT_TO_CHANNEL_TABLE_QM);
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            }
            throw e;
        }
        UiQueueManager uiQueueManager = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, this.addedDmQueueManager);
        mqQmgrExtObject = (MQQmgrExtObject)uiQueueManager.getExternalObject();
        return mqQmgrExtObject;
    }

    public MQQmgrExtObject addRemoteQueueManager(Trace t, String qmName, String connName, String chl, Hashtable<String, ?> connOptions, Hashtable<String, ?> options) throws QueueManagerConnectionException {
        MQQmgrExtObject mqQmgrExtObject = null;
        String busyText = this.msgFile.getMessage(t, "UI.QMGRS.AddQM.Busy.Text");
        this.busyDlg = new BusyDialog(UiPlugin.getShell(), busyText);
        int refreshInterval = this.getRefreshIntervalOption(t, options);
        boolean autoReconnect = this.getAutoReconnectOption(t, options);
        boolean isDisplayDlgs = this.getDisplayDialogs(t, options);
        Hashtable<String, Object> useConnOptions = connOptions;
        if (useConnOptions == null) {
            useConnOptions = new Hashtable();
        }
        UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, qmName, connName, chl, useConnOptions, refreshInterval, autoReconnect, true, (DmQueueManagerListener)this);
        this.busyDlg.showDialog(t);
        QueueManagerConnectionException e = this.processResponse(t, qmName, isDisplayDlgs, CANT_CONNECT_TO_SPECIFIED_QM);
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            }
            throw e;
        }
        UiQueueManager uiQueueManager = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, this.addedDmQueueManager);
        mqQmgrExtObject = (MQQmgrExtObject)uiQueueManager.getExternalObject();
        return mqQmgrExtObject;
    }

    public MQQmgrExtObject addRemoteQueueManager(Trace t, String qmName, String[] connNames, String chl, Hashtable<String, ?> connOptions, Hashtable<String, ?> options) throws QueueManagerConnectionException {
        MQQmgrExtObject mqQmgrExtObject = null;
        String busyText = this.msgFile.getMessage(t, "UI.QMGRS.AddQM.Busy.Text");
        this.busyDlg = new BusyDialog(UiPlugin.getShell(), busyText);
        int refreshInterval = this.getRefreshIntervalOption(t, options);
        boolean autoReconnect = this.getAutoReconnectOption(t, options);
        boolean isDisplayDlgs = this.getDisplayDialogs(t, options);
        Hashtable<String, Object> useConnOptions = connOptions;
        if (useConnOptions == null) {
            useConnOptions = new Hashtable();
        }
        UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, qmName, connNames, chl, useConnOptions, refreshInterval, autoReconnect, true, (DmQueueManagerListener)this);
        this.busyDlg.showDialog(t);
        QueueManagerConnectionException e = this.processResponse(t, qmName, isDisplayDlgs, CANT_CONNECT_TO_SPECIFIED_QM);
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            }
            throw e;
        }
        UiQueueManager uiQueueManager = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, this.addedDmQueueManager);
        mqQmgrExtObject = (MQQmgrExtObject)uiQueueManager.getExternalObject();
        return mqQmgrExtObject;
    }

    public MQQmgrExtObject addRemoteQueueManager(Trace t, MQQmgrExtObject existingQM, String targetQ, String targetQM, Hashtable<String, ?> options) throws QueueManagerConnectionException {
        MQQmgrExtObject mqQmgrExtObject = null;
        String busyText = this.msgFile.getMessage(t, "UI.QMGRS.AddQM.Busy.Text");
        this.busyDlg = new BusyDialog(UiPlugin.getShell(), busyText);
        int refreshInterval = this.getRefreshIntervalOption(t, options);
        boolean autoReconnect = this.getAutoReconnectOption(t, options);
        boolean isDisplayDlgs = this.getDisplayDialogs(t, options);
        UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, ((UiQueueManager)existingQM.getInternalObject()).getDmQueueManagerObject(), targetQ, targetQM, refreshInterval, autoReconnect, true, (DmQueueManagerListener)this);
        this.busyDlg.showDialog(t);
        QueueManagerConnectionException e = this.processResponse(t, targetQM, isDisplayDlgs, CANT_CONNECT_TO_SPECIFIED_QM);
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                t.data(67, "RemoteQmgrConnection.addRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            }
            throw e;
        }
        UiQueueManager uiQueueManager = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, this.addedDmQueueManager);
        mqQmgrExtObject = (MQQmgrExtObject)uiQueueManager.getExternalObject();
        return mqQmgrExtObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeRemoteQueueManager(Trace t, MQQmgrExtObject mqQmgrExtObject) throws QueueManagerConnectionException {
        boolean result = false;
        if (mqQmgrExtObject != null) {
            if (mqQmgrExtObject.isRemote()) {
                ExplorerNotifyEvent event = new ExplorerNotifyEvent((Object)mqQmgrExtObject, null);
                boolean dontRemove = UiPlugin.getNotificationManager().notifyIsPreventRemoveQueueManager(t, event);
                if (dontRemove) {
                    QueueManagerConnectionException e = new QueueManagerConnectionException(CommonServices.getSystemMessage((Trace)t, (String)"AMQ4105"), "AMQ4105", 1, 50056);
                    if (!Trace.isTracing) throw e;
                    t.data(67, "RemoteQmgrConnection.removeRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                    t.data(67, "RemoteQmgrConnection.removeRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
                    throw e;
                }
                UiQueueManager uiQmgr = (UiQueueManager)mqQmgrExtObject.getInternalObject();
                DmQueueManager dmQmgr = uiQmgr.getDmQueueManagerObject();
                return UiPlugin.getTheDataModel().removeQueueManager(t, dmQmgr.getConnectionHandle());
            }
            QueueManagerConnectionException e = new QueueManagerConnectionException(Message.format((String)CommonServices.getSystemMessage((Trace)t, (String)"AMQ4581"), (String)"removeRemoteQueueManager", (String)"queue manager is not remote"), "AMQ4581", 2, 50057);
            if (!Trace.isTracing) throw e;
            t.data(67, "RemoteQmgrConnection.removeRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
            t.data(67, "RemoteQmgrConnection.removeRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            throw e;
        }
        QueueManagerConnectionException e = new QueueManagerConnectionException(Message.format((String)CommonServices.getSystemMessage((Trace)t, (String)"AMQ4581"), (String)"removeRemoteQueueManager", (String)"queue manager is (null)"), "AMQ4581", 2, 50020);
        if (!Trace.isTracing) throw e;
        t.data(67, "RemoteQmgrConnection.removeRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
        t.data(67, "RemoteQmgrConnection.removeRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
        throw e;
    }

    private int getRefreshIntervalOption(Trace t, Hashtable<String, ?> options) {
        int refreshInterval = UiPlugin.getRemoteDefaultRefreshRate();
        if (options != null && options.containsKey("refreshInterval")) {
            Object value = options.get("refreshInterval");
            if (value instanceof Integer) {
                refreshInterval = (Integer)value;
            } else if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.getRefreshIntervalOption", 900, "Incorrect object type provided for option refreshInterval - should be an Integer");
            }
        }
        if (Trace.isTracing) {
            t.data(67, "RemoteQmgrConnection.getRefreshIntervalOption", 300, "using refresh interval " + refreshInterval);
        }
        return refreshInterval;
    }

    private boolean getAutoReconnectOption(Trace t, Hashtable<String, ?> options) {
        boolean autoReconnect = false;
        if (options != null && options.containsKey("autoReconnect")) {
            Object value = options.get("autoReconnect");
            if (value instanceof Boolean) {
                autoReconnect = (Boolean)value;
            } else if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.getAutoReconnectOption", 900, "Incorrect object type provided for option autoReconnect - should be a Boolean");
            }
        }
        if (Trace.isTracing) {
            t.data(67, "RemoteQmgrConnection.getAutoReconnectOption", 300, "using auto-reconnect " + autoReconnect);
        }
        return autoReconnect;
    }

    private boolean getDisplayDialogs(Trace t, Hashtable<String, ?> options) {
        boolean isDisplayDlgs = false;
        if (options != null && options.containsKey("showDialogsOnError")) {
            Object value = options.get("showDialogsOnError");
            if (value instanceof Boolean) {
                isDisplayDlgs = (Boolean)value;
            } else if (Trace.isTracing) {
                t.data(67, "RemoteQmgrConnection.getDisplayDialogs", 900, "Incorrect object type provided for option showDialogsOnError - should be a Boolean");
            }
        }
        if (Trace.isTracing) {
            t.data(67, "RemoteQmgrConnection.getDisplayDialogs", 300, "using display dialogs " + isDisplayDlgs);
        }
        return isDisplayDlgs;
    }

    public QueueManagerConnectionException processResponse(Trace t, String qmgrName, boolean isDisplayDlgs, String connectErrorMessage) {
        QueueManagerConnectionException qmgrConnException = null;
        UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
        boolean keepQueueManager = false;
        if (this.addedQmgrEvent != null) {
            DmCoreException exception = this.addedQmgrEvent.getException();
            if (exception != null) {
                if (isDisplayDlgs) {
                    MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)exception);
                    if (exception.getReasonCode() != 10042) {
                        DmQueueManager queueManager = (DmQueueManager)this.addedQmgrEvent.getSource();
                        String displayedName = queueManager.getTreeName(t);
                        int response = MessageBox.showYesNoMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)connectErrorMessage, (String)displayedName), (int)1, (String)connectErrorMessage);
                        keepQueueManager = response == 0;
                    }
                } else {
                    keepQueueManager = false;
                }
            } else {
                keepQueueManager = true;
            }
            DmQueueManager dmQueueManagerObject = (DmQueueManager)this.addedQmgrEvent.getSource();
            if (keepQueueManager) {
                dmQueueManagerObject.notifyListeners(t);
            } else {
                dmQueueManagerObject.close(t);
                qmgrConnException = new QueueManagerConnectionException(exception.getLocalizedMessage(), exception.getMessageID(), exception.getCompCode(), exception.getReasonCode());
            }
        } else {
            t.FFST(67, "RemoteQmgrConnection.processResponse", 1, 50020, 0, 0, "Null event from the data model", qmgrName, null);
            String msgId = "AMQ4859";
            String msgText = CommonServices.getSystemMessage((String)msgId);
            qmgrConnException = new QueueManagerConnectionException(msgText, msgId, 2, 50053);
        }
        return qmgrConnException;
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        this.addedQmgrEvent = event;
        if (event.getException() == null && event.getSource() instanceof DmQueueManager) {
            this.addedDmQueueManager = (DmQueueManager)event.getSource();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                RemoteQmgrConnection.this.busyDlg.closeDialog(tr);
            }
        });
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        this.addedQmgrEvent = event;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                RemoteQmgrConnection.this.busyDlg.closeDialog(tr);
            }
        });
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }
}

