/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWiz;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CreateQmgrWizPage4
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/CreateQmgrWizPage4.java";
    private static final int DEFAULT_PORT_NUMBER = 1414;
    private static final int MAX_PORT_VALUE = 65535;
    private static String titleText = null;
    private static String descriptionText = null;
    private static String blankPortError = null;
    private static String portInuseError = null;
    private static String qmgrText = null;
    private static String createListenerText = null;
    private static String portText = null;
    private static String listenerExplanation = null;
    private static String portExplanation = null;
    private Text qmgrName;
    private Button configureListener;
    private Spinner port;
    private HashSet<Integer> usedPorts;
    private int defaultPortNumber;
    private CreateQmgrWiz wizard = null;

    public CreateQmgrWizPage4(String pageName) {
        super(pageName, "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_4");
        this.setHeadingsInfo();
    }

    public CreateQmgrWizPage4(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage, "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_4");
        this.setHeadingsInfo();
    }

    private void setHeadingsInfo() {
        Trace t = Trace.getDefault();
        if (titleText == null) {
            Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Command Dialog");
            titleText = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page4.Title");
            descriptionText = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page4.Desc");
            blankPortError = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page4.BlankPortError");
            portInuseError = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page4.PortInuseError");
            qmgrText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.QmgrLabel");
            createListenerText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.CreateListener");
            listenerExplanation = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.Page4.Text1");
            portText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.Port");
            portExplanation = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.Page4.Text2");
        }
        this.setTitle(titleText);
        this.setDescription(descriptionText);
        DmObjectFilter filter = new DmObjectFilter(t, 97, 2);
        this.usedPorts = new HashSet();
        ArrayList qmgrs = UiPlugin.getTheDataModel().getQueueManagers(t);
        int i = 0;
        while (i < qmgrs.size()) {
            block11: {
                DmQueueManager qmgr = (DmQueueManager)qmgrs.get(i);
                if (qmgr.isLocal() && qmgr.isConnected()) {
                    ArrayList listeners = null;
                    try {
                        int defaultPort = 1414;
                        AttrInt portAttr = (AttrInt)qmgr.getAttribute(t, 85, 0);
                        if (portAttr != null) {
                            Integer port1 = (Integer)portAttr.getValue(t);
                            defaultPort = port1;
                        }
                        if (Trace.isTracing) {
                            t.data(67, "CreateQmgrWizPage4.setHeadingsInfo", 300, "Default port address is " + defaultPort);
                        }
                        listeners = qmgr.getObjects(t, filter);
                        int j = 0;
                        while (j < listeners.size()) {
                            DmListener listener = (DmListener)listeners.get(j);
                            AttrInt attr = (AttrInt)listener.getAttribute(t, 1522, 0);
                            if (attr != null) {
                                Integer port1 = (Integer)attr.getValue(t);
                                this.usedPorts.add(port1);
                            } else if (Trace.isTracing) {
                                t.data(67, "CreateQmgrWizPage4.setHeadingsInfo", 900, "TCP listener with no port ? " + listener.toString(t));
                            }
                            ++j;
                        }
                    }
                    catch (DmCoreException e) {
                        if (!Trace.isTracing) break block11;
                        t.data(67, "CreateQmgrWizPage4.setHeadingsInfo", 900, "Error getting listener info" + Common.NEW_LINE + e.getMessage());
                    }
                }
            }
            ++i;
        }
        this.defaultPortNumber = 1414;
    }

    public void performHelp() {
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_4");
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (CreateQmgrWiz)this.getWizard();
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
        }
        Label pad = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        pad.setLayoutData((Object)gridData);
        Label label = new Label(parent, 131072);
        label.setText(qmgrText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.qmgrName = new Text(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.qmgrName.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.qmgrName, (boolean)true);
        pad = new Label(parent, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        gridData.heightHint = 20;
        pad.setLayoutData((Object)gridData);
        pad = new Label(parent, 0);
        Text text = new Text(parent, 74);
        text.setText(listenerExplanation);
        gridData = new GridData();
        gridData = new GridData(1040);
        gridData.widthHint = 400;
        gridData.horizontalSpan = 4;
        text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        pad = new Label(parent, 0);
        this.configureListener = new Button(parent, 32);
        this.configureListener.setText(createListenerText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.configureListener.setSelection(true);
        this.configureListener.setLayoutData((Object)gridData);
        this.configureListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateQmgrWizPage4.this.configureListener.getSelection()) {
                    CreateQmgrWizPage4.this.port.setEnabled(true);
                } else {
                    CreateQmgrWizPage4.this.port.setEnabled(false);
                }
                CreateQmgrWizPage4.this.checkIfEnableButtons();
            }
        });
        pad = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.heightHint = 20;
        pad.setLayoutData((Object)gridData);
        pad = new Label(parent, 0);
        text = new Text(parent, 74);
        text.setText(portExplanation);
        gridData = new GridData(1040);
        gridData.widthHint = 400;
        gridData.horizontalSpan = 4;
        text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        pad = new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText(portText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 128;
        label.setLayoutData((Object)gridData);
        this.port = new Spinner(parent, 2048);
        this.port.setMinimum(0);
        this.port.setMaximum(65535);
        this.port.setSelection(this.defaultPortNumber);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.port.setLayoutData((Object)gridData);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.port);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQmgrWizPage4.this.checkIfEnableButtons();
            }
        });
        pad = new Label(parent, 0);
    }

    public void checkIfEnableButtons() {
        boolean isEnableNext = false;
        boolean isEnableFinish = false;
        Integer value = this.port.getSelection();
        if (!this.configureListener.getSelection()) {
            isEnableNext = true;
            isEnableFinish = true;
            this.setErrorMessage(null);
        } else if (value == null) {
            isEnableNext = false;
            isEnableFinish = false;
            this.setErrorMessage(blankPortError);
        } else if (this.usedPorts.contains(value)) {
            isEnableNext = false;
            isEnableFinish = false;
            this.setErrorMessage(portInuseError);
        } else {
            isEnableNext = true;
            isEnableFinish = true;
            this.setErrorMessage(null);
        }
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }

    public boolean isPortOk() {
        boolean result = true;
        Integer value = this.port.getSelection();
        if (!this.configureListener.getSelection()) {
            result = true;
        } else if (value == null) {
            result = false;
        } else if (this.usedPorts.contains(value)) {
            result = false;
        }
        return result;
    }

    public void setQueueManagerName(String name) {
        this.qmgrName.setText(name);
    }

    public boolean getConfigureListener() {
        return this.configureListener.getSelection();
    }

    public int getPort() {
        int number = 0;
        Integer object = this.port.getSelection();
        if (object != null) {
            number = object;
        }
        return number;
    }

    public boolean performFinish() {
        return false;
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 5);
    }
}

