/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWiz;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CreateQmgrWizPage2
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/CreateQmgrWizPage2.java";
    private static final int LOG_PRIMARY_FILES_MIN = 2;
    private static final int LOG_PRIMARY_FILES_DEFAULT = 3;
    private static final int LOG_SECONDARY_FILES_MIN = 1;
    private static final int LOG_SECONDARY_FILES_DEFAULT = 2;
    private static final int LOG_FILES_MAX_WINDOWS = 255;
    private static final int LOG_FILES_MAX_UNIX = 511;
    private static final int LOG_FILESIZE_MAX = 65535;
    private static final int LOG_FILESIZE_MIN_WINDOWS = 32;
    private static final int LOG_FILESIZE_MIN_UNIX = 64;
    private static final int LOG_FILESIZE_DEF_WINDOWS = 256;
    private static final int LOG_FILESIZE_DEF_UNIX = 1024;
    private static final String LOG_TYPE_CIRCULAR = "CIRCULAR";
    private static final String LOG_TYPE_LINEAR = "LINEAR";
    private static String titleText = null;
    private static String descriptionText = null;
    private static String notDirError = null;
    private static String qmgrText = null;
    private static String circularLoggingText = null;
    private static String linearLoggingText = null;
    private static String autoManagementText = null;
    private static String archiveManagementText = null;
    private static String logPathText = null;
    private static String logFileSizeText = null;
    private static String logPrimaryFilesText = null;
    private static String logSecondaryFilesText = null;
    private static String browseText = null;
    private static String browseDialog = null;
    private Text qmgrName;
    private Button circularLogging;
    private Button linearLogging;
    private Button autoManagement;
    private Button archiveManagement;
    private Text logPath;
    private Button browse;
    private Spinner logFileSize;
    private Spinner logPrimaryFiles;
    private Spinner logSecondaryFiles;
    private int maxLogFiles = 0;
    private boolean changedByCode = false;
    private CreateQmgrWiz wizard = null;
    private static String dataPathText = null;
    private static String notDirErrorData = null;
    private static String browseDataText = null;
    private static String browseDataDialog = null;
    private Text dataPath;
    private Button browseData;
    private static final String QMGR_DATA_PATHNAME = "qmgrs";
    private static String groupChangePathsText = null;
    private static String radioChangePathsText = null;
    private Button radioChangePaths = null;

    public CreateQmgrWizPage2(String pageName) {
        super(pageName, "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_2");
        Trace t = Trace.getDefault();
        this.setHeadingsInfo();
        this.maxLogFiles = this.getMaxLogFiles(t);
    }

    public CreateQmgrWizPage2(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage, "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_2");
        Trace t = Trace.getDefault();
        this.setHeadingsInfo();
        this.maxLogFiles = this.getMaxLogFiles(t);
    }

    private void setHeadingsInfo() {
        Trace t = Trace.getDefault();
        if (titleText == null) {
            Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Command Dialog");
            titleText = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page2.Title");
            descriptionText = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page2.Desc");
            notDirError = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page2.NotDirectoryError");
            qmgrText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.QmgrLabel");
            circularLoggingText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.CircularLogging");
            linearLoggingText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.LinearLogging");
            autoManagementText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.AutoMgmt");
            archiveManagementText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.ArchiveMgmt");
            logPathText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.LogPath");
            logFileSizeText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.LogFileSize");
            logPrimaryFilesText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.LogPrimaryFiles");
            logSecondaryFilesText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.LogSecondaryFiles");
            browseText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.LogBrowse");
            browseDialog = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.BrowseDialog");
            notDirErrorData = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page1.DataNotDirectoryError");
            dataPathText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DataPath");
            browseDataDialog = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DataBrowseDialog");
            groupChangePathsText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.GroupChangePaths");
            radioChangePathsText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.RadioChangePaths");
            msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
            browseDataText = msgFile.getMessage(t, "UI.TABLES.Button.Browse");
        }
        this.setTitle(titleText);
        this.setDescription(descriptionText);
    }

    public void performHelp() {
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_2");
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (CreateQmgrWiz)this.getWizard();
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
        }
        Label pad = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        pad.setLayoutData((Object)gridData);
        Label label = new Label(parent, 131072);
        label.setText(qmgrText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.qmgrName = new Text(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.qmgrName.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.qmgrName, (boolean)true);
        UiUtils.createBlankLine((Composite)parent, (int)5);
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        Composite buttonGroup = new Composite(parent, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        this.circularLogging = new Button(buttonGroup, 16);
        this.circularLogging.setText(circularLoggingText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.circularLogging.setLayoutData((Object)gridData);
        boolean selection = LOG_TYPE_CIRCULAR.equals(this.getLogTypeDef(t));
        this.circularLogging.setSelection(selection);
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        this.linearLogging = new Button(buttonGroup, 16);
        this.linearLogging.setText(linearLoggingText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.linearLogging.setLayoutData((Object)gridData);
        selection = LOG_TYPE_LINEAR.equals(this.getLogTypeDef(t));
        this.linearLogging.setSelection(selection);
        this.linearLogging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateQmgrWizPage2.this.linearLogging.getSelection()) {
                    CreateQmgrWizPage2.this.autoManagement.setEnabled(true);
                    CreateQmgrWizPage2.this.archiveManagement.setEnabled(true);
                } else {
                    CreateQmgrWizPage2.this.autoManagement.setEnabled(false);
                    CreateQmgrWizPage2.this.archiveManagement.setEnabled(false);
                }
            }
        });
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        this.autoManagement = new Button(buttonGroup, 32);
        this.autoManagement.setText(autoManagementText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.autoManagement.setLayoutData((Object)gridData);
        this.autoManagement.setSelection(false);
        this.autoManagement.setEnabled(LOG_TYPE_LINEAR.equals(this.getLogTypeDef(t)));
        this.autoManagement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateQmgrWizPage2.this.autoManagement.getSelection()) {
                    CreateQmgrWizPage2.this.archiveManagement.setEnabled(true);
                } else {
                    CreateQmgrWizPage2.this.archiveManagement.setEnabled(false);
                }
            }
        });
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        this.archiveManagement = new Button(buttonGroup, 32);
        this.archiveManagement.setText(archiveManagementText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.archiveManagement.setLayoutData((Object)gridData);
        this.archiveManagement.setSelection(false);
        this.archiveManagement.setEnabled(LOG_TYPE_LINEAR.equals(this.getLogTypeDef(t)));
        label = new Label(parent, 0);
        label.setText(logFileSizeText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.logFileSize = new Spinner(parent, 2048);
        gridData = new GridData(768);
        this.logFileSize.setLayoutData((Object)gridData);
        this.logFileSize.setMinimum(CreateQmgrWizPage2.getLogFileSizeMin(t));
        this.logFileSize.setMaximum(65535);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.logFileSize);
        this.logFileSize.setSelection(CreateQmgrWizPage2.getLogFileSizeDef(t));
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText(logPrimaryFilesText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.logPrimaryFiles = new Spinner(parent, 2048);
        gridData = new GridData(768);
        this.logPrimaryFiles.setLayoutData((Object)gridData);
        this.logPrimaryFiles.setMinimum(2);
        this.logPrimaryFiles.setMaximum(this.getMaxLogPrimaryFiles(t));
        UiUtils.limitSpinner((Trace)t, (Spinner)this.logPrimaryFiles);
        this.logPrimaryFiles.setSelection(this.getDefaultLogPrimaryFiles(t));
        this.logPrimaryFiles.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQmgrWizPage2.this.primaryLogFilesModified(Trace.getDefault());
                CreateQmgrWizPage2.this.checkIfEnableButtons();
            }
        });
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText(logSecondaryFilesText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.logSecondaryFiles = new Spinner(parent, 2048);
        gridData = new GridData(768);
        this.logSecondaryFiles.setLayoutData((Object)gridData);
        this.logSecondaryFiles.setMinimum(1);
        this.logSecondaryFiles.setMaximum(this.getMaxLogSecondaryFiles(t));
        UiUtils.limitSpinner((Trace)t, (Spinner)this.logSecondaryFiles);
        this.logSecondaryFiles.setSelection(this.getDefaultLogSecondaryFiles(t));
        this.logSecondaryFiles.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQmgrWizPage2.this.secondaryLogFilesModified(Trace.getDefault());
                CreateQmgrWizPage2.this.checkIfEnableButtons();
            }
        });
        pad = new Label(parent, 0);
        pad = new Label(parent, 0);
        UiUtils.createBlankLine((Composite)parent, (int)5);
        Group groupChangePaths = new Group(parent, 0);
        groupChangePaths.setText(groupChangePathsText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        groupChangePaths.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        groupChangePaths.setLayout((Layout)gridLayout);
        this.radioChangePaths = new Button((Composite)groupChangePaths, 32);
        this.radioChangePaths.setText(radioChangePathsText);
        this.radioChangePaths.setSelection(true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.radioChangePaths.setLayoutData((Object)gridData);
        this.radioChangePaths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateQmgrWizPage2.this.checkStandbyChanges();
            }
        });
        label = new Label((Composite)groupChangePaths, 0);
        label.setText(dataPathText);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.dataPath = new Text((Composite)groupChangePaths, 2048);
        this.dataPath.setText(this.getDataPathDef(t));
        this.dataPath.setEnabled(false);
        gridData = new GridData(768);
        this.dataPath.setLayoutData((Object)gridData);
        this.dataPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQmgrWizPage2.this.checkIfEnableButtons();
            }
        });
        this.browseData = new Button((Composite)groupChangePaths, 8);
        this.browseData.setText(browseDataText);
        this.browseData.setEnabled(false);
        gridData = new GridData();
        this.browseData.setLayoutData((Object)gridData);
        this.browseData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                CreateQmgrWizPage2.this.browseData(t2);
            }
        });
        label = new Label((Composite)groupChangePaths, 0);
        label.setText(logPathText);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.logPath = new Text((Composite)groupChangePaths, 2048);
        this.logPath.setText(this.getLogPathDef(t));
        this.logPath.setEnabled(false);
        gridData = new GridData(768);
        this.logPath.setLayoutData((Object)gridData);
        this.logPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQmgrWizPage2.this.checkIfEnableButtons();
            }
        });
        this.browse = new Button((Composite)groupChangePaths, 8);
        this.browse.setText(browseText);
        this.browse.setEnabled(false);
        gridData = new GridData();
        this.browse.setLayoutData((Object)gridData);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                CreateQmgrWizPage2.this.browse(t1);
            }
        });
    }

    public void checkIfEnableButtons() {
        boolean isEnableNext = true;
        boolean isEnableFinish = true;
        String logPathFilename = this.logPath.getText();
        File file = new File(logPathFilename);
        if (!file.exists()) {
            isEnableNext = false;
            isEnableFinish = false;
            this.setErrorMessage(notDirError);
        } else {
            isEnableNext = true;
            this.setErrorMessage(null);
            isEnableFinish = this.wizard.isPortOk();
        }
        if (isEnableNext) {
            String dataPathFilename = this.dataPath.getText();
            file = new File(dataPathFilename);
            if (!file.exists()) {
                isEnableNext = false;
                isEnableFinish = false;
                this.setErrorMessage(notDirErrorData);
            } else if (logPathFilename.equals(dataPathFilename)) {
                isEnableNext = false;
                isEnableFinish = false;
                this.setErrorMessage(notDirError);
            } else {
                isEnableNext = true;
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }

    public void browse(Trace t) {
        Shell shell = this.getShell();
        String filename = this.logPath.getText();
        DirectoryDialog dialog = new DirectoryDialog(shell, 0);
        dialog.setText(browseDialog);
        dialog.setFilterPath(filename);
        String result = dialog.open();
        if (result != null) {
            this.logPath.setText(result);
        }
    }

    public void setQueueManagerName(String name) {
        this.qmgrName.setText(name);
    }

    private String getLogPathDef(Trace t) {
        String value;
        DmMachine machine = UiPlugin.getTheDataModel().getMachine(t);
        Attr attr = machine.getAttribute(t, 10514, 0);
        if (attr == null) {
            t.FFST(67, "CreateQmgrWizPage2.getLogPathDef", 1, 0, 0, 0, null, null, null);
            String installDir = "";
            try {
                installDir = QueryValue.queryInstallDir((Trace)t);
            }
            catch (CommonServicesException e) {
                installDir = "";
                Shell shell = this.getShell();
                MessageBox.showExceptionMessage((Trace)t, (Shell)shell, (CommonServicesException)e);
            }
            File defaultLogDir = new File(installDir, "log");
            value = defaultLogDir.toString();
        } else {
            value = (String)attr.getValue(t);
        }
        return value;
    }

    private static int getLogFileSizeMin(Trace t) {
        int value = 0;
        value = CommonServices.PLATFORM_ID == 1 ? 32 : 64;
        return value;
    }

    private static int getLogFileSizeDef(Trace t) {
        int value = 0;
        DmMachine machine = UiPlugin.getTheDataModel().getMachine(t);
        Attr attr = machine.getAttribute(t, 10511, 0);
        if (attr == null) {
            t.FFST(67, "CreateQmgrWizPage2.getLogFileSizeDef", 1, 0, 0, 0, null, null, null);
            value = CommonServices.PLATFORM_ID == 1 ? 256 : 1024;
        } else {
            Integer obj = (Integer)attr.getValue(t);
            value = obj;
        }
        return value;
    }

    private String getLogTypeDef(Trace t) {
        String value;
        DmMachine machine = UiPlugin.getTheDataModel().getMachine(t);
        Attr attr = machine.getAttribute(t, 10512, 0);
        if (attr == null) {
            t.FFST(67, "CreateQmgrWizPage2.getLogTypeDef", 1, 0, 0, 0, null, null, null);
            value = LOG_TYPE_CIRCULAR;
        } else {
            value = (String)attr.getValue(t);
        }
        return value;
    }

    private int getMaxLogPrimaryFiles(Trace t) {
        int value = 3;
        value = CommonServices.PLATFORM_ID == 1 ? 254 : 510;
        return value;
    }

    private int getMaxLogSecondaryFiles(Trace t) {
        int value = 3;
        value = CommonServices.PLATFORM_ID == 1 ? 253 : 509;
        return value;
    }

    private int getMaxLogFiles(Trace t) {
        int value = 255;
        value = CommonServices.PLATFORM_ID == 1 ? 255 : 511;
        return value;
    }

    private int getDefaultLogPrimaryFiles(Trace t) {
        int value = 3;
        DmMachine machine = UiPlugin.getTheDataModel().getMachine(t);
        Attr attr = machine.getAttribute(t, 10508, 0);
        if (attr == null) {
            t.FFST(67, "CreateQmgrWizPage2.getDefaultLogPrimaryFiles", 1, 0, 0, 0, null, null, null);
        } else {
            Integer object = (Integer)attr.getValue(t);
            value = object;
        }
        return value;
    }

    private int getDefaultLogSecondaryFiles(Trace t) {
        int value = 2;
        DmMachine machine = UiPlugin.getTheDataModel().getMachine(t);
        Attr attr = machine.getAttribute(t, 10509, 0);
        if (attr == null) {
            t.FFST(67, "CreateQmgrWizPage2.getDefaultLogSecondaryFiles", 1, 0, 0, 0, null, null, null);
        } else {
            Integer object = (Integer)attr.getValue(t);
            value = object;
        }
        return value;
    }

    public boolean getUseLinearLogging(Trace t) {
        return this.linearLogging.getSelection();
    }

    public boolean getUseAutoManagement(Trace t) {
        return this.autoManagement.getSelection();
    }

    public boolean getUseArchiveManagement(Trace t) {
        return this.archiveManagement.getSelection();
    }

    public String getLogPath(Trace t) {
        String value = this.logPath.getText();
        String logPathDef = this.getLogPathDef(t);
        String result = null;
        if (logPathDef == null) {
            result = value;
        } else if (!value.equals(logPathDef)) {
            result = value;
        }
        return result;
    }

    public Integer getLogFileSize(Trace t) {
        int def;
        Integer value = null;
        int number = this.logFileSize.getSelection();
        if (number != (def = CreateQmgrWizPage2.getLogFileSizeDef(t))) {
            value = number;
        }
        return value;
    }

    public Integer getLogPrimaryFiles(Trace t) {
        int defaultNumber;
        Integer value = null;
        int number = this.logPrimaryFiles.getSelection();
        if (number != (defaultNumber = this.getDefaultLogPrimaryFiles(t))) {
            value = number;
        }
        return value;
    }

    public Integer getLogSecondaryFiles(Trace t) {
        int defaultNumber;
        Integer value = null;
        int number = this.logSecondaryFiles.getSelection();
        if (number != (defaultNumber = this.getDefaultLogSecondaryFiles(t))) {
            value = number;
        }
        return value;
    }

    public boolean performFinish() {
        return false;
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 5);
    }

    private void primaryLogFilesModified(Trace t) {
        if (!this.changedByCode) {
            int primary = this.logPrimaryFiles.getSelection();
            int maxSecondary = this.maxLogFiles - primary;
            int secondary = this.logSecondaryFiles.getSelection();
            if (secondary > maxSecondary) {
                this.changedByCode = true;
                this.logSecondaryFiles.setSelection(maxSecondary);
                this.changedByCode = false;
            }
        }
    }

    private void secondaryLogFilesModified(Trace t) {
        if (!this.changedByCode) {
            int secondary = this.logSecondaryFiles.getSelection();
            int maxPrimary = this.maxLogFiles - secondary;
            int primary = this.logPrimaryFiles.getSelection();
            if (primary > maxPrimary) {
                this.changedByCode = true;
                this.logPrimaryFiles.setSelection(maxPrimary);
                this.changedByCode = false;
            }
        }
    }

    private String getDataPathDef(Trace t) {
        String value;
        DmMachine machine = UiPlugin.getTheDataModel().getMachine(t);
        Attr attr = machine.getAttribute(t, 10500, 0);
        if (attr == null) {
            t.FFST(67, "CreateQmgrWizPage2.getDataPathDef", 1, 0, 0, 0, null, null, null);
            String installDir = "";
            try {
                installDir = QueryValue.queryInstallDir((Trace)t);
            }
            catch (CommonServicesException e) {
                installDir = "";
                MessageBox.showExceptionMessage((Trace)t, (Shell)this.getShell(), (CommonServicesException)e);
            }
            File defaultDataDir = new File(installDir, QMGR_DATA_PATHNAME);
            value = defaultDataDir.toString();
        } else {
            value = (String)attr.getValue(t);
            File defaultDataDir = new File(value, QMGR_DATA_PATHNAME);
            value = defaultDataDir.toString();
        }
        return value;
    }

    public void browseData(Trace t) {
        Shell shell = this.getShell();
        String filename = this.dataPath.getText();
        DirectoryDialog dialog = new DirectoryDialog(shell, 0);
        dialog.setText(browseDataDialog);
        dialog.setFilterPath(filename);
        String result = dialog.open();
        if (result != null) {
            this.dataPath.setText(result);
        }
    }

    public String getDataPath(Trace t) {
        String value = this.dataPath.getText();
        String dataPathDef = this.getDataPathDef(t);
        String result = null;
        if (dataPathDef == null) {
            result = value;
        } else if (!value.equals(dataPathDef)) {
            result = value;
        }
        return result;
    }

    private void checkStandbyChanges() {
        Trace t = Trace.getDefault();
        boolean b = this.radioChangePaths.getSelection();
        if (b) {
            this.dataPath.setEnabled(!b);
            this.logPath.setEnabled(!b);
            this.browse.setEnabled(!b);
            this.browseData.setEnabled(!b);
            this.logPath.setText(this.getLogPathDef(t));
            this.dataPath.setText(this.getDataPathDef(t));
        } else {
            this.dataPath.setEnabled(!b);
            this.logPath.setEnabled(!b);
            this.browse.setEnabled(!b);
            this.browseData.setEnabled(!b);
        }
        this.checkIfEnableButtons();
    }
}

