/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWiz;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CreateQmgrWizPage1
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/CreateQmgrWizPage1.java";
    private static final int TRIGGER_INTERVAL_MIN = 0;
    private static final int TRIGGER_INTERVAL_MAX = 999999999;
    private static final int TRIGGER_INTERVAL_DEFAULT = 999999999;
    private static final int MAXIMUM_HANDLE_LIMIT_MIN = 1;
    private static final int MAXIMUM_HANDLE_LIMIT_MAX = 999999999;
    private static final int MAXIMUM_HANDLE_LIMIT_DEFAULT = 256;
    private static final int MAXUNCOMMSG_MIN = 1;
    private static final int MAXUNCOMMSG_MAX = 999999999;
    private static final int MAXUNCOMMSG_DEFAULT = 10000;
    private static final int UNIX_GROUP_NAME_LENGTH_MAX = 12;
    private static String titleText = null;
    private static String descriptionText = null;
    private static String blankQmgrNameError = null;
    private static String qmgrNameAlreadyUsedError = null;
    private static String qmgrText = null;
    private static String defaultQmgrButtonText = null;
    private static String defXmitQLabelText = null;
    private static String deadLetterQueueLabelText = null;
    private static String maxHandleLimitText = null;
    private static String triggerIntervalText = null;
    private static String maxUnComMsgText = null;
    private static String appGroupText = null;
    private Text qmgrName;
    private Button defaultQmgrButton;
    private Text deadLetterQueue;
    private Text defXmitQ;
    private Spinner maxHandleLimit;
    private Spinner triggerInterval;
    private Spinner maxUncomMsg;
    private HashSet<String> existingQueueManagers;
    private CreateQmgrWiz wizard = null;
    private boolean isFirstTimeRound = true;
    private Text appGroup;
    private boolean qmValid = true;
    private boolean xmitqValid = true;
    private boolean dlqValid = true;

    public CreateQmgrWizPage1(String pageName) {
        super(pageName, "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_1");
        this.setHeadingsInfo();
    }

    public CreateQmgrWizPage1(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage, "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_1");
        this.setHeadingsInfo();
    }

    private void setHeadingsInfo() {
        Trace t = Trace.getDefault();
        if (titleText == null) {
            Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Command Dialog");
            titleText = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page1.Title");
            descriptionText = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page1.Desc");
            blankQmgrNameError = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page1.BlankQmgrNameError");
            qmgrNameAlreadyUsedError = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Page1.QmgrNameAlreadyUsedError");
            qmgrText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.QmgrLabel");
            defaultQmgrButtonText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DefaultQmgr");
            defXmitQLabelText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DefXmitQ");
            defXmitQLabelText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DefXmitQ");
            deadLetterQueueLabelText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DeadLetterQ");
            maxHandleLimitText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.MaxHandleLimit");
            triggerIntervalText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.TriggerInterval");
            maxUnComMsgText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.UnComMsgs");
            appGroupText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.AppGroup");
        }
        this.setTitle(titleText);
        this.setDescription(descriptionText);
        this.existingQueueManagers = new HashSet();
        ArrayList qmgrs = UiPlugin.getTheDataModel().getQueueManagers(t);
        int i = 0;
        while (i < qmgrs.size()) {
            DmQueueManager qmgr = (DmQueueManager)qmgrs.get(i);
            if (qmgr.isLocal()) {
                String name = qmgr.toString(t);
                this.existingQueueManagers.add(name);
            }
            ++i;
        }
        List otherQmgrs = UiPlugin.getTheDataModel().getQueueManagersFromOtherInstallations(t);
        for (DmQueueManager qmgr : otherQmgrs) {
            this.existingQueueManagers.add(qmgr.getQueueManagerName());
        }
    }

    public void createPageContent(Trace t, Composite parent) {
        boolean displayAppGroup;
        this.wizard = (CreateQmgrWiz)this.getWizard();
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
            ((GridLayout)layout).horizontalSpacing = 12;
        }
        Label pad = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        pad.setLayoutData((Object)gridData);
        Label label = new Label(parent, 131072);
        label.setText(qmgrText);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.qmgrName = new Text(parent, 2048);
        this.qmgrName.setTextLimit(48);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.qmgrName.setLayoutData((Object)gridData);
        this.qmgrName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
        this.qmgrName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace t2 = Trace.getDefault();
                CreateQmgrWizPage1.this.qmValid = StringValidation.verifyMQObjectName((Trace)t2, (VerifyEvent)e);
                CreateQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
        UiUtils.createControlDecoration((Trace)t, (Control)this.qmgrName);
        pad = new Label(parent, 0);
        this.defaultQmgrButton = new Button(parent, 32);
        this.defaultQmgrButton.setText(defaultQmgrButtonText);
        gridData = new GridData(3);
        gridData.horizontalSpan = 4;
        this.defaultQmgrButton.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        label.setText(defXmitQLabelText);
        gridData = new GridData(3);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.defXmitQ = new Text(parent, 2048);
        this.defXmitQ.setTextLimit(48);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.defXmitQ.setLayoutData((Object)gridData);
        this.defXmitQ.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace t2 = Trace.getDefault();
                CreateQmgrWizPage1.this.xmitqValid = StringValidation.verifyMQObjectName((Trace)t2, (VerifyEvent)e);
                CreateQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
        label = new Label(parent, 0);
        label.setText(deadLetterQueueLabelText);
        gridData = new GridData(3);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        this.deadLetterQueue = new Text(parent, 2048);
        this.deadLetterQueue.setTextLimit(48);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.deadLetterQueue.setLayoutData((Object)gridData);
        this.deadLetterQueue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace t2 = Trace.getDefault();
                CreateQmgrWizPage1.this.dlqValid = StringValidation.verifyMQObjectName((Trace)t2, (VerifyEvent)e);
                CreateQmgrWizPage1.this.checkIfEnableButtons();
            }
        });
        label = new Label(parent, 0);
        label.setText(maxHandleLimitText);
        gridData = new GridData(3);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        this.maxHandleLimit = new Spinner(parent, 2048);
        this.maxHandleLimit.setMinimum(1);
        this.maxHandleLimit.setMaximum(999999999);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.maxHandleLimit);
        this.maxHandleLimit.setSelection(256);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.maxHandleLimit.setLayoutData((Object)gridData);
        pad = new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText(triggerIntervalText);
        gridData = new GridData(3);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        this.triggerInterval = new Spinner(parent, 2048);
        this.triggerInterval.setMinimum(0);
        this.triggerInterval.setMaximum(999999999);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.triggerInterval);
        this.triggerInterval.setSelection(999999999);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.triggerInterval.setLayoutData((Object)gridData);
        pad = new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText(maxUnComMsgText);
        gridData = new GridData(3);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        this.maxUncomMsg = new Spinner(parent, 2048);
        this.maxUncomMsg.setMinimum(1);
        this.maxUncomMsg.setMaximum(999999999);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.maxUncomMsg);
        this.maxUncomMsg.setSelection(10000);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.maxUncomMsg.setLayoutData((Object)gridData);
        pad = new Label(parent, 0);
        String platform = SWT.getPlatform();
        boolean bl = displayAppGroup = !"win32".equals(platform);
        if (displayAppGroup) {
            label = new Label(parent, 0);
            label.setText(appGroupText);
            gridData = new GridData(3);
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 3;
            label.setLayoutData((Object)gridData);
            this.appGroup = new Text(parent, 2048);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.appGroup.setLayoutData((Object)gridData);
            this.appGroup.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Trace t2 = Trace.getDefault();
                    CreateQmgrWizPage1.verifyAppGroup(t2, e);
                }
            });
        }
        UiUtils.createBlankLine((Composite)parent, (int)4);
        UiUtils.createBlankLine((Composite)parent, (int)4);
    }

    public void performHelp() {
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_Qmgrs_NEW_QMGR_1");
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean isEnableNext = false;
        boolean isEnableFinish = false;
        String name = this.qmgrName.getText();
        if (name.length() <= 0) {
            if (this.isFirstTimeRound) {
                this.isFirstTimeRound = false;
                this.setDescription(descriptionText);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(blankQmgrNameError);
            }
        } else if (!(this.qmValid && this.xmitqValid && this.dlqValid)) {
            Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
            String errMsg = msgFile.getMessage(t, "UI.GENERAL.NAME.INVALID.CHARS");
            this.setErrorMessage(errMsg);
        } else if (this.existingQueueManagers.contains(name)) {
            this.setErrorMessage(qmgrNameAlreadyUsedError);
        } else {
            isEnableNext = true;
            this.setErrorMessage(null);
        }
        if (isEnableNext) {
            isEnableFinish = this.wizard.isPortOk();
        }
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
        String name = this.qmgrName.getText();
        this.wizard.setQueueManagerName(name);
    }

    private static void verifyAppGroup(Trace t, VerifyEvent e) {
        String textString = e.text;
        char[] chars = new char[textString.length()];
        textString.getChars(0, chars.length, chars, 0);
        Text textControl = (Text)e.getSource();
        String text = textControl.getText();
        int overallLength = text.length() + chars.length;
        if (overallLength > 12) {
            e.doit = false;
            UiPlugin.getDisplay().beep();
        } else {
            int i = 0;
            while (i < chars.length) {
                char ch = chars[i];
                if (Character.isWhitespace(ch)) {
                    e.doit = false;
                    UiPlugin.getDisplay().beep();
                    break;
                }
                ++i;
            }
        }
    }

    public String getQueueManagerName() {
        return this.qmgrName.getText();
    }

    public boolean getDefaultQueueManager() {
        return this.defaultQmgrButton.getSelection();
    }

    public String getDefaultXmitQueue() {
        return this.defXmitQ.getText();
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue.getText();
    }

    public Integer getMaxHandleLimit() {
        Integer value = null;
        int selection = this.maxHandleLimit.getSelection();
        if (selection != 256) {
            value = selection;
        }
        return value;
    }

    public Integer getTriggerInterval() {
        Integer value = null;
        int selection = this.triggerInterval.getSelection();
        if (selection != 999999999) {
            value = selection;
        }
        return value;
    }

    public Integer getMaxUncomMsg() {
        Integer value = null;
        int selection = this.maxUncomMsg.getSelection();
        if (selection != 10000) {
            value = selection;
        }
        return value;
    }

    public String getAppGroup() {
        String string;
        String value = null;
        if (this.appGroup != null && (string = this.appGroup.getText()).length() > 0) {
            value = string;
        }
        return value;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.qmgrName.setFocus();
        }
    }

    public boolean performFinish() {
        return false;
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 5);
    }
}

