/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizCompletedEvent;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizDlg;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizPage1;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizPage2;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizPage3;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizPage4;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.CreateQmgrWizPage5;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.ICreateQmgrWizCompletedListener;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.ConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleDialog;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CreateQmgrWiz
extends Wizard
implements DmQueueManagerListener,
IConsoleDialogUser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/CreateQmgrWiz.java";
    private static final String WIN32 = "win32";
    private static String wizardName = null;
    private static String createTextDetail = null;
    private static String createTextGeneral = null;
    private static String startText = null;
    private static String configListenerText = null;
    private static String defineServerConnChannelText = null;
    private static String startListenerText = null;
    private static String endText = null;
    private static String UNEXPECTED_ERROR = "AMQ4082";
    private CreateQmgrWizPage1 page1 = null;
    private CreateQmgrWizPage2 page2 = null;
    private CreateQmgrWizPage3 page3 = null;
    private CreateQmgrWizPage4 page4 = null;
    private CreateQmgrWizPage5 page5 = null;
    private boolean enableFinish = false;
    private CreateQmgrWizDlg createQmgrWizDlg = null;
    private ConsoleDialog consoleDialog;
    private ArrayList<ConsoleCommand> commandList;
    private String qmgrName;
    private boolean autoReconnect = true;
    private int refreshInterval = 0;
    private DmQueueManager createdDmQueueManager = null;
    private Vector<ICreateQmgrWizCompletedListener> completeListeners = null;

    public CreateQmgrWiz() {
        Trace t = Trace.getDefault();
        if (wizardName == null) {
            Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Command Dialog");
            wizardName = msgFile.getMessage(t, "UI.QMGRS.Create.Wizard.Name");
            createTextDetail = msgFile.getMessage(t, "UI.QMGRS.CreateDetail.Text");
            createTextGeneral = msgFile.getMessage(t, "UI.QMGRS.CreateGeneral.Text");
            startText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.StartQmgrText");
            configListenerText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.ConfigListener");
            defineServerConnChannelText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.DefineChannel");
            startListenerText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.StartListener");
            endText = msgFile.getMessage(t, "UI.QMGR.Create.Wizard.EndQmgr");
        }
        this.page1 = new CreateQmgrWizPage1("Basic values");
        this.page2 = new CreateQmgrWizPage2("Log parameters");
        this.page3 = new CreateQmgrWizPage3("Startup options");
        this.page4 = new CreateQmgrWizPage4("Listener options");
        this.page5 = new CreateQmgrWizPage5("Explorer options");
        this.setWindowTitle(wizardName);
        this.completeListeners = new Vector();
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        this.commandList = new ArrayList();
        this.qmgrName = this.page1.getQueueManagerName();
        boolean startQmgr = this.page3.getStartQueueManage();
        boolean permitFailover = this.page3.getPermitFailover();
        boolean defineServerConnChannel = this.page3.defineServerConnChannel();
        boolean configureListener = this.page4.getConfigureListener();
        this.autoReconnect = this.page5.getAutoReconnect();
        this.refreshInterval = this.page5.getRefreshInterval();
        Shell shell = this.createQmgrWizDlg.getShell();
        Shell parentShell = shell.getParent().getShell();
        this.consoleDialog = new ConsoleDialog(t, parentShell, (IConsoleDialogUser)this);
        this.consoleDialog.setTitle(Message.format((String)createTextDetail, (String)this.qmgrName));
        this.consoleDialog.setHelp("com.ibm.mq.explorer.ui.infopop.UI_QmgrsCreateDialog");
        this.buildCreateCommand(t, this.qmgrName);
        if (startQmgr || defineServerConnChannel || configureListener) {
            this.buildConfigureCommands(t, this.qmgrName, startQmgr, defineServerConnChannel, configureListener, permitFailover);
        }
        UiPlugin.getTheDataModel().addObserver(t, (DmObjectListener)this, null);
        Display display = shell.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                CreateQmgrWiz.this.consoleDialog.execute(tr, CreateQmgrWiz.this.commandList);
            }
        });
        return true;
    }

    private void buildCreateCommand(Trace t, String qmName) {
        String crtmqmCommand = "crtmqm ";
        StringBuffer command = new StringBuffer();
        command.append(crtmqmCommand);
        this.addBasicArgsToCreateCommand(t, command);
        this.addLogArgsToCreateCommand(t, command);
        this.addRemainingArgsToCreateCommand(t, command);
        command.append(" ");
        command.append(qmName);
        ConsoleCommand c = new ConsoleCommand(createTextGeneral, command.toString());
        c.addExitValue(0);
        this.commandList.add(c);
    }

    private void addBasicArgsToCreateCommand(Trace t, StringBuffer command) {
        String autoconfigINIPath;
        String autoconfigMQSCPath;
        String dataPath;
        Integer maxHandleLimit;
        String defXmitQueue;
        String platform = SWT.getPlatform();
        if (WIN32.equals(platform)) {
            int QmgrStartup = this.page3.getQueueManagerStartup();
            if (QmgrStartup == 2) {
                command.append(" -ss ");
            } else if (QmgrStartup == 0) {
                command.append(" -si ");
            } else if (this.page3.getPermitFailover()) {
                command.append(" -sax ");
            } else {
                command.append(" -sa ");
            }
        }
        if ((defXmitQueue = this.page1.getDefaultXmitQueue()).length() > 0) {
            command.append(" -d ");
            command.append(defXmitQueue);
        }
        if ((maxHandleLimit = this.page1.getMaxHandleLimit()) != null) {
            command.append(" -h ");
            command.append(maxHandleLimit);
        }
        if ((dataPath = this.page2.getDataPath(t)) != null) {
            command.append(" -md \"");
            command.append(dataPath);
            command.append("\"");
        }
        if ((autoconfigMQSCPath = this.page3.getAutoConfigMQSCPath(t)) != null && !autoconfigMQSCPath.equals("")) {
            command.append(" -ic \"");
            command.append(autoconfigMQSCPath);
            command.append("\"");
        }
        if ((autoconfigINIPath = this.page3.getAutoConfigINIPath(t)) != null && !autoconfigINIPath.equals("")) {
            command.append(" -ii \"");
            command.append(autoconfigINIPath);
            command.append("\"");
        }
    }

    private void addLogArgsToCreateCommand(Trace t, StringBuffer command) {
        Integer logSecondaryFiles;
        Integer getLogPrimaryFiles;
        Integer logFileSize;
        String logPath;
        boolean useLinearLogging = this.page2.getUseLinearLogging(t);
        if (useLinearLogging) {
            if (this.page2.getUseAutoManagement(t)) {
                if (this.page2.getUseArchiveManagement(t)) {
                    command.append(" -lln");
                } else {
                    command.append(" -lla");
                }
            } else {
                command.append(" -ll");
            }
        }
        if ((logPath = this.page2.getLogPath(t)) != null) {
            command.append(" -ld \"");
            command.append(logPath);
            command.append("\"");
        }
        if ((logFileSize = this.page2.getLogFileSize(t)) != null) {
            command.append(" -lf ");
            command.append(logFileSize);
        }
        if ((getLogPrimaryFiles = this.page2.getLogPrimaryFiles(t)) != null) {
            command.append(" -lp ");
            command.append(getLogPrimaryFiles);
        }
        if ((logSecondaryFiles = this.page2.getLogSecondaryFiles(t)) != null) {
            command.append(" -ls ");
            command.append(logSecondaryFiles);
        }
    }

    private void addRemainingArgsToCreateCommand(Trace t, StringBuffer command) {
        Integer maxUncomMsg;
        String deadLetterQueue;
        Integer triggerInterval;
        String applicationGroup;
        boolean defaultQueueManager = this.page1.getDefaultQueueManager();
        if (defaultQueueManager) {
            command.append(" -q");
        }
        if ((applicationGroup = this.page1.getAppGroup()) != null) {
            command.append(" -g");
            command.append(applicationGroup);
        }
        if ((triggerInterval = this.page1.getTriggerInterval()) != null) {
            command.append(" -t ");
            command.append(triggerInterval);
        }
        if ((deadLetterQueue = this.page1.getDeadLetterQueue()).length() > 0) {
            command.append(" -u ");
            command.append(deadLetterQueue);
        }
        if ((maxUncomMsg = this.page1.getMaxUncomMsg()) != null) {
            command.append(" -x ");
            command.append(maxUncomMsg);
        }
    }

    private void buildConfigureCommands(Trace t, String qmName, boolean startQmgr, boolean defineServerConnChannel, boolean configureListener, boolean permitFailover) {
        StringBuffer command = new StringBuffer();
        StringBuffer input = new StringBuffer();
        int port = this.page4.getPort();
        command.setLength(0);
        command.append("strmqm ");
        if (permitFailover) {
            command.append(" -x ");
        }
        command.append(qmName);
        ConsoleCommand c = new ConsoleCommand(startText, command.toString());
        c.addExitValue(0);
        this.commandList.add(c);
        if (configureListener) {
            command.setLength(0);
            command.append("runmqsc ");
            command.append(qmName);
            input.setLength(0);
            input.append("DEFINE LISTENER('");
            input.append("LISTENER.TCP");
            input.append("') TRPTYPE(TCP) PORT(");
            input.append(port);
            input.append(") CONTROL(QMGR)");
            c = new ConsoleCommand(configListenerText, command.toString(), input.toString());
            c.addExitValue(0);
            this.commandList.add(c);
            if (startQmgr) {
                command.setLength(0);
                command.append("runmqsc ");
                command.append(qmName);
                input.setLength(0);
                input.append("START LISTENER('");
                input.append("LISTENER.TCP");
                input.append("')");
                c = new ConsoleCommand(startListenerText, command.toString(), input.toString());
                c.addExitValue(0);
                this.commandList.add(c);
            }
        }
        if (defineServerConnChannel) {
            command.setLength(0);
            command.append("runmqsc ");
            command.append(qmName);
            input.setLength(0);
            input.append("DEFINE CHANNEL('");
            input.append("SYSTEM.ADMIN.SVRCONN");
            input.append("') CHLTYPE(SVRCONN)");
            c = new ConsoleCommand(defineServerConnChannelText, command.toString(), input.toString());
            c.addExitValue(0);
            this.commandList.add(c);
        }
        if (!startQmgr) {
            command.setLength(0);
            command.append("endmqm ");
            command.append("-i ");
            command.append(qmName);
            c = new ConsoleCommand(endText, command.toString());
            c.addExitValue(0);
            this.commandList.add(c);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
        this.addPage((IWizardPage)this.page4);
        this.addPage((IWizardPage)this.page5);
        this.setNeedsProgressMonitor(true);
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void updateButtons() {
        if (this.createQmgrWizDlg == null) {
            this.createQmgrWizDlg = (CreateQmgrWizDlg)this.getContainer();
        }
        this.createQmgrWizDlg.updateButtons();
    }

    public void setQueueManagerName(String name) {
        this.page2.setQueueManagerName(name);
        this.page3.setQueueManagerName(name);
        this.page4.setQueueManagerName(name);
        this.page5.setQueueManagerName(name);
    }

    public boolean isPortOk() {
        return this.page4.isPortOk();
    }

    public void finished(Trace t, int id, boolean result) {
        UiPlugin.getTheDataModel().refreshDmMonitor(t);
        if (!result) {
            UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
            this.informCompletionListeners(t, false);
        } else {
            TreeNode node = UiPlugin.getUiMachineObject().getUiQmgrsObject().getTreeNode();
            UiPlugin.getMQNavigatorView().expandTreeNode(t, node);
        }
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        Object o = event.getSource();
        if (o instanceof DmQueueManager) {
            DmQueueManagerHandle handle;
            DmQueueManager qm = (DmQueueManager)o;
            String qmTitle = qm.getTitle();
            if (Trace.isTracing) {
                t.data(67, "CreateQmgrWiz.dmObjectAdded", 800, "qmgr added:" + this.qmgrName);
            }
            if (this.qmgrName.equals(qmTitle) && !(handle = qm.getConnectionHandle()).isClient(t)) {
                if (Trace.isTracing) {
                    t.data(67, "CreateQmgrWiz.dmObjectAdded", 800, "found qmgr");
                }
                Integer objAutoReconnect = 0;
                if (this.autoReconnect) {
                    objAutoReconnect = 1;
                }
                Object job = handle.beginUpdate(t);
                boolean result1 = true;
                boolean result2 = true;
                result1 = handle.setAttributeValue(t, job, 11012, 0, (Object)objAutoReconnect);
                result2 = handle.setAttributeValue(t, job, 11011, 0, (Object)this.refreshInterval);
                int result3 = handle.actionChange(t, null, job, false);
                if (!result1 || !result2 || result3 != 0) {
                    String text = "result1: " + result1 + ", result2: " + result2 + ", result3: " + result3;
                    t.FFST(67, "CreateQmgrWiz.dmObjectAdded", 1, 0, text);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Trace tr = Trace.getDefault();
                            MessageBox.showMessageFailure((Trace)tr, (Shell)UiPlugin.getShell(), (String)UNEXPECTED_ERROR);
                        }
                    });
                } else {
                    this.createdDmQueueManager = qm;
                }
                UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
                this.informCompletionListeners(t, true);
            }
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void addCompletionListener(Trace t, ICreateQmgrWizCompletedListener listener) {
        this.completeListeners.add(listener);
    }

    public void removeCompletionListener(Trace t, ICreateQmgrWizCompletedListener listener) {
        this.completeListeners.remove(listener);
    }

    protected void informCompletionListeners(Trace t, boolean success) {
        if (this.completeListeners.size() > 0) {
            CreateQmgrWizCompletedEvent event = new CreateQmgrWizCompletedEvent(t, success, this.createdDmQueueManager);
            Iterator<ICreateQmgrWizCompletedListener> iterator = this.completeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().changed(event);
            }
        }
    }
}

