/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizPgAbstract;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.IAddQmgrWizPageFinish;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLOptions;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.SSLPeerNameTextWrapper;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Hashtable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class AddQmgrWizPg7
extends AddQmgrWizPgAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/AddQmgrWizPg7.java";
    private SSLPeerNameTextWrapper textPeerName = null;
    private Spinner spinnerResetCount = null;
    private ExtCombo comboCipherSuites = null;
    private Button buttonEnable = null;
    private ConnectionDetailsSSLOptions sslOptionsComposite = null;
    private String savedPeerName = "";
    private String savedFIPSRequired = "";
    private boolean savedButtonEnable = false;
    private String savedCipherSuites = "";
    private String savedResetCount = "";

    public AddQmgrWizPg7(Trace t, String pageName) {
        super(t, pageName, "com.ibm.mq.explorer.ui.infopop.UI_QmgrsAddRemotePage7");
    }

    public void createPageContent(Trace t, Composite parent) {
        super.createPageContentHeader(t, parent);
        UiUtils.createBlankLine((Composite)parent, (int)4);
        this.sslOptionsComposite = new ConnectionDetailsSSLOptions(parent, 0, 4, false);
        this.textPeerName = this.sslOptionsComposite.getTextPeerName();
        this.comboCipherSuites = this.sslOptionsComposite.getComboCipherSuites();
        this.spinnerResetCount = this.sslOptionsComposite.getSpinnerResetCount();
        this.buttonEnable = this.sslOptionsComposite.getButtonEnable();
        this.buttonEnable.setText(msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg7.Enable"));
        this.loadCurrentSettings(t);
        this.titleText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg7.Title");
        this.descriptionText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg7.Desc");
        this.setHeadings(this.titleText, this.descriptionText);
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enable = true;
        if (this.sslOptionsComposite.getButtonEnable().getSelection() && this.sslOptionsComposite.getComboCipherSuites().getText().equals("")) {
            enable = false;
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(enable);
        this.wizard.updateButtons();
        this.saveSettings(t);
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.buttonEnable.setSelection(store.getBoolean("SSLOptionsEnabled"));
        this.textPeerName.setText(store.getString("SSLPeerName"));
        this.sslOptionsComposite.setFIPSRequired(t, store.getInt("SSLFIPSRequired"));
        this.sslOptionsComposite.setCipherSuite(t, store.getString("SSLCipherSuite"));
        this.spinnerResetCount.setSelection(store.getInt("SSLResetCount"));
        this.enableOptions(t);
        this.sslOptionsComposite.enableControls(t);
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg7.this.checkIfEnableButtons();
            }
        });
        this.comboCipherSuites.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg7.this.checkIfEnableButtons();
            }
        });
        this.saveSettings(t);
    }

    private void enableOptions(Trace t) {
        IAddQmgrWizPageFinish page = (IAddQmgrWizPageFinish)this.wizard.getPreviousPage((IWizardPage)this);
        if (page.isPagePropertiesEnabled(t)) {
            this.buttonEnable.setEnabled(true);
        } else {
            this.buttonEnable.setEnabled(false);
            this.buttonEnable.setSelection(false);
        }
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            this.textQmgrName.setText(this.wizard.getQueueManagerName());
            if (this.buttonEnable.getSelection()) {
                this.comboCipherSuites.setFocus();
            } else {
                this.buttonEnable.setFocus();
            }
            this.enableOptions(t);
            this.sslOptionsComposite.enableControls(t);
            this.sslOptionsComposite.setIsCCDTConnection(this.wizard.isUsingCCDT(t));
        }
    }

    @Override
    public Hashtable<String, Object> getSecurityOptions(Trace t) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (this.savedButtonEnable) {
            if (!this.savedPeerName.equals("")) {
                table.put("SSL Peer Name", this.savedPeerName);
            }
            if (!this.savedCipherSuites.equals("")) {
                table.put("SSL Cipher Suite", this.savedCipherSuites);
            }
            if (!this.savedFIPSRequired.equals("")) {
                table.put("SSL Fips Required", this.savedFIPSRequired);
            }
            if (!this.savedResetCount.equals("")) {
                table.put("KeyResetCount", this.savedResetCount);
            }
        }
        return table;
    }

    @Override
    public void saveSettings(Trace t) {
        if (this.textPeerName != null && !this.textPeerName.getWidget().isDisposed()) {
            this.savedPeerName = this.textPeerName.getText();
        }
        if (this.buttonEnable != null && !this.buttonEnable.isDisposed()) {
            this.savedButtonEnable = this.buttonEnable.getSelection();
        }
        this.savedFIPSRequired = String.valueOf(this.sslOptionsComposite.getFIPSRequired(t));
        if (this.comboCipherSuites != null && !this.comboCipherSuites.isDisposed()) {
            String s = this.sslOptionsComposite.getComboCipherSuites().getText();
            this.savedCipherSuites = (String)this.sslOptionsComposite.getComboCipherSuites().getData(s);
        }
        if (this.spinnerResetCount != null && !this.spinnerResetCount.isDisposed()) {
            int i = this.spinnerResetCount.getSelection();
            this.savedResetCount = Integer.toString(i);
        }
    }

    @Override
    public boolean isPagePropertiesEnabled(Trace t) {
        return this.savedButtonEnable;
    }
}

