/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizPgAbstract;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLStores;
import com.ibm.mq.explorer.ui.internal.dialogs.PasswordDialog;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Hashtable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class AddQmgrWizPg6
extends AddQmgrWizPgAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/AddQmgrWizPg6.java";
    private Text textTrustedStore = null;
    private Text textPersonalStore = null;
    private String savedTrustedPassword = "";
    private String savedPersonalPassword = "";
    private Button buttonEnable = null;
    private ConnectionDetailsSSLStores sslStoresComposite = null;
    private String savedTrustedStore = "";
    private String savedPersonalStore = "";
    private boolean savedButtonEnable = false;
    private Text textTrustedPassword = null;
    private Text textPersonalPassword = null;
    private Link[] linkPasswordWarnings = null;

    public AddQmgrWizPg6(Trace t, String pageName) {
        super(t, pageName, "com.ibm.mq.explorer.ui.infopop.UI_QmgrsAddRemotePage6");
    }

    public void createPageContent(Trace t, Composite parent) {
        super.createPageContentHeader(t, parent);
        UiUtils.createBlankLine((Composite)parent, (int)4);
        this.sslStoresComposite = new ConnectionDetailsSSLStores(parent, 0, 4);
        this.sslStoresComposite.setObjectId("com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw");
        this.sslStoresComposite.setPasswordValidation(false);
        this.textPersonalStore = this.sslStoresComposite.getTextPersonalStore();
        this.textTrustedStore = this.sslStoresComposite.getTextTrustedStore();
        this.buttonEnable = this.sslStoresComposite.getButtonEnable();
        this.buttonEnable.setText(msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg6.Enable"));
        this.textTrustedPassword = this.sslStoresComposite.getTextTrustedPassword();
        this.textPersonalPassword = this.sslStoresComposite.getTextPersonalPassword();
        this.loadCurrentSettings(t);
        this.titleText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg6.Title");
        this.descriptionText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg6.Desc");
        this.setHeadings(this.titleText, this.descriptionText);
        Link[] linkArray = this.linkPasswordWarnings = this.sslStoresComposite.getPasswordWarningLinks();
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link currentLink = linkArray[n2];
            currentLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PreferencePagePasswords.openPasswordPreferencePage(t2);
                    AddQmgrWizPg6.this.checkPasswordPreference(t2);
                }
            });
            ++n2;
        }
        this.checkPasswordPreference(t);
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textTrustedStore.setText(store.getString("TrustedStoreName"));
        this.textPersonalStore.setText(store.getString("PersonalStoreName"));
        this.buttonEnable.setSelection(store.getBoolean("SSLStoresEnabled"));
        IPwCredentials c = PwStoreManager.getStoreManager((Trace)t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.trusted.store.pw", this.textTrustedStore.getText());
        if (c != null) {
            this.textTrustedPassword.setText("********");
            this.sslStoresComposite.setTrustedStorePassword(c.getPassword());
        } else {
            this.textTrustedPassword.setText("");
        }
        c = PwStoreManager.getStoreManager((Trace)t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.personal.store.pw", this.textPersonalStore.getText());
        if (c != null) {
            this.textPersonalPassword.setText("********");
            this.sslStoresComposite.setPersonalStorePassword(c.getPassword());
        } else {
            this.textPersonalPassword.setText("");
        }
        this.sslStoresComposite.enableControls(t);
        this.addListeners(t);
        this.saveSettings(t);
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enable = true;
        if (this.sslStoresComposite.getButtonEnable().getSelection() && this.sslStoresComposite.getTextTrustedStore().getText().equals("")) {
            enable = false;
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(enable);
        this.wizard.updateButtons();
        this.saveSettings(t);
    }

    public IWizardPage getNextPage() {
        return this.wizard.getNextPage((IWizardPage)this);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            this.textQmgrName.setText(this.wizard.getQueueManagerName());
            if (this.buttonEnable.getSelection()) {
                this.textTrustedStore.setFocus();
            } else {
                this.buttonEnable.setFocus();
            }
        }
        this.checkPasswordPreference(t);
    }

    @Override
    public Hashtable<String, Object> getSecurityOptions(Trace t) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (this.savedButtonEnable) {
            if (this.savedTrustedStore != null && !this.savedTrustedStore.equals("")) {
                table.put("sslTrustedStore", this.savedTrustedStore);
                String tmpTrustedStorePasswrd = null;
                if (this.savedTrustedPassword != null && !this.savedTrustedPassword.equals("")) {
                    tmpTrustedStorePasswrd = this.savedTrustedPassword;
                    PwUtils.savePassword((Trace)t, (String)credentialsOwnerId, (String)"com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", (String)this.savedTrustedStore, (String)this.savedTrustedPassword);
                } else if (!PwStoreManager.isSavingPasswordsPreference()) {
                    tmpTrustedStorePasswrd = this.promptForPassword(t, this.savedTrustedStore);
                }
                if (tmpTrustedStorePasswrd != null) {
                    table.put("sslTrustedStorePw", tmpTrustedStorePasswrd);
                }
            }
            if (this.savedPersonalStore != null && !this.savedPersonalStore.equals("")) {
                table.put("sslPersonalStore", this.savedPersonalStore);
                String tmpPersonalStorePasswrd = null;
                if (this.savedPersonalPassword != null && !this.savedPersonalPassword.equals("")) {
                    tmpPersonalStorePasswrd = this.savedPersonalPassword;
                    PwUtils.savePassword((Trace)t, (String)credentialsOwnerId, (String)"com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", (String)this.savedPersonalStore, (String)this.savedPersonalPassword);
                } else if (!PwStoreManager.isSavingPasswordsPreference()) {
                    tmpPersonalStorePasswrd = this.promptForPassword(t, this.savedPersonalStore);
                }
                if (tmpPersonalStorePasswrd != null) {
                    table.put("sslPersonalStorePw", tmpPersonalStorePasswrd);
                }
            }
        }
        return table;
    }

    private String promptForPassword(Trace t, String storeName) {
        String tmpPassword = null;
        Message pwdMsgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Queue Manager");
        PasswordDialog dialog = new PasswordDialog(this.getShell());
        dialog.setTitle(pwdMsgFile.getMessage("Ui.Dialog.Passwords.Title"));
        dialog.setDescription(pwdMsgFile.getMessage("Ui.Dialog.Passwords.Enter.Password", storeName));
        dialog.create(t);
        if (dialog.open(t)) {
            tmpPassword = dialog.getPassword();
        }
        return tmpPassword;
    }

    @Override
    public void saveSettings(Trace t) {
        if (this.textPersonalStore != null && !this.textPersonalStore.isDisposed()) {
            this.savedPersonalStore = this.textPersonalStore.getText();
        }
        if (this.textTrustedStore != null && !this.textTrustedStore.isDisposed()) {
            this.savedTrustedStore = this.textTrustedStore.getText();
        }
        if (this.buttonEnable != null && !this.buttonEnable.isDisposed()) {
            this.savedButtonEnable = this.buttonEnable.getSelection();
        }
        if (this.sslStoresComposite != null && !this.sslStoresComposite.isDisposed()) {
            this.savedPersonalPassword = this.sslStoresComposite.getPersonalStorePassword();
            this.savedTrustedPassword = this.sslStoresComposite.getTrustedStorePassword();
        }
    }

    @Override
    public boolean isPagePropertiesEnabled(Trace t) {
        return this.savedButtonEnable;
    }

    private void addListeners(Trace t) {
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg6.this.checkIfEnableButtons();
                if (AddQmgrWizPg6.this.buttonEnable.getSelection()) {
                    AddQmgrWizPg6.this.textTrustedStore.setFocus();
                }
            }
        });
        this.textTrustedStore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                AddQmgrWizPg6.this.sslStoresComposite.setOwnerId(credentialsOwnerId);
                AddQmgrWizPg6.this.sslStoresComposite.checkForStorePassword(t2);
                AddQmgrWizPg6.this.checkIfEnableButtons();
            }
        });
        this.textPersonalStore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Trace t2 = Trace.getDefault();
                AddQmgrWizPg6.this.sslStoresComposite.setOwnerId(credentialsOwnerId);
                AddQmgrWizPg6.this.sslStoresComposite.checkForStorePassword(t2);
                AddQmgrWizPg6.this.checkIfEnableButtons();
            }
        });
        this.textPersonalPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AddQmgrWizPg6.this.checkIfEnableButtons();
            }
        });
    }

    private void checkPasswordPreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
        Link[] linkArray = this.linkPasswordWarnings;
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link curLink = linkArray[n2];
            curLink.setVisible(!passwordStoreEnabled);
            ++n2;
        }
        this.sslStoresComposite.setPasswordSaving(t, passwordStoreEnabled);
    }
}

