/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizPgAbstract;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsUserid;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Hashtable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class AddQmgrWizPg5
extends AddQmgrWizPgAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/AddQmgrWizPg5.java";
    private Text textUseridName = null;
    private Text textPassword = null;
    private Button buttonEnable = null;
    private Button buttonCompatMode = null;
    private ConnectionDetailsUserid useridComposite = null;
    private String savedPassword = null;
    private String savedUseridName = "";
    private boolean savedButtonEnable = false;
    private boolean savedButtonCompatMode = true;
    private int savedPasswordMode = -1;
    private Link linkPasswordWarning = null;
    private Button buttonNoPassword = null;
    private Button buttonPromptPassword = null;
    private Button buttonStoredPassword = null;

    public AddQmgrWizPg5(Trace t, String pageName) {
        super(t, pageName, "com.ibm.mq.explorer.ui.infopop.UI_QmgrsAddRemotePage5");
    }

    public void createPageContent(Trace t, Composite parent) {
        super.createPageContentHeader(t, parent);
        UiUtils.createBlankLine((Composite)parent, (int)4);
        this.useridComposite = new ConnectionDetailsUserid(parent, 0, 4, false);
        this.useridComposite.setPasswordValidation(false);
        this.textUseridName = this.useridComposite.getTextUseridName();
        this.textPassword = this.useridComposite.getTextPassword();
        this.buttonEnable = this.useridComposite.getButtonEnable();
        this.buttonCompatMode = this.useridComposite.getButtonCompatmode();
        this.buttonNoPassword = this.useridComposite.getButtonNoPassword();
        this.buttonPromptPassword = this.useridComposite.getButtonPromptPassword();
        this.buttonStoredPassword = this.useridComposite.getButtonStoredPassword();
        this.buttonEnable.setText(msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg5.Enable"));
        this.loadCurrentSettings(t);
        this.titleText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg5.Title");
        this.descriptionText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg5.Desc");
        this.setHeadings(this.titleText, this.descriptionText);
        this.linkPasswordWarning = this.useridComposite.getPasswordWarningLink();
        this.linkPasswordWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.openPasswordPreferencePage(t2);
                AddQmgrWizPg5.this.checkPasswordPreference(t2);
            }
        });
        this.checkPasswordPreference(t);
    }

    public IWizardPage getNextPage() {
        return this.wizard.getNextPage((IWizardPage)this);
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enable = true;
        this.setErrorMessage(null);
        if (this.useridComposite.getButtonEnable().getSelection() && this.useridComposite.getTextUseridName().getText().equals("")) {
            enable = false;
        }
        if (enable && this.useridComposite.getButtonEnable().getSelection() && this.useridComposite.getPasswordModeStateSelection() == 1) {
            String errMsg;
            if (this.wizard.isUsingMi(t)) {
                errMsg = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg5.Invalid.Mi.PasswordMode");
                enable = false;
                this.setErrorMessage(errMsg);
            }
            if (enable && this.wizard.getAutoReconnect(t)) {
                errMsg = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg5.Invalid.Reconnect.PasswordMode");
                enable = false;
                this.setErrorMessage(errMsg);
            }
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(enable);
        this.wizard.updateButtons();
        this.saveSettings(t);
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textUseridName.setText(store.getString("UseridName"));
        this.textPassword.setText(store.getString("UseridPassword"));
        this.buttonEnable.setSelection(store.getBoolean("UseridEnabled"));
        this.buttonCompatMode.setSelection(store.getBoolean("UseridCompatibilityMode"));
        this.useridComposite.setPasswordModeStateSelection(store.getInt("UseridPasswordMode"));
        IPwCredentials c = PwStoreManager.getStoreManager((Trace)t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.userid.pw", this.textUseridName.getText());
        if (c != null) {
            this.textPassword.setText("********");
            this.useridComposite.setPassword(c.getPassword());
        } else {
            this.textPassword.setText("");
        }
        this.useridComposite.enableControls(t);
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg5.this.checkIfEnableButtons();
                if (AddQmgrWizPg5.this.buttonEnable.getSelection()) {
                    AddQmgrWizPg5.this.textUseridName.setFocus();
                }
            }
        });
        this.buttonCompatMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg5.this.checkIfEnableButtons();
                if (AddQmgrWizPg5.this.buttonEnable.getSelection()) {
                    AddQmgrWizPg5.this.textUseridName.setFocus();
                }
            }
        });
        this.textUseridName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddQmgrWizPg5.this.checkIfEnableButtons();
            }
        });
        this.buttonNoPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg5.this.checkIfEnableButtons();
            }
        });
        this.buttonPromptPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg5.this.checkIfEnableButtons();
            }
        });
        this.buttonStoredPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg5.this.checkIfEnableButtons();
            }
        });
        this.saveSettings(t);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            this.textQmgrName.setText(this.wizard.getQueueManagerName());
            if (this.buttonEnable.getSelection()) {
                this.textUseridName.setFocus();
            } else {
                this.buttonEnable.setFocus();
            }
        }
        this.checkPasswordPreference(t);
    }

    @Override
    public Hashtable<String, Object> getSecurityOptions(Trace t) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("userIdState", String.valueOf(this.savedButtonEnable));
        if (this.savedButtonEnable) {
            table.put("Use MQCSP authentication", String.valueOf(!this.savedButtonCompatMode));
            table.put("passwordMode", String.valueOf(this.savedPasswordMode));
            table.put("userID", this.savedUseridName);
            if (this.savedPassword != null) {
                table.put("password", this.savedPassword);
                PwUtils.savePassword((Trace)t, (String)credentialsOwnerId, (String)"com.ibm.mq.explorer.addqm.conn.details.userid.pw", (String)this.savedUseridName, (String)this.savedPassword);
            }
        }
        return table;
    }

    @Override
    public void saveSettings(Trace t) {
        if (this.textUseridName != null && !this.textUseridName.isDisposed()) {
            this.savedUseridName = this.textUseridName.getText();
        }
        if (this.buttonCompatMode != null && !this.buttonCompatMode.isDisposed()) {
            this.savedButtonCompatMode = this.buttonCompatMode.getSelection();
        }
        if (this.buttonEnable != null && !this.buttonEnable.isDisposed()) {
            this.savedButtonEnable = this.buttonEnable.getSelection();
        }
        if (this.useridComposite != null && !this.useridComposite.isDisposed()) {
            this.savedPasswordMode = this.useridComposite.getPasswordModeStateSelection();
            if (this.savedButtonEnable) {
                this.setPasswordMode(this.savedPasswordMode);
            } else {
                this.setPasswordMode(-1);
            }
        }
        if (this.useridComposite != null && !this.useridComposite.isDisposed()) {
            this.savedPassword = this.useridComposite.getPassword();
        }
    }

    @Override
    public boolean isPagePropertiesEnabled(Trace t) {
        return this.savedButtonEnable;
    }

    private void checkPasswordPreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
        this.linkPasswordWarning.setVisible(!passwordStoreEnabled);
        this.useridComposite.setPasswordSaving(t, passwordStoreEnabled);
    }
}

