/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizPgAbstract;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSecurityExit;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AddQmgrWizPg4
extends AddQmgrWizPgAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/AddQmgrWizPg4.java";
    private Text textSecurityName = null;
    private Text textSecurityData = null;
    private Button buttonEnable = null;
    private ConnectionDetailsSecurityExit securityExitComposite = null;
    private Text textDirectoryName = null;
    private Text textJarFileName = null;
    private Button buttonDirectory = null;
    private Button buttonJarFile = null;
    private String savedSecurityName = "";
    private String savedSecurityData = "";
    private boolean savedButtonEnable = false;
    private String savedDirectoryName = "";
    private String savedJarFileName = "";
    private boolean savedButtonDirectory = false;

    public AddQmgrWizPg4(Trace t, String pageName) {
        super(t, pageName, "com.ibm.mq.explorer.ui.infopop.UI_QmgrsAddRemotePage4");
    }

    public void createPageContent(Trace t, Composite parent) {
        super.createPageContentHeader(t, parent);
        UiUtils.createBlankLine((Composite)parent, (int)4);
        this.securityExitComposite = new ConnectionDetailsSecurityExit(parent, 0, 4);
        this.textSecurityName = this.securityExitComposite.getTextSecurityName();
        this.textSecurityData = this.securityExitComposite.getTextSecurityData();
        this.buttonEnable = this.securityExitComposite.getButtonEnable();
        this.textDirectoryName = this.securityExitComposite.getTextDirectoryName();
        this.textJarFileName = this.securityExitComposite.getTextJarFileName();
        this.buttonDirectory = this.securityExitComposite.getButtonDirectory();
        this.buttonJarFile = this.securityExitComposite.getButtonJarFile();
        this.buttonEnable.setText(msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg4.Enable"));
        this.loadCurrentSettings(t);
        this.titleText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg4.Title");
        this.descriptionText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg4.Desc");
        this.setHeadings(this.titleText, this.descriptionText);
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean enable = true;
        if (this.securityExitComposite.getButtonEnable().getSelection()) {
            if (this.securityExitComposite.getTextSecurityName().getText().equals("")) {
                enable = false;
            } else if (this.securityExitComposite.getButtonDirectory().getSelection() && this.securityExitComposite.getTextDirectoryName().getText().equals("")) {
                enable = false;
            } else if (this.securityExitComposite.getButtonJarFile().getSelection() && this.securityExitComposite.getTextJarFileName().getText().equals("")) {
                enable = false;
            }
        }
        this.setPageComplete(enable);
        this.wizard.setEnableFinish(enable);
        this.wizard.updateButtons();
        this.saveSettings(t);
    }

    public IWizardPage getNextPage() {
        return this.wizard.getNextPage((IWizardPage)this);
    }

    private void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textSecurityName.setText(store.getString("SecurityExitName"));
        this.textSecurityData.setText(store.getString("SecurityExitData"));
        this.buttonEnable.setSelection(store.getBoolean("SecurityExitEnabled"));
        this.textDirectoryName.setText(store.getString("SecurityExitDirName"));
        this.textJarFileName.setText(store.getString("SecurityExitJarName"));
        this.buttonDirectory.setSelection(store.getBoolean("SecurityExitDirEnabled"));
        this.buttonJarFile.setSelection(store.getBoolean("SecurityExitJarEnabled"));
        this.securityExitComposite.enableControls(t);
        this.addListeners(t);
        this.saveSettings(t);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.textQmgrName.setText(this.wizard.getQueueManagerName());
            if (this.buttonEnable.getSelection()) {
                this.textSecurityName.setFocus();
            } else {
                this.buttonEnable.setFocus();
            }
        }
    }

    @Override
    public Hashtable<String, Object> getSecurityOptions(Trace t) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (this.savedButtonEnable) {
            table.put("channelSecurityExit", this.savedSecurityName);
            if (!this.savedSecurityData.equals("")) {
                table.put("channelSecurityExitUserData", this.savedSecurityData);
            }
            if (this.savedButtonDirectory) {
                if (!this.savedDirectoryName.endsWith(File.separator)) {
                    this.savedDirectoryName = String.valueOf(this.savedDirectoryName) + File.separator;
                }
                table.put("exitClasspath", this.savedDirectoryName);
            } else {
                table.put("exitClasspath", this.savedJarFileName);
            }
        }
        return table;
    }

    @Override
    public void saveSettings(Trace t) {
        if (this.textSecurityName != null && !this.textSecurityName.isDisposed()) {
            this.savedSecurityName = this.textSecurityName.getText();
        }
        if (this.textSecurityData != null && !this.textSecurityData.isDisposed()) {
            this.savedSecurityData = this.textSecurityData.getText();
        }
        if (this.buttonEnable != null && !this.buttonEnable.isDisposed()) {
            this.savedButtonEnable = this.buttonEnable.getSelection();
        }
        if (this.textDirectoryName != null && !this.textDirectoryName.isDisposed()) {
            this.savedDirectoryName = this.textDirectoryName.getText();
        }
        if (this.textJarFileName != null && !this.textJarFileName.isDisposed()) {
            this.savedJarFileName = this.textJarFileName.getText();
        }
        if (this.buttonDirectory != null && !this.buttonDirectory.isDisposed()) {
            this.savedButtonDirectory = this.buttonDirectory.getSelection();
        }
    }

    @Override
    public boolean isPagePropertiesEnabled(Trace t) {
        return this.savedButtonEnable;
    }

    private void addListeners(Trace t) {
        this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg4.this.checkIfEnableButtons();
                if (AddQmgrWizPg4.this.buttonEnable.getSelection()) {
                    AddQmgrWizPg4.this.textSecurityName.setFocus();
                }
            }
        });
        this.textSecurityName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddQmgrWizPg4.this.checkIfEnableButtons();
            }
        });
        this.buttonDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg4.this.checkIfEnableButtons();
                if (AddQmgrWizPg4.this.buttonDirectory.getSelection()) {
                    AddQmgrWizPg4.this.textDirectoryName.setFocus();
                }
            }
        });
        this.buttonJarFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg4.this.checkIfEnableButtons();
                if (AddQmgrWizPg4.this.buttonJarFile.getSelection()) {
                    AddQmgrWizPg4.this.textJarFileName.setFocus();
                }
            }
        });
        this.textDirectoryName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AddQmgrWizPg4.this.checkIfEnableButtons();
            }
        });
        this.textJarFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AddQmgrWizPg4.this.checkIfEnableButtons();
            }
        });
    }
}

