/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.utils.ChannelTable;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizPgAbstract;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AddQmgrWizPg2ccdt
extends AddQmgrWizPgAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/AddQmgrWizPg2ccdt.java";
    private static final int WRAP_HINT = 300;
    private static final int NUMBER_OF_COLUMNS = 4;
    public static final String DEFAULT_CHANNEL_TABLE_NAME = "amqclchl.tab";
    private Label labelRefreshInterval = null;
    private boolean autoRefreshRequired = true;
    private Label labelChannelTable = null;
    private Text textChannelTable = null;
    private String strChannelTablePath = null;
    private String strChannelTableName = null;
    private String strSystemDrive = null;
    private Button buttonBrowse = null;
    private boolean isFileExists = false;
    private boolean isFileReadable = false;
    private boolean isFirstTime = true;
    private String strClientTableFilename = "";
    private static String textInfoText = null;
    private static String labelChannelTableText = null;
    private static String buttonBrowseText = null;
    private static String labelRefreshIntervalText = null;
    private static String checkboxAutoReconnectText = null;
    private static String checkboxAutoRefreshText = null;

    public AddQmgrWizPg2ccdt(Trace t, String pageName) {
        super(t, pageName, "com.ibm.mq.explorer.ui.infopop.UI_QmgrsAddRemotePage2ccdt");
        this.setHeadingsInfo(t);
    }

    private void setHeadingsInfo(Trace t) {
        if (msgFile != null) {
            this.titleText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg2.Title");
            this.descriptionText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg2.Desc");
            textInfoText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg2.Info.Text");
            labelChannelTableText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg2.Channel.Tabel.Label");
            buttonBrowseText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Pg2.Browse.Button");
            labelRefreshIntervalText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Refresh.Interval.Label");
            checkboxAutoRefreshText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Auto.Refresh.Checkbox");
            checkboxAutoReconnectText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Auto.Reconnect.Checkbox");
        }
        super.setHeadings(this.titleText, this.descriptionText);
    }

    public void createPageContent(Trace t, Composite parent) {
        super.createPageContentHeader(t, parent);
        UiUtils.createBlankLine((Composite)parent, (int)4);
        Group groupQm1 = new Group(parent, 0);
        groupQm1.setText(msgFile.getMessage("UI.QMGRS.AddQM.Pg2.Mi.Instance1"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        groupQm1.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        groupQm1.setLayout((Layout)gridLayout);
        Text text = new Text((Composite)groupQm1, 74);
        text.setText(textInfoText);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 2;
        Point ptLabel = text.computeSize(300, -1);
        gridData.widthHint = ptLabel.x;
        gridData.heightHint = ptLabel.y;
        text.setLayoutData((Object)gridData);
        UiUtils.createBlankLine((Composite)groupQm1, (int)4);
        this.labelChannelTable = new Label((Composite)groupQm1, 0);
        this.labelChannelTable.setText(labelChannelTableText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.labelChannelTable.setLayoutData((Object)gridData);
        Composite comp = new Composite((Composite)groupQm1, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        comp.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        comp.setLayoutData((Object)gridData);
        this.textChannelTable = new Text(comp, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.textChannelTable.setLayoutData((Object)gridData);
        this.strSystemDrive = System.getenv("SystemDrive");
        this.strChannelTablePath = System.getenv("MQCHLLIB");
        this.strChannelTableName = System.getenv("MQCHLTAB");
        if (this.strChannelTableName == null || this.strChannelTableName.equals("")) {
            this.strChannelTableName = DEFAULT_CHANNEL_TABLE_NAME;
        }
        if (this.strChannelTablePath == null || this.strChannelTablePath.equals("")) {
            try {
                if (CommonServices.isExtendedCommonServicesAvailable) {
                    this.strChannelTablePath = QueryValue.queryGeneralDataLib((Trace)t);
                }
            }
            catch (CommonServicesException commonServicesException) {
                this.strChannelTablePath = "";
            }
        }
        if (this.strChannelTablePath == null || this.strChannelTablePath.equals("")) {
            if (CommonServices.PLATFORM_ID == 1) {
                if (this.strSystemDrive == null || this.strSystemDrive.equals("")) {
                    this.strSystemDrive = "C:";
                }
                this.strChannelTablePath = String.valueOf(this.strSystemDrive) + "\\mqm\\";
            } else {
                this.strChannelTablePath = "/var/mqm/";
            }
        }
        if (!this.strChannelTablePath.endsWith(File.separator)) {
            this.strChannelTablePath = this.strChannelTablePath.concat(File.separator);
        }
        this.textChannelTable.setText(String.valueOf(this.strChannelTablePath) + this.strChannelTableName);
        this.textChannelTable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                AddQmgrWizPg2ccdt.this.textChannelTableModified(t2);
            }
        });
        this.buttonBrowse = new Button(comp, 8);
        this.buttonBrowse.setText(buttonBrowseText);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonBrowse.setLayoutData((Object)gridData);
        this.buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                AddQmgrWizPg2ccdt.this.browse(t2);
            }
        });
        UiUtils.createBlankLine((Composite)parent, (int)4);
        this.checkboxAutoReconnect = new Button(parent, 32);
        this.checkboxAutoReconnect.setText(checkboxAutoReconnectText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.checkboxAutoReconnect.setLayoutData((Object)gridData);
        this.checkboxAutoRefresh = new Button(parent, 32);
        this.checkboxAutoRefresh.setText(checkboxAutoRefreshText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.checkboxAutoRefresh.setLayoutData((Object)gridData);
        this.checkboxAutoRefresh.setSelection(this.autoRefreshRequired);
        this.checkboxAutoRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQmgrWizPg2ccdt.this.autoRefreshSelected();
            }
        });
        this.labelRefreshInterval = new Label(parent, 0);
        this.labelRefreshInterval.setText(labelRefreshIntervalText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.labelRefreshInterval.setLayoutData((Object)gridData);
        this.spinRefreshRate = new Spinner(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.spinRefreshRate.setLayoutData((Object)gridData);
        this.spinRefreshRate.setMaximum(UiPlugin.getRemoteRefreshRateMaxValue((Trace)t));
        this.spinRefreshRate.setMinimum(UiPlugin.getRemoteRefreshRateMinValue((Trace)t));
        UiUtils.limitSpinner((Trace)t, (Spinner)this.spinRefreshRate);
        this.spinRefreshRate.setSelection(UiPlugin.getRemoteDefaultRefreshRate());
        this.autoRefreshSelected();
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            this.textQmgrName.setText(this.wizard.getQueueManagerName());
            this.textChannelTable.setFocus();
            this.textChannelTableModified(t);
        }
    }

    protected void textChannelTableModified(Trace t) {
        this.strClientTableFilename = this.textChannelTable.getText();
        File file = new File(this.strClientTableFilename);
        this.isFileExists = true;
        this.isFileReadable = true;
        if (!file.isFile()) {
            this.setErrorMessage(msgFile.getMessage(t, "UI.QMGRS.AddQM.Error.DoesNotExist", this.strClientTableFilename));
            this.isFileExists = false;
            this.isFileReadable = false;
        } else if (!file.canRead()) {
            this.setErrorMessage(msgFile.getMessage(t, "UI.QMGRS.AddQM.Error.CanNotRead", this.strClientTableFilename));
            this.isFileReadable = false;
        } else {
            this.setErrorMessage(null);
        }
        this.checkIfEnableButtons();
    }

    protected void browse(Trace t) {
        String strFilename;
        FileDialog fileDialog = new FileDialog(this.buttonBrowse.getShell(), 4096);
        if (this.isFirstTime) {
            fileDialog.setFilterPath(this.strChannelTablePath);
            fileDialog.setFileName(this.strChannelTableName);
            this.isFirstTime = false;
        }
        if ((strFilename = fileDialog.open()) != null) {
            this.strClientTableFilename = strFilename;
            this.textChannelTable.setText(this.strClientTableFilename);
            this.textChannelTableModified(t);
        } else {
            this.isFirstTime = true;
        }
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        this.checkButtonsPanel2(t);
    }

    protected void checkButtonsPanel2(Trace t) {
        boolean isEnableFinish = this.isFileExists && this.isFileReadable;
        this.setPageComplete(isEnableFinish);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }

    private void autoRefreshSelected() {
        this.autoRefreshRequired = this.checkboxAutoRefresh.getSelection();
        this.labelRefreshInterval.setEnabled(this.autoRefreshRequired);
        this.spinRefreshRate.setEnabled(this.autoRefreshRequired);
    }

    public IWizardPage getNextPage() {
        IWizardPage page = null;
        page = this.wizard.getPage6();
        return page;
    }

    public Text getTextChannelTable() {
        return this.textChannelTable;
    }

    @Override
    public void nextPressed() {
        Trace t = Trace.getDefault();
        this.saveSettings(t);
    }

    @Override
    public void saveSettings(Trace t) {
        try {
            ChannelTable channelTable = new ChannelTable(t, this.textChannelTable.getText());
            credentialsOwnerId = String.valueOf(this.textQmgrName.getText()) + "/" + channelTable.getURL(t);
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)this.wizard.getShell(), (DmCoreException)e);
        }
        this.setAutoReconnect(t);
        this.setRefreshInterval(t);
    }
}

