/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.ChannelTable;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizPgAbstract;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.IAddQmgrWizActions;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddQmgrWizActions
implements IAddQmgrWizActions,
DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/qmgrs/AddQmgrWizActions.java";
    private static final String CANT_CONNECT_TO_SPECIFIED_QM = "AMQ4027";
    private static final String CANT_CONNECT_TO_CHANNEL_TABLE_QM = "AMQ4103";
    private static final String CHANNEL_TABLE_INVALID_FORMAT = "AMQ4104";
    private static final String CANT_CONNECT_USING_VIA_QM = "AMQ4145";
    private static final String CMD_LEVEL_TOO_LOW_FOR_VIA_QM = "AMQ4403";
    private AddQmgrWiz wizard = null;
    private static String busyText = null;
    private static Message msgFile = null;
    private String connectErrorMessage = "AMQ4027";
    private String ffstErrorMessage = "";
    private DmObjectEvent addedQmgrEvent = null;
    private DmQueueManager addedDmQueueManager = null;
    private BusyDialog busyDialog = null;

    public AddQmgrWizActions(Trace t, AddQmgrWiz wiz) {
        this.wizard = wiz;
        if (msgFile == null) {
            msgFile = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
            busyText = msgFile.getMessage(t, "UI.QMGRS.AddQM.Busy.Text");
        }
    }

    @Override
    public boolean connect(Trace t) {
        boolean keepQueueManager = false;
        keepQueueManager = this.wizard.isUsingCCDT(t) ? this.connectUsingCCDT(t) : (this.wizard.isUsingVia(t) ? this.connectVia(t) : (this.wizard.isUsingMi(t) ? this.connectWithInstances(t) : this.connectDirect(t)));
        if (keepQueueManager) {
            TreeNode node = UiPlugin.getUiMachineObject().getUiQmgrsObject().getTreeNode();
            UiPlugin.getMQNavigatorView().expandTreeNode(t, node);
        }
        return keepQueueManager;
    }

    public boolean connectUsingCCDT(Trace t) {
        boolean keepQueueManager = false;
        int rc = 0;
        ChannelTable channelTable = null;
        if (Trace.isTracing) {
            t.data(67, "AddQmgrWizActions.connectUsingCCDT", 800, "User entered info - Queue Manager: " + this.wizard.getQueueManagerName() + ", Client channel table file name: " + this.wizard.getClientTableFilename(t) + ", Refresh Interval: " + this.wizard.getRefreshInterval(t));
        }
        UiPlugin.showBusyCursor((Trace)t, (Shell)this.wizard.getShell(), (boolean)true);
        try {
            channelTable = new ChannelTable(t, this.wizard.getClientTableFilename(t));
            rc = channelTable.load(t);
            UiPlugin.showBusyCursor((Trace)t, (Shell)this.wizard.getShell(), (boolean)false);
            if (rc == 0) {
                URL channelTableURL = channelTable.getURL(t);
                UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, this.wizard.getQueueManagerName(), channelTableURL, this.getAllSecurityOptions(t), this.wizard.getRefreshInterval(t), this.wizard.getAutoReconnect(t), true, (DmQueueManagerListener)this.wizard.getAction());
                this.showBusyDialog(t, busyText);
                this.ffstErrorMessage = this.wizard.getClientTableFilename(t);
                this.connectErrorMessage = CANT_CONNECT_TO_CHANNEL_TABLE_QM;
                keepQueueManager = this.processResponse(t);
            } else {
                MessageBox.showMessageFailure((Trace)t, (Shell)this.wizard.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)CHANNEL_TABLE_INVALID_FORMAT, (String)this.wizard.getClientTableFilename(t)), (String)CHANNEL_TABLE_INVALID_FORMAT);
            }
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)this.wizard.getShell(), (DmCoreException)e);
            UiPlugin.showBusyCursor((Trace)t, (Shell)this.wizard.getShell(), (boolean)false);
        }
        return keepQueueManager;
    }

    public boolean connectDirect(Trace t) {
        boolean keepQueueManager = false;
        boolean connect = true;
        this.ffstErrorMessage = "";
        Hashtable<String, Object> secOptions = this.getAllSecurityOptions(t);
        if (this.isUseridPasswordPromptRequired(secOptions)) {
            String UserId = (String)secOptions.get("userID");
            String password = PwUtils.promptUseridPassword((String)this.wizard.getQueueManagerName(), (String)UserId);
            if (password != null) {
                secOptions.put("password", password);
            } else {
                connect = false;
            }
        }
        if (connect) {
            UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, this.wizard.getQueueManagerName(), this.wizard.getConnName(t)[0], this.wizard.getChannelName(t), secOptions, this.wizard.getRefreshInterval(t), this.wizard.getAutoReconnect(t), true, (DmQueueManagerListener)this.wizard.getAction());
            this.showBusyDialog(t, busyText);
            keepQueueManager = this.processResponse(t);
        }
        return keepQueueManager;
    }

    private boolean isUseridPasswordPromptRequired(Hashtable<String, Object> secOptions) {
        int passwordMode;
        boolean useridState;
        boolean prompt = false;
        String value = (String)secOptions.get("userIdState");
        if (value != null && (useridState = Boolean.valueOf(value).booleanValue()) && (value = (String)secOptions.get("passwordMode")) != null && (passwordMode = Integer.valueOf(value).intValue()) == 1) {
            prompt = true;
        }
        return prompt;
    }

    public boolean processResponse(Trace t) {
        boolean keepQueueManager = false;
        UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
        if (this.addedQmgrEvent != null) {
            DmCoreException exception = this.addedQmgrEvent.getException();
            if (exception != null) {
                MessageBox.showExceptionMessage((Trace)t, (Shell)this.wizard.getShell(), (DmCoreException)exception);
                if (exception.getReasonCode() != 10042) {
                    DmQueueManager queueManager = (DmQueueManager)this.addedQmgrEvent.getSource();
                    String displayedName = queueManager.getTreeName(t);
                    int response = MessageBox.showYesNoMessage((Trace)t, (Shell)this.wizard.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)this.connectErrorMessage, (String)displayedName), (int)1, (String)this.connectErrorMessage);
                    keepQueueManager = response == 0;
                } else {
                    keepQueueManager = false;
                }
            } else {
                keepQueueManager = true;
            }
            DmQueueManager dmQueueManagerObject = (DmQueueManager)this.addedQmgrEvent.getSource();
            if (keepQueueManager) {
                DmQueueManagerHandle dmQueueManagerHandleObject = dmQueueManagerObject.getConnectionHandle();
                if (exception != null && dmQueueManagerHandleObject.isPromptPassword()) {
                    dmQueueManagerHandleObject.deletePassword();
                }
                this.wizard.setAddedDmQueueManagerHandle(dmQueueManagerHandleObject);
                dmQueueManagerObject.notifyListeners(t);
            } else {
                this.wizard.setAddedDmQueueManagerHandle(null);
                dmQueueManagerObject.close(t);
            }
        } else if (Trace.isTracing) {
            t.data(67, "AddQmgrWizActions.processResponse", 900, "Null event from the data model for " + this.wizard.getQueueManagerName() + ", " + this.ffstErrorMessage);
        }
        return keepQueueManager;
    }

    public boolean connectVia(Trace t) {
        boolean keepQueueManager = false;
        DmQueueManager dmQueueManager = this.wizard.getViaQueueManager(t);
        UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, dmQueueManager, "SYSTEM.ADMIN.COMMAND.QUEUE", this.wizard.getQueueManagerName(), this.wizard.getRefreshInterval(t), this.wizard.getAutoReconnect(t), true, (DmQueueManagerListener)this.wizard.getAction());
        this.showBusyDialog(t, busyText);
        UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)((DmQueueManagerListener)this.wizard.getAction()));
        if (this.addedQmgrEvent != null) {
            DmCoreException exception = this.addedQmgrEvent.getException();
            if (exception != null) {
                int response;
                MessageBox.showExceptionMessage((Trace)t, (Shell)this.wizard.getShell(), (DmCoreException)exception);
                keepQueueManager = exception.getReasonCode() != 10042 ? (response = MessageBox.showYesNoMessage((Trace)t, (Shell)this.wizard.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)CANT_CONNECT_USING_VIA_QM), (int)1, (String)CANT_CONNECT_USING_VIA_QM)) == 0 : false;
            } else {
                int response;
                DmQueueManager dmConnectedQueueManagerObject = (DmQueueManager)this.addedQmgrEvent.getSource();
                int cmdLevelConnectedQM = dmConnectedQueueManagerObject.getCommandLevel();
                int cmdLevelViaQM = dmQueueManager.getCommandLevel();
                keepQueueManager = cmdLevelViaQM < cmdLevelConnectedQM ? (response = MessageBox.showYesNoMessage((Trace)t, (Shell)this.wizard.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)CMD_LEVEL_TOO_LOW_FOR_VIA_QM), (int)1, (String)CMD_LEVEL_TOO_LOW_FOR_VIA_QM)) == 0 : true;
            }
            DmQueueManager dmQueueManagerObject = (DmQueueManager)this.addedQmgrEvent.getSource();
            if (keepQueueManager) {
                DmQueueManagerHandle dmQueueManagerHandleObject = dmQueueManagerObject.getConnectionHandle();
                this.wizard.setAddedDmQueueManagerHandle(dmQueueManagerHandleObject);
                dmQueueManagerObject.notifyListeners(t);
            } else {
                this.wizard.setAddedDmQueueManagerHandle(null);
                dmQueueManagerObject.close(t);
            }
        } else {
            t.FFST(67, "AddQmgrWizActions.connectVia", 1, 50020, 0, 0, "Null event from the data model", this.wizard.getQueueManagerName(), dmQueueManager.getTreeName(t));
        }
        return keepQueueManager;
    }

    public boolean connectWithInstances(Trace t) {
        boolean keepQueueManager = false;
        UiPlugin.getTheDataModel().addQueueManagerAndObserver(t, this.getWizard().getQueueManagerName(), this.getWizard().getConnName(t), this.getWizard().getChannelName(t), this.getAllSecurityOptions(t), this.getWizard().getRefreshInterval(t), this.getWizard().getAutoReconnect(t), true, (DmQueueManagerListener)this.getWizard().getAction());
        this.showBusyDialog(t, null);
        keepQueueManager = this.processResponse(t);
        return keepQueueManager;
    }

    public void showBusyDialog(Trace t, String msg) {
        this.busyDialog = msg == null || msg.equals("") ? new BusyDialog(this.wizard.getShell(), busyText) : new BusyDialog(this.wizard.getShell(), msg);
        this.busyDialog.showDialog(t);
    }

    @Override
    public DmQueueManager getAddedQueueManager() {
        return this.addedDmQueueManager;
    }

    public DmObjectEvent getAddedQmgrEvent() {
        return this.addedQmgrEvent;
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        this.addedQmgrEvent = event;
        if (event.getException() == null && event.getSource() instanceof DmQueueManager) {
            this.addedDmQueueManager = (DmQueueManager)event.getSource();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                AddQmgrWizActions.this.busyDialog.closeDialog(tr);
            }
        });
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        this.addedQmgrEvent = event;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                AddQmgrWizActions.this.busyDialog.closeDialog(tr);
            }
        });
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public Hashtable<String, Object> getAllSecurityOptions(Trace t) {
        Hashtable<String, Object> tempTable = new Hashtable();
        Hashtable<String, Object> allTable = new Hashtable<String, Object>();
        int i = 0;
        while (i < AddQmgrWizPgAbstract.getListOfPages().size()) {
            AddQmgrWizPgAbstract page1 = AddQmgrWizPgAbstract.getListOfPages().get(i);
            tempTable = page1.getSecurityOptions(t);
            allTable = this.mergeTables(t, allTable, tempTable);
            ++i;
        }
        return allTable;
    }

    private Hashtable<String, Object> mergeTables(Trace t, Hashtable<String, Object> table1, Hashtable<String, Object> table2) {
        Enumeration<String> e = table2.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = (String)table2.get(key);
            table1.put(key, value);
        }
        return table1;
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public AddQmgrWiz getWizard() {
        return this.wizard;
    }
}

