/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultCredentials;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsUserid;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.preferences.PreferencePageAbstract;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PreferencePageUserid
extends PreferencePageAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/preferences/PreferencePageUserid.java";
    private Text textUseridName = null;
    private Text textPassword = null;
    private Button buttonEnable = null;
    private Button buttonCompatMode = null;
    private ConnectionDetailsUserid useridComposite = null;
    private String password = "";
    private Link linkPasswordWarning = null;

    protected Control createContents(Composite parent) {
        this.useridComposite = new ConnectionDetailsUserid(parent, 0, 1, true);
        UiPlugin.getHelpSystem().setHelp((Control)this.useridComposite, "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageConnDetails");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageConnDetailsUserid");
        this.textUseridName = this.useridComposite.getTextUseridName();
        this.textPassword = this.useridComposite.getTextPassword();
        this.buttonEnable = this.useridComposite.getButtonEnable();
        this.buttonCompatMode = this.useridComposite.getButtonCompatmode();
        this.useridComposite.pack();
        this.linkPasswordWarning = this.useridComposite.getPasswordWarningLink();
        this.linkPasswordWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.openPasswordPreferencePage(t2);
            }
        });
        return this.useridComposite;
    }

    protected void loadCurrentSettings(Trace t) {
        IPreferenceStore store = this.getPreferenceStore();
        this.textUseridName.setText(store.getString("UseridName"));
        this.buttonEnable.setSelection(store.getBoolean("UseridEnabled"));
        this.buttonCompatMode.setSelection(store.getBoolean("UseridCompatibilityMode"));
        this.useridComposite.setPasswordModeStateSelection(store.getInt("UseridPasswordMode"));
        IPwCredentials c = PwStoreManager.getStoreManager((Trace)t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.userid.pw", this.textUseridName.getText());
        if (c != null) {
            this.textPassword.setText("********");
            this.useridComposite.setPassword(c.getPassword());
        } else {
            this.textPassword.setText("");
        }
        this.isCurrentSettingsLoaded = true;
        if (Trace.isTracing) {
            t.data(67, "PreferencePageUserid.loadCurrentSettings", 300, "Loaded current userid details" + Common.NEW_LINE + "name = " + this.textUseridName.getText() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.useridComposite.enableControls(t);
    }

    protected void performDefaults() {
        Trace t = Trace.getDefault();
        IPreferenceStore store = this.getPreferenceStore();
        this.textUseridName.setText(store.getDefaultString("UseridName"));
        this.textPassword.setText(store.getDefaultString("UseridPassword"));
        this.buttonEnable.setSelection(store.getDefaultBoolean("UseridEnabled"));
        this.buttonCompatMode.setSelection(store.getDefaultBoolean("UseridCompatibilityMode"));
        this.useridComposite.setPasswordModeStateSelection(store.getDefaultInt("UseridPasswordMode"));
        this.applyPreferencesToHandle();
        if (Trace.isTracing) {
            t.data(67, "PreferencePageUserid.performDefaults", 300, "Loaded default userid details" + Common.NEW_LINE + "name = " + this.textUseridName.getText() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.useridComposite.enableControls(t);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceNode pref;
        Trace t = Trace.getDefault();
        if (PreferencePagePasswords.savePasswordPreferences && (pref = PlatformUI.getWorkbench().getPreferenceManager().find("com.ibm.mq.explorer.prefmain/com.ibm.mq.explorer.pref.passwords")) != null && pref.getPage() != null) {
            pref.getPage().performOk();
        }
        IPreferenceStore store = this.getPreferenceStore();
        String userid = this.textUseridName.getText();
        store.setValue("UseridName", userid);
        store.setValue("UseridPassword", this.textPassword.getText());
        this.password = this.useridComposite.getPassword();
        if (!userid.equals("") && PwStoreManager.isSavingPasswordsPreference()) {
            PwDefaultCredentials c = new PwDefaultCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.userid.pw", userid, this.password);
            if (this.password != null) {
                PwStoreManager.getStoreManager((Trace)t).saveCredentials(t, (IPwCredentials)c);
            } else {
                PwStoreManager.getStoreManager((Trace)t).deleteCredentials(t, (IPwCredentials)c);
            }
        }
        boolean b1 = this.buttonCompatMode.getSelection();
        store.setValue("UseridCompatibilityMode", b1);
        int tmpPasswordMode = this.useridComposite.getPasswordModeStateSelection();
        store.setValue("UseridPasswordMode", tmpPasswordMode);
        boolean b2 = this.buttonEnable.getSelection();
        store.setValue("UseridEnabled", b2);
        this.applyPreferencesToHandle();
        if (Trace.isTracing) {
            t.data(67, "PreferencePageUserid.performOk", 300, "Storing userid details" + Common.NEW_LINE + "name = " + this.textUseridName.getText() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        return super.performOk();
    }

    private void applyPreferencesToHandle() {
        boolean b = this.buttonEnable.getSelection();
        int tmpState = b ? 1 : 0;
        b = this.buttonCompatMode.getSelection();
        int tmpCompat = b ? 1 : 0;
        int tmpPasswordMode = this.useridComposite.getPasswordModeStateSelection();
        String tmpUserid = this.textUseridName.getText();
        String tmpPassword = this.useridComposite.getPassword();
        QueueManagerHandle.setDefaultUseridState((int)tmpState);
        QueueManagerHandle.setDefaultUserid((String)tmpUserid);
        QueueManagerHandle.setDefaultPassword((String)tmpPassword);
        QueueManagerHandle.setDefaultCompatMode((int)tmpCompat);
        QueueManagerHandle.setDefaultPasswordMode((int)tmpPasswordMode);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        if (visible) {
            boolean passwordStoreEnabled = false;
            IPreferenceNode pref = PlatformUI.getWorkbench().getPreferenceManager().find("com.ibm.mq.explorer.prefmain/com.ibm.mq.explorer.pref.passwords");
            if (pref != null && pref.getPage() != null && pref.getPage() instanceof PreferencePagePasswords) {
                PreferencePagePasswords passwordsPrefPage = (PreferencePagePasswords)pref.getPage();
                passwordStoreEnabled = passwordsPrefPage.getSavingPasswordsPref(t);
            } else {
                IPreferenceStore store = UiPlugin.getPrefStore();
                passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
            }
            this.linkPasswordWarning.setVisible(!passwordStoreEnabled);
            this.useridComposite.setPasswordSaving(t, passwordStoreEnabled);
        }
        super.setVisible(visible);
    }
}

