/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultCredentials;
import com.ibm.mq.explorer.qmgradmin.internal.preferences.PreferencePagePasswords;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLStores;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.preferences.PreferencePageAbstract;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PreferencePageSSLStores
extends PreferencePageAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/preferences/PreferencePageSSLStores.java";
    private Text textTrustedStore = null;
    private Text textPersonalStore = null;
    private String strTrustedStorePassword = "";
    private String strPersonalStorePassword = "";
    private Button buttonEnable = null;
    private ConnectionDetailsSSLStores sslStoresComposite = null;
    private Text textTrustedPassword = null;
    private Text textPersonalPassword = null;
    private Link[] linkPasswordWarnings = null;

    protected Control createContents(Composite parent) {
        this.sslStoresComposite = new ConnectionDetailsSSLStores(parent, 0, 1);
        this.sslStoresComposite.setOwnerId("com.ibm.mq.explorer.prefs.conn.details");
        this.sslStoresComposite.setObjectId("com.ibm.mq.explorer.prefs.conn.details.trusted.store.pw");
        UiPlugin.getHelpSystem().setHelp((Control)this.sslStoresComposite, "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageConnDetails");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageConnDetailsSSLStores");
        this.textPersonalStore = this.sslStoresComposite.getTextPersonalStore();
        this.textTrustedStore = this.sslStoresComposite.getTextTrustedStore();
        this.textTrustedPassword = this.sslStoresComposite.getTextTrustedPassword();
        this.textPersonalPassword = this.sslStoresComposite.getTextPersonalPassword();
        this.buttonEnable = this.sslStoresComposite.getButtonEnable();
        Link[] linkArray = this.linkPasswordWarnings = this.sslStoresComposite.getPasswordWarningLinks();
        int n = this.linkPasswordWarnings.length;
        int n2 = 0;
        while (n2 < n) {
            Link currentLink = linkArray[n2];
            currentLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PreferencePagePasswords.openPasswordPreferencePage(t2);
                }
            });
            ++n2;
        }
        this.sslStoresComposite.pack();
        return this.sslStoresComposite;
    }

    protected void loadCurrentSettings(Trace t) {
        IPreferenceStore store = this.getPreferenceStore();
        this.textTrustedStore.setText(store.getString("TrustedStoreName"));
        this.textPersonalStore.setText(store.getString("PersonalStoreName"));
        this.buttonEnable.setSelection(store.getBoolean("SSLStoresEnabled"));
        IPwCredentials c = PwStoreManager.getStoreManager((Trace)t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.trusted.store.pw", this.textTrustedStore.getText());
        if (c != null) {
            this.textTrustedPassword.setText("********");
            this.sslStoresComposite.setTrustedStorePassword(c.getPassword());
        } else {
            this.textTrustedPassword.setText("");
        }
        c = PwStoreManager.getStoreManager((Trace)t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.personal.store.pw", this.textPersonalStore.getText());
        if (c != null) {
            this.textPersonalPassword.setText("********");
            this.sslStoresComposite.setPersonalStorePassword(c.getPassword());
        } else {
            this.textPersonalPassword.setText("");
        }
        this.isCurrentSettingsLoaded = true;
        if (Trace.isTracing) {
            t.data(67, "PreferencePageSSLStores.loadCurrentSettings", 300, "Loaded current SSL certificate store details" + Common.NEW_LINE + "trust store = " + this.textTrustedStore.getText() + Common.NEW_LINE + "personal store = " + this.textPersonalStore.getText() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.sslStoresComposite.enableControls(t);
    }

    protected void performDefaults() {
        Trace t = Trace.getDefault();
        IPreferenceStore store = this.getPreferenceStore();
        this.textTrustedStore.setText(store.getDefaultString("TrustedStoreName"));
        this.textPersonalStore.setText(store.getDefaultString("PersonalStoreName"));
        this.textPersonalPassword.setText(store.getDefaultString("PersonalStoreName"));
        this.textTrustedPassword.setText(store.getDefaultString("PersonalStoreName"));
        this.strTrustedStorePassword = "";
        this.strPersonalStorePassword = "";
        this.buttonEnable.setSelection(store.getDefaultBoolean("SSLStoresEnabled"));
        if (Trace.isTracing) {
            t.data(67, "PreferencePageSSLStores.performDefaults", 300, "Loaded default SSL certificate store details" + Common.NEW_LINE + "trust store = " + this.textTrustedStore.getText() + Common.NEW_LINE + "personal store = " + this.textPersonalStore.getText() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.sslStoresComposite.enableControls(t);
        super.performDefaults();
    }

    public boolean performOk() {
        PwDefaultCredentials c;
        IPreferenceNode pref;
        Trace t = Trace.getDefault();
        if (PreferencePagePasswords.savePasswordPreferences && (pref = PlatformUI.getWorkbench().getPreferenceManager().find("com.ibm.mq.explorer.prefmain/com.ibm.mq.explorer.pref.passwords")) != null) {
            pref.getPage().performOk();
        }
        IPreferenceStore store = this.getPreferenceStore();
        String trustedStore = this.textTrustedStore.getText();
        store.setValue("TrustedStoreName", trustedStore);
        String personalStore = this.textPersonalStore.getText();
        store.setValue("PersonalStoreName", personalStore);
        boolean b = this.buttonEnable.getSelection();
        store.setValue("SSLStoresEnabled", b);
        this.strTrustedStorePassword = this.sslStoresComposite.getTrustedStorePassword();
        this.strPersonalStorePassword = this.sslStoresComposite.getPersonalStorePassword();
        if (this.strTrustedStorePassword != null && !trustedStore.equals("") && PwStoreManager.isSavingPasswordsPreference()) {
            c = new PwDefaultCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.trusted.store.pw", trustedStore, this.strTrustedStorePassword);
            if (!this.strTrustedStorePassword.equals("")) {
                PwStoreManager.getStoreManager((Trace)t).saveCredentials(t, (IPwCredentials)c);
            } else {
                PwStoreManager.getStoreManager((Trace)t).deleteCredentials(t, (IPwCredentials)c);
            }
        }
        if (this.strPersonalStorePassword != null && !personalStore.equals("") && PwStoreManager.isSavingPasswordsPreference()) {
            c = new PwDefaultCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.personal.store.pw", personalStore, this.strPersonalStorePassword);
            if (!this.strPersonalStorePassword.equals("")) {
                PwStoreManager.getStoreManager((Trace)t).saveCredentials(t, (IPwCredentials)c);
            } else {
                PwStoreManager.getStoreManager((Trace)t).deleteCredentials(t, (IPwCredentials)c);
            }
        }
        if (Trace.isTracing) {
            t.data(67, "PreferencePageSSLStores.performOk", 300, "Stored SSL certificate store details" + Common.NEW_LINE + "trust store = " + this.textTrustedStore.getText() + Common.NEW_LINE + "personal store = " + this.textPersonalStore.getText() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        if (visible) {
            boolean passwordStoreEnabled = false;
            IPreferenceNode pref = PlatformUI.getWorkbench().getPreferenceManager().find("com.ibm.mq.explorer.prefmain/com.ibm.mq.explorer.pref.passwords");
            if (pref != null && pref.getPage() != null && pref.getPage() instanceof PreferencePagePasswords) {
                PreferencePagePasswords passwordsPrefPage = (PreferencePagePasswords)pref.getPage();
                passwordStoreEnabled = passwordsPrefPage.getSavingPasswordsPref(t);
            } else {
                IPreferenceStore store = UiPlugin.getPrefStore();
                passwordStoreEnabled = store.getBoolean("PasswordsStoreEnabled");
            }
            Link[] linkArray = this.linkPasswordWarnings;
            int n = this.linkPasswordWarnings.length;
            int n2 = 0;
            while (n2 < n) {
                Link curLink = linkArray[n2];
                curLink.setVisible(!passwordStoreEnabled);
                ++n2;
            }
            this.sslStoresComposite.setPasswordSaving(t, passwordStoreEnabled);
        }
        super.setVisible(visible);
    }
}

