/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSSLOptions;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.SSLPeerNameTextWrapper;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.preferences.PreferencePageAbstract;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class PreferencePageSSLOptions
extends PreferencePageAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/preferences/PreferencePageSSLOptions.java";
    private static final String RESTART_MESSAGE = "AMQ4599";
    private SSLPeerNameTextWrapper textPeerName = null;
    private Spinner spinnerResetCount = null;
    private ExtCombo comboFIPSRequired = null;
    private ExtCombo comboCipherSuites = null;
    private Button buttonEnable = null;
    private ConnectionDetailsSSLOptions sslOptionsComposite = null;
    private int currentFipsValue = 0;

    protected Control createContents(Composite parent) {
        this.sslOptionsComposite = new ConnectionDetailsSSLOptions(parent, 0, 1, true);
        UiPlugin.getHelpSystem().setHelp((Control)this.sslOptionsComposite, "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageConnDetails");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageConnDetailsSSLOptions");
        this.textPeerName = this.sslOptionsComposite.getTextPeerName();
        this.comboCipherSuites = this.sslOptionsComposite.getComboCipherSuites();
        this.comboFIPSRequired = this.sslOptionsComposite.getComboFIPSRequired();
        this.spinnerResetCount = this.sslOptionsComposite.getSpinnerResetCount();
        this.buttonEnable = this.sslOptionsComposite.getButtonEnable();
        this.sslOptionsComposite.pack();
        return this.sslOptionsComposite;
    }

    protected void loadCurrentSettings(Trace t) {
        IPreferenceStore store = this.getPreferenceStore();
        this.textPeerName.setText(store.getString("SSLPeerName"));
        this.sslOptionsComposite.setCipherSuite(t, store.getString("SSLCipherSuite"));
        this.currentFipsValue = store.getInt("SSLFIPSRequired");
        this.sslOptionsComposite.setFIPSRequired(t, this.currentFipsValue);
        this.spinnerResetCount.setSelection(store.getInt("SSLResetCount"));
        this.buttonEnable.setSelection(store.getBoolean("SSLOptionsEnabled"));
        this.isCurrentSettingsLoaded = true;
        if (Trace.isTracing) {
            t.data(67, "PreferencePageSSLOptions.loadCurrentSettings", 300, "Loaded current SSL options" + Common.NEW_LINE + "cipher suite = " + this.comboCipherSuites.getText() + Common.NEW_LINE + "peer name = " + this.textPeerName.getText() + Common.NEW_LINE + "FIPS required = " + this.comboFIPSRequired.getText() + Common.NEW_LINE + "reset count = " + this.spinnerResetCount.getSelection() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.sslOptionsComposite.enableControls(t);
    }

    protected void performDefaults() {
        Trace t = Trace.getDefault();
        IPreferenceStore store = this.getPreferenceStore();
        this.textPeerName.setText(store.getDefaultString("SSLPeerName"));
        this.sslOptionsComposite.setCipherSuite(t, store.getDefaultString("SSLCipherSuite"));
        this.sslOptionsComposite.setFIPSRequired(t, store.getDefaultInt("SSLFIPSRequired"));
        this.spinnerResetCount.setSelection(store.getDefaultInt("SSLResetCount"));
        this.buttonEnable.setSelection(store.getDefaultBoolean("SSLOptionsEnabled"));
        if (Trace.isTracing) {
            t.data(67, "PreferencePageSSLOptions.performDefaults", 300, "Loaded default SSL options" + Common.NEW_LINE + "cipher suite = " + this.comboCipherSuites.getText() + Common.NEW_LINE + "peer name = " + this.textPeerName.getText() + Common.NEW_LINE + "FIPS required = " + this.comboFIPSRequired.getText() + Common.NEW_LINE + "reset count = " + this.spinnerResetCount.getSelection() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        this.sslOptionsComposite.enableControls(t);
        super.performDefaults();
    }

    public boolean performOk() {
        Trace t = Trace.getDefault();
        IPreferenceStore store = this.getPreferenceStore();
        String s = (String)this.comboCipherSuites.getData(this.comboCipherSuites.getText());
        store.setValue("SSLCipherSuite", s);
        s = this.textPeerName.getText();
        store.setValue("SSLPeerName", s);
        int i = this.spinnerResetCount.getSelection();
        store.setValue("SSLResetCount", i);
        boolean b = this.buttonEnable.getSelection();
        store.setValue("SSLOptionsEnabled", b);
        if (Trace.isTracing) {
            t.data(67, "PreferencePageSSLOptions.performOk", 300, "Stored SSL options" + Common.NEW_LINE + "cipher suite = " + this.comboCipherSuites.getText() + Common.NEW_LINE + "peer name = " + this.textPeerName.getText() + Common.NEW_LINE + "FIPS required = " + (this.comboFIPSRequired != null ? this.comboFIPSRequired.getText() : "<disabled>") + Common.NEW_LINE + "reset count = " + this.spinnerResetCount.getSelection() + Common.NEW_LINE + "button = " + this.buttonEnable.getSelection());
        }
        if (this.comboFIPSRequired != null) {
            this.checkForRestart(t, store);
        }
        return super.performOk();
    }

    private void checkForRestart(final Trace t, IPreferenceStore store) {
        int reply = 1;
        final int fips = (Integer)this.comboFIPSRequired.getData(this.comboFIPSRequired.getText());
        if (fips != this.currentFipsValue && (reply = MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((Trace)t, (String)RESTART_MESSAGE), (int)1, (String)RESTART_MESSAGE)) == 0) {
            store.setValue("SSLFIPSRequired", fips);
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiPlugin.getTheDataModel().enableFips(t, fips);
                    UiPlugin.restartExplorer((Trace)t);
                }
            });
        }
    }
}

