/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultStore;
import com.ibm.mq.explorer.passwords.internal.utils.PwUtils;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.dialogs.PasswordDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.preferences.PreferencePageAbstract;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferencePagePasswords
extends PreferencePageAbstract {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/preferences/PreferencePagePasswords.java";
    private static int MIN_KEY_LENGTH = 8;
    private static int MAX_KEY_LENGTH = 250;
    private static final String FILETYPES_XML = "*.xml";
    private static final String FILETYPE_XML = ".xml";
    private static final String FILETYPE_ALL = "*.*";
    private static final String CLEAR_KEY_HELP_TEXT = String.valueOf(Common.NEW_LINE) + Common.NEW_LINE + Common.NEW_LINE;
    private Button buttonPersistentPasswords = null;
    private Button buttonNonPersistentPasswords = null;
    private Text textFileName = null;
    private Button buttonBrowseFileName = null;
    private static boolean currentSavingPasswords = false;
    private static boolean currentUseUserKey = false;
    private static String currentFileName = "";
    private static boolean newSavingPasswords = false;
    private static boolean newUseUserKey = false;
    private static String newFileName = "";
    private Button buttonDefaultKey = null;
    private Button buttonUserKey = null;
    private Text textUserKey = null;
    private Button buttonSetUserKey = null;
    private Composite keyComposite = null;
    private Composite savePasswordComposite = null;
    private static String currentUserDefinedKey = "";
    private static String newUserDefinedKey = "";
    private PwStoreManager storeManager = null;
    private Text textKeyHelp = null;
    private boolean newFile = false;
    public static boolean savePasswordPreferences = false;
    public static final String ID_PATH = "com.ibm.mq.explorer.prefmain/com.ibm.mq.explorer.pref.passwords";
    public static final String ID = "com.ibm.mq.explorer.pref.passwords";

    protected Control createContents(Composite parent) {
        Trace t = Trace.getDefault();
        this.uiMessages = QmgradminPlugin.getMessages(t, "KEY_Queue Manager");
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 10;
        gridLayout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)gridData);
        UiPlugin.getHelpSystem().setHelp((Control)mainComposite, "com.ibm.mq.explorer.ui.infopop.UI_PreferencesPagePasswords");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.ui.infopop.UI_PreferencesPagePasswords");
        UiUtils.createBlankLine((Composite)mainComposite, (int)1);
        final Text textLine1 = new Text(mainComposite, 66);
        textLine1.setText(this.uiMessages.getMessage("PW.Preferences.Passwords.Info1"));
        gridData = new GridData(768);
        gridData.widthHint = 100;
        textLine1.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)textLine1, (boolean)false);
        UiUtils.createBlankLine((Composite)mainComposite, (int)1);
        final Text textLine2 = new Text(mainComposite, 66);
        textLine2.setText(this.uiMessages.getMessage("PW.Preferences.Passwords.Info2"));
        gridData = new GridData(768);
        gridData.widthHint = 100;
        textLine2.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)textLine2, (boolean)false);
        UiUtils.createBlankLine((Composite)mainComposite, (int)1);
        this.savePasswordComposite = new Composite(mainComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 10;
        gridLayout.makeColumnsEqualWidth = false;
        this.savePasswordComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.savePasswordComposite.setLayoutData((Object)gridData);
        this.buttonNonPersistentPasswords = new Button(this.savePasswordComposite, 16);
        this.buttonNonPersistentPasswords.setText(this.uiMessages.getMessage("PW.Preferences.NonPersistent.Passwords"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        gridData.horizontalSpan = 3;
        this.buttonNonPersistentPasswords.setLayoutData((Object)gridData);
        this.buttonNonPersistentPasswords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.enableSavePasswordControls(t2);
            }
        });
        UiUtils.createBlankLine((Composite)this.savePasswordComposite, (int)3);
        this.buttonPersistentPasswords = new Button(this.savePasswordComposite, 16);
        this.buttonPersistentPasswords.setText(this.uiMessages.getMessage("PW.Preferences.Persistent.Passwords"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        this.buttonPersistentPasswords.setLayoutData((Object)gridData);
        this.buttonPersistentPasswords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.enableSavePasswordControls(t2);
            }
        });
        this.textFileName = new Text(this.savePasswordComposite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 200;
        this.textFileName.setLayoutData((Object)gridData);
        this.textFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.enableOkButton(t2);
            }
        });
        this.buttonBrowseFileName = new Button(this.savePasswordComposite, 8);
        this.buttonBrowseFileName.setText(this.uiMessages.getMessage("PW.Preferences.Button.Browse"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonBrowseFileName.setLayoutData((Object)gridData);
        this.buttonBrowseFileName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.browse(t2);
            }
        });
        UiUtils.createBlankLine((Composite)mainComposite, (int)1);
        this.keyComposite = new Composite(mainComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 10;
        gridLayout.makeColumnsEqualWidth = false;
        this.keyComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.keyComposite.setLayoutData((Object)gridData);
        this.buttonDefaultKey = new Button(this.keyComposite, 16);
        this.buttonDefaultKey.setText(this.uiMessages.getMessage("PW.Preferences.Use.Default.Key"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 3;
        this.buttonDefaultKey.setLayoutData((Object)gridData);
        this.buttonDefaultKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.enableUserKeyControls(t2);
            }
        });
        this.buttonUserKey = new Button(this.keyComposite, 16);
        this.buttonUserKey.setText(this.uiMessages.getMessage("PW.Preferences.User.Key"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        gridData.horizontalIndent = 20;
        this.buttonUserKey.setLayoutData((Object)gridData);
        this.buttonUserKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.enableUserKeyControls(t2);
            }
        });
        this.textUserKey = new Text(this.keyComposite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 200;
        this.textUserKey.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.textUserKey, (boolean)false);
        this.buttonSetUserKey = new Button(this.keyComposite, 8);
        this.buttonSetUserKey.setText(this.uiMessages.getMessage("PW.Preferences.Button.Set.Key"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonSetUserKey.setLayoutData((Object)gridData);
        this.buttonSetUserKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PreferencePagePasswords.this.changeUserKeyPrompt(t2);
            }
        });
        UiUtils.createBlankLine((Composite)this.keyComposite, (int)3);
        this.textKeyHelp = new Text(this.keyComposite, 66);
        this.textKeyHelp.setText(CLEAR_KEY_HELP_TEXT);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 20;
        this.textKeyHelp.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.textKeyHelp, (boolean)false);
        mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace t2 = Trace.getDefault();
                UiUtils.resizeControl((Trace)t2, (Control)PreferencePagePasswords.this.textKeyHelp);
                UiUtils.resizeControl((Trace)t2, (Control)textLine1);
                UiUtils.resizeControl((Trace)t2, (Control)textLine2);
            }
        });
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{this.buttonBrowseFileName, this.buttonSetUserKey});
        this.loadCurrentSettings(t);
        this.storeManager = PwStoreManager.getStoreManager((Trace)t);
        mainComposite.pack();
        return mainComposite;
    }

    protected void performDefaults() {
        Trace t = Trace.getDefault();
        IPreferenceStore store = UiPlugin.getPrefStore();
        currentFileName = store.getDefaultString("PasswordsFileName");
        this.textFileName.setText(currentFileName);
        currentSavingPasswords = store.getDefaultBoolean("PasswordsStoreEnabled");
        this.buttonPersistentPasswords.setSelection(currentSavingPasswords);
        this.buttonNonPersistentPasswords.setSelection(!currentSavingPasswords);
        currentUseUserKey = store.getDefaultBoolean("PasswordsStoreUserKeyEnabled");
        this.buttonUserKey.setSelection(currentUseUserKey);
        this.buttonDefaultKey.setSelection(!currentUseUserKey);
        this.textUserKey.setText("");
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.performDefaults", 300, "Loaded default password preference details" + Common.NEW_LINE + "file name = " + this.textFileName.getText() + Common.NEW_LINE + "store enabled = " + this.buttonNonPersistentPasswords.getSelection() + Common.NEW_LINE + "user key enabled = " + this.buttonUserKey.getSelection());
        }
        this.enableSavePasswordControls(t);
        super.performDefaults();
    }

    public boolean performOk() {
        Trace t = Trace.getDefault();
        boolean result = true;
        if (savePasswordPreferences) {
            savePasswordPreferences = false;
            IPreferenceStore store = UiPlugin.getPrefStore();
            newSavingPasswords = this.buttonPersistentPasswords.getSelection();
            newUseUserKey = this.buttonUserKey.getSelection();
            newFileName = this.textFileName.getText();
            if (Trace.isTracing) {
                t.data(67, "PreferencePagePasswords.performOk", 300, "Saving password preference details" + Common.NEW_LINE + "file name = " + this.textFileName.getText() + Common.NEW_LINE + "store enabled = " + this.buttonNonPersistentPasswords.getSelection() + Common.NEW_LINE + "user key enabled = " + this.buttonUserKey.getSelection());
            }
            if (newSavingPasswords) {
                result = this.updatePasswordStore(t);
                if (result) {
                    currentFileName = newFileName;
                    currentUserDefinedKey = newUserDefinedKey;
                    currentSavingPasswords = newSavingPasswords;
                    currentUseUserKey = newUseUserKey;
                    store.setValue("PasswordsFileName", this.textFileName.getText());
                    store.setValue("PasswordsStoreEnabled", newSavingPasswords);
                    store.setValue("PasswordsStoreUserKeyEnabled", newUseUserKey);
                }
            } else {
                store.setValue("PasswordsFileName", this.textFileName.getText());
                store.setValue("PasswordsStoreEnabled", newSavingPasswords);
                store.setValue("PasswordsStoreUserKeyEnabled", newUseUserKey);
                this.storeManager.close(t);
            }
        }
        return result;
    }

    private boolean updatePasswordStore(Trace t) {
        boolean result = true;
        int rc = 0;
        result = this.verifyStoreName(t, newUserDefinedKey, true);
        if (PwDefaultStore.getDefaultStore((Trace)t).isOpen(t) && !PwDefaultStore.getDefaultStore((Trace)t).isSavingPasswords(t)) {
            PwStoreManager.getStoreManager((Trace)t).open(t, this.textFileName.getText(), newUserDefinedKey);
        }
        if (result) {
            if (currentFileName.equals(newFileName)) {
                if (currentUseUserKey && !newUseUserKey) {
                    if (this.getCurrentUserKeyPrompt(t) && (rc = this.storeManager.setKey(t, currentUserDefinedKey, newUserDefinedKey = "")) != 0 && rc != 8) {
                        result = false;
                    }
                } else if (!this.newFile && newUseUserKey && (rc = this.storeManager.setKey(t, currentUserDefinedKey, newUserDefinedKey)) != 0 && rc != 8) {
                    result = false;
                }
            } else {
                if (currentUseUserKey && (result = this.getCurrentUserKeyPrompt(t))) {
                    newUserDefinedKey = "";
                    rc = this.storeManager.validate(t, currentUserDefinedKey);
                }
                if (rc == 0 && result) {
                    boolean copy = false;
                    if (MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4601"), (int)1, null) == 0) {
                        copy = true;
                    }
                    if ((rc = this.storeManager.createStore(t, newFileName, newUserDefinedKey, copy)) != 0 && rc != 8) {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    private void browse(Trace t) {
        String name = null;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILETYPES_XML, FILETYPE_ALL});
        dialog.setFileName(this.textFileName.getText());
        name = dialog.open();
        if (name != null) {
            if (!name.toLowerCase().endsWith(FILETYPE_XML)) {
                name = String.valueOf(name) + FILETYPE_XML;
            }
            this.textFileName.setText(name);
            if (!name.equals(currentFileName) && !name.equals(newFileName)) {
                this.buttonDefaultKey.setSelection(true);
                this.buttonUserKey.setSelection(false);
                this.enableUserKeyControls(t);
                if (Trace.isTracing) {
                    t.data(67, "PreferencePagePasswords.browse", 300, "Reset to use system default key");
                }
            }
            newFileName = name;
        }
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.browse", 300, "Password store file name is " + name);
        }
    }

    private void changeUserKeyPrompt(Trace t) {
        newSavingPasswords = this.buttonPersistentPasswords.getSelection();
        newUseUserKey = this.buttonUserKey.getSelection();
        PasswordDialog dialog = new PasswordDialog(this.getShell(), true);
        dialog.setTitle(this.uiMessages.getMessage("PW.Dialog.Passwords.Key.Title"));
        dialog.setDescription(this.uiMessages.getMessage("PW.Preferences.Enter.User.Key"));
        dialog.setErrorMessage(this.uiMessages.getMessage("PW.Dialog.Passwords.Mismatch"));
        dialog.setMaxPasswordLength(MAX_KEY_LENGTH);
        dialog.setMinPasswordLength(MIN_KEY_LENGTH);
        if (!currentSavingPasswords && newUseUserKey) {
            dialog.setPassword1Description(this.uiMessages.getMessage("PW.Dialog.Passwords.New.Key1"));
            dialog.setPassword2Description(this.uiMessages.getMessage("PW.Dialog.Passwords.New.Key2"));
        } else if (newSavingPasswords && !currentUseUserKey && newUseUserKey) {
            dialog.setPassword1Description(this.uiMessages.getMessage("PW.Dialog.Passwords.New.Key1"));
            dialog.setPassword2Description(this.uiMessages.getMessage("PW.Dialog.Passwords.New.Key2"));
        } else if (newSavingPasswords && currentUseUserKey && newUseUserKey) {
            dialog.setPassword1Description(this.uiMessages.getMessage("PW.Dialog.Passwords.New.Key1"));
            dialog.setPassword2Description(this.uiMessages.getMessage("PW.Dialog.Passwords.New.Key2"));
            dialog.setCurrentPasswordDescription(this.uiMessages.getMessage("PW.Dialog.Passwords.Current.Key"));
            dialog.useChangePassword();
        }
        dialog.create(t);
        if (dialog.open(t)) {
            newUserDefinedKey = dialog.getPassword();
            currentUserDefinedKey = dialog.getCurrentPassword();
            this.textUserKey.setText("********");
            if (Trace.isTracing) {
                t.data(67, "PreferencePagePasswords.changeUserKeyPrompt", 300, "User entered a key");
            }
        } else if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.changeUserKeyPrompt", 300, "No key entered");
        }
        this.enableOkButton(t);
    }

    private boolean getCurrentUserKeyPrompt(Trace t) {
        boolean result = false;
        newSavingPasswords = this.buttonPersistentPasswords.getSelection();
        newUseUserKey = this.buttonUserKey.getSelection();
        PasswordDialog dialog = new PasswordDialog(this.getShell());
        dialog.setTitle(this.uiMessages.getMessage("PW.Dialog.Passwords.Key.Title"));
        dialog.setDescription(this.uiMessages.getMessage("PW.Preferences.Enter.User.Key.Validation"));
        dialog.create(t);
        if (dialog.open(t)) {
            currentUserDefinedKey = dialog.getPassword();
            result = true;
            if (Trace.isTracing) {
                t.data(67, "PreferencePagePasswords.getCurrentUserKeyPrompt", 300, "User entered a key");
            }
        } else if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.getCurrentUserKeyPrompt", 300, "No password key");
        }
        return result;
    }

    private void enableSavePasswordControls(Trace t) {
        boolean selected = this.buttonNonPersistentPasswords.getSelection();
        if (selected) {
            this.textKeyHelp.setText(CLEAR_KEY_HELP_TEXT);
        }
        this.buttonPersistentPasswords.setSelection(!selected);
        UiUtils.enableControls((Trace)t, (Control[])new Control[]{this.textFileName, this.buttonBrowseFileName, this.buttonDefaultKey, this.buttonUserKey, this.buttonSetUserKey}, (!selected ? 1 : 0) != 0);
        if (!selected) {
            this.enableUserKeyControls(t);
        } else {
            this.enableOkButton(t);
        }
    }

    private void enableUserKeyControls(Trace t) {
        boolean selected = this.buttonDefaultKey.getSelection();
        if (selected) {
            this.textKeyHelp.setText(this.uiMessages.getMessage("PW.Preferences.Passwords.Key.Help1"));
            this.textUserKey.setText("");
            currentUserDefinedKey = "";
            newUserDefinedKey = "";
        } else {
            this.textKeyHelp.setText(this.uiMessages.getMessage("PW.Preferences.Passwords.Key.Help2"));
        }
        this.buttonUserKey.setSelection(!selected);
        UiUtils.enableControls((Trace)t, (Control[])new Control[]{this.buttonSetUserKey, this.textUserKey}, (!selected ? 1 : 0) != 0);
        this.enableOkButton(t);
    }

    private void enableOkButton(Trace t) {
        boolean valid = true;
        boolean selected = this.buttonNonPersistentPasswords.getSelection();
        if (!selected) {
            valid = !this.textFileName.getText().equals("") ? ((selected = this.buttonDefaultKey.getSelection()) ? true : !this.textUserKey.getText().equals("")) : false;
        }
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.enableOkButton", 300, "Enabling OK and Apply buttons : " + valid);
        }
        super.setValid(valid);
        savePasswordPreferences = valid;
    }

    protected void loadCurrentSettings(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        currentFileName = store.getString("PasswordsFileName");
        this.textFileName.setText(currentFileName);
        currentSavingPasswords = store.getBoolean("PasswordsStoreEnabled");
        this.buttonPersistentPasswords.setSelection(currentSavingPasswords);
        this.buttonNonPersistentPasswords.setSelection(!currentSavingPasswords);
        currentUseUserKey = store.getBoolean("PasswordsStoreUserKeyEnabled");
        this.buttonUserKey.setSelection(currentUseUserKey);
        this.buttonDefaultKey.setSelection(!currentUseUserKey);
        if (currentUseUserKey) {
            this.textUserKey.setText("********");
        }
        this.isCurrentSettingsLoaded = true;
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.loadCurrentSettings", 300, "Loaded current password preference details" + Common.NEW_LINE + "file name = " + currentFileName + Common.NEW_LINE + "store enabled = " + !currentSavingPasswords + Common.NEW_LINE + "user key enabled = " + currentUseUserKey);
        }
        this.enableSavePasswordControls(t);
    }

    private void setDefaults(Trace t) {
        String storeFilename = null;
        IPreferenceStore store = UiPlugin.getPrefStore();
        store.setDefault("PasswordsStoreEnabled", false);
        store.setDefault("PasswordsStoreUserKeyEnabled", false);
        try {
            storeFilename = UiPlugin.getPersistentFileLocation().toString();
            storeFilename = String.valueOf(storeFilename) + File.separator + "WMQ_Passwords.xml";
            store.setDefault("PasswordsFileName", storeFilename);
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(67, "PreferencePagePasswords.setDefaults", 900, "Error getting password store file name" + Common.NEW_LINE + e.getMessage());
            }
            storeFilename = "WMQ_Passwords.xml";
            store.setDefault("PasswordsFileName", storeFilename);
        }
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.setDefaults", 300, "Setting default password store filename to : " + storeFilename);
        }
    }

    public void init(IWorkbench workbench) {
        super.init(workbench);
        this.setDefaults(Trace.getDefault());
    }

    private boolean verifyStoreName(Trace t, String key, boolean closing) {
        boolean valid = true;
        this.newFile = false;
        File file = new File(this.textFileName.getText());
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.verifyStoreName", 300, "Password store file name is " + file.toString());
        }
        if (file.canWrite()) {
            if (file.isFile()) {
                if (PwStoreManager.getStoreManager((Trace)t).validate(t, file) != 0) {
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4605", (String)PwUtils.formatPasswordStoreName((String)file.toString())), (String)"AMQ4605");
                    valid = false;
                }
            } else {
                MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4603", (String)PwUtils.formatPasswordStoreName((String)file.toString())), (String)"AMQ4603");
                valid = false;
            }
        } else if (!file.exists()) {
            int rc = PwStoreManager.getStoreManager((Trace)t).createStore(t, file.toString(), key, false);
            this.newFile = true;
            if (rc != 0) {
                MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4600", (String)PwUtils.formatPasswordStoreName((String)file.toString())), (String)"AMQ4600");
                valid = false;
            }
        } else {
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4604", (String)PwUtils.formatPasswordStoreName((String)file.toString())), (String)"AMQ4604");
            valid = false;
        }
        if (Trace.isTracing) {
            t.data(67, "PreferencePagePasswords.verifyStoreName", 300, "Password store verified : " + valid);
        }
        super.setValid(valid);
        return valid;
    }

    public static void openPasswordPreferencePage(Trace t) {
        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)UiPlugin.getShell(), (String)ID, null, (Object)"");
        dlg.open();
    }

    public boolean getSavingPasswordsPref(Trace t) {
        boolean savePasswordsPref = this.buttonPersistentPasswords.getSelection();
        return savePasswordsPref;
    }
}

