/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.listeners.zos;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagementListener;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.listeners.zos.UiZOSListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UiZOSListenerActions
implements DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/listeners/zos/UiZOSListenerActions.java";
    protected BusyDialog listenerBusyDialog = null;
    protected boolean starting;
    protected Shell shell = null;
    private UiZOSListener uiZOSListener = null;
    private DmDistQueueManagementListener dmDistQMListener = null;

    public UiZOSListenerActions(Shell sh, UiZOSListener uiZOSList) {
        this.shell = sh;
        this.uiZOSListener = uiZOSList;
        this.dmDistQMListener = (DmDistQueueManagementListener)this.uiZOSListener.getDmObject();
    }

    public void startListener(Trace t) {
        this.listenerBusyDialog = new BusyDialog(this.shell, QmgradminPlugin.getNLSString(t, this.uiZOSListener.getNLSResourceFileKey(), "UI.LIS.Listeners.Busy.Starting"));
        this.starting = true;
        this.dmDistQMListener.actionStart(t, (DmActionListener)this);
        this.listenerBusyDialog.showDialog(t);
    }

    public void stopListener(Trace t) {
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4132", (String)this.uiZOSListener.toFormattedString());
        int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.shell, (String)msg, (int)1, (String)"AMQ4132");
        if (rc == 0) {
            this.listenerBusyDialog = new BusyDialog(this.shell, QmgradminPlugin.getNLSString(t, this.uiZOSListener.getNLSResourceFileKey(), "UI.LIS.Listeners.Busy.Stopping"));
            this.starting = false;
            this.dmDistQMListener.actionStop(t, (DmActionListener)this);
            this.listenerBusyDialog.showDialog(t);
        }
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        Display display = this.shell.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                UiZOSListenerActions.this.listenerBusyDialog.closeDialog(t);
                String amqNumber = null;
                amqNumber = UiZOSListenerActions.this.starting ? "AMQ4149" : "AMQ4150";
                final String amq = amqNumber;
                if (rc == 0) {
                    UiZOSListenerActions.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)amq, null, (String)amq);
                        }
                    });
                } else if (exc != null) {
                    UiZOSListenerActions.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                        }
                    });
                } else {
                    UiZOSListenerActions.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                        }
                    });
                }
            }
        });
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }
}

