/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.listeners.zos;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagementListener;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.listeners.zos.UiZOSListenerActions;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public class UiZOSListener
extends UiMQObject
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/listeners/zos/UiZOSListener.java";
    private String objectType = "";
    private int listenerType = -1;
    private Shell shell = null;
    private Action actionStart = null;
    private Action actionStop = null;
    private UiQueueManager uiQueueManager = null;
    private UiZOSListenerActions uiZOSListenerActions = null;

    public UiZOSListener() {
    }

    public UiZOSListener(Trace t, IDmObject dmListener, UiMQObject parent) {
        super(t, dmListener);
        Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Object_Types");
        this.objectType = msgFile.getMessage(t, "UI.OBJECT.Type.zOSListener");
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        this.uiZOSListenerActions = new UiZOSListenerActions(UiPlugin.getShell(), this);
    }

    public void appendToContextMenu(Shell sh, IMenuManager manager, Object contextObject) {
        Attr a;
        final Trace t = Trace.getDefault();
        this.shell = sh;
        DmDistQueueManagementListener dmListener = (DmDistQueueManagementListener)this.getDmObject();
        this.uiZOSListenerActions.setShell(sh);
        if (this.actionStart == null) {
            this.actionStart = new Action(){

                public void run() {
                    UiZOSListener.this.uiZOSListenerActions.startListener(t);
                }
            };
            this.actionStart.setText(QmgradminPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.LIS.Listeners.Start.Menu"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionStart, "com.ibm.mq.explorer.ui.infopop.UI_Listener_StartMenuItem");
        }
        if (this.actionStop == null) {
            this.actionStop = new Action(){

                public void run() {
                    UiZOSListener.this.uiZOSListenerActions.stopListener(t);
                }
            };
            this.actionStop.setText(QmgradminPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.LIS.Listeners.Stop.Menu"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionStop, "com.ibm.mq.explorer.ui.infopop.UI_Listener_StopMenuItem");
        }
        if ((a = dmListener.getAttribute(t, 1599, 0)) != null) {
            int i = (Integer)a.getValue(t);
            switch (i) {
                case 1: 
                case 2: {
                    manager.add((IAction)this.actionStop);
                    break;
                }
                case 0: 
                case 3: {
                    break;
                }
                default: {
                    manager.add((IAction)this.actionStart);
                    manager.add((IAction)this.actionStop);
                }
            }
        }
        super.appendToContextMenu(this.shell, manager, contextObject);
    }

    public String getId() {
        return "com.ibm.mq.explorer.listener.zos";
    }

    public String toString() {
        String title = "";
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            title = dmObj.getTitle();
        }
        return title;
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getNLSResourceFileKey() {
        return "KEY_Listeners";
    }

    public void updateIcon() {
        Trace t = Trace.getDefault();
        Attr attr = this.getDmObject().getAttribute(t, 1599, 0);
        if (attr != null) {
            Integer i = (Integer)attr.getValue(t);
            int status = i;
            this.setImage(UiZOSListener.getUpdateIcon(t, status));
        } else {
            this.setImage(Icons.get((String)Icons.iconkeyListenerSmallWarning));
        }
    }

    public static Image getUpdateIcon(Trace t, int status) {
        Image img = null;
        switch (status) {
            case 2: {
                img = Icons.get((String)Icons.iconkeyListenerSmallRunning);
                break;
            }
            case 1: 
            case 3: {
                img = Icons.get((String)Icons.iconkeyListenerSmallAlert);
                break;
            }
            case 4: {
                img = Icons.get((String)Icons.iconkeyListenerSmallWarning);
                break;
            }
            case 0: {
                img = Icons.get((String)Icons.iconkeyListenerSmallStopped);
                break;
            }
            default: {
                img = Icons.get((String)Icons.iconkeyMQserviceStopped1);
            }
        }
        return img;
    }

    public int getDataModelObjectType(Trace t) {
        return 1015;
    }

    public boolean isSupportDelete() {
        return false;
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public int getListenerType(Trace t) {
        Object attrValue;
        Attr attr;
        if (this.listenerType == -1 && (attr = this.getDmObject().getAttribute(t, 1501, 0)) != null && (attrValue = attr.getValue(t)) instanceof Integer) {
            this.listenerType = (Integer)attrValue;
        }
        if (Trace.isTracing) {
            t.data(67, "UiZOSListener.getListenerType", 300, "Type for Listener '" + this.toString() + "' is " + this.listenerType);
        }
        return this.listenerType;
    }

    public boolean isLU62(Trace t) {
        return this.getListenerType(t) == 1;
    }

    public boolean isTCP(Trace t) {
        return this.getListenerType(t) == 2;
    }

    public boolean isNETBIOS(Trace t) {
        return this.getListenerType(t) == 3;
    }

    public boolean isSPX(Trace t) {
        return this.getListenerType(t) == 4;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public UiQueueManager getOwningUiQueueManager() {
        return this.uiQueueManager;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "UiZOSListener.testAttribute", 300, "testing object '" + target.toString() + "'");
            t.data(67, "UiZOSListener.testAttribute", 300, "checking attribute '" + name + "'");
            t.data(67, "UiZOSListener.testAttribute", 300, "for value '" + value + "'");
        }
        boolean result = false;
        UiMQObject targetObject = null;
        if (target instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)target;
            targetObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (targetObject != null && targetObject instanceof UiZOSListener) {
            if (name.compareTo("ListenerType") == 0) {
                int lisType = this.getListenerType(t);
                if (value.compareTo("LU62") == 0 && lisType == 1) {
                    result = true;
                } else if (value.compareTo("NetBIOS") == 0 && lisType == 3) {
                    result = true;
                } else if (value.compareTo("SPX") == 0 && lisType == 4) {
                    result = true;
                } else if (value.compareTo("TCP") == 0 && lisType == 2) {
                    result = true;
                }
            } else if (name.compareTo("ListenerStatus") == 0) {
                int status = 0;
                Attr attr = this.getDmObject().getAttribute(t, 1599, 0);
                if (attr != null && attr instanceof AttrInt) {
                    Integer intStatus = (Integer)((AttrInt)attr).getValue(t);
                    status = intStatus;
                }
                if (value.compareTo("Running") == 0 && status == 2) {
                    result = true;
                } else if (value.compareTo("Stopped") == 0 && status == 0) {
                    result = true;
                } else if (value.compareTo("Starting") == 0 && status == 1) {
                    result = true;
                } else if (value.compareTo("Stopping") == 0 && status == 3) {
                    result = true;
                }
            } else {
                int iResult = this.uiQueueManager.testQmgrAttribute(t, (Object)this.uiQueueManager, name, value);
                switch (iResult) {
                    case 1: {
                        result = true;
                        break;
                    }
                    case 0: {
                        result = false;
                        break;
                    }
                    default: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(67, "UiZOSListener.testAttribute", 900, "Object is not a UiZOSListener");
            }
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(67, "UiZOSListener.testAttribute", 300, "returning " + result);
        }
        return result;
    }
}

