/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.listeners;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.listeners.SelectListenersViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.listeners.UiListenerFilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ViewerFilter;

public class UiListenerNewObjectProvider
extends NewObjectProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/listeners/UiListenerNewObjectProvider.java";
    private static final String TYPE_LISTENER_LU62 = "com.ibm.mq.explorer.listener.lu62";
    private static final String TYPE_LISTENER_TCP = "com.ibm.mq.explorer.listener.tcp";
    private static final String TYPE_LISTENER_NETBIOS = "com.ibm.mq.explorer.listener.netbios";
    private static final String TYPE_LISTENER_SPX = "com.ibm.mq.explorer.listener.spx";
    private UiQueueManager uiQueueManager = null;
    private FilterProvider filterProvider = null;
    private Message msgFile = null;

    public UiListenerNewObjectProvider() {
    }

    public UiListenerNewObjectProvider(Trace t, UiMQObject parent) {
        super(t, parent);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        this.filterProvider = new UiListenerFilterProvider();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_NewObject");
    }

    public int getNewObjectTypeCount(Trace t) {
        DmQueueManager dmQm = this.uiQueueManager.getDmQueueManagerObject();
        int[] subTypes = dmQm.getSupportedSubTypes(t, 97);
        return subTypes.length;
    }

    public String[] getNewObjectTypes(Trace t) {
        DmQueueManager dmQm = this.uiQueueManager.getDmQueueManagerObject();
        int[] subTypes = dmQm.getSupportedSubTypes(t, 97);
        ArrayList<String> types = new ArrayList<String>();
        int k = 0;
        while (k < subTypes.length) {
            if (subTypes[k] == 2) {
                types.add(TYPE_LISTENER_TCP);
            }
            ++k;
        }
        k = 0;
        while (k < subTypes.length) {
            if (subTypes[k] == 1) {
                types.add(TYPE_LISTENER_LU62);
            }
            ++k;
        }
        k = 0;
        while (k < subTypes.length) {
            if (subTypes[k] == 3) {
                types.add(TYPE_LISTENER_NETBIOS);
            }
            ++k;
        }
        k = 0;
        while (k < subTypes.length) {
            if (subTypes[k] == 4) {
                types.add(TYPE_LISTENER_SPX);
            }
            ++k;
        }
        String[] strTypes = new String[types.size()];
        int i = 0;
        Iterator itr = types.iterator();
        while (itr.hasNext()) {
            strTypes[i] = (String)itr.next();
            ++i;
        }
        return strTypes;
    }

    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return String.valueOf(this.getNameForNewObjectType(t, typeId)) + "...";
    }

    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        String helpId = null;
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Listener_LU62";
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Listener_TCP";
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Listener_NETBIOS";
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Listener_SPX";
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getHelpIdForNewObjectType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return helpId;
    }

    public String getNameForNewObjectType(Trace t, String typeId) {
        String name = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Listeners");
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            name = messageBundle.getMessage(t, "UI.LIS.Listeners.TypeLU62");
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            name = messageBundle.getMessage(t, "UI.LIS.Listeners.TypeTCP");
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            name = messageBundle.getMessage(t, "UI.LIS.Listeners.TypeNETBIOS");
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            name = messageBundle.getMessage(t, "UI.LIS.Listeners.TypeSPX");
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getNameForNewObjectType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return name;
    }

    public String getDefaultLikeObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            name = "SYSTEM.DEFAULT.LISTENER.LU62";
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            name = "SYSTEM.DEFAULT.LISTENER.TCP";
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            name = "SYSTEM.DEFAULT.LISTENER.NETBIOS";
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            name = "SYSTEM.DEFAULT.LISTENER.SPX";
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getDefaultLikeObjectName", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return name;
    }

    public String getGenericObjectName(Trace t) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Listeners");
        String name = messageBundle.getMessage(t, "UI.OBJECT.Type.Listener");
        return name;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.listener";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.orderid.listeners";
    }

    public boolean supportsDataModelListen(Trace t) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t) {
        return this.uiQueueManager.getDmQueueManagerObject();
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        return 97;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        int subType = 2;
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            subType = 1;
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            subType = 2;
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            subType = 3;
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            subType = 4;
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getDataModelObjectSubType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return subType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.listener");
    }

    public ViewerFilter getViewerFilter(Trace t, String typeId) {
        SelectListenersViewerFilter viewerFilter = new SelectListenersViewerFilter();
        viewerFilter.setHideLU62Listeners(true);
        viewerFilter.setHideTCPListeners(true);
        viewerFilter.setHideNETBIOSListeners(true);
        viewerFilter.setHideSPXListeners(true);
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            viewerFilter.setHideLU62Listeners(false);
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            viewerFilter.setHideTCPListeners(false);
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            viewerFilter.setHideNETBIOSListeners(false);
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            viewerFilter.setHideSPXListeners(false);
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getViewerFilter", 10, 50999, 0, 0, "Unknown Viewer Filter type", typeId, null);
        }
        return viewerFilter;
    }

    public int[] getMandatoryAttributeIds(Trace t, String typeId) {
        int[] ids = null;
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)97, (int)1);
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)97, (int)2);
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)97, (int)3);
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)97, (int)4);
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getMandatoryAttributeIds", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return ids;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.filterid.listeners";
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public Integer getQSGDisposition() {
        return null;
    }

    public String getWizardTitle(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Listener.LU62");
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Listener.TCP");
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Listener.NetBIOS");
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Listener.SPX");
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getWizardTitle", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return title;
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Listener.LU62");
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Listener.TCP");
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Listener.NetBIOS");
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Listener.SPX");
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getWizardPage1Title", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return title;
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        String desc = "";
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Listener.LU62");
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Listener.TCP");
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Listener.NetBIOS");
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Listener.SPX");
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getWizardPage2Description", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return desc;
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        String text = "";
        if (typeId.compareTo(TYPE_LISTENER_LU62) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Listener.LU62");
        } else if (typeId.compareTo(TYPE_LISTENER_TCP) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Listener.TCP");
        } else if (typeId.compareTo(TYPE_LISTENER_NETBIOS) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Listener.NetBIOS");
        } else if (typeId.compareTo(TYPE_LISTENER_SPX) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Listener.SPX");
        } else {
            t.FFST(67, "UiListenerNewObjectProvider.getWizardCreatingTaskText", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return text;
    }
}

