/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.chlauth;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.chlauth.UiChlAuthWizFramework;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UiChlAuthWizPage5
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/chlauth/UiChlAuthWizPage5.java";
    private static final int HORIZONTAL_SPAN = 1;
    private static final int TEXT_WIDTH_HINT = 400;
    private static final String INSTANCE_ID_CHLAUTH_PROFILE_TABLE = "com.ibm.mq.explorer.qmgradmin.internal.chlauth.profile.table";
    private Message msgFile = null;
    private Text profileName = null;
    private Label profileContext = null;
    private ExplorerTable chlTable = null;
    private String currentProfileName = "";
    private int currentProfileType = -1;
    private boolean firstPass = true;

    public UiChlAuthWizPage5(String pageName) {
        super(pageName, "com.ibm.mq.explorer.ui.infopop.UI_NewWiz_ChlAuth_Page5");
        Trace t = Trace.getDefault();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Channel Authentication Records");
        String title = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Title");
        this.setTitle(title);
        String description = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Desc");
        this.setDescription(description);
    }

    public void nextPressed() {
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        UiChlAuthWizFramework wizard = (UiChlAuthWizFramework)this.getWizard();
        boolean enableNext = false;
        if (this.profileName != null && this.profileName.getText().length() > 0) {
            Pattern regularExpression = Pattern.compile("^[a-zA-Z0-9%/._*]+$");
            Matcher matcher = regularExpression.matcher(this.profileName.getText());
            boolean isValid = matcher.matches();
            if (isValid) {
                enableNext = true;
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.msgFile.getMessage(t, "UI.ChlAuth.Wiz.Err.InvalidProfile"));
                UiPlugin.getDisplay().beep();
            }
        } else if (!this.firstPass) {
            this.setErrorMessage(this.msgFile.getMessage(t, "UI.ChlAuth.Wiz.Err.NoProfile"));
        }
        this.firstPass = false;
        this.setPageComplete(enableNext);
        wizard.setFinish(false);
        wizard.getContainer().updateButtons();
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void createPageContent(final Trace t, Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
            ((GridLayout)layout).horizontalSpacing = 12;
        }
        Composite baseComp = parent;
        final Text txtIntro = new Text(baseComp, 66);
        txtIntro.setText(this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Intro"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)txtIntro, (boolean)true);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        txtIntro.setLayoutData((Object)gridData);
        baseComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)txtIntro);
            }
        });
        UiUtils.createBlankLine((Composite)baseComp, (int)1);
        Label lblMatch = new Label(baseComp, 64);
        lblMatch.setText(this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Text.Profile"));
        UiUtils.createControlDecoration((Trace)t, (Control)lblMatch, (int)0x1020000);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 16384;
        gridData.grabExcessHorizontalSpace = true;
        lblMatch.setLayoutData((Object)gridData);
        this.profileName = new Text(baseComp, 2048);
        this.profileName.setTextLimit(20);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.profileName.setLayoutData((Object)gridData);
        this.profileName.setFocus();
        this.profileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiChlAuthWizPage5.this.checkIfEnableButtons();
            }
        });
        Button btnMatch = new Button(baseComp, 8);
        btnMatch.setText(this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Button.ShowMatch"));
        btnMatch.setEnabled(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        gridData.grabExcessHorizontalSpace = false;
        btnMatch.setLayoutData((Object)gridData);
        UiUtils.createBlankLine((Composite)baseComp, (int)1);
        this.profileContext = new Label(baseComp, 64);
        this.profileContext.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        this.profileContext.setLayoutData((Object)gridData);
        Message msg = QmgradminPlugin.getMessages(t, "KEY_Channels");
        String genericObjectName = msg.getMessage(t, "UI.CHL.Channels.Title");
        String attributeOrder = "com.ibm.mq.explorer.orderid.channels";
        String objectId = "com.ibm.mq.explorer.channel";
        this.chlTable = new ExplorerTable(t, baseComp, 0, genericObjectName, false, false, false, false, (Object)"com.ibm.mq.explorer.contentpage.channels", 0, null, false);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 400;
        this.chlTable.setLayoutData((Object)gridData);
        this.chlTable.setObjectId(t, objectId);
        this.chlTable.setAttributeOrderId(t, attributeOrder);
        this.chlTable.setFilteringAvailable(t, false);
        this.chlTable.setTickCrossMode(t, false, null, null);
        this.chlTable.setInstance(t, INSTANCE_ID_CHLAUTH_PROFILE_TABLE, false);
        btnMatch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UiChlAuthWizPage5.this.updateChannelTable(t);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        UiChlAuthWizFramework wiz = (UiChlAuthWizFramework)this.getWizard();
        int type = wiz.getChlAuthType(t);
        if (this.profileContext != null) {
            this.updateContextSummary(t);
            UiUtils.resizeControl((Trace)t, (Control)this.profileContext);
        }
        if (!(this.profileName == null || this.chlTable == null || this.currentProfileName.equals(this.profileName.getText()) && this.currentProfileType == type)) {
            this.currentProfileType = type;
            if (!this.firstPass) {
                this.updateChannelTable(t);
            }
        }
        if (this.profileName != null) {
            if (visible) {
                if (type == 2) {
                    this.profileName.setText("*");
                    this.profileName.setEnabled(false);
                } else if (!this.firstPass) {
                    this.profileName.setText(this.currentProfileName);
                    this.profileName.setEnabled(true);
                }
            } else if (type != 2) {
                this.currentProfileName = this.profileName.getText();
            }
            this.profileName.setFocus();
        }
    }

    private void updateChannelTable(Trace t) {
        UiChlAuthWizFramework wiz = (UiChlAuthWizFramework)this.getWizard();
        MQQmgrExtObject extQmgrObj = wiz.getQueueManager();
        IUiMQObjectFactory uiMQObjectFactory = null;
        UiQueueManager uiQmgr = null;
        DmQueueManager dmQmgr = null;
        Object obj = extQmgrObj.getInternalObject();
        if (obj instanceof UiQueueManager) {
            uiQmgr = (UiQueueManager)obj;
            dmQmgr = uiQmgr.getDmQueueManagerObject();
            uiMQObjectFactory = uiQmgr.getFactoryClass(t, "com.ibm.mq.explorer.channel");
            try {
                DmObjectFilter dmFilter = new DmObjectFilter(t, "*", 25);
                ArrayList dmChannelList = dmQmgr.getObjects(t, dmFilter);
                this.chlTable.beginUpdate(t);
                this.chlTable.removeAll(t);
                int nx = 0;
                while (nx < dmChannelList.size()) {
                    DmChannel dmChannel = (DmChannel)dmChannelList.get(nx);
                    boolean fInsert = false;
                    switch (wiz.getChlAuthType(t)) {
                        case 2: 
                        case 3: 
                        case 4: {
                            fInsert = true;
                            break;
                        }
                        case 1: 
                        case 5: {
                            if (dmChannel.getObjectSubType(t) != 7 && dmChannel.getObjectSubType(t) != 11) break;
                            fInsert = true;
                            break;
                        }
                        case 6: {
                            if (dmChannel.getObjectSubType(t) == 7 || dmChannel.getObjectSubType(t) == 11) break;
                            fInsert = true;
                        }
                    }
                    if (fInsert && Pattern.matches(this.convertToRegEx(this.profileName.getText()), dmChannel.getTitle())) {
                        this.chlTable.addTableItem(t, uiMQObjectFactory.create(t, (IDmObject)dmChannel, (UiMQObject)uiQmgr));
                    }
                    ++nx;
                }
                this.chlTable.endUpdate(t);
            }
            catch (DmCoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void updateContextSummary(Trace t) {
        UiChlAuthWizFramework wizard = (UiChlAuthWizFramework)this.getWizard();
        String context = "";
        int type = wizard.getChlAuthType(t);
        if (type == 4 || type == 2) {
            context = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Context.Line1A");
        } else if (type == 1) {
            context = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Context.Line2A");
        } else if (type == 6) {
            context = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Context.Line3A");
        } else if (type == 3) {
            context = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Context.Line4A");
        } else if (type == 5) {
            context = this.msgFile.getMessage(t, "UI.ChlAuth.WizPage5.Context.Line5A");
        }
        this.profileContext.setText(context);
    }

    private String convertToRegEx(String searchStr) {
        StringBuffer regexStr = new StringBuffer(searchStr.length());
        regexStr.append('^');
        int nx = 0;
        while (nx < searchStr.length()) {
            char ch = searchStr.charAt(nx);
            switch (ch) {
                case '*': {
                    regexStr.append(".*");
                    break;
                }
                case '?': {
                    regexStr.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regexStr.append("\\");
                    regexStr.append(ch);
                    break;
                }
                default: {
                    regexStr.append(ch);
                }
            }
            ++nx;
        }
        regexStr.append('$');
        return regexStr.toString();
    }

    public String getProfileName() {
        Trace t = Trace.getDefault();
        UiChlAuthWizFramework wiz = (UiChlAuthWizFramework)this.getWizard();
        String name = "*";
        if (wiz.getChlAuthType(t) != 2) {
            name = this.profileName.getText();
        }
        return name;
    }
}

