/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.chlauth;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.chlauth.SelectChlAuthViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.chlauth.UiChlAuthFilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ViewerFilter;

public class UiChlAuthNewObjectProvider
extends NewObjectProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/chlauth/UiChlAuthNewObjectProvider.java";
    private static final String TYPE_BLOCKUSER = "com.ibm.mq.explorer.chlauth.blockuser";
    private static final String TYPE_BLOCKADDR = "com.ibm.mq.explorer.chlauth.blockaddr";
    private static final String TYPE_SSLPEERMAP = "com.ibm.mq.explorer.chlauth.sslpeermap";
    private static final String TYPE_ADDRESSMAP = "com.ibm.mq.explorer.chlauth.addressmap";
    private static final String TYPE_USERMAP = "com.ibm.mq.explorer.chlauth.usermap";
    private static final String TYPE_QMGRMAP = "com.ibm.mq.explorer.chlauth.qmgrmap";
    private static final String[] TYPES = new String[]{"com.ibm.mq.explorer.chlauth.blockuser", "com.ibm.mq.explorer.chlauth.blockaddr", "com.ibm.mq.explorer.chlauth.sslpeermap", "com.ibm.mq.explorer.chlauth.addressmap", "com.ibm.mq.explorer.chlauth.usermap", "com.ibm.mq.explorer.chlauth.qmgrmap"};
    private static final int[] SUBTYPE_IDS = new int[]{1, 2, 3, 4, 5, 6};
    private ArrayList<String> supportedTypes = null;
    private UiQueueManager uiQueueManager = null;
    private FilterProvider filterProvider = null;
    private Message msgFile = null;

    public UiChlAuthNewObjectProvider() {
    }

    public UiChlAuthNewObjectProvider(Trace t, UiMQObject parent) {
        super(t, parent);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        this.filterProvider = new UiChlAuthFilterProvider();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_NewObject");
    }

    public int getNewObjectTypeCount(Trace t) {
        int type_count = 0;
        if (this.supportedTypes == null) {
            this.supportedTypes = this.getSupportedTypes(t);
            type_count = this.supportedTypes.size();
        }
        return type_count;
    }

    private ArrayList<String> getSupportedTypes(Trace t) {
        ArrayList<String> supTypes = new ArrayList<String>();
        DmQueueManager dmQmgr = this.uiQueueManager.getDmQueueManagerObject();
        if (dmQmgr.getCommandLevel() >= 710) {
            int i = 0;
            while (i < SUBTYPE_IDS.length) {
                if (dmQmgr.isObjectSupported(t, 204, SUBTYPE_IDS[i])) {
                    supTypes.add(TYPES[i]);
                }
                ++i;
            }
        }
        return supTypes;
    }

    public String[] getNewObjectTypes(Trace t) {
        DmQueueManager dmQmgr = this.uiQueueManager.getDmQueueManagerObject();
        if (dmQmgr.getCommandLevel() >= 710 && this.supportedTypes == null) {
            this.supportedTypes = this.getSupportedTypes(t);
        }
        int size = this.supportedTypes.size();
        String[] objectTypes = this.supportedTypes.toArray(new String[size]);
        return objectTypes;
    }

    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return String.valueOf(this.getNameForNewObjectType(t, typeId)) + "...";
    }

    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        String helpId = null;
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_ChlAuth_BlockUser";
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_ChlAuth_BlockAddr";
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_ChlAuth_SSLPeerMap";
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_ChlAuth_AddressMap";
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_ChlAuth_UserMap";
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_ChlAuth_QmgrMap";
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getHelpIdForNewObjectType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return helpId;
    }

    public String getNameForNewObjectType(Trace t, String typeId) {
        String name = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Channel Authentication Records");
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.TypeBlockUser");
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.TypeBlockAddr");
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.TypeSSLPeerMap");
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.TypeAddressMap");
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.TypeUserMap");
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.TypeQmgrMap");
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getNameForNewObjectType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return name;
    }

    public String getDefaultLikeObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            name = "SYSTEM.DEF.BLOCKUSER";
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            name = "*";
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            name = "SYSTEM.DEF.SSLPEER";
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            name = "SYSTEM.DEF.ADDRESS";
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            name = "SYSTEM.DEF.USER";
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            name = "SYSTEM.DEF.QMGR";
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getDefaultLikeObjectName", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return name;
    }

    public String getGenericObjectName(Trace t) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Channel Authentication Records");
        String name = messageBundle.getMessage(t, "UI.CAUT.ChlAuth.Title");
        return name;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.chlauth";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.orderid.chlauth";
    }

    public boolean supportsDataModelListen(Trace t) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t) {
        return this.uiQueueManager.getDmQueueManagerObject();
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        return 204;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        int subType = -1;
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            subType = 1;
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            subType = 2;
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            subType = 3;
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            subType = 4;
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            subType = 5;
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            subType = 6;
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getDataModelObjectSubType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return subType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.chlauth");
    }

    public ViewerFilter getViewerFilter(Trace t, String typeId) {
        SelectChlAuthViewerFilter viewerFilter = new SelectChlAuthViewerFilter();
        viewerFilter.setHideBlockUserTypes(true);
        viewerFilter.setHideBlockAddrTypes(true);
        viewerFilter.setHideSSLPeerMapTypes(true);
        viewerFilter.setHideAddressMapTypes(true);
        viewerFilter.setHideUserMapTypes(true);
        viewerFilter.setHideQmgrMapTypes(true);
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            viewerFilter.setHideBlockUserTypes(false);
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            viewerFilter.setHideBlockAddrTypes(false);
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            viewerFilter.setHideSSLPeerMapTypes(false);
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            viewerFilter.setHideAddressMapTypes(false);
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            viewerFilter.setHideUserMapTypes(false);
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            viewerFilter.setHideQmgrMapTypes(false);
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getViewerFilter", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return viewerFilter;
    }

    public int[] getMandatoryAttributeIds(Trace t, String typeId) {
        int[] ids = null;
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)204, (int)1);
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)204, (int)2);
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)204, (int)3);
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)204, (int)4);
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)204, (int)5);
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)204, (int)6);
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getMandatoryAttributeIds", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return ids;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.filterid.chlauth";
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public Integer getQSGDisposition() {
        return null;
    }

    public String getWizardTitle(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.ChlAuth.BlockUser");
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.ChlAuth.BlockAddr");
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.ChlAuth.SSLPeerMap");
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.ChlAuth.AddressMap");
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.ChlAuth.UserMap");
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.ChlAuth.QmgrMap");
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getWizardTitle", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return title;
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.ChlAuth.BlockUser");
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.ChlAuth.BlockAddr");
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.ChlAuth.SSLPeerMap");
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.ChlAuth.AddressMap");
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.ChlAuth.UserMap");
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.ChlAuth.QmgrMap");
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getWizardPage1Title", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return title;
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        String desc = "";
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.ChlAuth.BlockUser");
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.ChlAuth.BlockAddr");
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.ChlAuth.SSLPeerMap");
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.ChlAuth.AddressMap");
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.ChlAuth.UserMap");
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.ChlAuth.QmgrMap");
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getWizardPage2Description", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return desc;
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        String text = "";
        if (typeId.compareTo(TYPE_BLOCKUSER) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.ChlAuth.BlockUser");
        } else if (typeId.compareTo(TYPE_BLOCKADDR) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.ChlAuth.BlockAddr");
        } else if (typeId.compareTo(TYPE_SSLPEERMAP) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.ChlAuth.SSLPeerMap");
        } else if (typeId.compareTo(TYPE_ADDRESSMAP) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.ChlAuth.AddressMap");
        } else if (typeId.compareTo(TYPE_USERMAP) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.ChlAuth.UserMap");
        } else if (typeId.compareTo(TYPE_QMGRMAP) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.ChlAuth.QmgrMap");
        } else {
            t.FFST(67, "UiChlAuthNewObjectProvider.getWizardCreatingTaskText", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return text;
    }
}

