/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.chlauth;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmChannelAuthenticationRecord;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.chlauth.ChlAuthCustomPropertyItemGroup;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionFilter;

public class UiChlAuth
extends UiMQObject
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/chlauth/UiChlAuth.java";
    private int chlauthType = -1;
    private String objectType = "";
    private UiQueueManager uiQueueManager = null;

    public UiChlAuth() {
    }

    public UiChlAuth(Trace t, IDmObject dmChlAuth, UiMQObject parent) {
        super(t, dmChlAuth);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Object_Types");
        this.objectType = msgFile.getMessage(t, "UI.OBJECT.Type.ChlAuth");
    }

    public String getId() {
        return "com.ibm.mq.explorer.chlauth";
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        uiDisplayGroup.getDisplayGroup().getId();
        boolean isCustomGrp = false;
        return isCustomGrp;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        uiDisplayGroup.getDisplayGroup().getId();
        if (Trace.isTracing) {
            t.data(67, "UiChlAuth.createCustomPropertyPage", 800, "No Custom Page to be displayed.");
        }
        CustomPropertyPage customPage = null;
        return customPage;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        boolean result = false;
        int attrID = attr.getAttributeID();
        if (attrID == 11601 || attrID == 1638 || attrID == 3527 || attrID == 1639 || attrID == 258) {
            result = true;
        }
        return result;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        ChlAuthCustomPropertyItemGroup customPropertyItem = null;
        int attrID = attr.getAttributeID();
        if (attrID == 11601) {
            customPropertyItem = new ChlAuthCustomPropertyItemGroup(t, parent, style, this, attr, readonly);
        }
        return customPropertyItem;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public String getNLSResourceFileKey() {
        return "KEY_Channel Authentication Records";
    }

    public void updateIcon() {
        Trace t = Trace.getDefault();
        int type = this.getChlAuthType(t);
        Image image = UiChlAuth.getUpdateIcon(t, type);
        super.setImage(image);
    }

    public static Image getUpdateIcon(Trace t, int chlauthType) {
        Image image = null;
        switch (chlauthType) {
            case 1: {
                image = Icons.get((String)Icons.iconkeyChlAuthBlockUser);
                break;
            }
            case 2: {
                image = Icons.get((String)Icons.iconkeyChlAuthBlockAddr);
                break;
            }
            case 3: {
                image = Icons.get((String)Icons.iconkeyChlAuthSSLPeerMap);
                break;
            }
            case 4: {
                image = Icons.get((String)Icons.iconkeyChlAuthAddressMap);
                break;
            }
            case 5: {
                image = Icons.get((String)Icons.iconkeyChlAuthUserMap);
                break;
            }
            case 6: {
                image = Icons.get((String)Icons.iconkeyChlAuthQmgrMap);
                break;
            }
            default: {
                image = null;
            }
        }
        return image;
    }

    public int getChlAuthType(Trace t) {
        if (this.chlauthType == -1) {
            this.chlauthType = ((DmChannelAuthenticationRecord)this.getDmObject()).getObjectSubType(t);
        }
        if (Trace.isTracing) {
            t.data(67, "UiChlAuth.getChlAuthType", 300, "Type for Channel Authentication Record'" + this.toString() + "' is " + this.chlauthType);
        }
        return this.chlauthType;
    }

    public int getDataModelObjectType(Trace t) {
        return 204;
    }

    public boolean isSupportDelete() {
        return true;
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        boolean result;
        Trace t;
        block25: {
            block23: {
                block24: {
                    t = Trace.getDefault();
                    if (Trace.isTracing) {
                        t.data(67, "UiChlAuth.testAttribute", 300, "testing object '" + target.toString() + "'");
                        t.data(67, "UiChlAuth.testAttribute", 300, "checking attribute '" + name + "'");
                        t.data(67, "UiChlAuth.testAttribute", 300, "for value '" + value + "'");
                    }
                    result = false;
                    UiMQObject targetObject = null;
                    if (target instanceof MQExtObject) {
                        MQExtObject mqExtObject = (MQExtObject)target;
                        targetObject = (UiMQObject)mqExtObject.getInternalObject();
                    }
                    if (targetObject == null || !(targetObject instanceof UiChlAuth)) break block23;
                    if (name.compareTo("Type") != 0) break block24;
                    int type = this.getChlAuthType(t);
                    switch (type) {
                        case 1: {
                            if (value.compareTo("Block User List") == 0) {
                                result = true;
                                break;
                            }
                            break block25;
                        }
                        case 2: {
                            if (value.compareTo("Block Address List") == 0) {
                                result = true;
                                break;
                            }
                            break block25;
                        }
                        case 3: {
                            if (value.compareTo("SSL Peer Map") == 0) {
                                result = true;
                                break;
                            }
                            break block25;
                        }
                        case 4: {
                            if (value.compareTo("Address Map") == 0) {
                                result = true;
                                break;
                            }
                            break block25;
                        }
                        case 5: {
                            if (value.compareTo("User Map") == 0) {
                                result = true;
                                break;
                            }
                            break block25;
                        }
                        case 6: {
                            if (value.compareTo("Queue Manager Map") == 0) {
                                result = true;
                                break;
                            }
                            break block25;
                        }
                        default: {
                            result = false;
                            break;
                        }
                    }
                    break block25;
                }
                int iResult = this.uiQueueManager.testQmgrAttribute(t, (Object)this.uiQueueManager, name, value);
                switch (iResult) {
                    case 1: {
                        result = true;
                        break;
                    }
                    case 0: {
                        result = false;
                        break;
                    }
                    case -1: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                    default: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                }
                break block25;
            }
            if (Trace.isTracing) {
                t.data(67, "UiChlAuth.testAttribute", 900, "Object is not a UiChlAuth");
            }
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(67, "UiChlAuth.testAttribute", 300, "returning " + result);
        }
        return result;
    }

    public boolean isAttributeValidToDisplay(int id) {
        boolean rc = false;
        if (id == 3527 || id == 258) {
            Trace t = Trace.getDefault();
            Attr attr = this.getDmObject().getAttribute(t, 1638, 0);
            if (attr != null) {
                Integer usrcValue = (Integer)attr.getValue(t);
                if (usrcValue == 0 && id == 3527) {
                    rc = true;
                } else if (usrcValue != 1 && id == 258) {
                    rc = true;
                }
            }
        } else if (id == 1639) {
            Trace t = Trace.getDefault();
            Integer type = (Integer)this.getDmObject().getAttribute(t, 1352, 0).getValue(t);
            if (type == 2 || type == 1) {
                rc = true;
            } else {
                Attr userSrc = this.getDmObject().getAttribute(t, 1638, 0);
                if (userSrc != null && (Integer)userSrc.getValue(t) == 1) {
                    rc = true;
                }
            }
        } else {
            rc = super.isAttributeValidToDisplay(id);
        }
        return rc;
    }
}

