/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.chlauth;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmChannelAuthenticationRecord;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.chlauth.UiChlAuth;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import com.ibm.mq.explorer.ui.internal.properties.UiAttr;
import java.util.ArrayList;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ChlAuthCustomPropertyItemGroup
extends CustomPropertyItem
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/chlauth/ChlAuthCustomPropertyItemGroup.java";
    private static final String EMPTY_STRING = "";
    private static final String NON_EMPTY_STRING = "{dummy}";
    private static final Integer LISTENER_TYPE_NOTIFY = 1;
    private UiChlAuth uiChlAuth = null;
    private Attr attrCombinedUserSrc = null;
    private UiAttr uiAttrCombinedUserSrc = null;
    private Attr attrUserSrc = null;
    private UiAttr uiAttrUserSrc = null;
    private Attr attrMcaUserId = null;
    private UiAttr uiAttrMcaUserId = null;
    private Attr attrWarning = null;
    private UiAttr uiAttrWarning = null;
    private Attr attrChckClnt = null;
    private UiAttr uiAttrChckClnt = null;
    protected Message msgFile = null;
    private Composite parent = null;
    private final int numColumns = 2;
    private boolean isMapType = true;
    private boolean isChckClntType = true;
    private int prevUSrcValue = -1;
    private int prevChckClntValue = 4;
    private int prevWarnValue = 0;
    private String prevMcaUserIdValue = "";

    public ChlAuthCustomPropertyItemGroup(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr att, boolean ro) {
        super(t, parent, style, uiMQObject, att, ro);
        Object job;
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_Properties");
        this.parent = parent;
        this.uiChlAuth = (UiChlAuth)uiMQObject;
        int type = ((DmChannelAuthenticationRecord)this.uiChlAuth.getDmObject()).getObjectSubType(t);
        if (type == 1 || type == 2) {
            this.isMapType = false;
        }
        if (type == 1 || type == 2 || type == 6) {
            this.isChckClntType = false;
        } else if (((DmChannelAuthenticationRecord)this.uiChlAuth.getDmObject()).getQueueManager().getCommandLevel() < 800) {
            this.isChckClntType = false;
        }
        this.attrCombinedUserSrc = att;
        IDmObject obj = this.uiChlAuth.getDmObject();
        if (this.isMapType) {
            this.attrUserSrc = obj.getAttribute(t, 1638, 0);
            this.attrMcaUserId = obj.getAttribute(t, 3527, 0);
            if (this.attrMcaUserId == null) {
                t.data(67, "ChlAuthCustomPropertyItemGroup.constructor", "MCA UserID is null. Creating MCA UserID with a blank value");
                job = obj.beginUpdate(t);
                obj.createAttribute(t, job, 3527, 0, (Object)EMPTY_STRING);
                this.attrMcaUserId = obj.getAttribute(t, 3527, 0);
                obj.endUpdate(t, job);
            }
        }
        this.attrWarning = obj.getAttribute(t, 1639, 0);
        if (this.attrWarning == null) {
            t.data(67, "ChlAuthCustomPropertyItemGroup.constructor", "attrWarning is null. Creating an attrWarning with value MQWARN_NO");
            job = obj.beginUpdate(t);
            obj.createAttribute(t, job, 1639, 0, (Object)0);
            this.attrWarning = obj.getAttribute(t, 1639, 0);
            obj.endUpdate(t, job);
        }
        if (this.isChckClntType) {
            this.attrChckClnt = obj.getAttribute(t, 258, 0);
            if (this.attrChckClnt == null) {
                t.data(67, "ChlAuthCustomPropertyItemGroup.constructor", "attrChckClnt is null. Creating an attrChckClnt with value MQCHK_AS_Q_MGR");
                job = obj.beginUpdate(t);
                obj.createAttribute(t, job, 258, 0, (Object)4);
                this.attrChckClnt = obj.getAttribute(t, 258, 0);
                obj.endUpdate(t, job);
            }
        }
    }

    public ArrayList<UiAttr> getUiAttrsArray() {
        ArrayList<UiAttr> uiAttrs = new ArrayList<UiAttr>();
        uiAttrs.add(this.uiAttrCombinedUserSrc);
        if (this.isMapType) {
            uiAttrs.add(this.uiAttrUserSrc);
            uiAttrs.add(this.uiAttrMcaUserId);
        }
        uiAttrs.add(this.uiAttrWarning);
        if (this.isChckClntType) {
            uiAttrs.add(this.uiAttrChckClnt);
        }
        return uiAttrs;
    }

    public void init(Trace t) {
        Group swtgroup = new Group(this.parent, 1);
        if (this.isMapType) {
            swtgroup.setText(this.msgFile.getMessage(t, "UI.CAUT.ChlAuth.MapGrpTitle"));
        } else {
            swtgroup.setText(this.msgFile.getMessage(t, "UI.CAUT.ChlAuth.BlkGrpTitle"));
        }
        Composite visibleControls = new Composite((Composite)swtgroup, 0);
        Composite invisibleControls = new Composite((Composite)swtgroup, 0);
        StackLayout stackLayout = new StackLayout();
        swtgroup.setLayout((Layout)stackLayout);
        stackLayout.topControl = visibleControls;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        visibleControls.setLayout((Layout)gridLayout);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        invisibleControls.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        swtgroup.setLayoutData((Object)gridData);
        PropertyControl pc = this.getUiDisplayGroup().getPropertyControl();
        DisplayGroup dg = this.getUiDisplayGroup().getDisplayGroup();
        Integer usrcValue = 1;
        if (this.isMapType) {
            this.uiAttrUserSrc = new UiAttr(t, this.attrUserSrc, dg);
            pc.addAttributeToPage(t, visibleControls, this.uiAttrUserSrc);
            this.uiAttrUserSrc.getAttributeControl().addModifyListener((IAttributeModifiedListener)this, LISTENER_TYPE_NOTIFY);
            this.uiAttrMcaUserId = new UiAttr(t, this.attrMcaUserId, dg);
            pc.addAttributeToPage(t, visibleControls, this.uiAttrMcaUserId);
            AttributeControl ac = this.uiAttrMcaUserId.getAttributeControl();
            int attrId = this.attrMcaUserId.getAttributeID();
            String attrName = this.attrMcaUserId.getAttrType().getPropTitle();
            Object value = this.attrMcaUserId.getValue(t);
            boolean present = value != null && value.toString().length() > 0;
            ac.addModifyListener((IAttributeModifiedListener)pc, PropertyControl.LISTENER_TYPE_MANDATORY);
            pc.sendMandatoryAttributeEvent(t, attrId, attrName, present);
            ac.addMandatoryDecoration(t);
            usrcValue = (Integer)this.attrUserSrc.getValue(t);
        }
        this.uiAttrWarning = new UiAttr(t, this.attrWarning, dg);
        pc.addAttributeToPage(t, visibleControls, this.uiAttrWarning);
        if (this.isChckClntType) {
            this.uiAttrChckClnt = new UiAttr(t, this.attrChckClnt, dg);
            pc.addAttributeToPage(t, visibleControls, this.uiAttrChckClnt);
        }
        this.uiAttrCombinedUserSrc = new UiAttr(t, this.attrCombinedUserSrc, dg);
        pc.addAttributeToPage(t, invisibleControls, this.uiAttrCombinedUserSrc);
        this.enableItems(t, usrcValue);
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        return false;
    }

    public void attrModified(AttributeModifiedEvent event) {
        Trace t = Trace.getDefault();
        String combinedName = EMPTY_STRING;
        Object objUserSrcValue = this.uiAttrUserSrc.getAttributeControl().getValue(t);
        if (!(objUserSrcValue instanceof Integer) && Trace.isTracing) {
            t.data(67, "ChlAuthCustomPropertyItemGroup.attrModified", 900, "Unexpected object type for User Source attribute control.  Expected Int.  Got: " + objUserSrcValue.getClass().toString());
        }
        this.enableItems(t, (Integer)objUserSrcValue);
        if ((Integer)objUserSrcValue == 0) {
            combinedName = this.uiAttrMcaUserId.getAttributeControl().toString();
        } else if ((Integer)objUserSrcValue == 1) {
            combinedName = this.uiAttrWarning.getAttributeControl().toString();
        } else if ((Integer)objUserSrcValue == 2) {
            combinedName = NON_EMPTY_STRING;
        }
        this.uiAttrCombinedUserSrc.getAttributeControl().setValue(t, (Object)combinedName);
        Object currValue = this.uiAttrMcaUserId.getAttributeControl().getValue(t);
        this.uiAttrMcaUserId.getAttributeControl().setValue(t, (Object)".");
        this.uiAttrMcaUserId.getAttributeControl().setValue(t, currValue);
    }

    public boolean isEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
    }

    private void enableItems(Trace t, int usrcValue) {
        if (usrcValue != this.prevUSrcValue) {
            IDmObject dmObj = this.uiChlAuth.getDmObject();
            if (this.isMapType) {
                this.prevMcaUserIdValue = ((String)dmObj.getAttribute(t, 3527, 0).getValue(t)).toString();
                this.uiAttrMcaUserId.getAttributeControl().getAssociatedLabel().setEnabled(usrcValue == 0);
                this.uiAttrMcaUserId.getAttributeControl().setEnabled(usrcValue == 0);
                this.uiAttrMcaUserId.setAlwaysMandatory(usrcValue == 0);
                if (!this.uiAttrMcaUserId.getAttributeControl().isEnabled()) {
                    this.uiAttrMcaUserId.getAttributeControl().setValue(t, (Object)this.prevMcaUserIdValue);
                }
            }
            this.prevWarnValue = (Integer)dmObj.getAttribute(t, 1639, 0).getValue(t);
            this.uiAttrWarning.getAttributeControl().getAssociatedLabel().setEnabled(usrcValue == 1);
            this.uiAttrWarning.getAttributeControl().setEnabled(usrcValue == 1);
            if (!this.uiAttrWarning.getAttributeControl().isEnabled()) {
                this.uiAttrWarning.getAttributeControl().setValue(t, (Object)this.prevWarnValue);
            }
            if (this.isChckClntType) {
                this.prevChckClntValue = (Integer)dmObj.getAttribute(t, 258, 0).getValue(t);
                this.uiAttrChckClnt.getAttributeControl().getAssociatedLabel().setEnabled(usrcValue != 1);
                this.uiAttrChckClnt.getAttributeControl().setEnabled(usrcValue != 1);
                if (!this.uiAttrChckClnt.getAttributeControl().isEnabled()) {
                    this.uiAttrChckClnt.getAttributeControl().setValue(t, (Object)this.prevChckClntValue);
                }
            }
            this.prevUSrcValue = usrcValue;
        }
    }
}

