/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.channels;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.channels.SelectChannelsViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.channels.UiChannelFilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ViewerFilter;

public class UiChannelNewObjectProvider
extends NewObjectProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/channels/UiChannelNewObjectProvider.java";
    private static final String TYPE_SENDER = "com.ibm.mq.explorer.channel.sender";
    private static final String TYPE_SERVER = "com.ibm.mq.explorer.channel.server";
    private static final String TYPE_RECEIVER = "com.ibm.mq.explorer.channel.receiver";
    private static final String TYPE_REQUESTER = "com.ibm.mq.explorer.channel.requester";
    private static final String TYPE_SVRCONN = "com.ibm.mq.explorer.channel.serverconn";
    private static final String TYPE_CLUSSDR = "com.ibm.mq.explorer.channel.cluster.sender";
    private static final String TYPE_CLUSRCVR = "com.ibm.mq.explorer.channel.cluster.receiver";
    private static final String TYPE_AMQP = "com.ibm.mq.explorer.channel.amqp";
    private static final String[] TYPES = new String[]{"com.ibm.mq.explorer.channel.sender", "com.ibm.mq.explorer.channel.server", "com.ibm.mq.explorer.channel.receiver", "com.ibm.mq.explorer.channel.requester", "com.ibm.mq.explorer.channel.serverconn", "com.ibm.mq.explorer.channel.cluster.sender", "com.ibm.mq.explorer.channel.cluster.receiver", "com.ibm.mq.explorer.channel.amqp"};
    private static final int[] SUBTYPE_IDS = new int[]{1, 2, 3, 4, 7, 9, 8, 11};
    private ArrayList<String> supportedTypes = null;
    private UiQueueManager uiQueueManager = null;
    private FilterProvider filterProvider = null;
    private Message msgFile = null;

    public UiChannelNewObjectProvider() {
    }

    public UiChannelNewObjectProvider(Trace t, UiMQObject parent) {
        super(t, parent);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        this.filterProvider = new UiChannelFilterProvider();
        this.msgFile = QmgradminPlugin.getMessages(t, "KEY_NewObject");
    }

    public int getNewObjectTypeCount(Trace t) {
        if (this.supportedTypes == null) {
            this.supportedTypes = this.getSupportedTypes(t);
        }
        return this.supportedTypes.size();
    }

    private ArrayList<String> getSupportedTypes(Trace t) {
        ArrayList<String> supTypes = new ArrayList<String>();
        DmQueueManager dmQmgr = this.uiQueueManager.getDmQueueManagerObject();
        int i = 0;
        while (i < SUBTYPE_IDS.length) {
            if (dmQmgr.isObjectSupported(t, 25, SUBTYPE_IDS[i])) {
                if (SUBTYPE_IDS[i] == 11) {
                    if (dmQmgr.isAMPQSupported(t)) {
                        supTypes.add(TYPES[i]);
                    }
                } else {
                    supTypes.add(TYPES[i]);
                }
            }
            ++i;
        }
        return supTypes;
    }

    public String[] getNewObjectTypes(Trace t) {
        this.supportedTypes = this.getSupportedTypes(t);
        int size = this.supportedTypes.size();
        return this.supportedTypes.toArray(new String[size]);
    }

    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return String.valueOf(this.getNameForNewObjectType(t, typeId)) + "...";
    }

    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        String helpId = null;
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_Sender";
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_Server";
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_Receiver";
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_Requester";
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_ServerConn";
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_ClusterSender";
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_ClusterReceiver";
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_NewMenuItem_Channel_AMQP";
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getHelpIdForNewObjectType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return helpId;
    }

    public String getNameForNewObjectType(Trace t, String typeId) {
        String name = null;
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Channels");
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeSender");
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeServer");
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeReceiver");
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeRequester");
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeServerConn");
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeClusterSender");
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeClusterReceiver");
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            name = messageBundle.getMessage(t, "UI.CHL.Channels.TypeAMQP");
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getNameForNewObjectType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return name;
    }

    public String getDefaultLikeObjectName(Trace t, String typeId) {
        String name = null;
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            name = "SYSTEM.DEF.SENDER";
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            name = "SYSTEM.DEF.SERVER";
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            name = "SYSTEM.DEF.RECEIVER";
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            name = "SYSTEM.DEF.REQUESTER";
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            name = "SYSTEM.DEF.SVRCONN";
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            name = "SYSTEM.DEF.CLUSSDR";
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            name = "SYSTEM.DEF.CLUSRCVR";
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            name = "SYSTEM.DEF.AMQP";
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getDefaultLikeObjectName", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return name;
    }

    public String getGenericObjectName(Trace t) {
        Message messageBundle = QmgradminPlugin.getMessages(t, "KEY_Channels");
        String name = messageBundle.getMessage(t, "UI.CHL.Channels.Title");
        return name;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.channel";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.orderid.channels";
    }

    public boolean supportsDataModelListen(Trace t) {
        return true;
    }

    public DmQueueManager getDmQueueManagerObject(Trace t) {
        return this.uiQueueManager.getDmQueueManagerObject();
    }

    public int getDataModelObjectType(Trace t, String typeId) {
        return 25;
    }

    public int getDataModelObjectSubType(Trace t, String typeId) {
        int subType = 1;
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            subType = 1;
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            subType = 2;
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            subType = 3;
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            subType = 4;
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            subType = 7;
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            subType = 9;
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            subType = 8;
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            subType = 11;
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getDataModelObjectSubType", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return subType;
    }

    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return this.uiQueueManager.getFactoryClass(t, "com.ibm.mq.explorer.channel");
    }

    public ViewerFilter getViewerFilter(Trace t, String typeId) {
        SelectChannelsViewerFilter viewerFilter = new SelectChannelsViewerFilter();
        viewerFilter.setHideSenderChannels(true);
        viewerFilter.setHideServerChannels(true);
        viewerFilter.setHideRequesterChannels(true);
        viewerFilter.setHideReceiverChannels(true);
        viewerFilter.setHideServerConnChannels(true);
        viewerFilter.setHideClusterSenderChannels(true);
        viewerFilter.setHideClusterReceiverChannels(true);
        viewerFilter.setHideClientConnChannels(true);
        viewerFilter.setHideAMQPChannels(true);
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            viewerFilter.setHideSenderChannels(false);
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            viewerFilter.setHideServerChannels(false);
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            viewerFilter.setHideReceiverChannels(false);
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            viewerFilter.setHideRequesterChannels(false);
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            viewerFilter.setHideServerConnChannels(false);
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            viewerFilter.setHideClusterSenderChannels(false);
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            viewerFilter.setHideClusterReceiverChannels(false);
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            viewerFilter.setHideAMQPChannels(false);
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getViewerFilter", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return viewerFilter;
    }

    public int[] getMandatoryAttributeIds(Trace t, String typeId) {
        int[] ids = null;
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)1);
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)2);
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)3);
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)4);
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)7);
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)9);
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)8);
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            ids = DmObject.getMandatoryIds((Trace)t, (int)25, (int)11);
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getMandatoryAttributeIds", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return ids;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.filterid.channels";
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public Integer getQSGDisposition() {
        return null;
    }

    public String getWizardTitle(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.Sender");
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.Server");
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.Receiver");
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.Requester");
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.ServerConn");
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.ClusterSender");
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.ClusterReceiver");
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.Wizard.Title.Channel.AMQP");
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getWizardTitle", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return title;
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        String title = "";
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.Sender");
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.Server");
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.Receiver");
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.Requester");
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.ServerConn");
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.ClusterSender");
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.ClusterReceiver");
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            title = this.msgFile.getMessage("UI.NewObject.WizPage1.Title.Channel.AMQP");
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getWizardPage1Title", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return title;
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        String desc = "";
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.Sender");
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.Server");
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.Receiver");
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.Requester");
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.ServerConn");
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.ClusterSender");
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.ClusterReceiver");
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            desc = this.msgFile.getMessage("UI.NewObject.WizPage2.Desc.Channel.AMQP");
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getWizardPage2Description", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return desc;
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        String text = "";
        if (typeId.compareTo(TYPE_SENDER) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.Sender");
        } else if (typeId.compareTo(TYPE_SERVER) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.Server");
        } else if (typeId.compareTo(TYPE_RECEIVER) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.Receiver");
        } else if (typeId.compareTo(TYPE_REQUESTER) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.Requester");
        } else if (typeId.compareTo(TYPE_SVRCONN) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.ServerConn");
        } else if (typeId.compareTo(TYPE_CLUSSDR) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.ClusterSender");
        } else if (typeId.compareTo(TYPE_CLUSRCVR) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.ClusterReceiver");
        } else if (typeId.compareTo(TYPE_AMQP) == 0) {
            text = this.msgFile.getMessage("UI.NewObject.Wizard.Creating.Channel.AMQP");
        } else {
            t.FFST(67, "UiChannelNewObjectProvider.getWizardCreatingTaskText", 10, 50999, 0, 0, "Invalid Object Type ID", typeId, null);
        }
        return text;
    }

    public boolean isObjectTypesDynamic() {
        return true;
    }
}

