/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.channels;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionPing;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionPurge;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionReset;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionResolve;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionStart;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionStop;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelClusterPropertyPage;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelSSLPropertyPage;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public class UiChannel
extends UiMQObject
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/channels/UiChannel.java";
    private String objectType = "";
    private UiQueueManager uiQueueManager = null;
    private int channelType = -1;
    private Action actionStart = null;
    private Action actionStop = null;
    private Action actionResolve = null;
    private Action actionPing = null;
    private Action actionReset = null;
    private Action actionPurge = null;
    private static String startMenuText = null;
    private static String stopMenuText = null;
    private static String resolveMenuText = null;
    private static String pingMenuText = null;
    private static String resetMenuText = null;
    private static String purgeMenuText = null;

    public UiChannel() {
    }

    public UiChannel(Trace t, IDmObject dmChannelObj, UiMQObject parent) {
        super(t, dmChannelObj);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        Message msgFile = QmgradminPlugin.getMessages(t, "KEY_Object_Types");
        this.objectType = msgFile.getMessage(t, "UI.OBJECT.Type.Channel");
        if (startMenuText == null) {
            startMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Start.Menu");
            stopMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Stop.Menu");
            resolveMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Resolve.Menu");
            pingMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Ping.Menu");
            resetMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Reset.Menu");
            purgeMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Purge.Menu");
        }
    }

    public void appendToContextMenu(Shell theShell, IMenuManager manager, Object contextObject) {
        DmChannel dmChl;
        Attr a;
        Trace t = Trace.getDefault();
        if (this.actionStart == null) {
            this.actionStart = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiChannel.this.startMenuAction(trace);
                }
            };
            this.actionStart.setText(startMenuText);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionStart, "com.ibm.mq.explorer.ui.infopop.UI_ChannelStartMenuItem");
        }
        if (this.actionStop == null) {
            this.actionStop = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiChannel.this.stopMenuAction(trace);
                }
            };
            this.actionStop.setText(stopMenuText);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionStop, "com.ibm.mq.explorer.ui.infopop.UI_ChannelStopMenuItem");
        }
        if (this.actionResolve == null) {
            this.actionResolve = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiChannel.this.resolveMenuAction(trace);
                }
            };
            this.actionResolve.setText(resolveMenuText);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionResolve, "com.ibm.mq.explorer.ui.infopop.UI_ChannelResolveMenuItem");
        }
        if (this.actionPing == null) {
            this.actionPing = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiChannel.this.pingMenuAction(trace);
                }
            };
            this.actionPing.setText(pingMenuText);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionPing, "com.ibm.mq.explorer.ui.infopop.UI_ChannelPingMenuItem");
        }
        if (this.actionReset == null) {
            this.actionReset = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiChannel.this.resetMenuAction(trace);
                }
            };
            this.actionReset.setText(resetMenuText);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionReset, "com.ibm.mq.explorer.ui.infopop.UI_ChannelResetMenuItem");
        }
        if (this.actionPurge == null) {
            this.actionPurge = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiChannel.this.purgeMenuAction(trace);
                }
            };
            this.actionPurge.setText(purgeMenuText);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionPurge, "com.ibm.mq.explorer.ui.infopop.UI_ChannelPurgeMenuItem");
        }
        if ((a = (dmChl = (DmChannel)this.getDmObject()).getAttribute(t, 1527, 0)) != null) {
            int i = (Integer)a.getValue(t);
            switch (i) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 13: {
                    manager.add((IAction)this.actionStop);
                    break;
                }
                case 8: {
                    manager.add((IAction)this.actionStart);
                    break;
                }
                default: {
                    manager.add((IAction)this.actionStart);
                    manager.add((IAction)this.actionStop);
                }
            }
        }
        manager.add((IContributionItem)new Separator());
        switch (this.getChannelType(t)) {
            case 1: 
            case 2: 
            case 9: {
                manager.add((IAction)this.actionResolve);
                manager.add((IAction)this.actionPing);
                manager.add((IAction)this.actionReset);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                manager.add((IAction)this.actionReset);
                break;
            }
            case 7: {
                break;
            }
            case 11: {
                manager.add((IAction)this.actionPurge);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(67, "UiChannel.appendToContextMenu", 900, "Unrecognised channel type");
            }
        }
        super.appendToContextMenu(theShell, manager, contextObject);
    }

    public String getId() {
        return "com.ibm.mq.explorer.channel";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 10: 
            case 11: {
                isCustom = true;
            }
        }
        return isCustom;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        CustomPropertyPage customPage = null;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 10: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new ChannelClusterPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiChannel.createCustomPropertyPage", 800, "Channel Cluster Property Custom Page to be displayed.");
                break;
            }
            case 11: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new ChannelSSLPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiChannel.createCustomPropertyPage", 800, "Channel SSL Property Custom Page to be displayed.");
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(67, "UiChannel.createCustomPropertyPage", 800, "No Custom Page to be displayed.");
            }
        }
        return customPage;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public String getNLSResourceFileKey() {
        return "KEY_Channels";
    }

    public void updateIcon() {
        int i;
        Trace t = Trace.getDefault();
        Image image = null;
        int chanType = this.getChannelType(t);
        int chanStatus = this.getChannelStatus(t);
        boolean qdispGroup = false;
        Attr attr = this.getDmObject().getAttribute(t, 63, 0);
        if (attr != null && (i = ((Integer)attr.getValue(t)).intValue()) == 3) {
            qdispGroup = true;
        }
        image = UiChannel.getUpdateIcon(t, chanType, chanStatus, qdispGroup);
        super.setImage(image);
    }

    public static Image getUpdateIcon(Trace t, int chanType, int chanStatus, boolean qdispGroup) {
        Image image = null;
        if (qdispGroup) {
            switch (chanType) {
                case 6: {
                    break;
                }
                case 8: {
                    image = Icons.get((String)Icons.iconkeyQSGclusterReceiverChannel);
                    break;
                }
                case 9: {
                    image = Icons.get((String)Icons.iconkeyQSGclusterSenderChannel);
                    break;
                }
                case 3: {
                    image = Icons.get((String)Icons.iconkeyQSGreceiverChannel);
                    break;
                }
                case 4: {
                    image = Icons.get((String)Icons.iconkeyQSGrequestorChannel);
                    break;
                }
                case 1: {
                    image = Icons.get((String)Icons.iconkeyQSGsenderChannel);
                    break;
                }
                case 2: {
                    image = Icons.get((String)Icons.iconkeyQSGserverChannel);
                    break;
                }
                case 7: {
                    image = Icons.get((String)Icons.iconkeyQSGserverConnection);
                    break;
                }
                case 11: {
                    image = Icons.get((String)Icons.iconkeyQSGamqpChannel);
                    break;
                }
            }
        } else {
            block11 : switch (chanType) {
                case 6: {
                    image = Icons.get((String)Icons.iconkeyClientConnection);
                    break;
                }
                case 8: {
                    image = Icons.get((String)Icons.iconkeyclusterReceiverSmall);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeyclusterReceiverRunningSmall);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeyclusterReceiverAlertSmall);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeyclusterReceiverStoppedSmall);
                            break block11;
                        }
                    }
                    break;
                }
                case 9: {
                    image = Icons.get((String)Icons.iconkeyclusterSenderSmall);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeyclusterSenderRunningSmall);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeyclusterSenderAlertSmall);
                            break block11;
                        }
                        case 5: 
                        case 14: {
                            image = Icons.get((String)Icons.iconkeyclusterSenderWarningSmall);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeyclusterSenderStoppedSmall);
                            break block11;
                        }
                    }
                    break;
                }
                case 3: {
                    image = Icons.get((String)Icons.iconkeyChannelReceiver);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeychannelReceiverRunning);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeychannelReceiverAlert);
                            break block11;
                        }
                        case 5: {
                            image = Icons.get((String)Icons.iconkeychannelReceiverWarning);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeychannelReceiverStopped);
                            break block11;
                        }
                    }
                    break;
                }
                case 4: {
                    image = Icons.get((String)Icons.iconkeyChannelRequester);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeychannelRequesterRunning);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeychannelRequesterAlert);
                            break block11;
                        }
                        case 5: {
                            image = Icons.get((String)Icons.iconkeychannelRequesterWarning);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeychannelRequesterStopped);
                            break block11;
                        }
                    }
                    break;
                }
                case 1: {
                    image = Icons.get((String)Icons.iconkeyChannelSender);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeychannelSenderRunning);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeychannelSenderAlert);
                            break block11;
                        }
                        case 5: {
                            image = Icons.get((String)Icons.iconkeychannelSenderWarning);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeychannelSenderStopped);
                            break block11;
                        }
                    }
                    break;
                }
                case 2: {
                    image = Icons.get((String)Icons.iconkeyChannelServer);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeychannelServerRunning);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeychannelServerAlert);
                            break block11;
                        }
                        case 5: {
                            image = Icons.get((String)Icons.iconkeychannelServerWarning);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeychannelServerStopped);
                            break block11;
                        }
                    }
                    break;
                }
                case 7: {
                    image = Icons.get((String)Icons.iconkeyServerConnection);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeyserverConnectionRunning);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeyserverConnectionAlert);
                            break block11;
                        }
                        case 5: {
                            image = Icons.get((String)Icons.iconkeyserverConnectionWarning);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeyserverConnectionStopped);
                            break block11;
                        }
                    }
                    break;
                }
                case 11: {
                    image = Icons.get((String)Icons.iconkeyChannelAMQP);
                    switch (chanStatus) {
                        case 3: {
                            image = Icons.get((String)Icons.iconkeychannelAMQPRunning);
                            break block11;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 13: {
                            image = Icons.get((String)Icons.iconkeychannelAMQPAlert);
                            break block11;
                        }
                        case 5: {
                            image = Icons.get((String)Icons.iconkeychannelAMQPWarning);
                            break block11;
                        }
                        case 0: 
                        case 6: 
                        case 8: {
                            image = Icons.get((String)Icons.iconkeychannelAMQPStopped);
                            break block11;
                        }
                    }
                    break;
                }
            }
        }
        return image;
    }

    private int getChannelStatus(Trace t) {
        DmChannel dmChl = (DmChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 1527, 0);
        int i = -999;
        if (a != null) {
            i = (Integer)a.getValue(t);
        }
        return i;
    }

    public int getDataModelObjectType(Trace t) {
        return 25;
    }

    public boolean isSupportDelete() {
        return true;
    }

    private void startMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionStart(t, this.shell, dmChannel);
    }

    private void stopMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionStop(t, this.shell, dmChannel);
    }

    private void purgeMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionPurge(t, this.shell, dmChannel);
    }

    private void pingMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionPing(t, this.shell, dmChannel);
    }

    private void resolveMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionResolve(t, this.shell, dmChannel);
    }

    private void resetMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionReset(t, this.shell, dmChannel);
    }

    public UiQueueManager getOwningUiQueueManager() {
        return this.uiQueueManager;
    }

    public int getChannelType(Trace t) {
        if (this.channelType == -1) {
            this.channelType = ((DmChannel)this.getDmObject()).getObjectSubType(t);
        }
        int chlType = this.channelType;
        if (Trace.isTracing) {
            t.data(67, "UiChannel.getChannelType", 300, "Type for Channel '" + this.toString() + "' is " + chlType);
        }
        return chlType;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "UiChannel.testAttribute", 300, "testing object '" + target.toString() + "'");
            t.data(67, "UiChannel.testAttribute", 300, "checking attribute '" + name + "'");
            t.data(67, "UiChannel.testAttribute", 300, "for value '" + value + "'");
        }
        boolean result = false;
        UiMQObject targetObject = null;
        if (target instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)target;
            targetObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (targetObject != null && targetObject instanceof UiChannel) {
            if (name.compareTo("ChannelType") == 0) {
                int chType = this.getChannelType(t);
                if (value.compareTo("Sender") == 0 && chType == 1) {
                    result = true;
                } else if (value.compareTo("Server") == 0 && chType == 2) {
                    result = true;
                } else if (value.compareTo("Receiver") == 0 && chType == 3) {
                    result = true;
                } else if (value.compareTo("Requester") == 0 && chType == 4) {
                    result = true;
                } else if (value.compareTo("ServerConnection") == 0 && chType == 7) {
                    result = true;
                } else if (value.compareTo("ClientConnection") == 0 && chType == 6) {
                    result = true;
                } else if (value.compareTo("ClusterSender") == 0 && chType == 9) {
                    result = true;
                } else if (value.compareTo("ClusterReceiver") == 0 && chType == 8) {
                    result = true;
                } else if (value.compareTo("AMQP") == 0 && chType == 11) {
                    result = true;
                }
            } else if (name.compareTo("ChannelOverallStatus") == 0) {
                Attr attr = this.getDmObject().getAttribute(t, 1527, 0);
                if (attr != null && attr instanceof AttrInt) {
                    Integer intStatus = (Integer)((AttrInt)attr).getValue(t);
                    int status = intStatus;
                    if (value.compareTo("Binding") == 0 && status == 1) {
                        result = true;
                    } else if (value.compareTo("Inactive") == 0 && status == 0) {
                        result = true;
                    } else if (value.compareTo("Initializing") == 0 && status == 13) {
                        result = true;
                    } else if (value.compareTo("Paused") == 0 && status == 8) {
                        result = true;
                    } else if (value.compareTo("Requesting") == 0 && status == 7) {
                        result = true;
                    } else if (value.compareTo("Retrying") == 0 && status == 5) {
                        result = true;
                    } else if (value.compareTo("Running") == 0 && status == 3) {
                        result = true;
                    } else if (value.compareTo("Starting") == 0 && status == 2) {
                        result = true;
                    } else if (value.compareTo("Stopped") == 0 && status == 6) {
                        result = true;
                    } else if (value.compareTo("Stopping") == 0 && status == 4) {
                        result = true;
                    } else if (value.compareTo("Switching") == 0 && status == 14) {
                        result = true;
                    }
                }
            } else {
                int iResult = this.uiQueueManager.testQmgrAttribute(t, (Object)this.uiQueueManager, name, value);
                switch (iResult) {
                    case 1: {
                        result = true;
                        break;
                    }
                    case 0: {
                        result = false;
                        break;
                    }
                    default: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(67, "UiChannel.testAttribute", 900, "Object is not a UiChannel");
            }
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(67, "UiChannel.testAttribute", 300, "returning " + result);
        }
        return result;
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public boolean isSelectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter) {
        return true;
    }

    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh) {
        String selectedAttributeObjectName = this.uiQueueManager.selectAttributeObjectFromDmObjectFilter(t, attrId, dmObjectFilter, currentSelection, helpId, sh, this.getSelectObjectDialogTitle(t, attrId), this.getSelectObjectDialogDescription(t, attrId), true);
        return selectedAttributeObjectName;
    }

    private String getSelectObjectDialogTitle(Trace t, int attrId) {
        String template = UiPlugin.getNLSString((Trace)t, (String)"KEY_Properties", (String)"UI.Objects.Select.Title");
        String title = Message.format((String)template, (String)DmChannel.getAttributeTitle((Trace)t, (int)attrId));
        return title;
    }

    private String getSelectObjectDialogDescription(Trace t, int attrId) {
        return this.getSelectObjectDialogTitle(t, attrId);
    }

    public void deleteMenuAction(Trace t) {
        DmChannel dmChl = (DmChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 1527, 0);
        if (a != null) {
            Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)this.getNLSResourceFileKey());
            int i = (Integer)a.getValue(t);
            if (i != 0 && i != 6) {
                String msg = msgFile.getMessage(t, "UI.QMGRS.DeleteRunningChannel.Text", this.toString());
                int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.shell, (String)msg, (int)1, null);
                if (rc == 0) {
                    int result = dmChl.actionStop(t, null);
                    if (result == 0) {
                        if (this.isDeleteSystemObject(t, this.shell)) {
                            String busyMsg = "";
                            if (msgFile != null) {
                                busyMsg = msgFile.getMessage(t, "UI.GENERAL.BUSY.DELETE", this.toString());
                            }
                            this.busyDialog = new BusyDialog(this.shell, busyMsg);
                            this.getDmObject().actionDelete(t, (DmActionListener)this, null);
                            this.busyDialog.showDialog(t);
                        }
                    } else {
                        String failMsg = msgFile.getMessage(t, "UI.QMGRS.FailStopChannelForDelete.Text", this.toString());
                        MessageBox.showMessageFailure((Trace)t, (Shell)this.shell, (String)failMsg);
                    }
                }
            } else {
                super.deleteMenuAction(t);
            }
        } else {
            super.deleteMenuAction(t);
        }
    }

    public List<Integer> getGroupExclusions(Trace t) {
        ArrayList<Integer> exclusions = new ArrayList<Integer>();
        int chType = this.getChannelType(t);
        if (this.uiQueueManager.getPlatform(t) == 27 && (chType == 4 || chType == 3)) {
            exclusions.add(8);
        }
        return exclusions;
    }
}

