/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.qmgradmin.internal.actions.QmgrAction;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.NotificationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.ConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleDialog;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.queuemanager.SelectStartQmgrModeDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class StartQueueManagerAction
extends QmgrAction
implements IConsoleDialogUser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/actions/StartQueueManagerAction.java";
    public static final int STRMQM_ALREADY_RUNNING_EXITVALUE = 5;
    public static final int STRMQCSV_ALREADY_RUNNING_EXITVALUE = 20;
    public static final int STRMQM_STANDBY_INSTANCE_RUNNING_EXITVALUE = 30;
    private static final String WIN32 = "win32";
    private static final String STRMQM = "strmqm ";
    private static final String STRMQM_AUTOMATIC = "strmqm -sa ";
    private static final String STRMQM_SERVICE = "strmqm -ss ";
    private static final String STRMQM_INTERACTIVE = "strmqm -si ";
    private static final String PERMIT_STANDBY_PARAMETER = " -x ";
    private static String startTextDetail = null;
    private static String startTextGeneral = null;
    private String queueManagerName;
    private ConsoleDialog dialog;
    private ArrayList<ConsoleCommand> commandList;
    private static final int UNITS_PER_QM = 100;
    private static final int INITIAL_DELAY = 20;
    private static final float DELAY_INCREASE_FACTOR = 1.05f;
    private boolean multiSelectChosen = false;
    private boolean dlgConfirmed = false;
    private static int dlgSelectedMode;
    private static boolean dlgStandbyMode;
    private boolean cancelFlag = false;

    public void run(IAction action) {
        if (this.structuredSelection != null) {
            final List<MQQmgrExtObject> qmgrs = this.getQmgrExtObjectsFromSelection(this.structuredSelection);
            final Message msgFile = QmgradminPlugin.getMessages(Trace.getDefault(), "KEY_General");
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) {
                        String taskName;
                        Trace t2 = Trace.getDefault();
                        int total = qmgrs.size();
                        int count = 1;
                        if (total == 1) {
                            taskName = msgFile.getMessage(t2, "UI.QMGRS.Start.Dlg.Text");
                            StartQueueManagerAction.this.multiSelectChosen = false;
                        } else {
                            taskName = msgFile.getMessage(t2, "UI.QMGRS.Start.Multi.Dlg.Text");
                            StartQueueManagerAction.this.multiSelectChosen = true;
                        }
                        monitor.beginTask(taskName, total * 100);
                        if (startTextDetail == null) {
                            Message msgFile2 = UiPlugin.getUIMessages((Trace)t2, (String)"KEY_Queue Manager");
                            startTextDetail = msgFile2.getMessage(t2, "UI.QMGRS.StartDetail.Text");
                            startTextGeneral = msgFile2.getMessage(t2, "UI.QMGRS.StartGeneral.Text");
                        }
                        for (MQQmgrExtObject mqQmgrExtObject : qmgrs) {
                            final UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
                            if (count > 1) {
                                StartQueueManagerAction.this.dlgConfirmed = true;
                            }
                            String subtaskName = msgFile.getMessage(t2, "UI.QMGRS.Starting.Text", String.valueOf(count), String.valueOf(total), uiQueueManager.getTreeName());
                            monitor.subTask(subtaskName);
                            ++count;
                            final boolean[] done = new boolean[]{false};
                            final int[] workRemaining = new int[]{100};
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    int delay = 20;
                                    while (!done[0]) {
                                        if (workRemaining[0] > 0) {
                                            monitor.worked(1);
                                            workRemaining[0] = workRemaining[0] - 1;
                                        }
                                        try {
                                            Thread.sleep(delay);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        delay = (int)((float)delay * 1.05f);
                                    }
                                }
                            };
                            new Thread(r).start();
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Trace t = Trace.getDefault();
                                    StartQueueManagerAction.this.open(t, uiQueueManager);
                                }
                            });
                            if (workRemaining[0] > 0) {
                                monitor.worked(workRemaining[0]);
                            }
                            if (monitor.isCanceled()) break;
                        }
                        StartQueueManagerAction.this.dlgConfirmed = false;
                        StartQueueManagerAction.this.multiSelectChosen = false;
                        StartQueueManagerAction.this.cancelFlag = false;
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean open(Trace t, UiQueueManager qmgr) {
        boolean result = true;
        this.queueManagerName = qmgr.toString();
        if (!this.dlgConfirmed) {
            SelectStartQmgrModeDialog dlg = new SelectStartQmgrModeDialog(t, UiPlugin.getShell());
            Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Queue Manager");
            String startText = "";
            String startTitle = "";
            if (this.multiSelectChosen) {
                startText = "UI.QMGRS.Start.Multi.Text";
                startTitle = "UI.QMGRS.Start.Multi.Title";
            } else {
                startText = "UI.QMGRS.Start.Text";
                startTitle = "UI.QMGRS.Start.Title";
            }
            dlg.setMessage(t, msgFile.getMessage(startText, this.queueManagerName), -1);
            dlg.setTitle(t, msgFile.getMessage(startTitle, this.queueManagerName));
            dlg.setRunningElsewhere(qmgr.isRunningElsewhere());
            if (dlg.open() == 0) {
                dlgSelectedMode = dlg.getStartMode();
                dlgStandbyMode = dlg.isPermitStandbySelected();
                this.perform(t, dlgSelectedMode, dlgStandbyMode, qmgr);
            } else {
                this.cancelFlag = true;
            }
        } else if (!this.cancelFlag) {
            this.perform(t, dlgSelectedMode, dlgStandbyMode, qmgr);
        }
        return result;
    }

    public void perform(Trace t, int startupType, boolean permitStandby, UiQueueManager qmgr) {
        StringBuffer command = new StringBuffer();
        this.commandList = new ArrayList();
        Shell parentShell = UiPlugin.getShell();
        NotificationManager notificationManager = UiPlugin.getNotificationManager();
        ExplorerNotifyEvent notifyEvent = new ExplorerNotifyEvent((Object)qmgr.getExternalObject(), null);
        notificationManager.notifyQueueManagerStarted(t, notifyEvent);
        qmgr.getDmQueueManagerObject().connectAsynchronously(t);
        String strmqmCommand = null;
        String platform = SWT.getPlatform();
        strmqmCommand = WIN32.equals(platform) ? (startupType == 1 ? STRMQM_AUTOMATIC : (startupType == 0 ? STRMQM_INTERACTIVE : (startupType == 2 ? STRMQM_SERVICE : STRMQM))) : STRMQM;
        if (permitStandby) {
            strmqmCommand = String.valueOf(strmqmCommand) + PERMIT_STANDBY_PARAMETER;
        }
        this.dialog = new ConsoleDialog(t, parentShell, (IConsoleDialogUser)this);
        this.dialog.setTitle(Message.format((String)startTextDetail, (String)qmgr.toString()));
        this.dialog.setHelp("com.ibm.mq.explorer.ui.infopop.UI_QueueManagerStartDialog");
        command.setLength(0);
        command.append(strmqmCommand);
        command.append(qmgr.toString());
        ConsoleCommand c = new ConsoleCommand(startTextGeneral, command.toString());
        c.addExitValue(0);
        c.addExitValue(5);
        c.addExitValue(30);
        this.commandList.add(c);
        Display display = parentShell.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                StartQueueManagerAction.this.dialog.execute(tr, StartQueueManagerAction.this.commandList);
            }
        });
        UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
    }

    public void finished(Trace t, int id, boolean result) {
        UiPlugin.getTheDataModel().refreshDmMonitor(t);
    }
}

