/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.actions.QmgrAction;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.NotificationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.AbstractConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleDialog;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.SelectStopQmgrModeDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class EndQueueManagerAction
extends QmgrAction
implements IConsoleDialogUser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/actions/EndQueueManagerAction.java";
    private static final int UNITS_PER_QM = 100;
    private static final int INITIAL_DELAY = 20;
    private static final float DELAY_INCREASE_FACTOR = 1.05f;
    public static int ACTION_CONTROLLED = 0;
    public static int ACTION_IMMEDIATE = 1;
    private DmQueueManager dmQueueManager;
    private static String endingText1 = null;
    private ConsoleDialog consoleDialog;
    private boolean dlgConfirmed = false;
    private static boolean dlgStandbyInstance;
    private static boolean dlgNonStandbyInstance;
    private boolean multiSelectChosen = false;
    private static boolean dlgClientReconnectSelected;
    private static int dlgSelectedMode;
    private static boolean dlgSwitchOverSelected;
    private static boolean dlgPermitStandbyMode;
    private boolean cancelFlag = false;
    private ArrayList<AbstractConsoleCommand> commandList;
    protected int defaultAction = ACTION_CONTROLLED;
    public static final int STRMQCSV_ALREADY_RUNNING_EXITVALUE = 20;

    public void run(IAction action) {
        if (this.structuredSelection != null) {
            final List<MQQmgrExtObject> qmgrs = this.getQmgrExtObjectsFromSelection(this.structuredSelection);
            final Message msgFile = QmgradminPlugin.getMessages(Trace.getDefault(), "KEY_General");
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) {
                        String taskName;
                        Trace t2 = Trace.getDefault();
                        int total = qmgrs.size();
                        int count = 1;
                        if (total == 1) {
                            taskName = msgFile.getMessage(t2, "UI.QMGRS.End.Dlg.Text");
                        } else {
                            taskName = msgFile.getMessage(t2, "UI.QMGRS.End.Multi.Dlg.Text");
                            EndQueueManagerAction.this.multiSelectChosen = true;
                        }
                        monitor.beginTask(taskName, total * 100);
                        if (endingText1 == null) {
                            endingText1 = UiPlugin.getNLSString((Trace)t2, (String)"KEY_Queue Manager", (String)"UI.QMGRS.EndGeneral.Text");
                        }
                        for (MQQmgrExtObject mqQmgrExtObject : qmgrs) {
                            UiQueueManager qmgr = (UiQueueManager)mqQmgrExtObject.getInternalObject();
                            EndQueueManagerAction.this.dmQueueManager = qmgr.getDmQueueManagerObject();
                            if (EndQueueManagerAction.this.dmQueueManager.isStandbyPermitted()) {
                                dlgStandbyInstance = true;
                                continue;
                            }
                            dlgNonStandbyInstance = true;
                        }
                        for (MQQmgrExtObject mqQmgrExtObject : qmgrs) {
                            final UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
                            if (count > 1) {
                                EndQueueManagerAction.this.dlgConfirmed = true;
                            }
                            String subtaskName = msgFile.getMessage(t2, "UI.QMGRS.Ending1.Text", String.valueOf(count), String.valueOf(total), uiQueueManager.getTreeName());
                            monitor.subTask(subtaskName);
                            ++count;
                            final boolean[] done = new boolean[]{false};
                            final int[] workRemaining = new int[]{100};
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    int delay = 20;
                                    while (!done[0]) {
                                        if (workRemaining[0] > 0) {
                                            monitor.worked(1);
                                            workRemaining[0] = workRemaining[0] - 1;
                                        }
                                        try {
                                            Thread.sleep(delay);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        delay = (int)((float)delay * 1.05f);
                                    }
                                }
                            };
                            new Thread(r).start();
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Trace t = Trace.getDefault();
                                    EndQueueManagerAction.this.open(t, uiQueueManager);
                                }
                            });
                            done[0] = true;
                            if (workRemaining[0] > 0) {
                                monitor.worked(workRemaining[0]);
                            }
                            if (monitor.isCanceled()) break;
                        }
                        EndQueueManagerAction.this.dlgConfirmed = false;
                        dlgStandbyInstance = false;
                        dlgNonStandbyInstance = false;
                        EndQueueManagerAction.this.multiSelectChosen = false;
                        EndQueueManagerAction.this.cancelFlag = false;
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean open(Trace t, UiQueueManager qmgr) {
        ExplorerNotifyEvent notifyEvent;
        boolean result = true;
        this.dmQueueManager = qmgr.getDmQueueManagerObject();
        NotificationManager notificationManager = UiPlugin.getNotificationManager();
        if (!notificationManager.notifyIsPreventStopQueueManager(t, notifyEvent = new ExplorerNotifyEvent((Object)qmgr.getExternalObject(), null))) {
            if (this.dmQueueManager.isStandby()) {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4612", (String)qmgr.toString());
                int reply = MessageBox.showYesNoMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)msg, (int)1, (String)"AMQ4612");
                if (reply == 0) {
                    this.endQueueManager(t, 2, false, false, qmgr);
                }
            } else if (!this.dlgConfirmed) {
                String endText = "";
                String endTitle = "";
                if (this.multiSelectChosen) {
                    endText = "UI.QMGRS.End.Multi.Text";
                    endTitle = "UI.QMGRS.End.Multi.Title";
                } else {
                    endText = "UI.QMGRS.End.Text";
                    endTitle = "UI.QMGRS.End.Title";
                }
                this.showDialog(t, qmgr, endText, endTitle);
            } else if (!this.cancelFlag) {
                if (qmgr.isStandbyPermitted()) {
                    this.endQueueManager(t, dlgSelectedMode, dlgPermitStandbyMode, dlgClientReconnectSelected, qmgr);
                } else {
                    this.endQueueManager(t, dlgSelectedMode, dlgSwitchOverSelected, dlgClientReconnectSelected, qmgr);
                }
            }
        }
        return result;
    }

    private void showDialog(Trace t, UiQueueManager qmgr, String endText, String endTitle) {
        String queueManagerName = qmgr.toString();
        Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Queue Manager");
        SelectStopQmgrModeDialog dlg = new SelectStopQmgrModeDialog(t, UiPlugin.getShell());
        if (dlgStandbyInstance && dlgNonStandbyInstance) {
            dlg.setMixtureSelect(true);
        }
        dlg.setStandbyPermitted(dlgStandbyInstance);
        dlg.setModeSelected(this.defaultAction == ACTION_CONTROLLED ? 0 : 1);
        dlg.setMessage(t, msgFile.getMessage(endText, queueManagerName), -1);
        dlg.setTitle(t, msgFile.getMessage(endTitle, queueManagerName));
        if (dlg.open() == 0) {
            dlgSelectedMode = dlg.getModeSelected();
            dlgClientReconnectSelected = dlg.isClientReconnectSelected();
            if (dlgStandbyInstance) {
                dlgPermitStandbyMode = dlg.isSwitchOverSelected();
            } else {
                dlgSwitchOverSelected = false;
            }
            if (qmgr.isStandbyPermitted()) {
                this.endQueueManager(t, dlg.getModeSelected(), dlgPermitStandbyMode, dlg.isClientReconnectSelected(), qmgr);
            } else {
                this.endQueueManager(t, dlg.getModeSelected(), dlgSwitchOverSelected, dlg.isClientReconnectSelected(), qmgr);
            }
        } else {
            this.cancelFlag = true;
        }
    }

    public void perform(Trace t, int mode, boolean switchOver, boolean clientReconnect, UiQueueManager qmgr) {
        ExplorerNotifyEvent notifyEvent;
        NotificationManager notificationManager = UiPlugin.getNotificationManager();
        if (!notificationManager.notifyIsPreventStopQueueManager(t, notifyEvent = new ExplorerNotifyEvent((Object)qmgr.getExternalObject(), null))) {
            this.endQueueManager(t, mode, switchOver, clientReconnect, qmgr);
        }
    }

    private void endQueueManager(Trace t, int mode, boolean switchOver, boolean clientReconnect, UiQueueManager qmgr) {
        NotificationManager notificationManager = UiPlugin.getNotificationManager();
        ExplorerNotifyEvent notifyEvent = new ExplorerNotifyEvent((Object)qmgr.getExternalObject(), null);
        notificationManager.notifyQueueManagerStopped(t, notifyEvent);
        UiPlugin.triggerDisconnectActionListeners((Trace)t, (DmQueueManager)qmgr.getDmQueueManagerObject());
        Shell parentShell = UiPlugin.getShell();
        String queueManagerName = qmgr.toString();
        this.consoleDialog = new ConsoleDialog(t, parentShell, (IConsoleDialogUser)this);
        this.consoleDialog.setTitle(Message.format((String)endingText1, (String)queueManagerName));
        this.consoleDialog.setHelp("com.ibm.mq.explorer.ui.infopop.UI_QueueManagerEndDialog");
        this.commandList = new ArrayList();
        StringBuffer command = new StringBuffer();
        command.append("endmqm ");
        switch (mode) {
            case 1: {
                command.append(" -i ");
                break;
            }
            case 2: {
                command.append(" -x ");
                break;
            }
            default: {
                command.append(" -w ");
            }
        }
        if (switchOver) {
            command.append(" -s ");
        }
        if (clientReconnect) {
            command.append(" -r ");
        }
        command.append(queueManagerName);
        ConsoleCommand c = new ConsoleCommand(endingText1, command.toString());
        c.addExitValue(0);
        this.commandList.add((AbstractConsoleCommand)c);
        Display display = parentShell.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                EndQueueManagerAction.this.consoleDialog.execute(tr, EndQueueManagerAction.this.commandList);
            }
        });
        UiPlugin.refreshAllViews((Trace)t, (String)"com.ibm.mq.explorer.queuemanager", (boolean)false);
    }

    public void finished(Trace t, int id, boolean result) {
        UiPlugin.getTheDataModel().refreshDmMonitor(t);
    }

    public void setDefaultAction(int action) {
        this.defaultAction = action;
    }
}

