/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.qmgradmin.internal.actions.QmgrAction;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class DisconnectAction
extends QmgrAction {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/internal/actions/DisconnectAction.java";
    private static final int UNITS_PER_QM = 100;
    private static final int INITIAL_DELAY = 20;
    private static final float DELAY_INCREASE_FACTOR = 1.05f;

    public void run(IAction action) {
        if (this.structuredSelection != null) {
            final List<MQQmgrExtObject> qmgrs = this.getQmgrExtObjectsFromSelection(this.structuredSelection);
            final Message msgFile = QmgradminPlugin.getMessages(Trace.getDefault(), "KEY_General");
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) {
                        Trace t2 = Trace.getDefault();
                        int total = qmgrs.size();
                        int count = 1;
                        String taskName = total == 1 ? msgFile.getMessage(t2, "UI.QMGR.Disconnect.Single.Text") : msgFile.getMessage(t2, "UI.QMGR.Disconnect.Multi.Text");
                        monitor.beginTask(taskName, total * 100);
                        for (MQQmgrExtObject mqQmgrExtObject : qmgrs) {
                            UiQueueManager uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
                            String subtaskName = msgFile.getMessage(t2, "UI.QMGR.Disconnect.Subtask.Text", String.valueOf(count), String.valueOf(total), uiQueueManager.getTreeName());
                            monitor.subTask(subtaskName);
                            ++count;
                            final boolean[] done = new boolean[]{false};
                            final int[] workRemaining = new int[]{100};
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    int delay = 20;
                                    while (!done[0]) {
                                        if (workRemaining[0] > 0) {
                                            monitor.worked(1);
                                            workRemaining[0] = workRemaining[0] - 1;
                                        }
                                        try {
                                            Thread.sleep(delay);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        delay = (int)((float)delay * 1.05f);
                                    }
                                }
                            };
                            new Thread(r).start();
                            DisconnectAction.this.disconnect(t2, uiQueueManager);
                            done[0] = true;
                            if (workRemaining[0] > 0) {
                                monitor.worked(workRemaining[0]);
                            }
                            if (monitor.isCanceled()) break;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void disconnect(Trace t, UiQueueManager uiQueueManager) {
        final DmQueueManager dmQueueManager = (DmQueueManager)uiQueueManager.getDmObject();
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UiPlugin.triggerDisconnectActionListeners((Trace)Trace.getDefault(), (DmQueueManager)dmQueueManager);
            }
        });
        dmQueueManager.getConnectionHandle().setUserDisconnect(t, true);
        dmQueueManager.disconnectAsync(t, 0);
        t.data(67, "DisconnectAction.disconnect", "Disconnecting from queue manager " + dmQueueManager.getTitle());
    }
}

