/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.mi.ShowInstancesDialog;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.Hashtable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class ShowInstancesMenuAction
implements IActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin/src/com/ibm/mq/explorer/qmgradmin/actions/ShowInstancesMenuAction.java";
    private ISelection selection = null;
    private UiQueueManager uiQueueManager = null;
    private MQExtObject selectedMQExtObject = null;
    private static Hashtable<String, ShowInstancesDialog> tableOfDialogs = new Hashtable();
    private ShowInstancesDialog showInstancesDialog = null;

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        this.showInstancesDialog(t);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }

    private String getSelectedName(Trace t) {
        IStructuredSelection structuredSelection;
        Object obj;
        String mqObjectName = null;
        TreeNode selectedTreeNode = null;
        if (this.selection != null && this.selection instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)this.selection).getFirstElement()) != null) {
            if (obj instanceof TreeNode) {
                selectedTreeNode = (TreeNode)obj;
                if (selectedTreeNode.getId().startsWith("com.ibm.mq.explorer.treenode.qm.")) {
                    Object treeNodeObj = selectedTreeNode.getObject();
                    if (treeNodeObj instanceof MQExtObject) {
                        this.selectedMQExtObject = (MQExtObject)treeNodeObj;
                        mqObjectName = this.selectedMQExtObject.getName();
                    }
                } else {
                    mqObjectName = selectedTreeNode.toString();
                }
            } else if (obj instanceof MQQmgrExtObject) {
                this.selectedMQExtObject = (MQQmgrExtObject)obj;
                mqObjectName = this.selectedMQExtObject.getName();
            }
            if (this.selectedMQExtObject != null) {
                this.getMQQmgrExtObject(t, this.selectedMQExtObject);
            }
            if (Trace.isTracing) {
                t.data(67, "ShowInstancesMenuAction.getSelectedName", 300, "Selected MQ object name is " + mqObjectName);
            }
        }
        return mqObjectName;
    }

    private void showInstancesDialog(Trace t) {
        String name = this.getSelectedName(t);
        if (name != null) {
            String uuid = this.uiQueueManager.getDmQueueManagerObject().getUUID();
            String key = String.valueOf(uuid) + "/" + this.uiQueueManager.getTreeName();
            if (Trace.isTracing) {
                t.data(67, "ShowInstancesMenuAction.showInstancesDialog", 300, "Using key = " + key);
            }
            this.showInstancesDialog = tableOfDialogs.get(key);
            if (this.showInstancesDialog == null || this.showInstancesDialog.getShell() == null || this.showInstancesDialog.getShell().isDisposed()) {
                this.showInstancesDialog = new ShowInstancesDialog(UiPlugin.getShell(), this.uiQueueManager);
                tableOfDialogs.put(key, this.showInstancesDialog);
                this.showInstancesDialog.open();
            } else {
                Shell s = this.showInstancesDialog.getShell();
                if (s.isDisposed()) {
                    this.showInstancesDialog.open();
                } else {
                    if (s.getMinimized()) {
                        s.setMinimized(false);
                    }
                    s.setActive();
                }
            }
        } else if (Trace.isTracing) {
            t.data(67, "ShowInstancesMenuAction.showInstancesDialog", 900, "Selected MQ object name is not defined");
        }
    }

    private void getMQQmgrExtObject(Trace t, MQExtObject mqExtObject) {
        MQQmgrExtObject mqQmgrExtObject = null;
        MQExtObject testObject = mqExtObject;
        do {
            if (!(testObject instanceof MQQmgrExtObject)) continue;
            mqQmgrExtObject = (MQQmgrExtObject)testObject;
            break;
        } while ((testObject = testObject.getParent()) != null);
        if (mqQmgrExtObject != null) {
            this.uiQueueManager = (UiQueueManager)mqQmgrExtObject.getInternalObject();
        }
    }
}

