/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.passwords.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public abstract class PwUtils {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.passwords/src/com/ibm/mq/explorer/passwords/internal/utils/PwUtils.java";
    private static final byte[] SALT = new byte[]{116, 118, 114, 119, 107, 98, 118, 102};
    private static final int SALT_COUNT = 1000;
    private static final String ALGORITHM = "PBEWithMD5AndDES";
    private static Cipher pbeCipher = null;
    private static PBEParameterSpec pbeParamSpec = null;
    private static PBEKeySpec pbeKeySpec = null;
    private static SecretKey pbeKey = null;
    private static SecretKeyFactory keyFac = null;
    private static Base64.Encoder base64encoder = Base64.getEncoder();
    private static Base64.Decoder base64decoder = Base64.getDecoder();
    private static final int MAX_STORE_NAME_LENGTH = 50;
    private static final String SINGLE_QUOTE = "'";

    private PwUtils() {
        System.out.println("*** You should not be using this constructor ***");
    }

    public static String bytes2String(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bytes == null) {
            return null;
        }
        int i = 0;
        while (i < bytes.length) {
            stringBuffer.append((char)bytes[i]);
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String encrypt(Trace t, String pw, String data) {
        String ret;
        block3: {
            ret = null;
            if (pbeCipher == null) {
                PwUtils.getCipher(t);
            }
            try {
                pbeKeySpec = new PBEKeySpec(pw.toCharArray(), SALT, 1000);
                pbeKey = keyFac.generateSecret(pbeKeySpec);
                pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
                byte[] s = pbeCipher.doFinal(data.getBytes());
                ret = base64encoder.encodeToString(s);
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PwUtils.encrypt", 900, "Error encrypting data " + data + Common.LINE_SEPARATOR + e.toString());
            }
        }
        return ret;
    }

    public static String decrypt(Trace t, String pw, String data) {
        String ret;
        block3: {
            ret = null;
            if (pbeCipher == null) {
                PwUtils.getCipher(t);
            }
            try {
                pbeKeySpec = new PBEKeySpec(pw.toCharArray(), SALT, 1000);
                pbeKey = keyFac.generateSecret(pbeKeySpec);
                pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
                byte[] bb = base64decoder.decode(data);
                ret = PwUtils.bytes2String(pbeCipher.doFinal(bb));
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PwUtils.decrypt", 900, "Error decrypting data " + data + Common.LINE_SEPARATOR + e.toString());
            }
        }
        return ret;
    }

    private static void getCipher(Trace t) {
        try {
            pbeParamSpec = new PBEParameterSpec(SALT, 1000);
            keyFac = SecretKeyFactory.getInstance(ALGORITHM);
            pbeCipher = Cipher.getInstance(ALGORITHM);
        }
        catch (Exception e) {
            t.FFST(66, "PwUtils.getCipher", 0, 50018, 0, 0, e.getMessage(), null, null);
        }
    }

    public static String formatPasswordStoreName(String name) {
        String formattedName = SINGLE_QUOTE + name + SINGLE_QUOTE;
        if (name.length() > 50) {
            formattedName = String.valueOf(Common.LINE_SEPARATOR) + SINGLE_QUOTE + name + SINGLE_QUOTE + Common.LINE_SEPARATOR;
        }
        return formattedName;
    }
}

