/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.passwords.internal.store;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.passwords.internal.event.IPwStoreListener;
import com.ibm.mq.explorer.passwords.internal.event.PwStoreEvent;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.IPwStore;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultCredentials;
import com.ibm.mq.explorer.passwords.internal.utils.PwUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class PwDefaultStore
implements IPwStore {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.passwords/src/com/ibm/mq/explorer/passwords/internal/store/PwDefaultStore.java";
    private File storeFile = null;
    private Vector<IPwCredentials> allCredentials = new Vector();
    private static final String VALIDATION = "askjdOIJaaijopopjjJjJJ8882NJNhhpjs";
    private static final String KEY_FILE_VERSION = "WMQ_Explorer_Password_File_Version";
    private static final String KEY_VALIDATION = "Validate";
    private static final String FILE_VERSION = "1.0.1";
    private static final String KEY_CREDENTIALS = "credentials";
    private static final String KEY_CREDENTIAL = "credential";
    private static final String KEY_OWNERID = "owner";
    private static final String KEY_RESOURCE = "resource";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_OBJECTID = "object";
    private String storeKey = null;
    private static boolean open = false;
    private static boolean savingPasswords = false;
    private static boolean savingPasswordsPreference = false;
    private static PwDefaultStore defaultStore = null;
    private static Hashtable<String, IPwStoreListener> listeners = new Hashtable();

    protected PwDefaultStore(Trace t) {
        defaultStore = this;
    }

    @Override
    public int open(Trace t) {
        open = true;
        if (this.storeFile != null && this.storeKey != null) {
            savingPasswords = true;
        }
        this.notifyListeners(t, 1);
        return 0;
    }

    @Override
    public int open(Trace t, String f, String key) {
        int rc;
        block3: {
            rc = 5;
            try {
                File file = new File(f);
                rc = this.importData(t, file, key);
                if (rc == 0 || rc == 8) {
                    this.storeKey = key;
                    this.storeFile = file;
                    open = true;
                    savingPasswords = true;
                    this.notifyListeners(t, 1);
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PwDefaultStore.open", 900, "Error opening password store using file name " + this.storeFile + e.getMessage());
            }
        }
        return rc;
    }

    @Override
    public int saveCredentials(Trace t, IPwCredentials credentials) {
        int rc = 0;
        if (!this.allCredentials.contains(credentials)) {
            this.allCredentials.add(credentials);
            this.exportData(t, this.storeFile, this.storeKey, true);
            if (Trace.isTracing) {
                t.data(66, "PwDefaultStore.saveCredentials", 300, "Credentials saved to password store file name " + this.storeFile.toString());
            }
        } else {
            rc = 6;
            this.allCredentials.remove(credentials);
            this.allCredentials.add(credentials);
            this.exportData(t, this.storeFile, this.storeKey, true);
            if (Trace.isTracing) {
                t.data(66, "PwDefaultStore.saveCredentials", 300, "Credentials replaced in password store file name " + this.storeFile.toString());
            }
        }
        return rc;
    }

    @Override
    public int deleteCredentials(Trace t, IPwCredentials credentials) {
        int rc = 0;
        if (this.allCredentials.contains(credentials)) {
            this.allCredentials.remove(credentials);
            this.exportData(t, this.storeFile, this.storeKey, true);
            if (Trace.isTracing) {
                t.data(66, "PwDefaultStore.deleteCredentials", 300, "Credentials removed from password store file name " + this.storeFile.toString());
            }
        } else {
            rc = 3;
            if (Trace.isTracing) {
                t.data(66, "PwDefaultStore.deleteCredentials", 300, "Credentials not known " + credentials.toString());
            }
        }
        return rc;
    }

    @Override
    public Vector<IPwCredentials> getAllCredentials(Trace t) {
        return this.allCredentials;
    }

    @Override
    public Vector<IPwCredentials> getAllCredentials(Trace t, String owner) {
        return this.allCredentials;
    }

    @Override
    public IPwCredentials getCredentials(Trace t, String owner, String objectId, String resource) {
        IPwCredentials retValue = null;
        PwDefaultCredentials c = new PwDefaultCredentials(t, owner, objectId, resource);
        int index = this.allCredentials.indexOf(c);
        if (index > -1) {
            retValue = this.allCredentials.get(index);
            if (Trace.isTracing) {
                t.data(66, "PwDefaultStore.getCredentials", 300, "Credentials found " + retValue.toString());
            }
        } else if (Trace.isTracing) {
            t.data(66, "PwDefaultStore.getCredentials", 300, "Credentials not known " + ((Object)c).toString());
        }
        return retValue;
    }

    @Override
    public void close(Trace t) {
        this.notifyListeners(t, 2);
        listeners.clear();
        defaultStore = null;
        savingPasswords = false;
    }

    @Override
    public boolean isOpen(Trace t) {
        return open;
    }

    @Override
    public int setMasterKey(Trace t, String oldKey, String newKey) {
        int rc = 0;
        if (!newKey.equals(oldKey)) {
            try {
                this.storeKey = newKey;
                this.exportData(t, this.storeFile, newKey, true);
            }
            catch (Exception e) {
                rc = 4;
                t.FFST(66, "PwDefaultStore.setMasterKey", 9, rc, 0, 0, e.getMessage(), null, null);
            }
        }
        return rc;
    }

    private int importData(Trace t, File file, String key) {
        int rc = 0;
        XMLMemento rootRead = null;
        try {
            String encValidate;
            String validate;
            FileInputStream inputStream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(inputStream);
            rootRead = XMLMemento.createReadRoot((Reader)reader);
            String fileVersion = rootRead.getString(KEY_FILE_VERSION);
            if (fileVersion != null) {
                fileVersion.compareTo(FILE_VERSION);
            }
            if ((validate = rootRead.getString(KEY_VALIDATION)).equals(encValidate = PwUtils.encrypt(t, key, VALIDATION))) {
                this.allCredentials.clear();
                IMemento[] children = rootRead.getChildren(KEY_CREDENTIAL);
                int i = 0;
                while (i < children.length) {
                    String o = children[i].getString(KEY_OWNERID);
                    String r = children[i].getString(KEY_RESOURCE);
                    String p = children[i].getString(KEY_PASSWORD);
                    String j = children[i].getString(KEY_OBJECTID);
                    String dec = PwUtils.decrypt(t, key, p);
                    if (dec == null) {
                        rc = 4;
                        break;
                    }
                    PwDefaultCredentials c = new PwDefaultCredentials(t, o, j, r, dec);
                    this.allCredentials.add(c);
                    ++i;
                }
            } else {
                rc = 4;
            }
            reader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            rc = this.create(t, file.toString(), key, false);
        }
        catch (IOException e) {
            rc = 5;
            t.FFST(66, "PwDefaultStore.importData", 3, rc, 0, 0, e.getMessage(), null, null);
        }
        catch (WorkbenchException wbe) {
            rc = 5;
            t.FFST(66, "PwDefaultStore.importData", 4, rc, 0, 0, wbe.getMessage(), null, null);
        }
        catch (Exception e) {
            rc = 5;
            t.FFST(66, "PwDefaultStore.importData", 10, rc, 0, 0, e.getMessage(), null, null);
        }
        return rc;
    }

    private int exportData(Trace t, File file, String key, boolean all) {
        String enc = null;
        int rc = 0;
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)KEY_CREDENTIALS);
        rootWrite.putString(KEY_FILE_VERSION, FILE_VERSION);
        try {
            rootWrite.putString(KEY_VALIDATION, PwUtils.encrypt(t, key, VALIDATION));
            if (all) {
                int i = 0;
                while (i < this.allCredentials.size()) {
                    IMemento write = rootWrite.createChild(KEY_CREDENTIAL);
                    IPwCredentials c = this.allCredentials.get(i);
                    write.putString(KEY_OWNERID, c.getOwnerId());
                    write.putString(KEY_RESOURCE, c.getResourceId());
                    enc = PwUtils.encrypt(t, key, c.getPassword());
                    write.putString(KEY_PASSWORD, enc);
                    if (c.getObjectId() != null) {
                        write.putString(KEY_OBJECTID, c.getObjectId());
                    }
                    ++i;
                }
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            rootWrite.save((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            rc = 1;
            t.FFST(66, "PwDefaultStore.exportData", 5, rc, 0, 0, e.getMessage(), null, null);
        }
        catch (NullPointerException e) {
            rc = 1;
            t.FFST(66, "PwDefaultStore.exportData", 6, rc, 0, 0, e.getMessage(), null, null);
        }
        catch (Exception e) {
            rc = 1;
            t.FFST(66, "PwDefaultStore.exportData", 11, rc, 0, 0, e.getMessage(), null, null);
        }
        return rc;
    }

    public static PwDefaultStore getDefaultStore(Trace t) {
        if (defaultStore == null) {
            defaultStore = new PwDefaultStore(t);
        }
        return defaultStore;
    }

    public static void addListener(Trace t, IPwStoreListener listener) {
        if (listener != null && !listeners.containsKey(listener.getListenerId())) {
            listeners.put(listener.getListenerId(), listener);
            if (open) {
                listener.pwStoreOpen(new PwStoreEvent("com.ibm.mq.explorer.default.store"));
            }
        }
    }

    public static void removeListener(Trace t, IPwStoreListener listener) {
        if (listener != null) {
            if (listeners.containsKey(listener.getListenerId())) {
                listeners.remove(listener.getListenerId());
            } else if (Trace.isTracing) {
                t.data(66, "PwDefaultStore.removeListener", 300, "Listener not registerd " + listener.getListenerId());
            }
        }
    }

    private void notifyListeners(Trace t, int action) {
        Enumeration<IPwStoreListener> e = listeners.elements();
        block4: while (e.hasMoreElements()) {
            PwStoreEvent event = new PwStoreEvent(this);
            switch (action) {
                case 1: {
                    e.nextElement().pwStoreOpen(event);
                    break;
                }
                case 2: {
                    e.nextElement().pwStoreClosed(event);
                    break;
                }
                default: {
                    if (!Trace.isTracing) continue block4;
                    t.data(66, "PwDefaultStore.notifyListeners", 300, "Uknown event type " + action);
                }
            }
        }
    }

    @Override
    public int validate(Trace t, File fileName) {
        int rc;
        block8: {
            rc = 7;
            XMLMemento rootRead = null;
            try {
                FileInputStream inputStream = new FileInputStream(fileName);
                InputStreamReader reader = new InputStreamReader(inputStream);
                rootRead = XMLMemento.createReadRoot((Reader)reader);
                String validate = rootRead.getString(KEY_FILE_VERSION);
                if (validate != null) {
                    rc = 0;
                }
                reader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                rc = 8;
            }
            catch (IOException e) {
                if (Trace.isTracing) {
                    t.data(66, "PwDefaultStore.validate", 900, "IOException reading file " + fileName + Common.LINE_SEPARATOR + e);
                }
            }
            catch (WorkbenchException e) {
                if (Trace.isTracing) {
                    t.data(66, "PwDefaultStore.validate", 900, "WorkbenchException reading file " + fileName + Common.LINE_SEPARATOR + (Object)((Object)e));
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block8;
                t.data(66, "PwDefaultStore.validate", 900, "Exception reading file " + fileName + Common.LINE_SEPARATOR + e);
            }
        }
        return rc;
    }

    @Override
    public int validate(Trace t, String key) {
        int rc;
        block8: {
            rc = 4;
            XMLMemento rootRead = null;
            try {
                FileInputStream inputStream = new FileInputStream(this.storeFile);
                InputStreamReader reader = new InputStreamReader(inputStream);
                rootRead = XMLMemento.createReadRoot((Reader)reader);
                String validate = rootRead.getString(KEY_VALIDATION);
                String oo = PwUtils.encrypt(t, key, VALIDATION);
                if (validate.equals(oo)) {
                    rc = 0;
                }
                reader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                rc = 8;
            }
            catch (IOException e) {
                rc = 7;
                if (Trace.isTracing) {
                    t.data(66, "PwDefaultStore.validate", 900, "IOException reading file " + this.storeFile + Common.LINE_SEPARATOR + e);
                }
            }
            catch (WorkbenchException e) {
                rc = 7;
                if (Trace.isTracing) {
                    t.data(66, "PwDefaultStore.validate", 900, "WorkbenchException reading file " + this.storeFile + Common.LINE_SEPARATOR + (Object)((Object)e));
                }
            }
            catch (Exception e) {
                rc = 7;
                if (!Trace.isTracing) break block8;
                t.data(66, "PwDefaultStore.validate", 900, "Exception reading file " + this.storeFile + Common.LINE_SEPARATOR + e);
            }
        }
        return rc;
    }

    @Override
    public int create(Trace t, String f, String key, boolean copy) {
        int rc;
        block3: {
            rc = 5;
            try {
                File file = new File(f);
                rc = this.exportData(t, file, key, copy);
                this.storeFile = file;
                this.storeKey = key;
                if (this.isOpen(t) && !savingPasswords) {
                    savingPasswords = true;
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PwDefaultStore.create", 900, "Error opening password store using file name " + this.storeFile + e.getMessage());
            }
        }
        return rc;
    }

    @Override
    public File getPasswordStoreFile(Trace t) {
        return this.storeFile;
    }

    @Override
    public void setPasswordStoreFile(Trace t, File file) {
        this.storeFile = file;
    }

    public static boolean isSavingPasswordsPreference() {
        return savingPasswordsPreference;
    }

    public static void setSavingPasswordsPreference(boolean b) {
        savingPasswordsPreference = b;
    }

    @Override
    public boolean isSavingPasswords(Trace t) {
        return savingPasswords;
    }
}

