/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.tests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.tests.internal.JmsAdminTestsPlugin;
import com.ibm.mq.explorer.jmsadmin.tests.internal.JmsAdminTestsUtilities;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class MQNames
extends WMQTest {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin.tests/src/com/ibm/mq/explorer/jmsadmin/tests/internal/tests/MQNames.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String VALID_MQ_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%/._*";

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        String connFactoryError = "MQNameConnFactoryError";
        String destinationError = "MQNameDestinationError";
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        ArrayList<WMQTestResult> testResults = new ArrayList<WMQTestResult>();
        DmJmsAbstractContext dmObject = JmsAdminTestsUtilities.getDmObject(t, treenode);
        if (dmObject != null) {
            Attr BrokerPubQ_attr;
            Collection destinations = dmObject.getDestinations(t);
            guimonitor.beginTask(this.getTestName(), destinations.size());
            for (DmJmsAbstractDestination dmJmsDestination : destinations) {
                Attr BrokerPubQMgr_attr;
                Attr BrokerDurSubQ_attr;
                Attr BrokerCCDurSubQ_attr;
                Attr Q_attr;
                Attr QMgr_attr = dmJmsDestination.getAttribute(t, 13043, 0);
                if (QMgr_attr != null && !this.verifyMQChars((String)QMgr_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(destinationError, dmJmsDestination.getTitle(), dmObject.getTitle(), QMgr_attr.getAttrType().getPropTitle()));
                }
                if ((Q_attr = dmJmsDestination.getAttribute(t, 13044, 0)) != null && !this.verifyMQChars((String)Q_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(destinationError, dmJmsDestination.getTitle(), dmObject.getTitle(), Q_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerCCDurSubQ_attr = dmJmsDestination.getAttribute(t, 13001, 0)) != null && !this.verifyMQChars((String)BrokerCCDurSubQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(destinationError, dmJmsDestination.getTitle(), dmObject.getTitle(), BrokerCCDurSubQ_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerDurSubQ_attr = dmJmsDestination.getAttribute(t, 13004, 0)) != null && !this.verifyMQChars((String)BrokerDurSubQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(destinationError, dmJmsDestination.getTitle(), dmObject.getTitle(), BrokerDurSubQ_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerPubQ_attr = dmJmsDestination.getAttribute(t, 13005, 0)) != null && !this.verifyMQChars((String)BrokerPubQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(destinationError, dmJmsDestination.getTitle(), dmObject.getTitle(), BrokerPubQ_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerPubQMgr_attr = dmJmsDestination.getAttribute(t, 13006, 0)) != null && !this.verifyMQChars((String)BrokerPubQMgr_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(destinationError, dmJmsDestination.getTitle(), dmObject.getTitle(), BrokerPubQMgr_attr.getAttrType().getPropTitle()));
                }
                guimonitor.worked(1);
            }
            Collection connectionFactories = dmObject.getConnectionFactories(t);
            guimonitor.beginTask(this.getTestName(), connectionFactories.size());
            for (DmJmsAbstractConnectionFactory dmJmsConnFactory : connectionFactories) {
                Attr Channel_attr;
                Attr QMgr_attr;
                Attr TempQPrefix_attr;
                Attr TempModelQ_attr;
                Attr BrokerSubQ_attr;
                Attr BrokerQMgr_attr;
                Attr BrokerConQ_attr;
                Attr BrokerCCSubQ_attr = dmJmsConnFactory.getAttribute(t, 13002, 0);
                if (BrokerCCSubQ_attr != null && !this.verifyMQChars((String)BrokerCCSubQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), BrokerCCSubQ_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerConQ_attr = dmJmsConnFactory.getAttribute(t, 13003, 0)) != null && !this.verifyMQChars((String)BrokerConQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), BrokerConQ_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerPubQ_attr = dmJmsConnFactory.getAttribute(t, 13005, 0)) != null && !this.verifyMQChars((String)BrokerPubQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), BrokerPubQ_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerQMgr_attr = dmJmsConnFactory.getAttribute(t, 13007, 0)) != null && !this.verifyMQChars((String)BrokerQMgr_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), BrokerQMgr_attr.getAttrType().getPropTitle()));
                }
                if ((BrokerSubQ_attr = dmJmsConnFactory.getAttribute(t, 13008, 0)) != null && !this.verifyMQChars((String)BrokerSubQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), BrokerSubQ_attr.getAttrType().getPropTitle()));
                }
                if ((TempModelQ_attr = dmJmsConnFactory.getAttribute(t, 13064, 0)) != null && !this.verifyMQChars((String)TempModelQ_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), TempModelQ_attr.getAttrType().getPropTitle()));
                }
                if ((TempQPrefix_attr = dmJmsConnFactory.getAttribute(t, 13065, 0)) != null && !this.verifyMQChars((String)TempQPrefix_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), TempQPrefix_attr.getAttrType().getPropTitle()));
                }
                if ((QMgr_attr = dmJmsConnFactory.getAttribute(t, 13043, 0)) != null && !this.verifyMQChars((String)QMgr_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), QMgr_attr.getAttrType().getPropTitle()));
                }
                if ((Channel_attr = dmJmsConnFactory.getAttribute(t, 13012, 0)) != null && !this.verifyMQChars((String)Channel_attr.getValue(t))) {
                    testResults.add(this.generateTestResult(connFactoryError, dmJmsConnFactory.getTitle(), dmObject.getTitle(), Channel_attr.getAttrType().getPropTitle()));
                }
                guimonitor.worked(1);
            }
        } else {
            testResults.add(JmsAdminTestsUtilities.generateTestNotRunResult(this.getTestName(), this.getTestSubCategory(), treenode.toString()));
        }
        WMQTestResult[] finalresults = testResults.toArray(new WMQTestResult[testResults.size()]);
        this.testComplete(finalresults);
    }

    private WMQTestResult generateTestResult(String msgID, String destinationName, String name, String badMQName) {
        String res = JmsAdminTestsPlugin.getMessage(msgID, badMQName, destinationName);
        return new WMQTestResult(2, res, name, this.getTestSubCategory());
    }

    public boolean verifyMQChars(String txt) {
        boolean result = true;
        char[] chars = new char[txt.length()];
        txt.getChars(0, chars.length, chars, 0);
        int i = 0;
        while (i < chars.length) {
            if (VALID_MQ_CHARS.indexOf(chars[i]) == -1) {
                result = false;
            }
            ++i;
        }
        return result;
    }
}

