/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.v2;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.wmqfte.api.CommandException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.content.MonitorContentFactory;
import com.ibm.wmqfte.explorer.content.MonitorContentPage;
import com.ibm.wmqfte.explorer.content.TransferTemplatesFactory;
import com.ibm.wmqfte.explorer.content.TransferTemplatesPage;
import com.ibm.wmqfte.explorer.data.GUIListMonitorResult;
import com.ibm.wmqfte.explorer.data.MonitorProvider;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.data.TransferTemplateProvider;
import com.ibm.wmqfte.explorer.utils.AgentRequestMonitor;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.pages.v2.AttributePage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.InitialPage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ItemPage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.MetadataPage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPageA;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPageB;
import com.ibm.wmqfte.explorer.wizards.pages.v2.SchedulePage;
import com.ibm.wmqfte.explorer.wizards.pages.v2.SummaryPage;
import com.ibm.wmqfte.explorer.wizards.v2.PageSelection;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.wmqiface.WMQApiException;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import com.ibm.wmqfte.wmqiface.WMQPublicationData;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TransferWizardV2
extends Wizard
implements INewWizard {
    public static final String HELP_INITIAL_NEW_TRANSFER = "com.ibm.wmqfte.explorer.context.UI_Initial_NewTransfer";
    public static final String HELP_INITIAL_NEW_TEMPLATE = "com.ibm.wmqfte.explorer.context.UI_Initial_NewTemplate";
    public static final String HELP_INITIAL_EDIT_TEMPLATE = "com.ibm.wmqfte.explorer.context.UI_Initial_EditTemplate";
    public static final String HELP_INITIAL_SUBMIT_TEMPLATE = "com.ibm.wmqfte.explorer.context.UI_Initial_SubmitTemplate";
    public static final String HELP_INITIAL_NEW_MONITOR = "com.ibm.wmqfte.explorer.context.UI_Initial_NewMonitor";
    public static final String HELP_INITIAL_EDIT_MONITOR = "com.ibm.wmqfte.explorer.context.UI_Initial_EditMonitor";
    public static final String HELP_SCHEDULER = "com.ibm.wmqfte.explorer.context.UI_Scheduler";
    public static final String HELP_RESOURCE_MONITOR_DIR = "com.ibm.wmqfte.explorer.context.UI_ResourceMonitorDirectory";
    public static final String HELP_RESOURCE_MONITOR_QUEUE = "com.ibm.wmqfte.explorer.context.UI_ResourceMonitorQueue";
    public static final String HELP_ITEM = "com.ibm.wmqfte.explorer.context.UI_Item";
    public static final String HELP_ITEM_DIALOG = "com.ibm.wmqfte.explorer.context.UI_ItemDialog";
    public static final String HELP_META_DATA = "com.ibm.wmqfte.explorer.context.UI_MetaData";
    public static final String HELP_ATTRIBUTES = "com.ibm.wmqfte.explorer.context.UI_Attributes";
    public static final String HELP_INNVOCATION = "com.ibm.wmqfte.explorer.context.UI_Invocation";
    public static final String HELP_SUMMARY = "com.ibm.wmqfte.explorer.context.UI_Summary";
    public static final String HELP_RES_MON_SUB_VAR = "com.ibm.wmqfte.explorer.context.UI_ResMonVarStDialogHelp";
    public static final int COMBO_HISTORY_LENGTH = 10;
    private InitialPage initialPage;
    public ResourceMonitorPageA resourceMonitorPageA;
    public ResourceMonitorPageB resourceMonitorPageB;
    public SchedulePage schedulePage;
    public ItemPage itemPage;
    public AttributePage attributePage;
    public MetadataPage metadataPage;
    public SummaryPage summaryPage;
    public WizardPage[] pages = new WizardPage[8];
    public PageSelection pageSelection;
    public ResourceMonitorPage resourceMonitorPage;
    private final CreateType createType;
    private TransferTemplate transferTemplate = null;

    public TransferWizardV2(CreateType createType, TransferTemplate transferTemplate) {
        this.createType = createType;
        this.setWindowTitle(createType.getTitle(transferTemplate != null ? transferTemplate.getName() : ""));
        SectionHistory.initialiseHistory("UI_WIZARD_NEW_TRANSFER_SETTINGS", 10);
        this.transferTemplate = transferTemplate;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.initialPage = new InitialPage(this);
        this.addPage((IWizardPage)this.initialPage);
        this.pages[0] = this.initialPage;
        this.resourceMonitorPage = new ResourceMonitorPage(this);
        this.resourceMonitorPageA = new ResourceMonitorPageA(this, this.resourceMonitorPage);
        this.addPage((IWizardPage)this.resourceMonitorPageA);
        this.pages[1] = this.resourceMonitorPageA;
        this.resourceMonitorPageB = new ResourceMonitorPageB(this, this.resourceMonitorPage);
        this.addPage((IWizardPage)this.resourceMonitorPageB);
        this.pages[2] = this.resourceMonitorPageB;
        this.itemPage = new ItemPage(this);
        this.addPage((IWizardPage)this.itemPage);
        this.pages[3] = this.itemPage;
        this.schedulePage = new SchedulePage(this);
        this.addPage((IWizardPage)this.schedulePage);
        this.pages[4] = this.schedulePage;
        this.attributePage = new AttributePage(this);
        this.addPage((IWizardPage)this.attributePage);
        this.pages[5] = this.attributePage;
        this.metadataPage = new MetadataPage(this);
        this.addPage((IWizardPage)this.metadataPage);
        this.pages[6] = this.metadataPage;
        this.summaryPage = new SummaryPage(this);
        this.addPage((IWizardPage)this.summaryPage);
        this.pages[7] = this.summaryPage;
        this.pageSelection = new PageSelection(this, (IWizardPage[])this.pages);
    }

    public IWizardPage getPrevPage(IWizardPage currentPage) {
        IWizardPage page = this.pageSelection.prevPage(currentPage);
        return page;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        IWizardPage page = this.pageSelection.nextPage(currentPage);
        return page;
    }

    public boolean performFinish() {
        this.initialPage.saveHistory();
        this.attributePage.saveHistory();
        if (this.createType.isSaveTemplateRequired()) {
            TransferTemplate saveTransferTemplate = this.buildTransferTemplate(this.transferTemplate == null ? null : this.transferTemplate.getUUID());
            this.saveTemplate(saveTransferTemplate);
        } else if (this.createType.isSubmitable() && this.summaryPage.getTemplateName() != null) {
            TransferTemplate saveTransferTemplate = this.buildTransferTemplate(null);
            saveTransferTemplate.setName(this.summaryPage.getTemplateName());
            this.saveTemplate(saveTransferTemplate);
        } else {
            try {
                TransferTemplate tt = this.buildTransferTemplate(null);
                AgentRequestMonitor.submit(tt);
            }
            catch (CommandException e) {
                Tools.internalError(e, Elements.UI_WIZARD_V2_INTERR_SUBMIT, e.getLocalizedMessage());
            }
            catch (UnsupportedEncodingException e) {
                Tools.internalError(e, Elements.UI_WIZARD_V2_INTERR_SUBMIT, e.getLocalizedMessage());
            }
        }
        return true;
    }

    public void updateTemplate() {
        this.transferTemplate = this.buildTransferTemplate(this.transferTemplate == null ? null : this.transferTemplate.getUUID());
    }

    public boolean isTemplateMode() {
        return this.transferTemplate != null;
    }

    public boolean isTemplatePresent(String templateName) {
        boolean result = false;
        TransferTemplatesPage transferTemplatesPage = TransferTemplatesFactory.getTransferTemplatesPage();
        if (transferTemplatesPage == null) {
            TransferTemplateProvider transferTemplateProvider = Subscription.getTransferTemplateProvider();
            List<TransferTemplate> templates = transferTemplateProvider.getTransferTemplates();
            for (TransferTemplate template : templates) {
                if (!template.getName().equalsIgnoreCase(templateName)) continue;
                result = true;
                break;
            }
        } else {
            result = transferTemplatesPage.isTemplatePresent(templateName);
        }
        return result;
    }

    public boolean isMonitorPresent(String agentName, String monitorName) {
        boolean result = false;
        MonitorContentPage monitorContentPage = MonitorContentFactory.getMonitorContentPage();
        if (monitorContentPage == null) {
            MonitorProvider monitorProvider = Subscription.getMonitorProvider();
            List<GUIListMonitorResult> monitors = monitorProvider.getMonitors();
            for (GUIListMonitorResult monitor : monitors) {
                if (!monitor.getAgentName().equalsIgnoreCase(agentName) || !monitor.getMonitorName().equalsIgnoreCase(monitorName)) continue;
                result = true;
                break;
            }
        } else {
            result = monitorContentPage.isMonitorPresent(agentName, monitorName);
        }
        return result;
    }

    public boolean isSubmitable() {
        return this.createType.isSubmitable();
    }

    public TransferTemplate getTransferTemplate() {
        return this.transferTemplate;
    }

    public TransferTemplate generateTransferTemplate() {
        this.updateTemplate();
        return this.transferTemplate;
    }

    public String getSendingAgentName() {
        InitialPage ip = this.getInitialPage();
        return ip == null ? null : ip.getSendingAgentName();
    }

    public String getReceivingAgentName() {
        InitialPage ip = this.getInitialPage();
        return ip == null ? null : ip.getReceivingAgentName();
    }

    public String getSendingAgentToneZone() {
        String retStr = "";
        InitialPage ip = this.getInitialPage();
        if (ip != null) {
            retStr = ip.getSendingAgentToneZone();
        }
        return retStr;
    }

    public InitialPage getInitialPage() {
        return this.initialPage;
    }

    public ItemPage getItemPage() {
        return this.itemPage;
    }

    public CreateType getCreateType() {
        return this.createType;
    }

    public ResourceMonitorPage.ResourceType getMonitorResourceType() {
        return this.initialPage.getMonitorResourceType();
    }

    public String getMonitorName() {
        return this.initialPage.getMonitorName();
    }

    public MetadataPage getMetadataPage() {
        return this.metadataPage;
    }

    private TransferTemplate buildTransferTemplate(String uuid) {
        TransferTemplate template = new TransferTemplate();
        template.setUUID(uuid != null ? uuid : UUID.randomUUID().toString());
        this.initialPage.updateTransferTemplate(template);
        this.metadataPage.updateTransferTemplate(template);
        this.itemPage.updateTransferTemplate(template, this.initialPage.getSourceEndPoint(), this.initialPage.getDestinationEndPoint());
        this.schedulePage.updateTransferTemplate(template);
        this.attributePage.updateTransferTemplate(template);
        if (this.createType.isResourceMonitor()) {
            this.resourceMonitorPage.updateTransferTemplate(template);
            this.metadataPage.updateTransferTemplate(template);
        }
        boolean complete = this.initialPage.isComplete();
        complete &= this.itemPage.isComplete();
        template.setTemplateState(new TransferTemplate.TemplateState(complete &= this.attributePage.isComplete()));
        return template;
    }

    private void saveTemplate(TransferTemplate transferTemplate) {
        try {
            WMQConnectionData adminData = Subscription.getAdminConnectionData();
            WMQPublicationData pubData = new WMQPublicationData(adminData.getQueueManagerName(), adminData.getCcsid(), adminData.getCcsidName());
            Subscription.publishXML("Templates/" + transferTemplate.getUUID(), "SYSTEM.FTE", transferTemplate.toXML(), pubData);
            if (Trace.isTracing) {
                Trace.data((Level)Level.FINEST, (String)"TransferWizardV2", (String)"saveTemplate", (String)transferTemplate.toXML(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isTracing) {
                Trace.data((Level)Level.WARNING, (String)"TransferWizardV2", (String)"saveTemplate", (String)ex.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
            Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_CODEPAGE, new Object[0]);
        }
        catch (WMQApiException ex) {
            if (Trace.isTracing) {
                Trace.data((Level)Level.WARNING, (String)"TransferWizardV2", (String)"saveTemplate", (String)ex.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
            Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_WMQ_PUBLISH, ex.getReasonCode());
        }
    }

    public static enum CreateType {
        NEW_TRANSFER(false, false, false, false, true, false, Elements.UI_WIZARD_V2_TITLE_TRANSFER_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_TRANSFER_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_TRANSFER_SUMMARY),
        NEW_MONITOR(false, false, true, true, true, false, Elements.UI_WIZARD_V2_TITLE_MONITOR_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_SUMMARY),
        EDIT_MONITOR(false, false, false, true, true, false, Elements.UI_WIZARD_V2_TITLE_MONITOR_EDIT, Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_EDIT, Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_SUMMARY),
        COPY_MONITOR(false, false, true, true, true, false, Elements.UI_WIZARD_V2_TITLE_MONITOR_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_EDIT, Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_SUMMARY),
        NEW_TEMPLATE(true, true, true, false, false, false, Elements.UI_WIZARD_V2_TITLE_TEMPLATE_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_TEMPLATE_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_TEMPLATE_SUMMARY),
        EXISTING_TEMPLATE(true, false, false, false, true, false, Elements.UI_WIZARD_V2_TITLE_TRANSFER_FROM_TEMPLATE, Elements.UI_WIZARD_V2_SUB_TITLE_TRANSFER_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_TRANSFER_SUMMARY),
        EDIT_TEMPLATE(true, true, false, false, false, false, Elements.UI_WIZARD_V2_TITLE_TEMPLATE_EDIT, Elements.UI_WIZARD_V2_SUB_TITLE_TEMPLATE_EDIT, Elements.UI_WIZARD_V2_SUB_TITLE_TEMPLATE_SUMMARY),
        COPY_TEMPLATE(true, true, true, false, false, false, Elements.UI_WIZARD_V2_TITLE_TEMPLATE_EDIT, Elements.UI_WIZARD_V2_SUB_TITLE_TEMPLATE_NEW, Elements.UI_WIZARD_V2_SUB_TITLE_TEMPLATE_SUMMARY);

        private final boolean isTemplate;
        private final boolean saveTemplate;
        private final boolean changeableName;
        private final boolean resourceMonitorMode;
        private final boolean canSubmit;
        private final boolean initScheduler;
        private final String nlsTitle;
        private final String nlsSubTitle;
        private final String nlsSubTitleSummary;

        private CreateType(boolean isTemplate, boolean saveTemplate, boolean changeableName, boolean initMonitor, boolean canSubmit, boolean initScheduler, String nlsTitle, String nlsSubTitle, String nlsSubTitleSummary) {
            this.isTemplate = isTemplate;
            this.nlsTitle = nlsTitle;
            this.nlsSubTitle = nlsSubTitle;
            this.saveTemplate = saveTemplate;
            this.resourceMonitorMode = initMonitor;
            this.canSubmit = canSubmit;
            this.changeableName = changeableName;
            this.initScheduler = initScheduler;
            this.nlsSubTitleSummary = nlsSubTitleSummary;
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        public String getTitle(String templateName) {
            return MessageFormat.format(this.nlsTitle, templateName);
        }

        public String getSubTitle() {
            return this.nlsSubTitle;
        }

        public String getSummarySubTitle() {
            return this.nlsSubTitleSummary;
        }

        public boolean isSaveTemplateRequired() {
            return this.saveTemplate;
        }

        public boolean isNameChangeable() {
            return this.changeableName;
        }

        public boolean isResourceMonitor() {
            return this.resourceMonitorMode;
        }

        public boolean isSubmitable() {
            return this.canSubmit;
        }

        public boolean isSchedulerMode() {
            return this.initScheduler;
        }
    }
}

