/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.wizards.v2;

import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.content.MonitorContentFactory;
import com.ibm.wmqfte.explorer.content.MonitorContentPage;
import com.ibm.wmqfte.explorer.content.TransferTemplatesFactory;
import com.ibm.wmqfte.explorer.content.TransferTemplatesPage;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardV2;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class TransferWizardStarterV2 {
    private static final String COPY_POSTFIX = " (1)";
    private static final String COPY_NUM_POSTFIX = "%s (%d)";

    public static TransferWizardStarterV2 createTransfer(Shell shell) {
        return new TransferWizardStarterV2(shell, TransferWizardV2.CreateType.NEW_TRANSFER, null);
    }

    public static TransferWizardStarterV2 createMonitor(Shell shell) {
        return new TransferWizardStarterV2(shell, TransferWizardV2.CreateType.NEW_MONITOR, null);
    }

    public static TransferWizardStarterV2 createTemplate(Shell shell) {
        return new TransferWizardStarterV2(shell, TransferWizardV2.CreateType.NEW_TEMPLATE, null);
    }

    public static TransferWizardStarterV2 useTemplate(Shell shell, TransferTemplate transferTemplate) {
        TransferWizardV2.CreateType createType = TransferWizardV2.CreateType.EXISTING_TEMPLATE;
        return new TransferWizardStarterV2(shell, createType, transferTemplate);
    }

    public static TransferWizardStarterV2 editTemplate(Shell shell, TransferTemplate transferTemplate) {
        TransferWizardV2.CreateType createType = TransferWizardV2.CreateType.EDIT_TEMPLATE;
        return new TransferWizardStarterV2(shell, createType, transferTemplate);
    }

    public static TransferWizardStarterV2 copyTemplate(Shell shell, TransferTemplate transferTemplate) {
        TransferTemplatesPage ttp = TransferTemplatesFactory.getTransferTemplatesPage();
        if (ttp == null) {
            Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_NO_TEMPLATES, new Object[0]);
            return null;
        }
        TransferWizardV2.CreateType createType = TransferWizardV2.CreateType.COPY_TEMPLATE;
        String newTemplateName = TransferWizardStarterV2.getCopyTemplateName(ttp, transferTemplate.getName());
        TransferTemplate newTemplate = transferTemplate.copy(newTemplateName);
        return new TransferWizardStarterV2(shell, createType, newTemplate);
    }

    protected static String getCopyTemplateName(TransferTemplatesPage ttp, String origName) {
        String baseName = origName;
        if (origName.matches(".*\\([0-9]+\\)$")) {
            baseName = origName.substring(0, origName.lastIndexOf(40)).trim();
        }
        String proposedNewName = String.valueOf(baseName) + COPY_POSTFIX;
        int i = 2;
        while (i < 99 && ttp.isTemplatePresent(proposedNewName)) {
            proposedNewName = String.format(COPY_NUM_POSTFIX, baseName, i);
            ++i;
        }
        return proposedNewName;
    }

    public static TransferWizardStarterV2 editMonitor(Shell shell, TransferTemplate transferTemplate) {
        return new TransferWizardStarterV2(shell, TransferWizardV2.CreateType.EDIT_MONITOR, transferTemplate);
    }

    public static TransferWizardStarterV2 copyMonitor(Shell shell, TransferTemplate transferTemplate) {
        MonitorContentPage mcp = MonitorContentFactory.getMonitorContentPage();
        if (mcp == null) {
            Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_NO_MONITORS, new Object[0]);
            return null;
        }
        TransferWizardV2.CreateType createType = TransferWizardV2.CreateType.COPY_MONITOR;
        String newMonitorName = TransferWizardStarterV2.getCopyMonitorName(transferTemplate, mcp);
        transferTemplate.getResourceMonitor().setMonitorName(newMonitorName.toUpperCase());
        return new TransferWizardStarterV2(shell, createType, transferTemplate);
    }

    protected static String getCopyMonitorName(TransferTemplate transferTemplate, MonitorContentPage mcp) {
        String origName = transferTemplate.getResourceMonitor().getMonitorName();
        String agentName = transferTemplate.getResourceMonitor().getAgentName();
        String baseName = origName;
        if (origName.matches(".*\\([0-9]+\\)$")) {
            baseName = origName.substring(0, origName.lastIndexOf(40)).trim();
        }
        String proposedNewName = String.valueOf(baseName) + COPY_POSTFIX;
        int i = 2;
        while (i < 99 && mcp.isMonitorPresent(agentName, proposedNewName.toUpperCase())) {
            proposedNewName = String.format(COPY_NUM_POSTFIX, baseName, i);
            ++i;
        }
        return proposedNewName;
    }

    private TransferWizardStarterV2(Shell shell, TransferWizardV2.CreateType createType, TransferTemplate transferTemplate) {
        if (shell == null) {
            shell = UiPlugin.getShell();
        }
        if (this.environmentCheck()) {
            TransferWizardV2 wizard = new TransferWizardV2(createType, transferTemplate);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    private boolean environmentCheck() {
        boolean good = true;
        Set<AgentStatusDetails> asds = Subscription.getAgentStatusDetailsProvider().getAvailableAgents();
        if (asds.isEmpty()) {
            good = false;
            ErrorDialog.openError((Shell)UiPlugin.getShell(), (String)Elements.UI_WIZARD_V2_NO_AGENTS_TITLE, (String)Elements.UI_WIZARD_V2_NO_AGENTS_DESC, (IStatus)new Status(4, "com.ibm.wmqfte.explorer", Elements.UI_WIZARD_V2_NO_AGENTS_REASON));
        }
        return good;
    }
}

